/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.util.Logger;

class GaussianReader
extends AtomSetCollectionReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private static final int FREQ_FIRST_VECTOR_OFFSET = 2;
    private int firstCoordinateOffset = 3;
    private String energyString = "";
    private String energyKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    String modelName = "";
    int atomCount = 0;
    int moCount = 0;
    int shellCount = 0;
    int gaussianCount = 0;
    String calculationType = "";
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();

    GaussianReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("gaussian");
        boolean iHaveAtoms = false;
        try {
            int lineNum = 0;
            int stepNumber = 0;
            while (this.readLine() != null) {
                if (this.line.startsWith(" Step number")) {
                    this.equivalentAtomSets = 0;
                    ++stepNumber;
                    int scanPointIndex = this.line.indexOf("scan point");
                    this.scanPoint = scanPointIndex > 0 ? this.parseInt(this.line, scanPointIndex + 10) : -1;
                } else if (this.line.indexOf("-- Stationary point found") > 0) {
                    if (this.scanPoint >= 0) {
                        ++this.scanPoint;
                    }
                } else if (this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!iHaveAtoms) continue;
                        break;
                    }
                    ++this.equivalentAtomSets;
                    this.logger.log(" model " + this.modelNumber + " step " + stepNumber + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
                    this.readAtoms();
                    iHaveAtoms = true;
                } else if (iHaveAtoms && this.line.startsWith(" Energy=")) {
                    this.setEnergy();
                } else if (iHaveAtoms && this.line.startsWith(" SCF Done:")) {
                    this.readSCFDone();
                } else if (iHaveAtoms && this.line.startsWith(" Harmonic frequencies")) {
                    this.readFrequencies();
                } else if (iHaveAtoms && (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:"))) {
                    this.readPartialCharges();
                } else if (iHaveAtoms && this.line.startsWith(" Standard basis:")) {
                    this.logger.log(this.line);
                    this.moData.put("energyUnits", "");
                    this.moData.put("calculationType", this.line.substring(17).trim());
                } else if (iHaveAtoms && this.line.startsWith(" General basis read from cards:")) {
                    this.logger.log(this.line);
                    this.moData.put("energyUnits", "");
                    this.moData.put("calculationType", this.line.substring(31).trim());
                } else if (iHaveAtoms && this.line.startsWith(" AO basis set:")) {
                    this.readBasis();
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
                } else if (iHaveAtoms && this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
                    this.readMolecularOrbitals();
                    this.logger.log(this.orbitals.size() + " molecular orbitals read");
                    this.moData.put("mos", this.orbitals);
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
                } else if (this.line.startsWith(" Normal termination of Gaussian")) {
                    ++this.calculationNumber;
                } else if (lineNum < 25 && (this.line.indexOf("This is part of the Gaussian 94(TM) system") >= 0 || this.line.startsWith(" Gaussian 94:"))) {
                    this.firstCoordinateOffset = 2;
                }
                ++lineNum;
            }
        }
        catch (Exception ex) {
            Logger.error((String)"Could not read file", (Throwable)ex);
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    private void readSCFDone() throws Exception {
        String[] tokens = this.getTokens(this.line, 11);
        this.energyKey = tokens[0];
        this.energyString = tokens[2] + " " + tokens[3];
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyString, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyString, this.equivalentAtomSets);
        tokens = this.getTokens(this.readLine());
        this.atomSetCollection.setAtomSetProperties(tokens[0], tokens[2], this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(tokens[3], tokens[5], this.equivalentAtomSets);
        tokens = this.getTokens(this.readLine());
        this.atomSetCollection.setAtomSetProperties(tokens[0], tokens[2], this.equivalentAtomSets);
    }

    private void setEnergy() {
        String[] tokens = this.getTokens(this.line);
        this.energyKey = "Energy";
        this.energyString = tokens[1];
        this.atomSetCollection.setAtomSetNames("Energy = " + tokens[1], this.equivalentAtomSets);
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName("");
        String path = this.getTokens(this.line)[0];
        this.discardLines(4);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String[] tokens = this.getTokens(this.line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)this.parseInt(tokens[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            int offset = this.firstCoordinateOffset;
            ((Tuple3f)atom).x = this.parseFloat(tokens[offset]);
            ((Tuple3f)atom).y = this.parseFloat(tokens[++offset]);
            ((Tuple3f)atom).z = this.parseFloat(tokens[++offset]);
        }
        this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + path);
        this.atomSetCollection.setAtomSetName("Last read atomset.");
    }

    void readBasis() throws Exception {
        String[] tokens;
        Vector sdata = new Vector();
        Vector<String[]> gdata = new Vector<String[]>();
        this.atomCount = -1;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String lastAtom = "";
        while (this.readLine() != null && this.line.startsWith(" Atom")) {
            ++this.shellCount;
            tokens = this.getTokens(this.line);
            Hashtable<String, Object> slater = new Hashtable<String, Object>();
            if (!tokens[1].equals(lastAtom)) {
                ++this.atomCount;
            }
            lastAtom = tokens[1];
            slater.put("atomIndex", new Integer(this.atomCount));
            slater.put("basisType", tokens[4]);
            int nGaussians = this.parseInt(tokens[5]);
            slater.put("gaussianPtr", new Integer(this.gaussianCount));
            slater.put("nGaussians", new Integer(nGaussians));
            sdata.add(slater);
            this.gaussianCount += nGaussians;
            for (int i = 0; i < nGaussians; ++i) {
                gdata.add(this.getTokens(this.readLine()));
            }
        }
        if (this.atomCount == -1) {
            this.atomCount = 0;
        }
        float[][] garray = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            tokens = (String[])gdata.get(i);
            garray[i] = new float[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                garray[i][j] = this.parseFloat(tokens[j]);
            }
        }
        this.moData.put("shells", sdata);
        this.moData.put("gaussians", garray);
        this.logger.log(this.shellCount + " slater shells read");
        this.logger.log(this.gaussianCount + " gaussian primitives read");
    }

    void readMolecularOrbitals() throws Exception {
        Hashtable[] mos = new Hashtable[5];
        Vector[] data = new Vector[5];
        int nThisLine = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int i;
            int ptData;
            String[] tokens = this.getTokens(this.line);
            int n = ptData = this.line.charAt(5) == ' ' ? 2 : 4;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(nThisLine, data, mos);
                nThisLine = tokens.length;
                tokens = this.getTokens(this.readLine());
                for (i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Vector();
                    mos[i].put("symmetry", tokens[i]);
                }
                tokens = this.getStrings(this.readLine().substring(21), nThisLine, 10);
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", new Float(tokens[i]));
                }
                continue;
            }
            try {
                for (i = 0; i < nThisLine; ++i) {
                    data[i].add(tokens[i + ptData]);
                }
            }
            catch (Exception e) {
                Logger.error((String)("Error reading Gaussian file Molecular Orbitals at line: " + this.line));
                break;
            }
        }
        this.addMOData(nThisLine, data, mos);
    }

    void addMOData(int nColumns, Vector[] data, Hashtable[] mos) {
        for (int i = 0; i < nColumns; ++i) {
            float[] coefs = new float[data[i].size()];
            int j = coefs.length;
            while (--j >= 0) {
                coefs[j] = this.parseFloat((String)data[i].get(j));
            }
            mos[i].put("coefficients", coefs);
            this.orbitals.add(mos[i]);
        }
    }

    private void readFrequencies() throws Exception, IOException {
        while (this.readLine() != null && this.line.indexOf(":") < 0) {
        }
        if (this.line == null) {
            throw new Exception("No frequencies encountered");
        }
        while ((this.line = this.readLine()) != null && this.line.length() > 15) {
            String[] symmetries = this.getTokens(this.readLine());
            String[] frequencies = this.getTokens(this.discardLinesUntilStartsWith(" Frequencies"), 15);
            String[] red_masses = this.getTokens(this.discardLinesUntilStartsWith(" Red. masses"), 15);
            String[] frc_consts = this.getTokens(this.discardLinesUntilStartsWith(" Frc consts"), 15);
            String[] intensities = this.getTokens(this.discardLinesUntilStartsWith(" IR Inten"), 15);
            int frequencyCount = frequencies.length;
            for (int i = 0; i < frequencyCount; ++i) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(symmetries[i] + " " + frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyString);
                this.atomSetCollection.setAtomSetProperty("Frequency", frequencies[i] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Reduced Mass", red_masses[i] + " AMU");
                this.atomSetCollection.setAtomSetProperty("Force Constant", frc_consts[i] + " mDyne/A");
                this.atomSetCollection.setAtomSetProperty("IR Intensity", intensities[i] + " KM/Mole");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            int firstModelAtom = this.atomSetCollection.atomCount - frequencyCount * atomCount;
            this.discardLinesUntilStartsWith(" Atom AN");
            for (int i = 0; i < atomCount; ++i) {
                String[] tokens = this.getTokens(this.readLine());
                int atomCenterNumber = this.parseInt(tokens[0]);
                int offset = 2;
                for (int j = 0; j < frequencyCount; ++j) {
                    int atomOffset = firstModelAtom + j * atomCount + atomCenterNumber - 1;
                    Atom atom = this.atomSetCollection.atoms[atomOffset];
                    float x = this.parseFloat(tokens[offset++]);
                    float y = this.parseFloat(tokens[offset++]);
                    float z = this.parseFloat(tokens[offset++]);
                    atom.addVibrationVector(x, y, z);
                }
            }
        }
    }

    void readPartialCharges() throws Exception {
        this.discardLines(1);
        for (int i = this.atomSetCollection.getLastAtomSetAtomIndex(); i < this.atomSetCollection.atomCount; ++i) {
            while (this.atomSetCollection.atoms[i].elementNumber == 0) {
                ++i;
            }
            this.atomSetCollection.atoms[i].partialCharge = this.parseFloat(this.getTokens(this.readLine())[2]);
        }
    }
}

