/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

class JaguarReader
extends AtomSetCollectionReader {
    int atomCount;

    JaguarReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("jaguar");
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("  final geometry:")) {
                    this.readAtoms();
                    continue;
                }
                if (!this.line.startsWith("  harmonic frequencies in")) continue;
                this.readFrequencies();
                break;
            }
        }
        catch (Exception ex) {
            Logger.error((String)"Could not read file", (Throwable)ex);
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.discardLines(2);
        while (this.readLine() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String atomName = this.parseToken(this.line, 2, 7);
            float x = this.parseFloat(this.line, 8, 24);
            float y = this.parseFloat(this.line, 26, 42);
            float z = this.parseFloat(this.line, 44, 60);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
                return;
            }
            int len = atomName.length();
            if (len < 2) {
                return;
            }
            char ch2 = atomName.charAt(1);
            String elementSymbol = ch2 >= 'a' && ch2 <= 'z' ? atomName.substring(0, 2) : atomName.substring(0, 1);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            ((Tuple3f)atom).x = x;
            ((Tuple3f)atom).y = y;
            ((Tuple3f)atom).z = z;
        }
    }

    void readFrequencies() throws Exception {
        this.atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        int modelNumber = 1;
        while (this.readLine() != null && !this.line.startsWith("  frequencies ")) {
        }
        if (this.line == null) {
            return;
        }
        do {
            int freqCount = new StringTokenizer(this.line).countTokens() - 1;
            while (this.readLine() != null && !this.line.startsWith("  intensities ")) {
            }
            for (int atomCenterNumber = 0; atomCenterNumber < this.atomCount; ++atomCenterNumber) {
                this.readLine();
                StringTokenizer tokenizerX = new StringTokenizer(this.line);
                tokenizerX.nextToken();
                tokenizerX.nextToken();
                StringTokenizer tokenizerY = new StringTokenizer(this.readLine());
                tokenizerY.nextToken();
                tokenizerY.nextToken();
                StringTokenizer tokenizerZ = new StringTokenizer(this.readLine());
                tokenizerZ.nextToken();
                tokenizerZ.nextToken();
                for (int j = 0; j < freqCount; ++j) {
                    float x = this.parseFloat(tokenizerX.nextToken());
                    float y = this.parseFloat(tokenizerY.nextToken());
                    float z = this.parseFloat(tokenizerZ.nextToken());
                    this.recordAtomVector(modelNumber + j, atomCenterNumber, x, y, z);
                }
            }
            this.discardLines(1);
            modelNumber += freqCount;
        } while (this.readLine() != null && this.line.startsWith("  frequencies "));
    }

    void recordAtomVector(int modelNumber, int atomCenterNumber, float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            return;
        }
        if (atomCenterNumber <= 0 || atomCenterNumber > this.atomCount) {
            return;
        }
        if (atomCenterNumber == 1 && modelNumber > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.atoms[(modelNumber - 1) * this.atomCount + atomCenterNumber - 1];
        atom.vectorX = x;
        atom.vectorY = y;
        atom.vectorZ = z;
    }
}

