/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.LimitedLineReader;
import org.jmol.adapter.smarter.XmlReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

class Resolver {
    static final String[] nwchemRecords = new String[]{" argument  1 = "};
    static final String[] cubeRecords = new String[]{"JVXL"};
    static final String[] mol2Records = new String[]{"@<TRIPOS>"};
    static final String[] webmoRecords = new String[]{"[HEADER]"};
    static final String[][] fileStartsWithRecords = new String[][]{nwchemRecords, cubeRecords, mol2Records, webmoRecords};
    static final String[] fileStartsWithFormats = new String[]{"NWChem", "Cube", "Mol2", "WebMO"};
    static final String[] pdbRecords = new String[]{"HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL "};
    static final String[] shelxRecords = new String[]{"TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    static final String[] cifRecords = new String[]{"data_", "_publ"};
    static final String[] ghemicalMMRecords = new String[]{"!Header mm1gp", "!Header gpr"};
    static final String[] jaguarRecords = new String[]{"  |  Jaguar version"};
    static final String[] hinRecords = new String[]{"mol "};
    static final String[] mdlRecords = new String[]{"$MDL "};
    static final String[] spartanSmolRecords = new String[]{"INPUT="};
    static final String[] csfRecords = new String[]{"local_transform"};
    static final String[][] lineStartsWithRecords = new String[][]{pdbRecords, shelxRecords, cifRecords, ghemicalMMRecords, jaguarRecords, hinRecords, mdlRecords, spartanSmolRecords, csfRecords};
    static final String[] lineStartsWithFormats = new String[]{"Pdb", "Shelx", "Cif", "GhemicalMM", "Jaguar", "Hin", "Mol", "SpartanSmol", "Csf"};
    static final String[] xmlRecords = new String[]{"<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    static final String[] gaussianRecords = new String[]{"Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    static final String[] mopacRecords = new String[]{"MOPAC 93 (c) Fujitsu", "MOPAC2002 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)"};
    static final String[] qchemRecords = new String[]{"Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    static final String[] gamessRecords = new String[]{"GAMESS"};
    static final String[] spartanRecords = new String[]{"Spartan"};
    static final String[] spartanBinaryRecords = new String[]{"|PropertyArchive"};
    static final String[] adfRecords = new String[]{"Amsterdam Density Functional"};
    static final String[][] containsRecords = new String[][]{xmlRecords, gaussianRecords, mopacRecords, qchemRecords, gamessRecords, spartanBinaryRecords, spartanRecords, mol2Records, adfRecords};
    static final String[] containsFormats = new String[]{"Xml", "Gaussian", "Mopac", "Qchem", "Gamess", "SpartanSmol", "Spartan", "Mol2", "Adf"};

    Resolver() {
    }

    static Object resolve(String name, BufferedReader bufferedReader, JmolAdapter.Logger logger) throws Exception {
        return Resolver.resolve(name, bufferedReader, logger, null);
    }

    static Object resolve(String name, BufferedReader bufferedReader, JmolAdapter.Logger logger, int[] params) throws Exception {
        AtomSetCollectionReader atomSetCollectionReader;
        String atomSetCollectionReaderName = Resolver.determineAtomSetCollectionReader(bufferedReader, logger);
        logger.log("The Resolver thinks", (Object)atomSetCollectionReaderName);
        String className = "org.jmol.adapter.smarter." + atomSetCollectionReaderName + "Reader";
        if (atomSetCollectionReaderName == null) {
            return "unrecognized file format for file " + name;
        }
        try {
            Class<?> atomSetCollectionReaderClass = Class.forName(className);
            atomSetCollectionReader = (AtomSetCollectionReader)((Object)atomSetCollectionReaderClass.newInstance());
        }
        catch (Exception e) {
            String err = "Could not instantiate:" + className;
            logger.log(err);
            return err;
        }
        atomSetCollectionReader.setLogger(logger);
        atomSetCollectionReader.initialize(params);
        AtomSetCollection atomSetCollection = atomSetCollectionReader.readAtomSetCollection(bufferedReader);
        bufferedReader.close();
        return Resolver.finalize(atomSetCollection, "file " + name);
    }

    static Object DOMResolve(Object DOMNode, JmolAdapter.Logger logger) throws Exception {
        XmlReader atomSetCollectionReader = new XmlReader();
        atomSetCollectionReader.setLogger(logger);
        atomSetCollectionReader.initialize();
        AtomSetCollection atomSetCollection = ((AtomSetCollectionReader)atomSetCollectionReader).readAtomSetCollectionFromDOM(DOMNode);
        return Resolver.finalize(atomSetCollection, "DOM node");
    }

    static Object finalize(AtomSetCollection atomSetCollection, String filename) {
        atomSetCollection.freeze();
        if (atomSetCollection.errorMessage != null) {
            return atomSetCollection.errorMessage + " for " + filename + " of type " + atomSetCollection.fileTypeName;
        }
        if (atomSetCollection.atomCount == 0) {
            return "No atoms found for " + filename + " of type " + atomSetCollection.fileTypeName;
        }
        return atomSetCollection;
    }

    static String determineAtomSetCollectionReader(BufferedReader bufferedReader, JmolAdapter.Logger logger) throws Exception {
        int i;
        String recordTag;
        int j;
        String[] recordTags;
        int i2;
        String[] lines = new String[16];
        LimitedLineReader llr = new LimitedLineReader(bufferedReader, 16384);
        for (i2 = 0; i2 < lines.length; ++i2) {
            lines[i2] = llr.readLineWithNewline();
        }
        if (Resolver.checkV3000(lines)) {
            return "V3000";
        }
        if (Resolver.checkMol(lines)) {
            return "Mol";
        }
        if (Resolver.checkXyz(lines)) {
            return "Xyz";
        }
        if (Resolver.checkFoldingXyz(lines)) {
            return "FoldingXyz";
        }
        if (Resolver.checkCube(lines)) {
            return "Cube";
        }
        if (Resolver.checkOdyssey(lines)) {
            return "Odyssey";
        }
        for (i2 = 0; i2 < fileStartsWithRecords.length; ++i2) {
            recordTags = fileStartsWithRecords[i2];
            for (j = 0; j < recordTags.length; ++j) {
                recordTag = recordTags[j];
                if (!lines[0].startsWith(recordTag)) continue;
                return fileStartsWithFormats[i2];
            }
        }
        for (i2 = 0; i2 < lineStartsWithRecords.length; ++i2) {
            recordTags = lineStartsWithRecords[i2];
            for (j = 0; j < recordTags.length; ++j) {
                recordTag = recordTags[j];
                for (int k = 0; k < lines.length; ++k) {
                    if (!lines[k].startsWith(recordTag)) continue;
                    return lineStartsWithFormats[i2];
                }
            }
        }
        String header = llr.getHeader();
        for (i = 0; i < containsRecords.length; ++i) {
            String[] recordTags2 = containsRecords[i];
            for (int j2 = 0; j2 < recordTags2.length; ++j2) {
                String recordTag2 = recordTags2[j2];
                if (header.indexOf(recordTag2) == -1) continue;
                return containsFormats[i];
            }
        }
        if (lines[1] == null || lines[1].trim().length() == 0) {
            return "Jme";
        }
        for (i = 0; i < lines.length; ++i) {
            lines[i] = llr.readLineWithNewline();
        }
        return null;
    }

    static boolean checkOdyssey(String[] lines) {
        int i;
        for (i = 0; i < lines.length && lines[i].startsWith("C "); ++i) {
        }
        return i + 2 < lines.length && lines[i].charAt(0) == ' ' && lines[i + 2].equals("0 1\n");
    }

    static boolean checkV3000(String[] lines) {
        String line4trimmed;
        return lines[3].length() >= 6 && (line4trimmed = lines[3].trim()).endsWith("V3000");
    }

    static boolean checkMol(String[] lines) {
        if (lines[3].length() >= 6) {
            String line4trimmed = lines[3].trim();
            if (line4trimmed.endsWith("V2000") || line4trimmed.endsWith("v2000")) {
                return true;
            }
            try {
                Integer.parseInt(lines[3].substring(0, 3).trim());
                Integer.parseInt(lines[3].substring(3, 6).trim());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static boolean checkXyz(String[] lines) {
        try {
            Integer.parseInt(lines[0].trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static boolean checkFoldingXyz(String[] lines) {
        try {
            StringTokenizer tokens = new StringTokenizer(lines[0].trim(), " \t");
            if (tokens != null && tokens.countTokens() >= 2) {
                Integer.parseInt(tokens.nextToken().trim());
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    static boolean checkCube(String[] lines) {
        try {
            StringTokenizer tokens2 = new StringTokenizer(lines[2]);
            if (tokens2 == null || tokens2.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(tokens2.nextToken());
            int i = 3;
            while (--i >= 0) {
                new Float(tokens2.nextToken());
            }
            StringTokenizer tokens3 = new StringTokenizer(lines[3]);
            if (tokens3 == null || tokens3.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(tokens3.nextToken());
            int i2 = 3;
            while (--i2 >= 0) {
                Float f = new Float(tokens3.nextToken());
                if (!(f.floatValue() < 0.0f)) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    void dumpLines(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            Logger.info((String)("\nLine " + i + " len " + lines[i].length()));
            for (int j = 0; j < lines[i].length(); ++j) {
                Logger.info((String)("\t" + lines[i].charAt(j)));
            }
        }
        Logger.info((String)"");
    }
}

