/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.ArrayUtil;

class ShelxReader
extends AtomSetCollectionReader {
    String[] sfacElementSymbols;
    boolean isCmdf = false;
    boolean iHaveAtomSet = false;
    static final String[] supportedRecordTypes = new String[]{"TITL", "CELL", "SPGR", "SFAC", "LATT", "SYMM"};
    static final String[] unsupportedRecordTypes = new String[]{"ZERR", "DISP", "UNIT", "LAUE", "REM", "MORE", "TIME", "HKLF", "OMIT", "SHEL", "BASF", "TWIN", "EXTI", "SWAT", "HOPE", "MERG", "SPEC", "RESI", "MOVE", "ANIS", "AFIX", "HFIX", "FRAG", "FEND", "EXYZ", "EXTI", "EADP", "EQIV", "CONN", "PART", "BIND", "FREE", "DFIX", "DANG", "BUMP", "SAME", "SADI", "CHIV", "FLAT", "DELU", "SIMU", "DEFS", "ISOR", "NCSY", "SUMP", "L.S.", "CGLS", "BLOC", "DAMP", "STIR", "WGHT", "FVAR", "BOND", "CONF", "MPLA", "RTAB", "HTAB", "LIST", "ACTA", "SIZE", "TEMP", "WPDB", "FMAP", "GRID", "PLAN", "MOLE"};

    ShelxReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("shelx");
        this.setFractionalCoordinates(true);
        boolean modelRead = false;
        while (!modelRead || this.desiredModelNumber <= 0) {
            boolean readThisModel;
            boolean bl = readThisModel = ++this.modelNumber == this.desiredModelNumber || this.desiredModelNumber <= 0;
            if (readThisModel) {
                modelRead = true;
                this.sfacElementSymbols = null;
                this.applySymmetry();
                this.setFractionalCoordinates(true);
                this.isCmdf = false;
                this.iHaveAtomSet = false;
            }
            block1: while (this.readLine() != null) {
                int lineLength = this.line.trim().length();
                while (lineLength > 0 && this.line.charAt(lineLength - 1) == '=') {
                    this.line = this.line.substring(0, lineLength - 1) + this.readLine();
                }
                if (lineLength < 3) continue;
                String command = (this.line + " ").substring(0, 4).toUpperCase().trim();
                if (command.equals("END")) break;
                if (this.line.equals("NOTE")) {
                    this.isCmdf = true;
                    this.atomSetCollection.fileTypeName = "cmdf";
                    continue;
                }
                if (readThisModel && this.isCmdf && this.line.equals("ATOM")) {
                    this.processCmdfAtoms();
                    break;
                }
                int i = unsupportedRecordTypes.length;
                while (--i >= 0) {
                    if (!command.equals(unsupportedRecordTypes[i])) continue;
                    continue block1;
                }
                i = supportedRecordTypes.length;
                while (--i >= 0) {
                    if (!command.equals(supportedRecordTypes[i])) continue;
                    if (!readThisModel) continue block1;
                    this.processSupportedRecord(i);
                    continue block1;
                }
                if (!readThisModel || this.isCmdf || !this.iHaveAtomSet) continue;
                this.assumeAtomRecord();
            }
            if (this.readLine() != null) continue;
        }
        this.applySymmetry();
        return this.atomSetCollection;
    }

    void processSupportedRecord(int recordIndex) throws Exception {
        if (!this.iHaveAtomSet) {
            this.atomSetCollection.newAtomSet();
        }
        this.iHaveAtomSet = true;
        switch (recordIndex) {
            case 0: {
                this.atomSetCollection.setAtomSetName(this.parseTrimmed(this.line, 4));
                break;
            }
            case 1: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 2: {
                this.setSpaceGroupName(this.parseTrimmed(this.line, 4));
                break;
            }
            case 3: {
                this.parseSfacRecord();
                break;
            }
            case 4: {
                this.parseLattRecord();
                break;
            }
            case 5: {
                this.parseSymmRecord();
            }
        }
    }

    void parseLattRecord() throws Exception {
        this.parseToken(this.line);
        int latt = this.parseInt(this.line, this.ichNextParse);
        this.atomSetCollection.setLatticeParameter(latt);
    }

    void parseSymmRecord() throws Exception {
        this.setSymmetryOperator(this.parseTrimmed(this.line, 4));
    }

    void cell() throws Exception {
        String[] tokens = this.getTokens(this.line);
        int ioff = 1;
        if (this.isCmdf) {
            ioff = 0;
        } else {
            float wavelength = this.atomSetCollection.wavelength = this.parseFloat(tokens[0]);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("wavelength", new Float(wavelength));
        }
        for (int ipt = 0; ipt < 6; ++ipt) {
            this.setUnitCellItem(ipt, this.parseFloat(tokens[ipt + ioff + 1]));
        }
    }

    void parseSfacRecord() {
        String[] sfacTokens = this.getTokens(this.line, 4);
        boolean allElementSymbols = true;
        int i = sfacTokens.length;
        while (allElementSymbols && --i >= 0) {
            String token = sfacTokens[i];
            allElementSymbols = Atom.isValidElementSymbolNoCaseSecondChar(token);
        }
        if (allElementSymbols) {
            this.parseSfacElementSymbols(sfacTokens);
        } else {
            this.parseSfacCoefficients(sfacTokens);
        }
    }

    void parseSfacElementSymbols(String[] sfacTokens) {
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = sfacTokens;
        } else {
            int oldCount = this.sfacElementSymbols.length;
            int tokenCount = sfacTokens.length;
            this.sfacElementSymbols = ArrayUtil.setLength((String[])this.sfacElementSymbols, (int)(oldCount + tokenCount));
            int i = tokenCount;
            while (--i >= 0) {
                this.sfacElementSymbols[oldCount + i] = sfacTokens[i];
            }
        }
    }

    void parseSfacCoefficients(String[] sfacTokens) {
        float a1 = this.parseFloat(sfacTokens[1]);
        float a2 = this.parseFloat(sfacTokens[3]);
        float a3 = this.parseFloat(sfacTokens[5]);
        float a4 = this.parseFloat(sfacTokens[7]);
        float c = this.parseFloat(sfacTokens[9]);
        int z = (int)(a1 + a2 + a3 + a4 + c + 0.5f);
        String elementSymbol = AtomSetCollectionReader.getElementSymbol(z);
        int oldCount = 0;
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = new String[1];
        } else {
            oldCount = this.sfacElementSymbols.length;
            this.sfacElementSymbols = ArrayUtil.setLength((String[])this.sfacElementSymbols, (int)(oldCount + 1));
            this.sfacElementSymbols[oldCount] = elementSymbol;
        }
        this.sfacElementSymbols[oldCount] = elementSymbol;
    }

    void assumeAtomRecord() {
        try {
            int elementIndex;
            String atomName = this.parseToken(this.line);
            int scatterFactor = this.parseInt(this.line, this.ichNextParse);
            float a = this.parseFloat(this.line, this.ichNextParse);
            float b = this.parseFloat(this.line, this.ichNextParse);
            float c = this.parseFloat(this.line, this.ichNextParse);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = atomName;
            if (this.sfacElementSymbols != null && (elementIndex = scatterFactor - 1) >= 0 && elementIndex < this.sfacElementSymbols.length) {
                atom.elementSymbol = this.sfacElementSymbols[elementIndex];
            }
            this.setAtomCoord(atom, a, b, c);
        }
        catch (Exception ex) {
            this.logger.log("Exception", (Object)ex, (Object)this.line);
        }
    }

    void processCmdfAtoms() throws Exception {
        while (this.readLine() != null && this.line.length() > 10) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] tokens = this.getTokens(this.line);
            atom.elementSymbol = this.getSymbol(tokens[0]);
            this.setAtomCoord(atom, this.parseFloat(tokens[2]), this.parseFloat(tokens[3]), this.parseFloat(tokens[4]));
        }
    }

    String getSymbol(String sym) {
        if (sym == null) {
            return "Xx";
        }
        int len = sym.length();
        if (len < 2) {
            return sym;
        }
        char ch1 = sym.charAt(1);
        if (ch1 >= 'a' && ch1 <= 'z') {
            return sym.substring(0, 2);
        }
        return "" + sym.charAt(0);
    }
}

