/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SpartanArchive;
import org.jmol.util.Logger;

class SpartanSmolReader
extends AtomSetCollectionReader {
    final boolean debugReader = false;
    boolean isCompoundDocument;
    String modelName = "Spartan file";
    int atomCount;
    Hashtable moData = new Hashtable();

    SpartanSmolReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.readLine();
        this.isCompoundDocument = this.line.indexOf("Compound Document") >= 0;
        this.atomSetCollection = new AtomSetCollection("spartan " + (this.isCompoundDocument ? "compound document file" : "smol"));
        String bondData = "";
        SpartanArchive spartanArchive = null;
        try {
            while (this.line != null) {
                if (this.line.equals("HESSIAN") && bondData != null) {
                    while (this.readLine() != null && this.line.indexOf("ENDHESS") < 0) {
                        bondData = bondData + this.line + " ";
                    }
                }
                if (this.line.equals("BEGINARCHIVE") || this.line.equals("BEGIN Compound Document Entry: Archive")) {
                    spartanArchive = new SpartanArchive(this, this.logger, this.atomSetCollection, this.moData, bondData);
                    bondData = null;
                    this.readArchiveHeader();
                    this.atomCount = spartanArchive.readArchive(this.line, false);
                    if (this.atomCount > 0) {
                        this.atomSetCollection.setAtomSetName(this.modelName);
                    }
                } else if (this.atomCount > 0 && this.line.indexOf("BEGINPROPARC") == 0 || this.line.equals("BEGIN Compound Document Entry: PropertyArchive")) {
                    spartanArchive.readProperties();
                    if (!this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES")) {
                        this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES");
                    }
                }
                this.readLine();
            }
        }
        catch (Exception e) {
            Logger.error((String)("Could not read file at line: " + this.line), (Throwable)e);
        }
        if (this.atomCount > 0 && spartanArchive != null && bondData != null) {
            spartanArchive.addBonds(bondData);
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readArchiveHeader() throws Exception {
        String modelInfo = this.readLine();
        this.logger.log(modelInfo);
        this.atomSetCollection.setCollectionName(modelInfo);
        this.modelName = this.readLine();
        this.logger.log(this.modelName);
        this.readLine();
    }
}

