/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class V3000Reader
extends AtomSetCollectionReader {
    int headerAtomCount;
    int headerBondCount;

    V3000Reader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("v3000");
        boolean iHaveAtoms = false;
        try {
            while (this.readLine() != null) {
                if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                    if (!iHaveAtoms) {
                        this.flushLines();
                        continue;
                    }
                    break;
                }
                iHaveAtoms = true;
                this.processCtab();
            }
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
        }
        return this.atomSetCollection;
    }

    void processCtab() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$") && !this.line.startsWith("M  END")) {
            if (this.line.startsWith("M  V30 BEGIN ATOM")) {
                this.processAtomBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN BOND")) {
                this.processBondBlock();
                continue;
            }
            if (this.line.startsWith("M  V30 BEGIN CTAB")) {
                this.newAtomSet("");
                continue;
            }
            if (!this.line.startsWith("M  V30 COUNTS")) continue;
            this.headerAtomCount = this.parseInt(this.line, 13);
            this.headerBondCount = this.parseInt(this.line, this.ichNextParse);
        }
        if (this.line != null && !this.line.startsWith("$$$$")) {
            this.flushLines();
        }
    }

    String processAtomBlock() throws Exception {
        int i = this.headerAtomCount;
        while (--i >= 0) {
            String option;
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized atom");
            }
            Atom atom = new Atom();
            String[] tokens = this.getTokens(this.line);
            atom.atomSerial = this.parseInt(tokens[2]);
            atom.elementSymbol = tokens[3];
            ((Tuple3f)atom).x = this.parseFloat(tokens[4]);
            ((Tuple3f)atom).y = this.parseFloat(tokens[5]);
            ((Tuple3f)atom).z = this.parseFloat(tokens[6]);
            this.parseInt(this.line, this.ichNextParse);
            while ((option = this.parseToken(this.line, this.ichNextParse)) != null) {
                if (!option.startsWith("CHG=")) continue;
                atom.formalCharge = this.parseInt(option, 4);
            }
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END ATOM")) {
            throw new Exception("M  V30 END ATOM not found");
        }
        return this.line;
    }

    void processBondBlock() throws Exception {
        int i = this.headerBondCount;
        while (--i >= 0) {
            this.readLineWithContinuation();
            if (this.line == null || !this.line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized bond");
            }
            this.parseInt(this.line, 7);
            int order = this.parseInt(this.line, this.ichNextParse);
            int atomSerial1 = this.parseInt(this.line, this.ichNextParse);
            int atomSerial2 = this.parseInt(this.line, this.ichNextParse);
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(atomSerial1, atomSerial2, order);
        }
        this.readLine();
        if (this.line == null || !this.line.startsWith("M  V30 END BOND")) {
            throw new Exception("M  V30 END BOND not found");
        }
    }

    void readLineWithContinuation() throws Exception {
        this.readLine();
        if (this.line != null && this.line.length() > 7) {
            while (this.line.charAt(this.line.length() - 1) == '-') {
                String line2 = this.readLine();
                if (line2 == null || !this.line.startsWith("M  V30 ")) {
                    throw new Exception("Invalid line continuation");
                }
                this.line = this.line + line2.substring(7);
            }
        }
    }

    void flushLines() throws Exception {
        while (this.readLine() != null && !this.line.startsWith("$$$$")) {
        }
    }
}

