/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class MopacReader
extends AtomSetCollectionReader {
    String frameInfo;
    int baseAtomIndex;
    private boolean chargesFound = false;

    MopacReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("mopac");
        this.frameInfo = null;
        while (this.readLine() != null && !this.line.startsWith(" ---")) {
            if (this.line.indexOf("MOLECULAR POINT GROUP") >= 0 || !this.line.trim().equals("CARTESIAN COORDINATES")) continue;
            this.processCoordinates();
            this.atomSetCollection.setAtomSetName("Input Structure");
        }
        while (this.readLine() != null) {
            if (this.line.indexOf("TOTAL ENERGY") >= 0) {
                this.processTotalEnergy();
                continue;
            }
            if (this.line.indexOf("ATOMIC CHARGES") >= 0) {
                this.processAtomicCharges();
                continue;
            }
            if (this.line.trim().equals("CARTESIAN COORDINATES")) {
                this.processCoordinates();
                continue;
            }
            if (this.line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
                this.processCoordinates();
                this.atomSetCollection.setAtomSetName("Orientation in Force Field");
                continue;
            }
            if (this.line.indexOf("NORMAL COORDINATE ANALYSIS") < 0) continue;
            this.readFrequencies();
        }
        return this.atomSetCollection;
    }

    void processTotalEnergy() {
        this.frameInfo = this.line.trim();
    }

    void processAtomicCharges() throws Exception {
        int atomNumber;
        this.discardLines(2);
        this.atomSetCollection.newAtomSet();
        this.baseAtomIndex = this.atomSetCollection.atomCount;
        int expectedAtomNumber = 0;
        while (this.readLine() != null && (atomNumber = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = this.parseToken(this.line, this.ichNextParse);
            atom.partialCharge = this.parseFloat(this.line, this.ichNextParse);
        }
        this.chargesFound = true;
    }

    void processCoordinates() throws Exception {
        int atomNumber;
        this.discardLines(3);
        int expectedAtomNumber = 0;
        if (!this.chargesFound) {
            this.atomSetCollection.newAtomSet();
            this.baseAtomIndex = this.atomSetCollection.atomCount;
        } else {
            this.chargesFound = false;
        }
        while (this.readLine() != null && (atomNumber = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (atomNumber != ++expectedAtomNumber) {
                throw new Exception("unexpected atom number in coordinates");
            }
            String elementSymbol = this.parseToken(this.line, this.ichNextParse);
            Atom atom = this.atomSetCollection.atoms[this.baseAtomIndex + atomNumber - 1];
            if (atom == null) {
                atom = this.atomSetCollection.addNewAtom();
            }
            atom.atomSerial = atomNumber;
            atom.x = this.parseFloat(this.line, this.ichNextParse);
            atom.y = this.parseFloat(this.line, this.ichNextParse);
            atom.z = this.parseFloat(this.line, this.ichNextParse);
            int atno = this.parseInt(elementSymbol);
            if (atno != Integer.MIN_VALUE) {
                elementSymbol = AtomSetCollectionReader.getElementSymbol(atno);
            }
            atom.elementSymbol = elementSymbol;
        }
    }

    private void readFrequencies() throws Exception {
        Vector freqs = new Vector();
        Vector vibrations = new Vector();
        int nAtoms = this.atomSetCollection.getLastAtomSetAtomCount();
        while (this.readLine() != null && this.line.indexOf("DESCRIPTION") < 0) {
            if (this.line.indexOf("ROOT") < 0) continue;
            int frequencyCount = this.getTokens(this.line).length - 2;
            String[][] data = new String[nAtoms * 3 + 1][];
            this.fillDataBlock(data);
            for (int i = 0; i < frequencyCount; ++i) {
                float freq = this.parseFloat(data[0][i]);
                Hashtable<String, Object> info = new Hashtable<String, Object>();
                info.put("freq", new Float(freq));
                info.put("label", "");
                freqs.add(info);
                this.baseAtomIndex = this.atomSetCollection.atomCount;
                this.atomSetCollection.cloneLastAtomSet();
                Atom[] atoms = this.atomSetCollection.atoms;
                this.atomSetCollection.setAtomSetName(freq + " cm^-1");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
                Vector vib = new Vector();
                int dataPt = 1;
                for (int iatom = 0; iatom < nAtoms; ++iatom) {
                    float dx = this.parseFloat(data[dataPt++][i + 1]);
                    float dy = this.parseFloat(data[dataPt++][i + 1]);
                    float dz = this.parseFloat(data[dataPt++][i + 1]);
                    atoms[this.baseAtomIndex + iatom].addVibrationVector(dx, dy, dz);
                    Vector<Float> vibatom = new Vector<Float>();
                    vibatom.add(new Float(dx));
                    vibatom.add(new Float(dy));
                    vibatom.add(new Float(dz));
                    vib.add(vibatom);
                }
                vibrations.add(vib);
            }
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", freqs);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vibrations);
    }
}

