/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

class OdysseyXMLReader
extends AtomSetCollectionReader {
    String modelName = "Odyssey XML file";
    int atomCount;
    int bondCount;
    Hashtable moData = new Hashtable();

    OdysseyXMLReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("odysseyXML)");
        try {
            if (this.discardLinesUntilContains("<description") != null) {
                this.readDescription();
            }
            if (this.discardLinesUntilContains("<atoms") != null) {
                this.readAtoms();
            }
            if (this.discardLinesUntilContains("<bonds") != null) {
                this.readBonds();
            }
        }
        catch (Exception ex) {
            Logger.error("Could not read file", ex);
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        } else {
            this.atomSetCollection.setAtomSetName(this.modelName);
        }
        return this.atomSetCollection;
    }

    void readDescription() throws Exception {
        String title = "";
        String phase = null;
        while (this.readLine() != null && this.line.indexOf("</description>") < 0) {
            if (this.line.indexOf("title") >= 0) {
                title = this.line.substring(this.line.indexOf(">") + 1, this.line.lastIndexOf("<"));
                continue;
            }
            if (this.line.indexOf("phase") < 0) continue;
            phase = this.line.substring(this.line.indexOf(">") + 1, this.line.lastIndexOf("<"));
        }
        this.modelName = title + (phase != null ? " - " + phase : "");
    }

    void readAtoms() throws Exception {
        this.atomCount = 0;
        while (this.readLine() != null && this.line.indexOf("</atoms>") < 0) {
            Hashtable xml = this.readXML("atom");
            Atom atom = new Atom();
            atom.atomName = (String)xml.get("id");
            atom.elementSymbol = (String)xml.get("element");
            String[] tokens = this.getTokens((String)xml.get("xyz"));
            atom.x = this.parseFloat(tokens[0]);
            atom.y = this.parseFloat(tokens[1]);
            atom.z = this.parseFloat(tokens[2]);
            this.atomSetCollection.addAtomWithMappedName(atom);
            atom.atomName = (String)xml.get("label");
            ++this.atomCount;
        }
    }

    Hashtable readXML(String name) throws Exception {
        String tag = "<" + name;
        this.line = this.discardLinesUntilContains(tag);
        tag = "/" + name + ">";
        String tag2 = "/>";
        Hashtable<String, String> xml = new Hashtable<String, String>();
        while (this.line != null) {
            this.line = this.line.trim();
            int ipt = 0;
            int ipt0 = 0;
            while ((ipt = this.line.indexOf("=", ipt)) >= 0) {
                String key = this.line.substring(ipt0, ipt);
                if (key.indexOf(" ") > 0) {
                    key = key.substring(key.lastIndexOf(" ") + 1);
                }
                int ptQ1 = this.line.indexOf("\"", ipt0);
                ipt0 = this.line.indexOf("\"", ptQ1 + 1);
                String val = this.line.substring(ptQ1 + 1, ipt0);
                xml.put(key, val);
            }
            this.readLine();
            if (this.line.indexOf(tag) < 0 && this.line.indexOf(tag2) < 0) continue;
            break;
        }
        return xml;
    }

    void readBonds() throws Exception {
        while (this.readLine() != null && this.line.indexOf("</bonds>") < 0) {
            Hashtable xml = this.readXML("bond");
            int sourceIndex = this.atomSetCollection.getAtomNameIndex((String)xml.get("a"));
            int targetIndex = this.atomSetCollection.getAtomNameIndex((String)xml.get("b"));
            String order = (String)xml.get("order");
            int bondOrder = order == "single" ? 1 : (order == "double" ? 2 : (order == "triple" ? 3 : (order == "delocalized" ? 1 : 1)));
            this.atomSetCollection.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : 1));
            ++this.bondCount;
        }
        this.logger.log(this.bondCount + " bonds read");
    }
}

