/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Shape;

class Balls
extends Shape {
    BitSet bsSizeSet;
    BitSet bsColixSet;

    Balls() {
    }

    void setSize(int size, BitSet bsSelected) {
        int bsLength;
        short mad = (short)size;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        Atom[] atoms = this.frame.atoms;
        int i = bsLength = bsSelected.length();
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            Atom atom = atoms[i];
            atom.setMadAtom(mad);
            this.bsSizeSet.set(i);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = Graphics3D.getColix(value);
            if (colix == 3) {
                colix = 0;
            }
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int pid = value instanceof Byte ? ((Byte)value).intValue() : -1;
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                Atom atom = atoms[i];
                atom.setColixAtom(colix != 0 ? colix : this.viewer.getColixAtomPalette(atom, pid));
                this.bsColixSet.set(i, colix != 0 || pid > 0 || atom.isTranslucent());
                atom.setPaletteID((short)pid);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = value == "translucent";
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                atoms[i].setTranslucent(isTranslucent);
                if (!isTranslucent) continue;
                this.bsColixSet.set(i);
            }
            return;
        }
    }

    void setModelClickability() {
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            atom.clickabilityFlags = 0;
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(i)) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    void setVisibilityFlags(BitSet bs) {
        Atom[] atoms = this.frame.atoms;
        int displayModelIndex = this.viewer.getDisplayModelIndex();
        boolean isOneFrame = displayModelIndex >= 0;
        boolean showHydrogens = this.viewer.getShowHydrogens();
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            atom.shapeVisibilityFlags &= 0xFFFFFFFE & ~this.myVisibilityFlag;
            if (atom.madAtom == Short.MIN_VALUE || !showHydrogens && atom.getElementNumber() == 1 || (isOneFrame || !bs.get(atom.modelIndex)) && atom.modelIndex != displayModelIndex) continue;
            atom.shapeVisibilityFlags |= 1;
            if (atom.madAtom == 0 || this.frame.bsHidden.get(i)) continue;
            atom.shapeVisibilityFlags |= this.myVisibilityFlag;
        }
    }

    String getShapeState() {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        Hashtable temp = new Hashtable();
        for (int i = 0; i < atomCount; ++i) {
            short pid;
            if (this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                Shape.setStateInfo(temp, i, "Spacefill " + (float)atoms[i].madAtom / 2000.0f);
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i) || (pid = atoms[i].getPaletteID()) == 1) continue;
            Shape.setStateInfo(temp, i, this.getColorCommand("atoms", pid, atoms[i].colixAtom));
        }
        return Shape.getShapeCommands(temp, null, atomCount);
    }
}

