/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Group;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Compiler {
    Viewer viewer;
    String filename;
    String script;
    short[] lineNumbers;
    short[] lineIndices;
    Token[][] aatokenCompiled;
    boolean error;
    String errorMessage;
    String errorLine;
    boolean preDefining;
    boolean logMessages = false;
    int cchScript;
    short lineCurrent;
    int ichToken;
    int cchToken;
    Token[] atokenCommand;
    int ichCurrentCommand;
    boolean iHaveQuotedString = false;
    String[] loadFormats = new String[]{"alchemy ", "mol2 ", "mopac ", "nmrpdb ", "charmm ", "xyz ", "mdl ", "pdb "};
    boolean bracketsOpen;
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    int savedPtr;
    boolean residueSpecCodeGenerated;
    int seqcode;

    private void log(String message) {
        if (this.logMessages) {
            Logger.debug(message);
        }
    }

    Compiler(Viewer viewer) {
        this.viewer = viewer;
    }

    boolean compile(String filename, String script, boolean isPredefining) {
        this.filename = filename;
        this.script = script;
        this.logMessages = !isPredefining && Logger.isActiveLevel(0);
        this.lineIndices = null;
        this.lineNumbers = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        boolean bl = this.preDefining = filename == "#predefine";
        if (this.compile0()) {
            return true;
        }
        int icharEnd = script.indexOf(13, this.ichCurrentCommand);
        if (icharEnd == -1 && (icharEnd = script.indexOf(10, this.ichCurrentCommand)) == -1) {
            icharEnd = script.length();
        }
        this.errorLine = script.substring(this.ichCurrentCommand, icharEnd);
        return false;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    short[] getLineIndices() {
        return this.lineIndices;
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    String getErrorMessage() {
        String strError = this.errorMessage;
        strError = strError + " : " + this.errorLine + "\n";
        if (this.filename != null) {
            strError = strError + this.filename;
        }
        strError = strError + " line#" + this.lineCurrent;
        this.viewer.addCommand(this.errorLine + "#??");
        return strError;
    }

    /*
     * Exception decompiling
     */
    boolean compile0() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void getData(Vector ltoken, String key) {
        int i;
        this.ichToken += key.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            ++this.ichToken;
        }
        if ((i = this.script.indexOf("end \"" + key + "\"", this.ichToken)) < 0) {
            i = this.script.length();
        }
        String str = this.script.substring(this.ichToken, i);
        ltoken.addElement(new Token(4360, str));
        this.cchToken = i - this.ichToken + 6 + key.length();
    }

    private static final boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    boolean lookingAtLeadingWhitespace() {
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(ichT)); ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        return this.cchToken > 0;
    }

    boolean lookingAtComment() {
        char ch;
        int ichEnd;
        int ichFirstSharp = -1;
        for (ichEnd = this.ichToken; ichEnd < this.cchScript && (ch = this.script.charAt(ichEnd)) != ';' && ch != '\r' && ch != '\n'; ++ichEnd) {
            if (ch != '#' || ichFirstSharp != -1) continue;
            ichFirstSharp = ichEnd;
        }
        if (ichFirstSharp == -1) {
            return false;
        }
        if (this.cchScript - ichFirstSharp >= 3 && this.script.charAt(ichFirstSharp + 1) == 'j' && this.script.charAt(ichFirstSharp + 2) == 'c') {
            this.cchToken = ichEnd - this.ichToken;
            return true;
        }
        if (ichFirstSharp != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = ichEnd - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            return true;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT);
        if (ch == '\r') {
            if (++ichT < this.cchScript && this.script.charAt(ichT) == '\n') {
                ++ichT;
            }
        } else if (ch == '\n') {
            ++ichT;
        } else {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';') {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    boolean lookingAtString() {
        char ch;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int ichT = this.ichToken + 1;
        boolean previousCharBackslash = false;
        while (ichT < this.cchScript && ((ch = this.script.charAt(ichT++)) != '\"' || previousCharBackslash)) {
            previousCharBackslash = ch == '\\' ? !previousCharBackslash : false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer(this.cchToken - 2);
        int ichMax = this.ichToken + this.cchToken - 1;
        int ich = this.ichToken + 1;
        while (ich < ichMax) {
            int ch;
            if ((ch = this.script.charAt(ich++)) == 92 && ich < ichMax) {
                ch = this.script.charAt(ich++);
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 114: {
                        ch = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char chT;
                        int hexit;
                        int digitCount;
                        int n = digitCount = ch == 120 ? 2 : 4;
                        if (ich >= ichMax) break;
                        int unicode = 0;
                        int k = digitCount;
                        while (--k >= 0 && ich < ichMax && (hexit = Compiler.getHexitValue(chT = this.script.charAt(ich))) >= 0) {
                            unicode <<= 4;
                            unicode += hexit;
                            ++ich;
                        }
                        ch = (char)unicode;
                    }
                }
            }
            sb.append((char)ch);
        }
        return "" + sb;
    }

    static int getHexitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + ch - 97;
        }
        if (ch >= 'A' && ch <= 'F') {
            return 10 + ch - 65;
        }
        return -1;
    }

    boolean lookingAtLoadFormat() {
        int i = this.loadFormats.length;
        while (--i >= 0) {
            String strFormat = this.loadFormats[i];
            int cchFormat = strFormat.length();
            if (!this.script.regionMatches(true, this.ichToken, strFormat, 0, cchFormat)) continue;
            this.cchToken = cchFormat - 1;
            return true;
        }
        return false;
    }

    boolean lookingAtSpecialString() {
        char ch;
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && (ch = this.script.charAt(ichT)) != ';' && ch != '\r' && ch != '\n'; ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        this.log("lookingAtSpecialString cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    float lookingAtExponential() {
        boolean isExponential;
        boolean isNegative;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int ichT = this.ichToken;
        boolean bl = isNegative = this.script.charAt(ichT) == '-';
        if (isNegative) {
            ++ichT;
        }
        int pt0 = ichT;
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT < this.cchScript && ch == 46) {
            ++ichT;
        }
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT == this.cchScript || !digitSeen) {
            return Float.NaN;
        }
        int ptE = ichT;
        int factor = 1;
        int exp = 0;
        boolean bl2 = isExponential = ch == 69 || ch == 101;
        if (!isExponential || ++ichT == this.cchScript) {
            return Float.NaN;
        }
        ch = this.script.charAt(ichT);
        if (ch == 45 || ch == 43) {
            ++ichT;
            int n = factor = ch == 45 ? -1 : 1;
        }
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            exp = exp * 10 + ch - 48;
        }
        if (exp == 0) {
            return Float.NaN;
        }
        this.cchToken = ichT - this.ichToken;
        double value = Float.valueOf(this.script.substring(pt0, ptE)).doubleValue();
        return (float)(value *= (double)(isNegative ? -1 : 1) * Math.pow(10.0, factor * exp));
    }

    boolean lookingAtDecimal(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            ++ichT;
        }
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT == this.cchScript || ch != 46) {
            return false;
        }
        if (ch == 46 && ichT + 1 < this.cchScript && (Character.isLetter(this.script.charAt(ichT + 1)) || this.script.charAt(ichT + 1) == '?')) {
            return false;
        }
        if (ch == 46 && ichT + 2 < this.cchScript && (Character.isLetter(this.script.charAt(ichT + 2)) || this.script.charAt(ichT + 2) == '?')) {
            return false;
        }
        ++ichT;
        while (ichT < this.cchScript && Character.isDigit(this.script.charAt(ichT))) {
            ++ichT;
            digitSeen = true;
        }
        this.cchToken = ichT - this.ichToken;
        return digitSeen;
    }

    boolean lookingAtSeqcode() {
        int ichT;
        char ch = ' ';
        if (ichT + 1 < this.cchScript && this.script.charAt(ichT) == '*' && this.script.charAt(ichT + 1) == '^') {
            ch = '^';
            ++ichT;
        } else {
            for (ichT = this.ichToken; ichT < this.cchScript; ++ichT) {
                char c = this.script.charAt(ichT);
                ch = c;
                if (!Character.isDigit(c)) break;
            }
        }
        if (ch != '^') {
            return false;
        }
        if ((ch = ++ichT == this.cchScript ? (char)' ' : (char)this.script.charAt(ichT++)) != ' ' && ch != '*' && ch != '?' && !Character.isLetter(ch)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtInteger(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (allowNegative && this.script.charAt(this.ichToken) == '-') {
            ++ichT;
        }
        int ichBeginDigits = ichT;
        while (ichT < this.cchScript && Character.isDigit(this.script.charAt(ichT))) {
            ++ichT;
        }
        if (ichBeginDigits == ichT) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT++);
        switch (ch) {
            case '$': 
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '@': 
            case '{': 
            case '}': {
                break;
            }
            case '[': {
                this.bracketsOpen = true;
                break;
            }
            case ']': {
                this.bracketsOpen = false;
                break;
            }
            case '&': 
            case '|': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != ch) break;
                ++ichT;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (ichT >= this.cchScript || (ch = this.script.charAt(ichT)) != '<' && ch != '=' && ch != '>') break;
                ++ichT;
                break;
            }
            case '!': 
            case '/': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != '=') break;
                ++ichT;
                break;
            }
            default: {
                if (!Character.isLetter(ch)) {
                    return false;
                }
            }
            case '?': 
            case '_': 
            case '~': {
                while (ichT < this.cchScript && (Character.isLetterOrDigit(ch = this.script.charAt(ichT)) || ch == '_' || ch == '?' || ch == '~') || ch == '^' && ichT > this.ichToken && Character.isDigit(this.script.charAt(ichT - 1))) {
                    ++ichT;
                }
                break block0;
            }
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean commandExpected() {
        return this.compileError("command expected");
    }

    private boolean commandExpected(String cmd) {
        int i = cmd.indexOf(" ");
        if (i < 0) {
            i = cmd.length();
        }
        return this.compileError("command expected: " + cmd.substring(0, i));
    }

    private boolean cannotSet(String ident) {
        return this.compileError("cannot SET: " + ident);
    }

    private boolean cannotShow(String ident) {
        return this.compileError("cannot SHOW: " + ident);
    }

    private boolean invalidExpressionToken(String ident) {
        return this.compileError("invalid expression token: " + ident);
    }

    private boolean unrecognizedToken(String ident) {
        return this.compileError("unrecognized token: " + ident);
    }

    private boolean badArgumentCount() {
        return this.compileError("bad argument count");
    }

    private boolean endOfExpressionExpected() {
        return this.compileError("end of expression expected");
    }

    private boolean leftParenthesisExpected() {
        return this.compileError("left parenthesis expected");
    }

    private boolean rightParenthesisExpected() {
        return this.compileError("right parenthesis expected");
    }

    private boolean coordinateExpected() {
        return this.compileError("{number, number, number} expected");
    }

    private boolean commaExpected() {
        return this.compileError("comma expected");
    }

    private boolean commaOrCloseExpected() {
        return this.compileError("comma or right parenthesis expected");
    }

    private boolean stringExpected() {
        return this.compileError("double-quoted string expected");
    }

    private boolean unrecognizedExpressionToken() {
        return this.compileError("unrecognized expression token:" + this.valuePeek());
    }

    private boolean comparisonOperatorExpected() {
        return this.compileError("comparison operator expected");
    }

    private boolean equalSignExpected() {
        return this.compileError("equal sign expected");
    }

    private boolean integerExpected() {
        return this.compileError("integer expected");
    }

    private boolean nonnegativeIntegerExpected() {
        return this.compileError("nonnegative integer expected");
    }

    private boolean numberExpected() {
        return this.compileError("number expected");
    }

    private boolean numberOrKeywordExpected() {
        return this.compileError("number or keyword expected");
    }

    private boolean badRGBColor() {
        return this.compileError("bad [R,G,B] color");
    }

    private boolean identifierOrResidueSpecificationExpected() {
        return this.compileError("identifier or residue specification expected");
    }

    private boolean residueSpecificationExpected() {
        return this.compileError("residue specification (ALA, AL?, A*) expected");
    }

    private boolean invalidChainSpecification() {
        return this.compileError("invalid chain specification");
    }

    private boolean invalidModelSpecification() {
        return this.compileError("invalid model specification");
    }

    private boolean invalidAtomSpecification() {
        return this.compileError("invalid atom specification");
    }

    private boolean compileError(String errorMessage) {
        Logger.error("compileError(" + errorMessage + ")");
        this.error = true;
        this.errorMessage = errorMessage;
        return false;
    }

    private boolean compileCommand(Vector ltoken) {
        int tok;
        Token tokenCommand = (Token)ltoken.firstElement();
        int tokCommand = tokenCommand.tok;
        int size = ltoken.size();
        if ((tokenCommand.intValue & 0x21) == 33 && size == 1) {
            ltoken.addElement(Token.tokenOn);
        }
        if (tokCommand == 2106655 && size < 2) {
            return this.badArgumentCount();
        }
        this.atokenCommand = new Token[ltoken.size()];
        ltoken.copyInto(this.atokenCommand);
        int n = tok = size == 1 ? 0 : this.atokenCommand[1].tok;
        if (this.logMessages) {
            for (int i = 0; i < this.atokenCommand.length; ++i) {
                Logger.debug(i + ": " + this.atokenCommand[i]);
            }
        }
        if ((tokCommand & 0x80000) != 0 && !this.compileColorParam()) {
            return false;
        }
        if ((tok == 32785 || tok == 8392723) && (tokCommand & 0x200400) != 0x200400) {
            return true;
        }
        if ((tokCommand & 0x600) != 0 && !this.compileExpression()) {
            return false;
        }
        if ((tokenCommand.intValue & 0x10) == 0 && (tokenCommand.intValue & 0xF) + 1 != this.atokenCommand.length) {
            return this.badArgumentCount();
        }
        return true;
    }

    private boolean compileExpression() {
        int tokCommand = this.atokenCommand[0].tok;
        boolean isMultipleOK = (tokCommand & 0x400) != 0;
        int expPtr = 1;
        if (tokCommand == 777) {
            expPtr = 2;
        }
        while (expPtr > 0 && expPtr < this.atokenCommand.length) {
            if (isMultipleOK) {
                while (expPtr < this.atokenCommand.length && this.atokenCommand[expPtr].tok != 32768) {
                    ++expPtr;
                }
            }
            if (expPtr >= this.atokenCommand.length || (expPtr = this.compileExpression(expPtr)) <= 0) break;
            if (isMultipleOK) continue;
            return this.endOfExpressionExpected();
        }
        return expPtr == this.atokenCommand.length || expPtr == 0;
    }

    boolean addTokenToPostfix(Token token) {
        if (this.logMessages) {
            this.log("addTokenToPostfix" + token);
        }
        this.ltokenPostfix.addElement(token);
        return true;
    }

    int compileExpression(int itoken) {
        int i;
        int expPtr = 0;
        this.ltokenPostfix = new Vector();
        for (i = 0; i < itoken; ++i) {
            this.addTokenToPostfix(this.atokenCommand[i]);
        }
        this.atokenInfix = this.atokenCommand;
        this.itokenInfix = itoken;
        this.addTokenToPostfix(Token.tokenExpressionBegin);
        if (!this.clauseOr()) {
            return -1;
        }
        this.addTokenToPostfix(Token.tokenExpressionEnd);
        if (this.itokenInfix != this.atokenInfix.length) {
            expPtr = this.ltokenPostfix.size();
            for (i = this.itokenInfix; i < this.atokenInfix.length; ++i) {
                this.addTokenToPostfix(this.atokenCommand[i]);
            }
        }
        this.atokenCommand = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenCommand);
        return expPtr;
    }

    void savePtr() {
        this.savedPtr = this.itokenInfix;
    }

    void restorePtr() {
        this.itokenInfix = this.savedPtr;
    }

    Token tokenNext() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    boolean tokenNext(int tok) {
        Token token = this.tokenNext();
        return token != null && token.tok == tok;
    }

    Object valuePeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix].value;
    }

    int intPeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return Integer.MAX_VALUE;
        }
        return this.atokenInfix[this.itokenInfix].intValue;
    }

    int tokPeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    boolean clauseOr() {
        if (!this.clauseAnd()) {
            return false;
        }
        while (this.tokPeek() == 32772 || this.tokPeek() == 32791 || this.tokPeek() == 32792) {
            Token tokenOr = this.tokenNext();
            if (!this.clauseAnd()) {
                return false;
            }
            this.addTokenToPostfix(tokenOr);
        }
        return true;
    }

    boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek() == 32771) {
            Token tokenAnd = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            this.addTokenToPostfix(tokenAnd);
        }
        return true;
    }

    boolean clauseNot() {
        if (this.tokPeek() == 32773) {
            Token tokenNot = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            return this.addTokenToPostfix(tokenNot);
        }
        return this.clausePrimitive();
    }

    boolean clausePrimitive() {
        int tok = this.tokPeek();
        switch (tok) {
            case 34820: {
                return this.clauseBond();
            }
            case 98317: {
                return this.clauseCell();
            }
            case 32774: {
                return this.clauseWithin();
            }
            case 32788: {
                return this.clauseConnected();
            }
            case 32784: {
                return this.clauseSubstructure();
            }
            case 1: 
            case 2: 
            case 5: 
            case 32770: 
            case 32777: 
            case 32780: 
            case 32782: 
            case 49181: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            default: {
                if ((tok & 0x18000) == 98304) {
                    return this.clauseComparator();
                }
                if ((tok & 0x48000) != 294912) break;
            }
            case 36875: 
            case 49157: {
                return this.addTokenToPostfix(this.tokenNext());
            }
            case 32768: {
                this.tokenNext();
                if (!this.clauseOr()) {
                    return false;
                }
                if (!this.tokenNext(32769)) {
                    return this.rightParenthesisExpected();
                }
                return true;
            }
            case 32785: {
                return this.bitset();
            }
        }
        return this.unrecognizedExpressionToken();
    }

    float floatValue(Token token) {
        switch (token.tok) {
            case 2: {
                return token.intValue;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
        }
        return 0.0f;
    }

    boolean bitset() {
        Token token = this.tokenNext();
        int iPrev = -1;
        BitSet bs = new BitSet();
        block4: while ((token = this.tokenNext()) != null) {
            switch (token.tok) {
                case 2: 
                case 32786: {
                    if (iPrev >= 0) {
                        bs.set(iPrev);
                    }
                    if (token.tok == 32786) break block4;
                    iPrev = token.intValue;
                    continue block4;
                }
                case 32782: {
                    if (iPrev >= 0) {
                        token = this.tokenNext();
                        if (token.tok != 2) {
                            return this.invalidExpressionToken(token.toString());
                        }
                        for (int i = token.intValue; i >= iPrev; --i) {
                            bs.set(i);
                        }
                        continue block4;
                    }
                }
                default: {
                    return this.invalidExpressionToken(token.toString());
                }
            }
        }
        return this.addTokenToPostfix(new Token(16455, bs));
    }

    boolean clauseComparator() {
        boolean isNegative;
        Token tokenAtomProperty = this.tokenNext();
        Token tokenComparator = this.tokenNext();
        if ((tokenComparator.tok & 0x28000) == 0) {
            return this.comparisonOperatorExpected();
        }
        Token tokenValue = this.tokenNext();
        boolean bl = isNegative = tokenValue.tok == 32770;
        if (isNegative) {
            tokenValue = this.tokenNext();
        }
        int val = Integer.MAX_VALUE;
        if (tokenValue.tok == 3) {
            float vf = ((Float)tokenValue.value).floatValue();
            switch (tokenAtomProperty.tok) {
                case 100355: {
                    val = (int)(vf * 250.0f);
                    break;
                }
                case 98308: 
                case 98314: {
                    val = (int)(vf * 100.0f);
                }
            }
        } else if (tokenValue.tok == 2) {
            switch (tokenAtomProperty.tok) {
                case 98308: {
                    val = tokenValue.intValue * 100;
                    break;
                }
                default: {
                    val = tokenValue.intValue;
                }
            }
        }
        if (val == Integer.MAX_VALUE) {
            return this.numberExpected();
        }
        return this.addTokenToPostfix(new Token(tokenComparator.tok, tokenAtomProperty.tok, new Integer(val * (isNegative ? -1 : 1))));
    }

    boolean clauseCell() {
        Point3f cell = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(163844)) {
            return this.equalSignExpected();
        }
        Token coord = this.tokenNext();
        if (coord.tok == 2) {
            int nnn = coord.intValue;
            cell.x = nnn / 100 - 4;
            cell.y = nnn % 100 / 10 - 4;
            cell.z = nnn % 10 - 4;
            return this.addTokenToPostfix(new Token(98317, cell));
        }
        if (coord.tok != 32785) {
            return this.coordinateExpected();
        }
        coord = this.tokenNext();
        if (coord == null || coord.tok != 2 && coord.tok != 3) {
            return this.integerExpected();
        }
        cell.x = coord.tok == 2 ? (float)coord.intValue : ((Float)coord.value).floatValue();
        if (this.tokPeek() == 32772) {
            this.tokenNext();
        }
        if ((coord = this.tokenNext()) == null || coord.tok != 2 && coord.tok != 3) {
            return this.integerExpected();
        }
        cell.y = coord.tok == 2 ? (float)coord.intValue : ((Float)coord.value).floatValue();
        if (this.tokPeek() == 32772) {
            this.tokenNext();
        }
        if ((coord = this.tokenNext()) == null || coord.tok != 2 && coord.tok != 3) {
            return this.integerExpected();
        }
        cell.z = coord.tok == 2 ? (float)coord.intValue : ((Float)coord.value).floatValue();
        if (!this.tokenNext(32786)) {
            return this.coordinateExpected();
        }
        return this.addTokenToPostfix(new Token(98317, cell));
    }

    boolean clauseBond() {
        if (this.itokenInfix != 1) {
            return this.invalidExpressionToken(this.tokenNext().toString());
        }
        this.tokenNext();
        if (!this.tokenNext(32768)) {
            return this.leftParenthesisExpected();
        }
        this.addTokenToPostfix(new Token(34820));
        if (!this.bitset()) {
            return false;
        }
        if (!this.tokenNext(32769)) {
            return this.rightParenthesisExpected();
        }
        if (this.tokenNext() != null) {
            return this.endOfExpressionExpected();
        }
        return true;
    }

    boolean clauseWithin() {
        this.tokenNext();
        if (!this.tokenNext(32768)) {
            return this.leftParenthesisExpected();
        }
        Object distance = null;
        Token tokenDistance = this.tokenNext();
        if (tokenDistance == null) {
            return this.numberOrKeywordExpected();
        }
        switch (tokenDistance.tok) {
            case 2: {
                distance = new Float((float)(tokenDistance.intValue * 4) / 1000.0f);
                break;
            }
            case 3: 
            case 4: 
            case 36868: 
            case 36869: 
            case 98318: 
            case 98319: 
            case 98572: 
            case 102661: {
                distance = tokenDistance.value;
                break;
            }
            default: {
                return this.numberOrKeywordExpected();
            }
        }
        if (!this.tokenNext(32772)) {
            return this.commaExpected();
        }
        if (this.tokPeek() == 32785) {
            return this.addTokenToPostfix(new Token(32774, new Float(Float.NaN)));
        }
        if (!this.clauseOr()) {
            return false;
        }
        if (!this.tokenNext(32769)) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(32774, distance));
    }

    boolean clauseConnected() {
        int min = 1;
        int max = 100;
        boolean iHaveExpression = false;
        this.tokenNext();
        while (!iHaveExpression && this.tokPeek() == 32768) {
            Token token;
            this.tokenNext();
            int tok = this.tokPeek();
            if (tok == 2) {
                token = this.tokenNext();
                if (token.intValue < 0) {
                    return this.nonnegativeIntegerExpected();
                }
                min = max = token.intValue;
                token = this.tokenNext();
                tok = token.tok;
                if (tok == 32769) break;
                if (tok != 32772) {
                    return this.commaOrCloseExpected();
                }
                tok = this.tokPeek();
            }
            if (tok == 2) {
                token = this.tokenNext();
                if (token.intValue < 0) {
                    return this.nonnegativeIntegerExpected();
                }
                max = token.intValue;
                token = this.tokenNext();
                tok = token.tok;
                if (tok == 32769) break;
                if (tok != 32772) {
                    return this.commaOrCloseExpected();
                }
                tok = this.tokPeek();
            }
            if (tok == 32769) break;
            if (!this.clauseOr()) {
                return false;
            }
            if (!this.tokenNext(32769)) {
                return this.rightParenthesisExpected();
            }
            iHaveExpression = true;
        }
        if (!iHaveExpression) {
            this.addTokenToPostfix(new Token(36875));
        }
        return this.addTokenToPostfix(new Token(32788, min, new Integer(max)));
    }

    boolean clauseSubstructure() {
        this.tokenNext();
        if (!this.tokenNext(32768)) {
            return this.leftParenthesisExpected();
        }
        Token tokenSmiles = this.tokenNext();
        if (tokenSmiles == null || tokenSmiles.tok != 4) {
            return this.stringExpected();
        }
        if (!this.tokenNext(32769)) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(32784, tokenSmiles.value));
    }

    boolean generateResidueSpecCode(Token token) {
        this.addTokenToPostfix(token);
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.residueSpecCodeGenerated = true;
        return true;
    }

    boolean clauseResidueSpec() {
        boolean specSeen = false;
        this.residueSpecCodeGenerated = false;
        int tok = this.tokPeek();
        if (tok == 32777 || tok == 32780 || tok == 1) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32777 || tok == 32770 || tok == 2 || tok == 5) {
            if (!this.clauseResNumSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32782 || tok == 32777 || tok == 1 || tok == 2) {
            if (!this.clauseChainSpec(tok)) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32779) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 49181) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32782 || tok == 32783) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (!specSeen) {
            return this.residueSpecificationExpected();
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    boolean clauseResNameSpec() {
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        Token tokenT = this.tokenNext();
        if (tokenT == null) {
            return false;
        }
        if (tokenT.tok == 32780) {
            int pt;
            String strSpec = "";
            int tok = 0;
            while ((tokenT = this.tokenNext()) != null && tokenT.tok != 32781) {
                strSpec = strSpec + tokenT.value;
            }
            tok = tokenT.tok;
            if (tok != 32781) {
                return false;
            }
            if (strSpec == "") {
                return true;
            }
            if (strSpec.length() > 0 && (pt = strSpec.indexOf("*")) >= 0 && pt != strSpec.length() - 1) {
                return this.residueSpecificationExpected();
            }
            strSpec = strSpec.toUpperCase();
            return this.generateResidueSpecCode(new Token(16406, strSpec));
        }
        if (tokenT.tok != 1) {
            return this.identifierOrResidueSpecificationExpected();
        }
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return this.generateResidueSpecCode(new Token(1, tokenT.value + "*"));
        }
        return this.generateResidueSpecCode(tokenT);
    }

    boolean clauseResNumSpec() {
        this.log("clauseResNumSpec()");
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        return this.clauseSequenceRange();
    }

    boolean clauseSequenceRange() {
        if (!this.clauseSequenceCode()) {
            return false;
        }
        int tok = this.tokPeek();
        if (tok == 32770 || tok == 2 && this.intPeek() < 0) {
            if (tok == 32770) {
                this.tokenNext();
            }
            int seqcodeA = this.seqcode;
            if (!this.clauseSequenceCode()) {
                this.seqcode = Integer.MAX_VALUE;
            }
            return this.generateResidueSpecCode(new Token(16408, seqcodeA, new Integer(this.seqcode)));
        }
        return this.generateResidueSpecCode(new Token(16407, this.seqcode, "seqcode"));
    }

    boolean clauseSequenceCode() {
        boolean negative = false;
        int tokPeek = this.tokPeek();
        if (tokPeek == 32770) {
            this.tokenNext();
            negative = true;
            tokPeek = this.tokPeek();
        }
        if (tokPeek == 5) {
            this.seqcode = this.tokenNext().intValue;
        } else if (tokPeek == 2) {
            int val = this.tokenNext().intValue;
            this.seqcode = Group.getSeqcode(Math.abs(val), ' ');
        } else {
            return false;
        }
        if (negative) {
            this.seqcode = -this.seqcode;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    boolean clauseChainSpec(int tok) {
        void var3_4;
        if (tok == 32782) {
            this.tokenNext();
            tok = this.tokPeek();
            if (this.isSpecTerminator(tok)) {
                return this.generateResidueSpecCode(new Token(16409, 0, "spec_chain"));
            }
        }
        if (tok == 32777) {
            this.tokenNext();
            return true;
        }
        switch (tok) {
            case 2: {
                Token tokenChain = this.tokenNext();
                if (tokenChain.intValue < 0 || tokenChain.intValue > 9) {
                    return this.invalidChainSpecification();
                }
                char chain = (char)(48 + tokenChain.intValue);
                break;
            }
            case 1: {
                Token tokenChain = this.tokenNext();
                String strChain = (String)tokenChain.value;
                if (strChain.length() != 1) {
                    return this.invalidChainSpecification();
                }
                char chain = strChain.charAt(0);
                if (chain != '?') break;
                return true;
            }
            default: {
                return this.invalidChainSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16409, (int)var3_4, "spec_chain"));
    }

    boolean isSpecTerminator(int tok) {
        switch (tok) {
            case 0: 
            case 32769: 
            case 32771: 
            case 32772: 
            case 32773: 
            case 32783: 
            case 49181: {
                return true;
            }
        }
        return false;
    }

    boolean clauseAlternateSpec() {
        this.tokenNext();
        int tok = this.tokPeek();
        if (this.isSpecTerminator(tok)) {
            return this.generateResidueSpecCode(new Token(16410, null));
        }
        Token tokenAlternate = this.tokenNext();
        String alternate = (String)tokenAlternate.value;
        switch (tokenAlternate.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 32777: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16410, alternate));
    }

    boolean clauseModelSpec() {
        int tok = this.tokPeek();
        if (tok == 32782 || tok == 32783) {
            this.tokenNext();
        }
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            return true;
        }
        Token tokenModel = this.tokenNext();
        if (tokenModel == null) {
            return this.invalidModelSpecification();
        }
        switch (tokenModel.tok) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16411, (String)tokenModel.value));
    }

    boolean clauseAtomSpec() {
        if (!this.tokenNext(32779)) {
            return this.invalidAtomSpecification();
        }
        Token tokenAtomSpec = this.tokenNext();
        if (tokenAtomSpec == null) {
            return true;
        }
        String atomSpec = "";
        if (tokenAtomSpec.tok == 2) {
            atomSpec = atomSpec + "" + tokenAtomSpec.intValue;
            tokenAtomSpec = this.tokenNext();
            if (tokenAtomSpec == null) {
                return this.invalidAtomSpecification();
            }
        }
        switch (tokenAtomSpec.tok) {
            case 32777: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return this.invalidAtomSpecification();
            }
        }
        atomSpec = atomSpec + (String)tokenAtomSpec.value;
        if (this.tokPeek() == 32777) {
            this.tokenNext();
            atomSpec = atomSpec + "*";
        }
        return this.generateResidueSpecCode(new Token(16412, atomSpec));
    }

    boolean compileColorParam() {
        for (int i = 1; i < this.atokenCommand.length; ++i) {
            String id;
            int argb;
            Token token = this.atokenCommand[i];
            if (token.tok == 32780) {
                if (this.compileRGB(i)) continue;
                return false;
            }
            if (token.tok == 8392723) {
                ++i;
                continue;
            }
            if (token.tok != 1 || (argb = Graphics3D.getArgbFromString(id = (String)token.value)) == 0) continue;
            token.tok = 540692;
            token.intValue = argb;
        }
        return true;
    }

    boolean compileRGB(int i) {
        String hex;
        Token[] atoken = this.atokenCommand;
        if (atoken.length >= i + 7 && atoken[i].tok == 32780 && atoken[i + 1].tok == 2 && atoken[i + 2].tok == 32772 && atoken[i + 3].tok == 2 && atoken[i + 4].tok == 32772 && atoken[i + 5].tok == 2 && atoken[i + 6].tok == 32781) {
            int argb = 0xFF000000 | atoken[i + 1].intValue << 16 | atoken[i + 3].intValue << 8 | atoken[i + 5].intValue;
            atoken[i++] = new Token(540692, argb, "[R,G,B]");
            for (int ipt = i + 6; ipt < atoken.length; ++ipt) {
                atoken[i++] = atoken[ipt];
            }
            Token[] atokenNew = new Token[i];
            System.arraycopy(atoken, 0, atokenNew, 0, i);
            this.atokenCommand = atokenNew;
            return true;
        }
        if (atoken.length >= i + 3 && atoken[i].tok == 32780 && atoken[i + 1].tok == 1 && atoken[i + 2].tok == 32781 && (hex = (String)atoken[i + 1].value).length() == 7 && hex.charAt(0) == 'x') {
            try {
                int argb = 0xFF000000 | Integer.parseInt(hex.substring(1), 16);
                atoken[i++] = new Token(540692, argb, "[xRRGGBB]");
                for (int ipt = i + 2; ipt < atoken.length; ++ipt) {
                    atoken[i++] = atoken[ipt];
                }
                Token[] atokenNew = new Token[i];
                System.arraycopy(atoken, 0, atokenNew, 0, i);
                this.atokenCommand = atokenNew;
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return this.badRGBColor();
    }
}

