/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import org.jmol.util.Logger;
import org.jmol.viewer.Text;
import org.jmol.viewer.TextShape;

class Echo
extends TextShape {
    private static final String FONTFACE = "Serif";
    private static final int FONTSIZE = 20;
    private static final short COLOR = 10;

    Echo() {
    }

    void initShape() {
        this.myType = 1;
        this.setProperty("target", "top", null);
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        String target;
        Logger.debug("Echo.setProperty(" + propertyName + "," + value + ")");
        if ("target" == propertyName && (target = ((String)value).intern().toLowerCase()) != "none" && target != "all") {
            Text text = (Text)this.texts.get(target);
            if (text == null) {
                int valign = 0;
                int halign = 1;
                if ("top" == target) {
                    valign = 1;
                    halign = 2;
                } else if ("middle" == target) {
                    valign = 3;
                    halign = 2;
                } else if ("bottom" == target) {
                    valign = 2;
                }
                text = new Text(this.g3d, this.g3d.getFont3D(FONTFACE, 20), target, 10, valign, halign);
                text.setAdjustForWindow(true);
                this.texts.put(target, text);
                if (this.currentFont != null) {
                    text.setFont(this.currentFont);
                }
                if (this.currentColor != null) {
                    text.setColix(this.currentColor);
                }
                if (this.currentBgColor != null) {
                    text.setBgColix(this.currentBgColor);
                }
            }
            this.currentText = text;
        }
        super.setProperty(propertyName, value, null);
    }

    String getShapeState() {
        StringBuffer s = new StringBuffer();
        String lastFormat = "";
        Enumeration e = this.texts.elements();
        while (e.hasMoreElements()) {
            Text t = (Text)e.nextElement();
            s.append(t.getState(true));
            String format = t.getState(false);
            if (format.equals(lastFormat)) continue;
            lastFormat = format;
            s.append(format);
        }
        return s.toString();
    }
}

