/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.Context;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PatternMatcher;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Eval {
    Compiler compiler;
    static final int scriptLevelMax = 10;
    int scriptLevel;
    Context[] stack = new Context[10];
    String filename;
    String script;
    short[] linenumbers;
    short[] lineIndices;
    Token[][] aatoken;
    int pc;
    long timeBeginExecution;
    long timeEndExecution;
    boolean error;
    String errorMessage;
    Token[] statement;
    int statementLength;
    Viewer viewer;
    BitSet bsSubset;
    boolean tQuiet;
    boolean logMessages = false;
    static Boolean interruptExecution = Boolean.FALSE;
    static Boolean executionPaused = Boolean.FALSE;
    boolean isExecuting = false;
    Thread currentThread = null;
    int commandHistoryLevelMax = 0;
    static final int MAX_IF_DEPTH = 10;
    boolean[] ifs = new boolean[11];
    final StringBuffer strbufLog = new StringBuffer(80);
    int pcLastExpressionInstruction;
    boolean coordinatesAreFractional;
    Hashtable variables = new Hashtable();
    String[] dataLabelString;
    int lastMoNumber = 0;
    boolean ignoreError;

    Eval(Viewer viewer) {
        this.compiler = new Compiler(viewer);
        this.viewer = viewer;
        this.clearDefinitionsAndLoadPredefined();
    }

    void haltExecution() {
        this.resumePausedExecution();
        interruptExecution = Boolean.TRUE;
    }

    boolean isScriptExecuting() {
        return this.isExecuting && interruptExecution == false;
    }

    public void runEval() {
        this.viewer.pushHoldRepaint();
        interruptExecution = Boolean.FALSE;
        executionPaused = Boolean.FALSE;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.timeBeginExecution = System.currentTimeMillis();
        try {
            this.instructionDispatchLoop();
        }
        catch (ScriptException e) {
            this.error = true;
            this.errorMessage = "" + e;
            this.viewer.scriptStatus("script ERROR: " + this.errorMessage);
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && interruptExecution.booleanValue()) {
            this.errorMessage = "execution interrupted";
        } else if (!this.tQuiet) {
            this.viewer.scriptStatus("Script completed");
        }
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint();
    }

    boolean hadRuntimeError() {
        return this.error;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    void runScript(String script) throws ScriptException {
        this.pushContext();
        if (this.loadScript(null, script)) {
            this.instructionDispatchLoop();
        }
        this.popContext();
    }

    void pushContext() throws ScriptException {
        if (this.scriptLevel == 10) {
            this.evalError(GT._("too many script levels"));
        }
        Context context = new Context();
        context.filename = this.filename;
        context.script = this.script;
        context.linenumbers = this.linenumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.pc = this.pc;
        this.stack[this.scriptLevel++] = context;
    }

    void popContext() throws ScriptException {
        if (this.scriptLevel == 0) {
            this.evalError("RasMol virtual machine error - stack underflow");
        }
        Context context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.filename = context.filename;
        this.script = context.script;
        this.linenumbers = context.linenumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.pc = context.pc;
    }

    boolean loadScript(String filename, String script) {
        this.filename = filename;
        this.script = script;
        if (!this.compiler.compile(filename, script, false)) {
            this.error = true;
            this.errorMessage = this.compiler.getErrorMessage();
            this.viewer.scriptStatus("script compiler ERROR: " + this.errorMessage);
            return false;
        }
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.linenumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        return true;
    }

    boolean loadTokenInfo(String script, Vector tokenInfo) {
        this.filename = null;
        this.script = script;
        this.errorMessage = null;
        this.pc = 0;
        this.aatoken = (Token[][])tokenInfo.get(0);
        this.linenumbers = (short[])tokenInfo.get(1);
        this.lineIndices = (short[])tokenInfo.get(2);
        return true;
    }

    Object checkScript(String script) {
        if (!this.compiler.compile(null, script, false)) {
            return this.compiler.getErrorMessage();
        }
        Vector<Object> info = new Vector<Object>();
        info.add(this.compiler.getAatokenCompiled());
        info.add(this.compiler.getLineNumbers());
        info.add(this.compiler.getLineIndices());
        return info;
    }

    void clearState(boolean tQuiet) {
        int i = 10;
        while (--i >= 0) {
            this.stack[i] = null;
        }
        this.scriptLevel = 0;
        this.error = false;
        this.errorMessage = null;
        this.tQuiet = tQuiet;
    }

    boolean loadScriptString(String script, boolean tQuiet) {
        this.clearState(tQuiet);
        return this.loadScript(null, script);
    }

    boolean loadScriptFile(String filename, boolean tQuiet) {
        this.clearState(tQuiet);
        return this.loadScriptFileInternal(filename);
    }

    boolean loadScriptFileInternal(String filename) {
        Object t = this.viewer.getInputStreamOrErrorMessageFromName(filename);
        if (!(t instanceof InputStream)) {
            return this.loadError((String)t);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)t));
        StringBuffer script = new StringBuffer();
        try {
            String command;
            while ((command = reader.readLine()) != null) {
                script.append(command);
                script.append("\n");
            }
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.ioError(filename);
        }
        try {
            reader.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return this.loadScript(filename, script.toString());
    }

    boolean loadError(String msg) {
        this.error = true;
        this.errorMessage = msg;
        return false;
    }

    boolean fileNotFound(String filename) {
        return this.loadError("file not found:" + filename);
    }

    boolean ioError(String filename) {
        return this.loadError("io error reading:" + filename);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Eval\n pc:");
        str.append(this.pc);
        str.append("\n");
        str.append(this.aatoken.length);
        str.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            str.append(" |");
            Token[] atoken = this.aatoken[i];
            for (int j = 0; j < atoken.length; ++j) {
                str.append(' ');
                str.append(atoken[j]);
            }
            str.append("\n");
        }
        str.append("END\n");
        return str.toString();
    }

    void clearDefinitionsAndLoadPredefined() {
        String definition;
        this.variables.clear();
        this.bsSubset = null;
        this.viewer.setSelectionSubset(null);
        int cPredef = JmolConstants.predefinedSets.length;
        for (int iPredef = 0; iPredef < cPredef; ++iPredef) {
            this.predefine(JmolConstants.predefinedSets[iPredef]);
        }
        int firstIsotope = 4;
        int i = JmolConstants.elementNumberMax;
        while (--i > 1) {
            definition = "@" + JmolConstants.elementNameFromNumber(i) + " _e=" + i;
            this.predefine(definition);
        }
        i = JmolConstants.elementNumberMax;
        while (--i >= 1) {
            definition = "@_" + JmolConstants.elementSymbolFromNumber(i) + " " + JmolConstants.elementNameFromNumber(i);
            this.predefine(definition);
        }
        i = firstIsotope;
        while (--i >= 0) {
            definition = "@" + JmolConstants.altElementNameFromIndex(i) + " _e=" + JmolConstants.altElementNumberFromIndex(i);
            this.predefine(definition);
        }
        i = JmolConstants.altElementMax;
        while (--i >= firstIsotope) {
            String def = " element=" + JmolConstants.altElementNumberFromIndex(i);
            String definition2 = "@_" + JmolConstants.altElementSymbolFromIndex(i);
            this.predefine(definition2 + def);
            definition2 = "@_" + JmolConstants.altIsotopeSymbolFromIndex(i);
            this.predefine(definition2 + def);
            definition2 = "@" + JmolConstants.altElementNameFromIndex(i);
            if (definition2.length() <= 1) continue;
            this.predefine(definition2 + def);
        }
    }

    void predefine(String script) {
        if (this.compiler.compile("#predefine", script, true)) {
            Token[][] aatoken = this.compiler.getAatokenCompiled();
            if (aatoken.length != 1) {
                this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + script);
                return;
            }
            Token[] statement = aatoken[0];
            if (statement.length > 2) {
                int tok = statement[1].tok;
                if (tok == 1 || (tok & 0x48000) == 294912) {
                    String variable = (String)statement[1].value;
                    this.variables.put(variable, statement);
                } else {
                    this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + script);
                }
            } else {
                this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + script);
            }
        } else {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + script + "\ncompile error:" + this.compiler.getErrorMessage());
        }
    }

    void pauseExecution() {
        this.delay(100L);
        executionPaused = Boolean.TRUE;
    }

    void resumePausedExecution() {
        executionPaused = Boolean.FALSE;
    }

    boolean checkContinue() {
        if (!interruptExecution.booleanValue()) {
            if (!executionPaused.booleanValue()) {
                return true;
            }
            Logger.debug("script execution paused at this command: " + this.getCommand());
            try {
                while (executionPaused.booleanValue()) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.debug("script execution resumed");
        }
        return interruptExecution == false;
    }

    void instructionDispatchLoop() throws ScriptException {
        long timeBegin = 0L;
        int ifLevel = 0;
        this.ifs[0] = true;
        this.logMessages = Logger.isActiveLevel(0);
        if (this.logMessages) {
            timeBegin = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + timeBegin);
            this.viewer.scriptStatus(this.toString());
        }
        if (this.scriptLevel <= this.commandHistoryLevelMax) {
            this.viewer.addCommand(this.script);
        }
        block90: while (this.pc < this.aatoken.length && this.checkContinue()) {
            Token token = this.aatoken[this.pc][0];
            this.statement = this.aatoken[this.pc++];
            this.statementLength = this.statement.length;
            if (this.logMessages) {
                this.logDebugScript();
            }
            Logger.debug(token.toString());
            if (ifLevel > 0 && !this.ifs[ifLevel] && token.tok != 366 && token.tok != 364 && token.tok != 365) continue;
            switch (token.tok) {
                case 364: {
                    if (++ifLevel == 10) {
                        this.evalError(GT._("Too many nested {0} commands", "IF"));
                    }
                    this.ifs[ifLevel] = this.ifs[ifLevel - 1] && this.ifCmd();
                    continue block90;
                }
                case 365: {
                    if (ifLevel < 1) {
                        this.evalError(GT._("Invalid {0} command", "ELSE"));
                    }
                    this.ifs[ifLevel] = !this.ifs[ifLevel];
                    continue block90;
                }
                case 366: {
                    if (--ifLevel >= 0) continue block90;
                    this.evalError(GT._("Invalid {0} command", "ENDIF"));
                    continue block90;
                }
                case 303360: {
                    this.proteinShape(8);
                    continue block90;
                }
                case 4718849: {
                    this.background();
                    continue block90;
                }
                case 6916: {
                    this.center(1);
                    continue block90;
                }
                case 526598: {
                    this.color();
                    continue block90;
                }
                case 4360: {
                    this.data();
                    continue block90;
                }
                case 777: {
                    this.define();
                    continue block90;
                }
                case 1050891: {
                    this.echo();
                    continue block90;
                }
                case 1048933: {
                    this.message();
                    continue block90;
                }
                case 268: {
                    if (this.pc > 1) {
                        this.viewer.clearScriptQueue();
                    }
                }
                case 277: {
                    interruptExecution = this.pc > 1 || !this.viewer.usingScriptQueue() ? Boolean.TRUE : Boolean.FALSE;
                    continue block90;
                }
                case 0x10010F: {
                    this.label();
                    continue block90;
                }
                case 0x100151: {
                    this.hover();
                    continue block90;
                }
                case 0x200110: {
                    this.load();
                    continue block90;
                }
                case 15634: {
                    this.monitor();
                    continue block90;
                }
                case 278: {
                    this.refresh();
                    continue block90;
                }
                case 305: {
                    this.initialize();
                    continue block90;
                }
                case 280: {
                    this.reset();
                    continue block90;
                }
                case 2106651: {
                    this.rotate(false);
                    continue block90;
                }
                case 0x10011D: {
                    this.script();
                    continue block90;
                }
                case 6506: {
                    this.history(1);
                    continue block90;
                }
                case 798: {
                    this.select();
                    continue block90;
                }
                case 2097450: {
                    this.translate();
                    continue block90;
                }
                case 2097510: {
                    this.translateSelected();
                    continue block90;
                }
                case 302: {
                    this.zap();
                    continue block90;
                }
                case 2102575: {
                    this.zoom(false);
                    continue block90;
                }
                case 2102576: {
                    this.zoom(true);
                    continue block90;
                }
                case 316: {
                    this.delay();
                    continue block90;
                }
                case 317: {
                    this.delay();
                    this.pc = 0;
                    continue block90;
                }
                case 2097470: {
                    this.move();
                    continue block90;
                }
                case 2923: {
                    this.display();
                    continue block90;
                }
                case 847: {
                    this.hide();
                    continue block90;
                }
                case 793: {
                    this.restrict();
                    continue block90;
                }
                case 295791: {
                    this.subset();
                    continue block90;
                }
                case 2409: {
                    this.setSelectionHalo(1);
                    continue block90;
                }
                case 2106655: {
                    this.set();
                    continue block90;
                }
                case 8481: {
                    this.slab();
                    continue block90;
                }
                case 306: {
                    this.depth();
                    continue block90;
                }
                case 307: {
                    this.star();
                    continue block90;
                }
                case 341: {
                    this.halo();
                    continue block90;
                }
                case 2107683: {
                    this.spacefill();
                    continue block90;
                }
                case 8492: {
                    this.wireframe();
                    continue block90;
                }
                case 2097491: {
                    this.vector();
                    continue block90;
                }
                case 2098529: {
                    this.dipole();
                    continue block90;
                }
                case 323: {
                    this.animation();
                    continue block90;
                }
                case 338: {
                    this.vibration();
                    continue block90;
                }
                case 359: {
                    this.calculate();
                    continue block90;
                }
                case 8458: {
                    this.dots(1, 0);
                    continue block90;
                }
                case 10535: {
                    this.proteinShape(11);
                    continue block90;
                }
                case 340: {
                    this.proteinShape(12);
                    continue block90;
                }
                case 8474: {
                    this.proteinShape(13);
                    continue block90;
                }
                case 8489: {
                    this.proteinShape(9);
                    continue block90;
                }
                case 2307: {
                    this.proteinShape(10);
                    continue block90;
                }
                case 342: {
                    this.proteinShape(14);
                    continue block90;
                }
                case 2112832: {
                    this.rotate(true);
                    continue block90;
                }
                case 10532: {
                    this.ssbond();
                    continue block90;
                }
                case 10509: {
                    this.hbond(true);
                    continue block90;
                }
                case 288: {
                    this.show();
                    continue block90;
                }
                case 324: {
                    this.frame(1, false);
                    continue block90;
                }
                case 102661: {
                    this.frame(1, true);
                    continue block90;
                }
                case 336: {
                    this.font();
                    continue block90;
                }
                case 2098520: {
                    this.moveto();
                    continue block90;
                }
                case 345: {
                    this.bondorder();
                    continue block90;
                }
                case 346: {
                    this.console();
                    continue block90;
                }
                case 347: {
                    this.pmesh();
                    continue block90;
                }
                case 2626911: {
                    this.draw();
                    continue block90;
                }
                case 525660: {
                    this.polyhedra();
                    continue block90;
                }
                case 343: {
                    this.dots(1, 1);
                    continue block90;
                }
                case 349: {
                    this.centerAt();
                    continue block90;
                }
                case 2626910: {
                    this.isosurface();
                    continue block90;
                }
                case 524644: {
                    this.lcaoCartoon();
                    continue block90;
                }
                case 2625891: {
                    this.mo();
                    continue block90;
                }
                case 2621734: {
                    this.stereo();
                    continue block90;
                }
                case 1287: {
                    this.connect();
                    continue block90;
                }
                case 352: {
                    this.getProperty();
                    continue block90;
                }
                case 354: {
                    this.configuration();
                    continue block90;
                }
                case 2305: {
                    this.setAxes(1);
                    continue block90;
                }
                case 6405: {
                    this.setBoundbox(1);
                    continue block90;
                }
                case 301332: {
                    this.setUnitcell(1);
                    continue block90;
                }
                case 2335: {
                    this.setFrank(1);
                    continue block90;
                }
                case 1050894: {
                    this.help();
                    continue block90;
                }
                case 4380: {
                    this.save();
                    continue block90;
                }
                case 360: {
                    this.restore();
                    continue block90;
                }
                case 2349: {
                    this.write();
                    continue block90;
                }
                case 16659: {
                    this.pauseExecution();
                    continue block90;
                }
                case 261: 
                case 276: 
                case 296: 
                case 299: 
                case 319: 
                case 322: 
                case 4417: 
                case 10498: 
                case 98572: 
                case 2097431: {
                    this.viewer.scriptStatus("script ERROR: command not implemented:" + token.value);
                    continue block90;
                }
            }
            this.unrecognizedCommand(token);
            return;
        }
    }

    boolean ifCmd() throws ScriptException {
        if (this.statementLength < 1) {
            this.badArgumentCount();
        }
        boolean value = false;
        boolean isNot = false;
        int i = 1;
        if (i < this.statementLength && this.statement[i].tok == 32768) {
            ++i;
        }
        if (i < this.statementLength && this.statement[i].tok == 32773) {
            ++i;
            isNot = true;
        }
        if (i == this.statementLength) {
            this.badArgumentCount();
        }
        String str = (String)this.statement[i].value;
        value = this.viewer.getBooleanProperty(str);
        return isNot ? !value : value;
    }

    int getLinenumber() {
        return this.linenumbers[this.pc];
    }

    String getLine() {
        short ichBegin = this.lineIndices[this.pc];
        int ichEnd = this.script.indexOf(13, (int)ichBegin);
        if (ichEnd == -1 && (ichEnd = this.script.indexOf(10, (int)ichBegin)) == -1) {
            ichEnd = this.script.length();
        }
        return this.script.substring(ichBegin, ichEnd);
    }

    String getCommand() {
        int ichEnd;
        short ichBegin = this.lineIndices[this.pc];
        int n = ichEnd = this.pc + 1 == this.lineIndices.length || this.lineIndices[this.pc + 1] == 0 ? this.script.length() : this.lineIndices[this.pc + 1];
        while ("\n\r;".indexOf(this.script.charAt(ichEnd - 1)) >= 0) {
            --ichEnd;
        }
        return this.script.substring(ichBegin, ichEnd) + ";";
    }

    void logDebugScript() {
        int i;
        this.strbufLog.setLength(0);
        Logger.debug(this.statement[0].toString());
        for (i = 1; i < this.statementLength; ++i) {
            this.strbufLog.append(this.statement[i] + "\n");
            Logger.debug(this.statement[i].toString());
        }
        this.strbufLog.append(this.statement[0].value.toString());
        block18: for (i = 1; i < this.statementLength; ++i) {
            this.strbufLog.append(' ');
            Token token = this.statement[i];
            switch (token.tok) {
                case 2: {
                    this.strbufLog.append(token.intValue);
                    continue block18;
                }
                case 16407: {
                    this.strbufLog.append(Group.getSeqcodeString(token.intValue));
                    continue block18;
                }
                case 16409: {
                    this.strbufLog.append(':');
                    this.strbufLog.append((char)token.intValue);
                    continue block18;
                }
                case 16410: {
                    this.strbufLog.append("%");
                    this.strbufLog.append("" + token.value);
                    break;
                }
                case 16411: {
                    this.strbufLog.append("/");
                    this.strbufLog.append("" + token.value);
                    break;
                }
                case 16405: {
                    this.strbufLog.append('[');
                    this.strbufLog.append(Group.getGroup3((short)token.intValue));
                    this.strbufLog.append(']');
                    continue block18;
                }
                case 16406: {
                    this.strbufLog.append('[');
                    this.strbufLog.append(token.value);
                    this.strbufLog.append(']');
                    continue block18;
                }
                case 16455: {
                    this.strbufLog.append(StateManager.encodeBitset((BitSet)token.value));
                    continue block18;
                }
                case 16412: {
                    this.strbufLog.append('.');
                    break;
                }
                case 16408: {
                    this.strbufLog.append(Group.getSeqcodeString(token.intValue));
                    this.strbufLog.append('-');
                    this.strbufLog.append(Group.getSeqcodeString((Integer)token.value));
                    break;
                }
                case 32774: {
                    this.strbufLog.append("within ");
                    break;
                }
                case 32788: {
                    this.strbufLog.append("connected ");
                    break;
                }
                case 32784: {
                    this.strbufLog.append("substructure ");
                    break;
                }
                case 98317: {
                    Point3f pt = (Point3f)token.value;
                    this.strbufLog.append("cell={" + pt.x + " " + pt.y + " " + pt.z + "}");
                    continue block18;
                }
                case 4: {
                    this.strbufLog.append("\"" + token.value + "\"");
                    continue block18;
                }
                default: {
                    this.strbufLog.append(token.toString());
                }
            }
            this.strbufLog.append("" + token.value);
        }
        this.viewer.scriptStatus(this.strbufLog.toString());
    }

    BitSet expression(Token[] code, int pcStart) throws ScriptException {
        boolean isSubsetDefinition;
        BitSet[] stack = new BitSet[10];
        int sp = 0;
        Point3f thisCoordinate = null;
        boolean refreshed = false;
        this.pcLastExpressionInstruction = 1000;
        boolean bl = isSubsetDefinition = pcStart < 0;
        if (isSubsetDefinition) {
            pcStart = -pcStart;
        }
        if (this.logMessages) {
            this.viewer.scriptStatus("start to evaluate expression");
        }
        int pc = pcStart;
        block34: while (true) {
            Token instruction = code[pc];
            if (this.logMessages) {
                this.viewer.scriptStatus("instruction=" + instruction);
            }
            switch (instruction.tok) {
                case 32868: {
                    break;
                }
                case 32869: {
                    this.pcLastExpressionInstruction = pc;
                    break block34;
                }
                case 32785: {
                    thisCoordinate = this.getCoordinate(pc, true);
                    pc = this.pcLastExpressionInstruction;
                    break;
                }
                case 36875: {
                    int n = sp++;
                    BitSet bitSet = this.bsAll();
                    stack[n] = bitSet;
                    BitSet bs = bitSet;
                    break;
                }
                case 49157: {
                    stack[sp++] = new BitSet();
                    break;
                }
                case 32772: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].or(bs);
                    break;
                }
                case 32791: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].xor(bs);
                    break;
                }
                case 32771: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].and(bs);
                    break;
                }
                case 32773: {
                    BitSet bs = stack[sp - 1];
                    this.notSet(bs);
                    break;
                }
                case 32792: {
                    BitSet bs = stack[--sp];
                    this.toggle(stack[sp - 1], bs);
                    break;
                }
                case 32774: {
                    if (thisCoordinate != null) {
                        Object withinSpec = instruction.value;
                        if (!(withinSpec instanceof Float)) {
                            this.numberExpected();
                        }
                        stack[sp++] = this.viewer.getAtomsWithin(((Float)withinSpec).floatValue(), thisCoordinate);
                        thisCoordinate = null;
                        break;
                    }
                    BitSet bs = stack[sp - 1];
                    stack[sp - 1] = this.within(instruction, bs);
                    break;
                }
                case 32788: {
                    BitSet bs = stack[sp - 1];
                    stack[sp - 1] = this.connected(instruction, bs);
                    break;
                }
                case 32784: {
                    stack[sp++] = this.getSubstructureSet((String)instruction.value);
                    break;
                }
                case 299011: {
                    stack[sp++] = Eval.copyBitSet(this.viewer.getSelectionSet());
                    break;
                }
                case 295791: {
                    stack[sp++] = Eval.copyBitSet(this.bsSubset == null ? this.bsAll() : this.bsSubset);
                    break;
                }
                case 294928: {
                    stack[sp++] = Eval.copyBitSet(this.viewer.getHiddenSet());
                    break;
                }
                case 294929: {
                    stack[sp++] = this.invertBitSet(this.viewer.getHiddenSet());
                    break;
                }
                case 294925: {
                    if (!refreshed) {
                        this.viewer.setModelVisibility();
                    }
                    refreshed = true;
                    stack[sp++] = this.viewer.getVisibleSet();
                    break;
                }
                case 294926: {
                    this.refresh();
                    stack[sp++] = this.viewer.getClickableSet();
                    break;
                }
                case 294918: 
                case 294919: 
                case 294920: 
                case 294921: 
                case 294922: 
                case 294923: 
                case 294927: 
                case 296961: 
                case 296962: 
                case 299016: 
                case 299020: 
                case 301332: {
                    stack[sp++] = this.viewer.getAtomBits((String)instruction.value);
                    break;
                }
                case 16412: {
                    stack[sp++] = this.viewer.getAtomBits("SpecAtom", (String)instruction.value);
                    break;
                }
                case 16406: {
                    stack[sp++] = this.viewer.getAtomBits("SpecName", (String)instruction.value);
                    break;
                }
                case 16455: {
                    stack[sp++] = (BitSet)instruction.value;
                    break;
                }
                case 16410: {
                    stack[sp++] = this.viewer.getAtomBits("SpecAlternate", (String)instruction.value);
                    break;
                }
                case 16411: {
                    stack[sp++] = this.viewer.getAtomBits("SpecModel", (String)instruction.value);
                    break;
                }
                case 16405: {
                    stack[sp++] = this.viewer.getAtomBits("SpecResid", instruction.intValue);
                    break;
                }
                case 16407: {
                    stack[sp++] = this.viewer.getAtomBits("SpecSeqcode", instruction.intValue);
                    break;
                }
                case 16409: {
                    stack[sp++] = this.viewer.getAtomBits("SpecChain", instruction.intValue);
                    break;
                }
                case 16408: {
                    int seqcodeA = instruction.intValue;
                    int seqcodeB = (Integer)instruction.value;
                    stack[sp++] = this.viewer.getAtomBits("SpecSeqcodeRange", new int[]{seqcodeA, seqcodeB});
                    break;
                }
                case 98317: {
                    Point3f pt = (Point3f)instruction.value;
                    stack[sp++] = this.viewer.getAtomBits("Cell", new int[]{(int)(pt.x * 1000.0f), (int)(pt.y * 1000.0f), (int)(pt.z * 1000.0f)});
                    break;
                }
                case 1: 
                case 294912: 
                case 294917: 
                case 294924: 
                case 296964: 
                case 303360: {
                    stack[sp++] = this.lookupIdentifierValue((String)instruction.value);
                    break;
                }
                case 163840: 
                case 163841: 
                case 163842: 
                case 163843: 
                case 163844: 
                case 163845: {
                    int n = sp++;
                    BitSet bitSet = new BitSet();
                    stack[n] = bitSet;
                    BitSet bs = bitSet;
                    this.comparatorInstruction(instruction, bs);
                    break;
                }
                default: {
                    this.unrecognizedExpression();
                }
            }
            ++pc;
        }
        if (sp != 1) {
            this.evalError(GT._("atom expression compiler error - stack over/underflow"));
        }
        if (!isSubsetDefinition && this.bsSubset != null) {
            stack[0].and(this.bsSubset);
        }
        return stack[0];
    }

    void toggle(BitSet A, BitSet B) {
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!B.get(i)) continue;
            if (A.get(i)) {
                A.clear(i);
                continue;
            }
            A.or(B);
            return;
        }
    }

    void notSet(BitSet bs) {
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (bs.get(i)) {
                bs.clear(i);
                continue;
            }
            bs.set(i);
        }
    }

    BitSet lookupIdentifierValue(String identifier) throws ScriptException {
        BitSet bs = this.lookupValue(identifier, false);
        if (bs != null) {
            return Eval.copyBitSet(bs);
        }
        bs = this.viewer.getAtomBits("IdentifierOrNull", identifier);
        return bs == null ? new BitSet() : bs;
    }

    BitSet lookupValue(String variable, boolean plurals) throws ScriptException {
        Object value;
        if (this.logMessages) {
            this.viewer.scriptStatus("lookupValue(" + variable + ")");
        }
        if ((value = this.variables.get(variable)) != null) {
            if (value instanceof Token[]) {
                value = this.expression((Token[])value, 2);
                this.variables.put(variable, value);
            }
            return (BitSet)value;
        }
        if (plurals) {
            return null;
        }
        int len = variable.length();
        if (len < 5) {
            return null;
        }
        if (variable.charAt(len - 1) != 's') {
            return null;
        }
        variable = variable.endsWith("ies") ? variable.substring(0, len - 3) + 'y' : variable.substring(0, len - 1);
        return this.lookupValue(variable, true);
    }

    void comparatorInstruction(Token instruction, BitSet bs) throws ScriptException {
        int comparator = instruction.tok;
        int property = instruction.intValue;
        float propertyValue = Float.NaN;
        int comparisonValue = (Integer)instruction.value;
        BitSet propertyBitSet = null;
        int bitsetComparator = comparator;
        int bitsetBaseValue = comparisonValue;
        int atomCount = this.viewer.getAtomCount();
        int imax = 0;
        int imin = 0;
        Frame frame = this.viewer.getFrame();
        block39: for (int i = 0; i < atomCount; ++i) {
            boolean match = false;
            Atom atom = frame.getAtomAt(i);
            switch (property) {
                case 98304: {
                    propertyValue = atom.getAtomNumber();
                    break;
                }
                case 98322: {
                    propertyValue = i;
                    break;
                }
                case 98305: {
                    propertyValue = atom.getElementNumber();
                    break;
                }
                case 98319: {
                    propertyValue = atom.getAtomicAndIsotopeNumber();
                    break;
                }
                case 100371: {
                    propertyValue = atom.getFormalCharge();
                    break;
                }
                case 98318: {
                    propertyValue = atom.getAtomSite();
                    break;
                }
                case 98320: {
                    propertyBitSet = atom.getAtomSymmetry();
                    if (bitsetBaseValue < 1000) break;
                    comparisonValue = bitsetBaseValue % 1000;
                    int symop = bitsetBaseValue / 1000 - 1;
                    if (symop < 0 || !(match = propertyBitSet.get(symop))) continue block39;
                    bitsetComparator = 49157;
                    propertyValue = atom.getSymmetryTranslation(symop);
                    break;
                }
                case 98572: {
                    propertyValue = atom.getMoleculeNumber();
                    break;
                }
                case 98308: {
                    propertyValue = atom.getBfactor100();
                    if (!(propertyValue < 0.0f)) break;
                    continue block39;
                }
                case 98321: {
                    if (frame.getSurfaceDistanceMax() == 0.0f) {
                        this.dots(this.statementLength, 2);
                    }
                    if (!((propertyValue = atom.getSurfaceDistance()) < 0.0f)) break;
                    continue block39;
                }
                case 98314: {
                    propertyValue = atom.getOccupancy();
                    break;
                }
                case 98315: {
                    propertyValue = atom.getPolymerLength();
                    break;
                }
                case 98306: {
                    propertyValue = atom.getResno();
                    if (propertyValue != -1.0f) break;
                    continue block39;
                }
                case 98311: {
                    propertyValue = atom.getGroupID();
                    if (!(propertyValue < 0.0f)) break;
                    continue block39;
                }
                case 98312: {
                    propertyValue = atom.getSpecialAtomID();
                    if (!(propertyValue < 0.0f)) break;
                    continue block39;
                }
                case 98313: {
                    propertyValue = this.getProteinStructureType(atom);
                    if (propertyValue != -1.0f) break;
                    continue block39;
                }
                case 100355: {
                    propertyValue = atom.getRasMolRadius();
                    break;
                }
                case 98325: {
                    propertyValue = atom.getGroupPsi();
                    break;
                }
                case 98324: {
                    propertyValue = atom.getGroupPhi();
                    break;
                }
                case 98310: {
                    propertyValue = atom.getCovalentBondCount();
                    break;
                }
                case 102661: {
                    propertyValue = atom.getModelTagNumber();
                    break;
                }
                default: {
                    this.unrecognizedAtomProperty(property);
                }
            }
            if (propertyBitSet != null) {
                switch (bitsetComparator) {
                    case 163843: {
                        imax = comparisonValue - 1;
                        imin = 0;
                        break;
                    }
                    case 163842: {
                        imax = comparisonValue;
                        imin = 0;
                        break;
                    }
                    case 163841: {
                        imax = propertyBitSet.size();
                        imin = comparisonValue - 1;
                        break;
                    }
                    case 163840: {
                        imax = propertyBitSet.size();
                        imin = comparisonValue;
                        break;
                    }
                    case 163844: {
                        imax = comparisonValue;
                        imin = comparisonValue - 1;
                        break;
                    }
                    case 163845: {
                        boolean bl = match = !propertyBitSet.get(comparisonValue);
                    }
                }
                if (imin < 0) {
                    imin = 0;
                }
                if (imax > propertyBitSet.size()) {
                    imax = propertyBitSet.size();
                }
                for (int iBit = imin; iBit < imax; ++iBit) {
                    if (!propertyBitSet.get(iBit)) continue;
                    match = true;
                    break;
                }
                if (!match || Float.isNaN(propertyValue)) {
                    comparator = 49157;
                }
            }
            switch (comparator) {
                case 163843: {
                    match = propertyValue < (float)comparisonValue;
                    break;
                }
                case 163842: {
                    match = propertyValue <= (float)comparisonValue;
                    break;
                }
                case 163841: {
                    match = propertyValue >= (float)comparisonValue;
                    break;
                }
                case 163840: {
                    match = propertyValue > (float)comparisonValue;
                    break;
                }
                case 163844: {
                    match = propertyValue == (float)comparisonValue;
                    break;
                }
                case 163845: {
                    boolean bl = match = propertyValue != (float)comparisonValue;
                }
            }
            if (!match) continue;
            bs.set(i);
        }
    }

    BitSet within(Token instruction, BitSet bs) throws ScriptException {
        Object withinSpec = instruction.value;
        if (withinSpec instanceof Float) {
            return this.viewer.getAtomsWithin(((Float)withinSpec).floatValue(), bs);
        }
        if (withinSpec instanceof String) {
            String withinStr = (String)withinSpec;
            if (withinStr.equals("element") || withinStr.equals("site") || withinStr.equals("group") || withinStr.equals("chain") || withinStr.equals("molecule") || withinStr.equals("model")) {
                return this.viewer.getAtomsWithin(withinStr, bs);
            }
            return this.viewer.getAtomsWithin("sequence", withinStr, bs);
        }
        this.evalError(GT._("Unrecognized {0} parameter", "WITHIN") + ":" + withinSpec);
        return null;
    }

    BitSet connected(Token instruction, BitSet bs) {
        int min = instruction.intValue;
        int max = (Integer)instruction.value;
        return this.viewer.getAtomsConnected(min, max, bs);
    }

    BitSet getSubstructureSet(String smiles) throws ScriptException {
        PatternMatcher matcher = new PatternMatcher(this.viewer);
        try {
            return matcher.getSubstructureSet(smiles);
        }
        catch (InvalidSmilesException e) {
            this.evalError(e.getMessage());
            return null;
        }
    }

    int getProteinStructureType(Atom atom) {
        return atom.getProteinStructureType();
    }

    void checkStatementLength(int length) throws ScriptException {
        if (this.statementLength != length) {
            this.badArgumentCount();
        }
    }

    void checkLength34() throws ScriptException {
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.badArgumentCount();
        }
    }

    void checkLength23() throws ScriptException {
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.badArgumentCount();
        }
    }

    void checkLength2() throws ScriptException {
        this.checkStatementLength(2);
    }

    void checkLength3() throws ScriptException {
        this.checkStatementLength(3);
    }

    void checkLength4() throws ScriptException {
        this.checkStatementLength(4);
    }

    String parameterAsString(int i) {
        return this.statementLength <= i ? "" : (this.statement[i].tok == 2 ? "" + this.statement[i].intValue : "" + this.statement[i].value);
    }

    int intParameter(int index) throws ScriptException {
        if (index >= this.statementLength || this.statement[index].tok != 2) {
            this.integerExpected();
        }
        return this.statement[index].intValue;
    }

    float floatParameter(int index) throws ScriptException {
        if (index >= this.statementLength) {
            this.badArgumentCount();
        }
        float floatValue = 0.0f;
        switch (this.statement[index].tok) {
            case 2: {
                floatValue = this.statement[index].intValue;
                break;
            }
            case 3: {
                floatValue = ((Float)this.statement[index].value).floatValue();
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        return floatValue;
    }

    float radiusParameter(int index, float defaultValue) throws ScriptException {
        boolean isOffset;
        if (index >= this.statementLength) {
            this.badArgumentCount();
        }
        float v = Float.NaN;
        boolean bl = isOffset = this.statement[index].tok == 32775;
        if (isOffset) {
            ++index;
        }
        boolean isPercent = index + 1 < this.statementLength && this.statement[index + 1].tok == 49181;
        int tok = index < this.statementLength ? this.statement[index].tok : 0;
        switch (tok) {
            case 2: {
                v = this.statement[index].intValue;
            }
            case 3: {
                if (Float.isNaN(v)) {
                    v = ((Float)this.statement[index].value).floatValue();
                }
                if (!(v < 0.0f)) break;
                isOffset = true;
                break;
            }
            default: {
                v = defaultValue;
                --index;
            }
        }
        this.pcLastExpressionInstruction = index + (isPercent ? 1 : 0);
        if (Float.isNaN(v)) {
            this.numberExpected();
        }
        if (v == 0.0f) {
            return 0.0f;
        }
        if (isPercent) {
            if (v <= -100.0f) {
                this.invalidArgument();
            }
            v += (float)(isOffset ? 200 : 100);
        } else if (!isOffset) {
            if (v < 0.0f || v > 10.0f) {
                this.numberOutOfRange(0.0f, 10.0f);
            }
            v += 10.0f;
        }
        return v;
    }

    int floatParameterSet(int i, float[] fparams) throws ScriptException {
        if (i < this.statementLength && this.statement[i].tok == 32785) {
            ++i;
        }
        for (int j = 0; j < fparams.length; ++j) {
            fparams[j] = this.floatParameter(i++);
        }
        if (i < this.statementLength && this.statement[i].tok != 32786) {
            ++i;
        }
        return i;
    }

    boolean isFloatParameter(int index) {
        if (index >= this.statementLength) {
            return false;
        }
        switch (this.statement[index].tok) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    String stringParameter(int index) throws ScriptException {
        if (index >= this.statementLength) {
            this.badArgumentCount();
        }
        if (this.statement[index].tok == 4) {
            return (String)this.statement[index].value;
        }
        this.stringExpected();
        return null;
    }

    String objectNameParameter(int index) throws ScriptException {
        if (index >= this.statementLength || this.statement[index].tok != 1) {
            this.objectNameExpected();
        }
        return (String)this.statement[index].value;
    }

    int setShapeByNameParameter(int index) throws ScriptException {
        String objectName = this.objectNameParameter(index);
        int shapeType = this.viewer.getShapeIdFromObjectName(objectName);
        if (shapeType < 0) {
            this.objectNameExpected();
        }
        this.viewer.setShapeProperty(shapeType, "thisID", objectName);
        return shapeType;
    }

    float getRasmolAngstroms(int i) throws ScriptException {
        Token token = this.getToken(i);
        switch (token.tok) {
            case 2: {
                return (float)token.intValue / 250.0f;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
        }
        this.numberExpected();
        return -1.0f;
    }

    boolean booleanParameter(int i) throws ScriptException {
        if (this.statementLength == i) {
            return true;
        }
        this.checkStatementLength(i + 1);
        switch (this.statement[i].tok) {
            case 8193: {
                return true;
            }
            case 8192: {
                return false;
            }
        }
        this.booleanExpected();
        return false;
    }

    boolean isAtomCenterOrCoordinateNext(int i) {
        return i != this.statementLength && (this.statement[i].tok == 32785 || this.statement[i].tok == 32868);
    }

    Point3f atomCenterOrCoordinateParameter(int i) throws ScriptException {
        if (i >= this.statementLength) {
            this.badArgumentCount();
        }
        switch (this.statement[i].tok) {
            case 32868: {
                return this.viewer.getAtomSetCenter(this.expression(this.statement, ++i));
            }
            case 32785: {
                return this.getCoordinate(i, true);
            }
        }
        this.invalidArgument();
        return null;
    }

    Point4f planeParameter(int i) throws ScriptException {
        Vector3f vAB = new Vector3f();
        Vector3f vAC = new Vector3f();
        while (i < this.statementLength) {
            switch (this.statement[i].tok) {
                case 32785: {
                    if (!this.isCoordinate3(i)) {
                        return this.getPoint4f(i);
                    }
                }
                case 32868: {
                    Point3f pt1 = this.atomCenterOrCoordinateParameter(i);
                    i = this.pcLastExpressionInstruction;
                    Point3f pt2 = this.atomCenterOrCoordinateParameter(++i);
                    i = this.pcLastExpressionInstruction;
                    Point3f pt3 = this.atomCenterOrCoordinateParameter(++i);
                    i = this.pcLastExpressionInstruction;
                    Vector3f plane = new Vector3f();
                    float w = Graphics3D.getPlaneThroughPoints(pt1, pt2, pt3, plane, vAB, vAC);
                    Point4f p = new Point4f(plane.x, plane.y, plane.z, w);
                    Logger.info("defined plane: " + p);
                    return p;
                }
                case 1: 
                case 4: {
                    String str = (String)this.statement[i].value;
                    this.pcLastExpressionInstruction = i++;
                    if (str.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (str.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (str.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.pcLastExpressionInstruction += 2;
                    if (str.equalsIgnoreCase("x")) {
                        if (i == this.statementLength || this.statement[i++].tok != 163844) {
                            this.evalError("x=?");
                        }
                        return new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(i));
                    }
                    if (str.equalsIgnoreCase("y")) {
                        if (++i == this.statementLength || this.statement[i++].tok != 163844) {
                            this.evalError("y=?");
                        }
                        return new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(i));
                    }
                    if (!str.equalsIgnoreCase("z")) break;
                    if (++i == this.statementLength || this.statement[i++].tok != 163844) {
                        this.evalError("z=?");
                    }
                    return new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(i));
                }
            }
        }
        this.evalError(GT._("plane expected -- either three points or atom expressions or {0} or {1}", new Object[]{"{a b c d}", "\"xy\" \"xz\" \"yz\""}));
        return null;
    }

    Point4f hklParameter(int i) throws ScriptException {
        Point3f offset = this.viewer.getCurrentUnitCellOffset();
        if (offset == null) {
            this.evalError(GT._("No unit cell"));
        }
        Vector3f vAB = new Vector3f();
        Vector3f vAC = new Vector3f();
        Point3f pt = this.getCoordinate(i, true, false, true);
        Point3f pt1 = new Point3f(pt.x == 0.0f ? 1.0f : 1.0f / pt.x, 0.0f, 0.0f);
        Point3f pt2 = new Point3f(0.0f, pt.y == 0.0f ? 1.0f : 1.0f / pt.y, 0.0f);
        Point3f pt3 = new Point3f(0.0f, 0.0f, pt.z == 0.0f ? 1.0f : 1.0f / pt.z);
        if (pt.x == 0.0f && pt.y == 0.0f && pt.z == 0.0f) {
            this.evalError(GT._("Miller indices cannot all be zero."));
        } else if (pt.x == 0.0f && pt.y == 0.0f) {
            pt1.set(1.0f, 0.0f, pt3.z);
            pt2.set(0.0f, 1.0f, pt3.z);
        } else if (pt.y == 0.0f && pt.z == 0.0f) {
            pt2.set(pt1.x, 0.0f, 1.0f);
            pt3.set(pt1.x, 1.0f, 0.0f);
        } else if (pt.z == 0.0f && pt.x == 0.0f) {
            pt3.set(0.0f, pt2.y, 1.0f);
            pt1.set(1.0f, pt2.y, 0.0f);
        } else if (pt.x == 0.0f) {
            pt1.set(1.0f, pt2.y, 0.0f);
        } else if (pt.y == 0.0f) {
            pt2.set(0.0f, 1.0f, pt3.z);
        } else if (pt.z == 0.0f) {
            pt3.set(pt1.x, 0.0f, 1.0f);
        }
        this.viewer.convertFractionalCoordinates(pt1);
        this.viewer.convertFractionalCoordinates(pt2);
        this.viewer.convertFractionalCoordinates(pt3);
        pt1.add(offset);
        pt2.add(offset);
        pt3.add(offset);
        Vector3f plane = new Vector3f();
        float w = Graphics3D.getPlaneThroughPoints(pt1, pt2, pt3, plane, vAB, vAC);
        Point4f p = new Point4f(plane.x, plane.y, plane.z, w);
        Logger.info("defined plane: " + p);
        return p;
    }

    short getMadParameter() throws ScriptException {
        int tok = this.statement[1].tok;
        short mad = 1;
        switch (tok) {
            case 8193: {
                break;
            }
            case 8192: {
                mad = 0;
                break;
            }
            case 2: {
                mad = this.getMadInteger(this.statement[1].intValue);
                break;
            }
            case 3: {
                mad = this.getMadFloat(this.floatParameter(1));
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        return mad;
    }

    short getMadInteger(int radiusRasMol) throws ScriptException {
        if (radiusRasMol < 0 || radiusRasMol > 750) {
            this.numberOutOfRange(0, 750);
        }
        return (short)(radiusRasMol * 4 * 2);
    }

    short getMadFloat(float angstroms) throws ScriptException {
        if (angstroms < 0.0f || angstroms > 3.0f) {
            this.numberOutOfRange(0.0f, 3.0f);
        }
        return (short)(angstroms * 1000.0f * 2.0f);
    }

    short getSetAxesTypeMad(int cmdPt) throws ScriptException {
        if (cmdPt == 2) {
            this.checkLength3();
        }
        if (cmdPt == 1) {
            this.checkLength2();
        }
        int tok = this.statement[cmdPt].tok;
        short mad = 0;
        switch (tok) {
            case 8193: {
                mad = 1;
            }
            case 8192: {
                break;
            }
            case 2: {
                int diameterPixels = this.statement[cmdPt].intValue;
                if (diameterPixels < -1 || diameterPixels >= 20) {
                    this.numberOutOfRange(-1, 19);
                }
                mad = (short)diameterPixels;
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(cmdPt);
                if (angstroms < 0.0f || angstroms >= 2.0f) {
                    this.numberOutOfRange(0.01f, 1.99f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 16414: {
                mad = -1;
                break;
            }
            default: {
                this.booleanOrNumberExpected("DOTTED");
            }
        }
        return mad;
    }

    static BitSet copyBitSet(BitSet bitSet) {
        BitSet copy = new BitSet();
        copy.or(bitSet);
        return copy;
    }

    private BitSet invertBitSet(BitSet bitSet) {
        BitSet copy = this.bsAll();
        copy.andNot(bitSet);
        return copy;
    }

    BitSet getAtomBitSet(String atomExpression) throws ScriptException {
        BitSet bs = new BitSet();
        if (!this.loadScript(null, "select (" + atomExpression + ")")) {
            return bs;
        }
        bs = this.expression(this.aatoken[0], 1);
        return bs;
    }

    int getArgbParam(int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.colorExpected();
        }
        if (this.statement[itoken].tok != 540692) {
            this.colorExpected();
        }
        return this.statement[itoken].intValue;
    }

    int getArgbOrNoneParam(int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.colorExpected();
        }
        if (this.statement[itoken].tok == 540692) {
            return this.statement[itoken].intValue;
        }
        if (this.statement[itoken].tok != 49157) {
            this.colorExpected();
        }
        return 0;
    }

    int getArgbOrPaletteParam(int itoken) throws ScriptException {
        if (itoken < this.statementLength) {
            switch (this.statement[itoken].tok) {
                case 540692: {
                    return this.statement[itoken].intValue;
                }
                case 16392: {
                    return 16392;
                }
                case 16430: 
                case 49157: {
                    return 16430;
                }
            }
        }
        this.evalError(GT._("a color or palette name (Jmol, Rasmol) is required"));
        return 0;
    }

    boolean isCoordinate3(int i) {
        this.ignoreError = true;
        boolean isOK = true;
        try {
            this.getCoordinate(i, true, true, false);
        }
        catch (Exception e) {
            isOK = false;
        }
        this.ignoreError = false;
        return isOK;
    }

    Point3f getCoordinate(int i, boolean allowFractional) throws ScriptException {
        return this.getCoordinate(i, allowFractional, true, false);
    }

    Point3f getCoordinate(int i, boolean allowFractional, boolean doConvert, boolean implicitFractional) throws ScriptException {
        if (i >= this.statementLength) {
            this.coordinateExpected();
        }
        this.coordinatesAreFractional = implicitFractional;
        if (this.statement[i++].tok != 32785) {
            this.coordinateExpected();
        }
        Point3f pt = new Point3f();
        int j = i;
        block4: while (j + 1 < this.statementLength) {
            switch (this.statement[j].tok) {
                case 32783: {
                    this.coordinatesAreFractional = true;
                }
                case 32786: {
                    break block4;
                }
                default: {
                    ++j;
                    continue block4;
                }
            }
        }
        if (this.coordinatesAreFractional && !allowFractional) {
            this.evalError(GT._("fractional coordinates are not allowed in this context"));
        }
        pt.x = this.coordinateValue(i);
        pt.y = this.coordinateValue(++this.pcLastExpressionInstruction);
        pt.z = this.coordinateValue(++this.pcLastExpressionInstruction);
        if (this.statement[++this.pcLastExpressionInstruction].tok != 32786) {
            this.coordinateExpected();
        }
        if (this.coordinatesAreFractional && doConvert) {
            this.viewer.convertFractionalCoordinates(pt);
        }
        return pt;
    }

    Point4f getPoint4f(int i) throws ScriptException {
        this.coordinatesAreFractional = false;
        if (this.statement[i++].tok != 32785) {
            this.coordinateExpected();
        }
        Point4f pt = new Point4f();
        int j = i;
        block4: while (j + 1 < this.statementLength) {
            switch (this.statement[j].tok) {
                case 32783: {
                    this.coordinatesAreFractional = true;
                }
                case 32786: {
                    break block4;
                }
                default: {
                    ++j;
                    continue block4;
                }
            }
        }
        if (this.coordinatesAreFractional) {
            this.evalError(GT._("fractional coordinates are not allowed in this context"));
        }
        pt.x = this.coordinateValue(i);
        pt.y = this.coordinateValue(++this.pcLastExpressionInstruction);
        pt.z = this.coordinateValue(++this.pcLastExpressionInstruction);
        pt.w = this.coordinateValue(++this.pcLastExpressionInstruction);
        if (this.statement[++this.pcLastExpressionInstruction].tok != 32786) {
            this.coordinateExpected();
        }
        return pt;
    }

    float coordinateValue(int i) throws ScriptException {
        float val = this.floatParameter(i++);
        Token token = this.getToken(i);
        if (token.tok == 32783) {
            token = this.getToken(++i);
            if (token.tok == 2 || token.tok == 3) {
                val /= this.floatParameter(i++);
                token = this.getToken(i);
            }
        }
        this.pcLastExpressionInstruction = token.tok == 32772 ? i : i - 1;
        return val;
    }

    Token getToken(int i) throws ScriptException {
        if (i >= this.statementLength) {
            this.endOfStatementUnexpected();
        }
        return this.statement[i];
    }

    void help() throws ScriptException {
        if (!this.viewer.isApplet()) {
            this.evalError(GT._("Currently the {0} command only works for the applet", "help"));
        }
        String what = this.statementLength == 1 ? "" : this.stringParameter(1);
        this.viewer.getHelp(what);
    }

    void moveto() throws ScriptException {
        if (this.statementLength < 2) {
            this.badArgumentCount();
        }
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            this.refresh();
            this.viewer.moveTo(this.floatParameter(1), null, new Point3f(0.0f, 0.0f, 1.0f), 0.0f, 100.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        Point3f pt = new Point3f();
        Point3f center = null;
        int i = 1;
        float floatSecondsTotal = this.isFloatParameter(1) ? this.floatParameter(i++) : 2.0f;
        float zoom = 100.0f;
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        float degrees = 90.0f;
        switch (this.statement[i].tok) {
            case 32785: {
                if (this.isCoordinate3(i)) {
                    pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction + 1;
                    degrees = this.floatParameter(i++);
                    break;
                }
                Point4f pt4 = this.getPoint4f(i);
                pt.set(pt4.x, pt4.y, pt4.z);
                degrees = pt4.w;
                i = this.pcLastExpressionInstruction + 1;
                break;
            }
            case 16451: {
                pt.set(1.0f, 0.0f, 0.0f);
                degrees = 0.0f;
                ++i;
                break;
            }
            case 16452: {
                pt.set(0.0f, 1.0f, 0.0f);
                degrees = 180.0f;
                ++i;
                break;
            }
            case 16449: {
                pt.set(0.0f, 1.0f, 0.0f);
                ++i;
                break;
            }
            case 16450: {
                pt.set(0.0f, -1.0f, 0.0f);
                ++i;
                break;
            }
            case 16453: {
                pt.set(1.0f, 0.0f, 0.0f);
                ++i;
                break;
            }
            case 16454: {
                pt.set(-1.0f, 0.0f, 0.0f);
                ++i;
                break;
            }
            default: {
                pt = new Point3f(this.floatParameter(i++), this.floatParameter(i++), this.floatParameter(i++));
                degrees = this.floatParameter(i++);
            }
        }
        if (i != this.statementLength && !this.isAtomCenterOrCoordinateNext(i)) {
            zoom = this.floatParameter(i++);
        }
        if (i != this.statementLength && !this.isAtomCenterOrCoordinateNext(i)) {
            xTrans = this.floatParameter(i++);
            yTrans = this.floatParameter(i++);
        }
        float rotationRadius = 0.0f;
        if (i != this.statementLength) {
            center = this.atomCenterOrCoordinateParameter(i);
            i = this.pcLastExpressionInstruction + 1;
            if (i != this.statementLength) {
                rotationRadius = this.floatParameter(i++);
            }
        }
        this.refresh();
        this.viewer.moveTo(floatSecondsTotal, center, pt, degrees, zoom, xTrans, yTrans, rotationRadius);
    }

    void bondorder() throws ScriptException {
        Token tokenArg = this.statement[1];
        int order = 0;
        switch (tokenArg.tok) {
            case 2: {
                order = (short)tokenArg.intValue;
                if (order >= 0 && order <= 3) break;
                this.invalidArgument();
                break;
            }
            case 10509: {
                order = 64;
                break;
            }
            case 3: {
                float f = ((Float)tokenArg.value).floatValue();
                if (f == (float)((short)f)) {
                    order = (short)f;
                    if (order >= 0 && order <= 3) break;
                    this.invalidArgument();
                    break;
                }
                if (f == 0.5f) {
                    order = 64;
                    break;
                }
                if (f == 1.5f) {
                    order = 5;
                    break;
                }
                this.invalidArgument();
                break;
            }
            case 1: {
                order = JmolConstants.getBondOrderFromString((String)tokenArg.value);
                if (order >= 1) break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setShapeProperty(1, "bondOrder", new Short((short)order), this.viewer.getSelectedAtomsOrBonds());
    }

    void console() throws ScriptException {
        switch (this.statement[1].tok) {
            case 8192: {
                this.viewer.showConsole(false);
                break;
            }
            case 8193: {
                this.viewer.showConsole(true);
                this.viewer.clearConsole();
                break;
            }
            default: {
                this.evalError("console ON|OFF");
            }
        }
    }

    void centerAt() throws ScriptException {
        if (this.statementLength < 2) {
            this.badArgumentCount();
        }
        String relativeTo = null;
        switch (this.statement[1].tok) {
            case 16431: {
                relativeTo = "absolute";
                break;
            }
            case 16432: {
                relativeTo = "average";
                break;
            }
            case 6405: {
                relativeTo = "boundbox";
                break;
            }
            default: {
                this.unrecognizedSubcommand(this.statement[1].toString());
            }
        }
        Point3f pt = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            pt.x = this.floatParameter(2);
            pt.y = this.floatParameter(3);
            pt.z = this.floatParameter(4);
        } else if (this.statement[2].tok == 32785) {
            pt = this.getCoordinate(2, true);
        }
        this.viewer.setCenter(relativeTo, pt);
    }

    void stereo() throws ScriptException {
        int stereoMode = 1;
        float degrees = -5.0f;
        boolean degreesSeen = false;
        int[] colors = new int[2];
        int colorpt = 0;
        block7: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.statement[i].tok) {
                case 8193: {
                    this.checkLength2();
                    stereoMode = 1;
                    continue block7;
                }
                case 8192: {
                    this.checkLength2();
                    stereoMode = 0;
                    continue block7;
                }
                case 540692: {
                    if (colorpt > 1) {
                        this.badArgumentCount();
                    }
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    colors[colorpt++] = this.getArgbParam(i);
                    if (colorpt != 1) continue block7;
                    colors[colorpt] = ~colors[0];
                    continue block7;
                }
                case 2: 
                case 3: {
                    degrees = this.floatParameter(i);
                    degreesSeen = true;
                    continue block7;
                }
                case 1: {
                    String id = (String)this.statement[i].value;
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    if (id.equalsIgnoreCase("redblue")) {
                        stereoMode = 3;
                        continue block7;
                    }
                    if (id.equalsIgnoreCase("redcyan")) {
                        stereoMode = 2;
                        continue block7;
                    }
                    if (id.equalsIgnoreCase("redgreen")) {
                        stereoMode = 4;
                        continue block7;
                    }
                }
                default: {
                    this.booleanOrNumberExpected();
                }
            }
        }
        this.viewer.setFloatProperty("stereoDegrees", degrees);
        if (colorpt > 0) {
            this.viewer.setStereoMode(colors, StateManager.encodeColor(colors[0]) + " " + StateManager.encodeColor(colors[1]));
        } else {
            this.viewer.setStereoMode(stereoMode, (String)this.statement[1].value);
        }
    }

    void connect() throws ScriptException {
        float[] distances = new float[2];
        BitSet[] atomSets = new BitSet[2];
        atomSets[0] = atomSets[1] = this.viewer.getSelectionSet();
        int distanceCount = 0;
        int atomSetCount = 0;
        short bondOrder = -1;
        int operation = 3;
        boolean isDelete = false;
        boolean haveType = false;
        int nAtomSets = 0;
        int nDistances = 0;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block7: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.statement[i].tok) {
                case 8192: 
                case 8193: {
                    if (this.statementLength != 2) {
                        this.badArgumentCount();
                    }
                    this.viewer.rebond();
                    return;
                }
                case 2: 
                case 3: {
                    if (++nDistances > 2) {
                        this.badArgumentCount();
                    }
                    if (nAtomSets > 0 || haveType) {
                        this.invalidParameterOrder();
                    }
                    distances[distanceCount++] = this.floatParameter(i);
                    continue block7;
                }
                case 32868: {
                    if (++nAtomSets > 2) {
                        this.badArgumentCount();
                    }
                    if (haveType) {
                        this.invalidParameterOrder();
                    }
                    atomSets[atomSetCount++] = this.expression(this.statement, i);
                    i = this.pcLastExpressionInstruction;
                    continue block7;
                }
                case 1: 
                case 10509: {
                    String cmd = (String)this.statement[i].value;
                    int j = JmolConstants.bondOrderNames.length;
                    while (--j >= 0) {
                        if (!cmd.equalsIgnoreCase(JmolConstants.bondOrderNames[j])) continue;
                        if (haveType) {
                            this.incompatibleArguments();
                        }
                        cmd = JmolConstants.bondOrderNames[j];
                        bondOrder = JmolConstants.getBondOrderFromString(cmd);
                        haveType = true;
                        continue block7;
                    }
                    if (++i != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    if ("modify".equalsIgnoreCase(cmd)) {
                        operation = JmolConstants.connectOperationFromString(cmd);
                        continue block7;
                    }
                    if ("create".equalsIgnoreCase(cmd)) {
                        operation = JmolConstants.connectOperationFromString(cmd);
                        continue block7;
                    }
                    if ("modifyOrCreate".equalsIgnoreCase(cmd)) {
                        operation = JmolConstants.connectOperationFromString(cmd);
                        continue block7;
                    }
                    if ("auto".equalsIgnoreCase(cmd)) {
                        operation = JmolConstants.connectOperationFromString(cmd);
                        continue block7;
                    }
                    this.unrecognizedSubcommand(cmd);
                    continue block7;
                }
                case 16426: 
                case 49157: {
                    if (++i != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    operation = JmolConstants.connectOperationFromString("delete");
                    isDelete = true;
                    continue block7;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        if (distanceCount < 2) {
            if (distanceCount == 0) {
                distances[0] = 1.0E8f;
            }
            distances[1] = distances[0];
            distances[0] = 0.1f;
        }
        int n = this.viewer.makeConnections(distances[0], distances[1], bondOrder, operation, atomSets[0], atomSets[1]);
        if (isDelete) {
            this.viewer.scriptStatus(GT._("{0} connections deleted", n));
        } else {
            this.viewer.scriptStatus(GT._("{0} connections modified or created", n));
        }
    }

    void getProperty() {
        String retValue = "";
        String property = this.statementLength < 2 ? "" : (String)this.statement[1].value;
        String param = this.statementLength < 3 ? "" : (String)this.statement[2].value;
        retValue = (String)this.viewer.getProperty("readable", property, param);
        this.showString(retValue);
    }

    void background() throws ScriptException {
        int tok;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.badArgumentCount();
        }
        if ((tok = this.statement[1].tok) == 540692 || tok == 49157) {
            this.viewer.setBackgroundArgb(this.getArgbOrNoneParam(1));
        } else {
            this.viewer.setShapePropertyArgb(this.getShapeType(tok), "bgcolor", this.getArgbOrNoneParam(2));
        }
    }

    void center(int i) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setCenterBitSet(null, true);
            return;
        }
        if (this.statement[i].tok == 8392723) {
            String axisID = this.objectNameParameter(i + 1);
            this.viewer.setNewRotationCenter(axisID);
            return;
        }
        if (this.statement[i].tok == 32785) {
            Point3f pt = this.getCoordinate(i, true);
            this.viewer.setNewRotationCenter(pt);
            return;
        }
        this.viewer.setCenterBitSet(this.expression(this.statement, i), true);
    }

    void color() throws ScriptException {
        if (this.statementLength > 5 || this.statementLength < 2) {
            this.badArgumentCount();
        }
        int tok = this.statement[1].tok;
        switch (tok) {
            case 8392723: {
                this.colorNamedObject(2);
                return;
            }
            case 296: 
            case 2080: 
            case 16385: 
            case 16402: 
            case 16420: 
            case 16422: 
            case 16424: 
            case 16425: 
            case 32789: 
            case 32790: 
            case 36868: 
            case 36869: 
            case 49157: 
            case 98308: 
            case 98321: 
            case 98572: 
            case 100371: 
            case 294912: 
            case 540692: 
            case 2107683: {
                this.colorObject(4102, 1);
                return;
            }
            case 16392: 
            case 16430: {
                this.colorObject(4102, 1);
                return;
            }
            case 16421: {
                this.viewer.setRubberbandArgb(this.getArgbParam(2));
                return;
            }
            case 4718849: {
                this.viewer.setBackgroundArgb(this.getArgbOrNoneParam(2));
                return;
            }
            case 2409: {
                int argb = this.getArgbOrNoneParam(2);
                this.viewer.loadShape(16);
                this.viewer.setShapeProperty(16, "argbSelection", new Integer(argb));
                return;
            }
            case 1: 
            case 296962: {
                int argb = this.getArgbOrPaletteParam(2);
                String str = (String)this.statement[1].value;
                int i = JmolConstants.elementNumberMax;
                while (--i >= 0) {
                    if (!str.equalsIgnoreCase(JmolConstants.elementNameFromNumber(i))) continue;
                    this.viewer.setElementArgb(i, argb);
                    return;
                }
                i = JmolConstants.altElementMax;
                while (--i >= 0) {
                    if (!str.equalsIgnoreCase(JmolConstants.altElementNameFromIndex(i))) continue;
                    this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(i), argb);
                    return;
                }
                if (str.charAt(0) == '_') {
                    i = JmolConstants.elementNumberMax;
                    while (--i >= 0) {
                        if (!str.equalsIgnoreCase("_" + JmolConstants.elementSymbolFromNumber(i))) continue;
                        this.viewer.setElementArgb(i, argb);
                        return;
                    }
                    i = JmolConstants.altElementMax;
                    while (--i >= 4) {
                        if (str.equalsIgnoreCase("_" + JmolConstants.altElementSymbolFromIndex(i))) {
                            this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(i), argb);
                            return;
                        }
                        if (!str.equalsIgnoreCase("_" + JmolConstants.altIsotopeSymbolFromIndex(i))) continue;
                        this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(i), argb);
                        return;
                    }
                }
                argb = this.getArgbOrNoneParam(2);
                if (str.equalsIgnoreCase("dotsConvex")) {
                    this.viewer.setShapePropertyArgb(7, "colorConvex", argb);
                    return;
                }
                if (str.equalsIgnoreCase("dotsConcave")) {
                    this.viewer.setShapePropertyArgb(7, "colorConcave", argb);
                    return;
                }
                if (str.equalsIgnoreCase("dotsSaddle")) {
                    this.viewer.setShapePropertyArgb(7, "colorSaddle", argb);
                    return;
                }
                this.invalidArgument();
            }
        }
        if (tok == 10498) {
            tok = 34820;
        }
        this.colorObject(tok, 2);
    }

    void colorNamedObject(int index) throws ScriptException {
        int shapeType = this.setShapeByNameParameter(index);
        this.colorShape(shapeType, index + 1);
    }

    void colorObject(int tokObject, int itoken) throws ScriptException {
        this.colorShape(this.getShapeType(tokObject), itoken);
    }

    void colorShape(int shapeType, int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.badArgumentCount();
        }
        String translucentOrOpaque = null;
        Number colorvalue = null;
        String colorOrBgcolor = "color";
        int tok = this.statement[itoken].tok;
        if (tok == 4718849) {
            colorOrBgcolor = "bgcolor";
            tok = this.statement[++itoken].tok;
        }
        if (tok == 16425 || tok == 16424) {
            translucentOrOpaque = (String)this.statement[itoken].value;
            ++itoken;
        }
        String modifier = "";
        if (shapeType < 0) {
            shapeType = -shapeType;
            modifier = "Surface";
        }
        if (itoken < this.statementLength) {
            tok = this.statement[itoken].tok;
            if (tok == 540692) {
                int argb = this.getArgbParam(itoken);
                colorvalue = argb == 0 ? null : new Integer(argb);
            } else {
                int pid;
                int n = pid = tok == 2107683 ? 1 : JmolConstants.getPaletteID((String)this.statement[itoken].value);
                if (pid < 0 || pid == 18 && shapeType != 2) {
                    this.invalidArgument();
                }
                colorvalue = new Byte((byte)pid);
            }
            switch (tok) {
                case 98321: {
                    if (this.viewer.getFrame().getSurfaceDistanceMax() != 0.0f) break;
                    this.dots(this.statementLength, 2);
                    break;
                }
                case 98308: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 36868: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 16422: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 98572: {
                    this.viewer.calcSelectedMonomersCount();
                }
            }
            this.viewer.loadShape(shapeType);
            if (shapeType == 1) {
                this.viewer.setShapeProperty(shapeType, colorOrBgcolor + modifier, colorvalue, this.viewer.getSelectedAtomsOrBonds());
            } else {
                this.viewer.setShapeProperty(shapeType, colorOrBgcolor + modifier, colorvalue);
            }
        }
        if (translucentOrOpaque != null) {
            this.viewer.setShapeProperty(shapeType, "translucency" + modifier, translucentOrOpaque);
        }
    }

    void data() throws ScriptException {
        String dataString = null;
        String dataLabel = null;
        switch (this.statementLength) {
            case 3: 
            case 4: {
                dataString = (String)this.statement[2].value;
            }
            case 2: {
                dataLabel = (String)this.statement[1].value;
                if (dataLabel.equalsIgnoreCase("clear")) {
                    this.viewer.setData(null, null);
                    return;
                }
                if (this.statementLength > 2) break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        String dataType = dataLabel + " ";
        dataType = dataType.substring(0, dataType.indexOf(" "));
        this.dataLabelString = new String[2];
        this.dataLabelString[0] = dataLabel;
        this.dataLabelString[1] = dataString;
        this.viewer.setData(dataType, this.dataLabelString);
        if (dataType.equalsIgnoreCase("model")) {
            char newLine = this.viewer.getInlineChar();
            if (dataString.length() > 0 && dataString.charAt(0) != newLine) {
                newLine = '\u0000';
            }
            this.viewer.loadInline(dataString, newLine);
            return;
        }
    }

    void define() throws ScriptException {
        if (this.statementLength == 1) {
            this.keywordExpected();
        }
        String variable = (String)this.statement[1].value;
        BitSet bs = this.expression(this.statement, 2);
        this.variables.put(variable, bs);
        this.viewer.setStringProperty("@" + variable, StateManager.encodeBitset(bs));
    }

    void echo() {
        String text = "";
        if (this.statementLength == 2 && this.statement[1].tok == 4) {
            text = (String)this.statement[1].value;
        }
        if (this.viewer.getEchoStateActive()) {
            this.viewer.setShapeProperty(21, "text", text);
        }
        this.viewer.scriptEcho(text);
    }

    void message() {
        String text = "";
        if (this.statementLength == 2 && this.statement[1].tok == 4) {
            text = (String)this.statement[1].value;
        }
        this.viewer.scriptStatus(text);
    }

    void label() {
        String strLabel = (String)this.statement[1].value;
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = this.viewer.getStandardLabelFormat();
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(strLabel);
    }

    void hover() {
        String strLabel = (String)this.statement[1].value;
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = "%U";
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(22);
        this.viewer.setShapeProperty(22, "label", strLabel);
    }

    void load() throws ScriptException {
        String script;
        StringBuffer loadScript = new StringBuffer("load");
        int[] params = new int[4];
        Point3f unitCells = this.viewer.getDefaultLattice();
        params[1] = (int)unitCells.x;
        params[2] = (int)unitCells.y;
        params[3] = (int)unitCells.z;
        int i = 1;
        String filename = "fileset";
        if (this.statementLength == 1) {
            i = 0;
        } else {
            if (this.statement[1].tok == 1) {
                i = 2;
            }
            if (this.statement[i].tok != 4) {
                this.filenameExpected();
            }
        }
        if (this.statementLength == i + 1) {
            filename = (String)this.statement[i].value;
            if (i == 0 || filename.length() == 0) {
                filename = this.viewer.getFullPathName();
            }
            loadScript.append(" " + StateManager.escape(filename) + ";");
            this.viewer.openFile(filename, params, loadScript.toString());
        } else if (this.statement[i + 1].tok == 32785 || this.statement[i + 1].tok == 2) {
            filename = (String)this.statement[i++].value;
            if (filename.length() == 0) {
                filename = this.viewer.getFullPathName();
            }
            loadScript.append(" " + StateManager.escape(filename));
            if (this.statement[i].tok == 2) {
                params[0] = this.statement[i++].intValue;
                loadScript.append(" " + params[0]);
            }
            if (i < this.statementLength && this.statement[i].tok == 32785) {
                int j;
                int[] p;
                unitCells = this.getCoordinate(i, false);
                params[1] = (int)unitCells.x;
                params[2] = (int)unitCells.y;
                params[3] = (int)unitCells.z;
                loadScript.append(" " + StateManager.encloseCoord(unitCells));
                i = this.pcLastExpressionInstruction + 1;
                int iGroup = -1;
                if (i < this.statementLength && this.statement[i].tok == 6178) {
                    int n = ++i;
                    ++i;
                    String spacegroup = this.viewer.simpleReplace(this.stringParameter(n), "''", "\"");
                    loadScript.append(" " + StateManager.escape(spacegroup));
                    if (spacegroup.equalsIgnoreCase("ignoreOperators")) {
                        iGroup = -999;
                    } else {
                        if (spacegroup.indexOf(",") >= 0 && unitCells.x < 9.0f && unitCells.y < 9.0f && unitCells.z == 0.0f) {
                            spacegroup = spacegroup + "#doNormalize=0";
                        }
                        if ((iGroup = this.viewer.getSpaceGroupIndexFromName(spacegroup)) == -1) {
                            this.evalError(GT._("space group {0} was not found.", spacegroup));
                        }
                    }
                    p = new int[5];
                    for (j = 0; j < 4; ++j) {
                        p[j] = params[j];
                    }
                    p[4] = iGroup;
                    params = p;
                }
                if (i < this.statementLength && this.statement[i].tok == 301332) {
                    ++i;
                    p = new int[11];
                    for (int j2 = 0; j2 < params.length; ++j2) {
                        p[j2] = params[j2];
                    }
                    p[4] = iGroup;
                    float[] fparams = new float[6];
                    i = this.floatParameterSet(i, fparams);
                    loadScript.append(" {");
                    for (j = 0; j < 6; ++j) {
                        p[5 + j] = (int)(fparams[j] * 10000.0f);
                        loadScript.append((j == 0 ? "" : " ") + p[5 + j]);
                    }
                    loadScript.append("}");
                    params = p;
                }
            }
            loadScript.append(";");
            this.viewer.openFile(filename, params, loadScript.toString());
        } else {
            String modelName = (String)this.statement[i].value;
            loadScript.append(" " + StateManager.escape(modelName));
            String[] filenames = new String[this.statementLength - ++i];
            while (i < this.statementLength) {
                filenames[filenames.length - this.statementLength + i] = modelName = (String)this.statement[i].value;
                loadScript.append(" " + StateManager.escape(modelName));
                ++i;
            }
            loadScript.append(";");
            this.viewer.openFiles(modelName, filenames, loadScript.toString());
        }
        String errMsg = this.viewer.getOpenFileError();
        if (errMsg != null) {
            this.evalError(errMsg);
        }
        if (this.logMessages) {
            this.viewer.scriptStatus("Successfully loaded:" + filename);
        }
        String defaultScript = this.viewer.getDefaultLoadScript();
        String msg = "";
        if (defaultScript.length() > 0) {
            msg = msg + "\nUsing defaultLoadScript: " + defaultScript;
        }
        if ((script = this.viewer.getModelSetProperty("jmolscript")) != null) {
            msg = msg + "\nAdding embedded #jmolscript: " + script;
            defaultScript = defaultScript + ";" + script;
        }
        if (msg.length() > 0) {
            Logger.info(msg);
        }
        if (defaultScript.length() > 0) {
            this.runScript(defaultScript);
        }
    }

    void monitor() throws ScriptException {
        int[] countPlusIndexes = new int[5];
        float[] rangeMinMax = new float[2];
        switch (this.statementLength) {
            case 1: {
                this.viewer.hideMeasurements(false);
                return;
            }
            case 2: {
                if (this.statement[1].tok == 8193) {
                    this.viewer.hideMeasurements(false);
                } else if (this.statement[1].tok == 8192) {
                    this.viewer.hideMeasurements(true);
                } else if (this.statement[1].tok == 16426) {
                    this.viewer.clearAllMeasurements();
                } else {
                    this.keywordExpected("ON, OFF, or DELETE");
                }
                return;
            }
            case 3: {
                if (this.statement[1].tok != 16426) break;
                if (this.statement[1].tok == 36875) {
                    this.viewer.clearAllMeasurements();
                } else {
                    this.viewer.deleteMeasurement(this.intParameter(2) - 1);
                }
                return;
            }
        }
        countPlusIndexes[0] = 0;
        int argCount = this.statementLength - 1;
        int expressionCount = 0;
        int atomIndex = -1;
        int atomNumber = 0;
        int ptFloat = -1;
        rangeMinMax[0] = Float.MAX_VALUE;
        rangeMinMax[1] = Float.MAX_VALUE;
        boolean isAll = false;
        boolean isAllConnected = false;
        boolean isExpression = false;
        boolean isDelete = false;
        boolean isRange = true;
        boolean isON = false;
        boolean isOFF = false;
        Vector<BitSet> monitorExpressions = new Vector<BitSet>();
        BitSet bs = new BitSet();
        block18: for (int i = 1; i <= argCount; ++i) {
            Token token = this.getToken(i);
            switch (token.tok) {
                case 8193: {
                    if (isON || isOFF || isDelete) {
                        this.invalidArgument();
                    }
                    isON = true;
                    continue block18;
                }
                case 8192: {
                    if (isON || isOFF || isDelete) {
                        this.invalidArgument();
                    }
                    isOFF = true;
                    continue block18;
                }
                case 16426: {
                    if (isON || isOFF || isDelete) {
                        this.invalidArgument();
                    }
                    isDelete = true;
                    continue block18;
                }
                case 16446: {
                    isRange = true;
                    atomIndex = -1;
                    isAll = true;
                    continue block18;
                }
                case 1: {
                    if (((String)token.value).equalsIgnoreCase("ALLCONNECTED")) {
                        isAllConnected = true;
                    } else {
                        this.keywordExpected("ALL, ALLCONNECTED, or DELETE");
                    }
                }
                case 36875: {
                    atomIndex = -1;
                    isAll = true;
                    continue block18;
                }
                case 3: {
                    isAll = true;
                    isRange = true;
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = ((Float)token.value).floatValue();
                    continue block18;
                }
                case 2: {
                    isRange = true;
                    atomNumber = token.intValue;
                    atomIndex = this.viewer.getAtomIndexFromAtomNumber(atomNumber);
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = atomNumber;
                    break;
                }
                case 798: {
                    if (this.statementLength == 5 && i == 2 && this.statement[3].tok == 16455) {
                        this.viewer.setShapeProperty(6, "select", this.statement[3].value);
                        return;
                    }
                    this.expressionOrIntegerExpected();
                }
                case 847: {
                    if (this.statementLength == 5 && i == 2 && this.statement[3].tok == 16455) {
                        this.viewer.setShapeProperty(6, "hide", this.statement[3].value);
                        return;
                    }
                    this.expressionOrIntegerExpected();
                }
                case 32868: {
                    isExpression = true;
                    bs = this.expression(this.statement, i);
                    atomIndex = this.viewer.firstAtomOf(bs);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                default: {
                    this.expressionOrIntegerExpected();
                }
            }
            if (atomIndex == -1) {
                this.badAtomNumber();
            }
            if (isAll) {
                if (bs == null || bs.size() == 0) {
                    this.badAtomNumber();
                }
                if (++expressionCount > 4) {
                    this.badArgumentCount();
                }
                monitorExpressions.add(bs);
                continue;
            }
            if (atomIndex == -1) {
                this.badAtomNumber();
            }
            if ((countPlusIndexes[0] = countPlusIndexes[0] + 1) > 4) {
                this.badArgumentCount();
            }
            countPlusIndexes[countPlusIndexes[0]] = atomIndex;
        }
        if (isAll) {
            if (!isExpression) {
                this.expressionExpected();
            }
            if (isRange && rangeMinMax[1] < rangeMinMax[0]) {
                rangeMinMax[1] = rangeMinMax[0];
                rangeMinMax[0] = rangeMinMax[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
            }
            this.viewer.defineMeasurement(monitorExpressions, rangeMinMax, isDelete, isAllConnected, isON || isOFF, isOFF);
        } else if (isDelete) {
            this.viewer.deleteMeasurement(countPlusIndexes);
        } else if (isON) {
            this.viewer.showMeasurement(countPlusIndexes, true);
        } else if (isOFF) {
            this.viewer.showMeasurement(countPlusIndexes, false);
        } else {
            this.viewer.toggleMeasurement(countPlusIndexes);
        }
    }

    void refresh() {
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    void reset() {
        this.viewer.reset();
    }

    void initialize() {
        this.viewer.initialize();
        this.zap();
    }

    void restrict() throws ScriptException {
        this.select();
        BitSet bsSelected = this.viewer.getSelectionSet();
        this.viewer.invertSelection();
        if (this.bsSubset != null) {
            BitSet bs = new BitSet();
            bs.or(bsSelected);
            bs.and(this.bsSubset);
            this.viewer.setSelectionSet(bs);
        }
        boolean bondmode = this.viewer.getBondSelectionModeOr();
        this.viewer.setBooleanProperty("bondModeOr", true);
        this.viewer.setShapeSize(1, 0);
        int shapeType = 17;
        while (--shapeType >= 0) {
            if (shapeType == 6) continue;
            this.viewer.setShapeSize(shapeType, 0);
        }
        this.viewer.setShapeProperty(23, "delete", null);
        this.viewer.setLabel(null);
        this.viewer.setBooleanProperty("bondModeOr", bondmode);
        this.viewer.setSelectionSet(bsSelected);
    }

    void rotate(boolean isSpin) throws ScriptException {
        int i;
        if (this.statementLength == 2) {
            switch (this.statement[1].tok) {
                case 8193: {
                    this.viewer.setSpinOn(true);
                    return;
                }
                case 8192: {
                    this.viewer.setSpinOn(false);
                    return;
                }
            }
        }
        float degrees = Float.MIN_VALUE;
        int nPoints = 0;
        float endDegrees = Float.MAX_VALUE;
        boolean isAxisAngle = false;
        boolean isInternal = false;
        Point3f[] points = new Point3f[3];
        Point3f rotCenter = null;
        Vector3f rotAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        int direction = 1;
        boolean axesOrientationRasmol = this.viewer.getAxesOrientationRasmol();
        for (i = 0; i < 3; ++i) {
            points[i] = new Point3f(0.0f, 0.0f, 0.0f);
        }
        for (i = 1; i < this.statementLength; ++i) {
            Token token = this.statement[i];
            switch (token.tok) {
                case 32770: {
                    direction = -1;
                    break;
                }
                case 4109: {
                    isAxisAngle = true;
                    break;
                }
                case 1: {
                    String str = (String)this.statement[i].value;
                    if (str.equalsIgnoreCase("x")) {
                        rotAxis.set(direction, 0.0f, 0.0f);
                        break;
                    }
                    if (str.equalsIgnoreCase("y")) {
                        if (axesOrientationRasmol) {
                            direction = -direction;
                        }
                        rotAxis.set(0.0f, direction, 0.0f);
                        break;
                    }
                    if (str.equalsIgnoreCase("z")) {
                        rotAxis.set(0.0f, 0.0f, direction);
                        break;
                    }
                    if (!str.equalsIgnoreCase("internal") && !str.equalsIgnoreCase("molecular")) break;
                    isInternal = true;
                    break;
                }
                case 32785: {
                    Point3f pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction;
                    if (isAxisAngle) {
                        if (axesOrientationRasmol) {
                            pt.y = -pt.y;
                        }
                        rotAxis.set(pt);
                        isAxisAngle = false;
                        break;
                    }
                    points[nPoints++].set(pt);
                    break;
                }
                case 8392723: {
                    isInternal = true;
                    String axisID = this.objectNameParameter(++i);
                    rotCenter = this.viewer.getDrawObjectCenter(axisID);
                    rotAxis = this.viewer.getDrawObjectAxis(axisID);
                    if (rotCenter == null) {
                        this.drawObjectNotDefined(axisID);
                    }
                    points[nPoints++].set(rotCenter);
                    break;
                }
                case 32772: {
                    break;
                }
                case 2: 
                case 3: {
                    if (degrees == Float.MIN_VALUE) {
                        degrees = this.floatParameter(i);
                        break;
                    }
                    endDegrees = degrees;
                    degrees = this.floatParameter(i);
                    isSpin = true;
                    break;
                }
                case 32868: {
                    BitSet bs = this.expression(this.statement, i + 1);
                    rotCenter = this.viewer.getAtomSetCenter(bs);
                    points[nPoints++].set(rotCenter);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (nPoints < 3) continue;
            this.tooManyRotationPoints();
        }
        if (nPoints < 2 && !isInternal) {
            if (nPoints == 1) {
                rotCenter = new Point3f(points[0]);
            }
            if (degrees == Float.MIN_VALUE) {
                degrees = 10.0f;
            }
            this.viewer.rotateAxisAngleAtCenter(rotCenter, rotAxis, degrees, endDegrees, isSpin);
            return;
        }
        if (nPoints < 2) {
            points[1].set(points[0]);
            points[1].sub(rotAxis);
        }
        if (points[0].distance(points[1]) == 0.0f) {
            this.rotationPointsIdentical();
        }
        if (degrees == Float.MIN_VALUE) {
            degrees = 10.0f;
        }
        this.viewer.rotateAboutPointsInternal(points[0], points[1], degrees, endDegrees, isSpin);
    }

    void script() throws ScriptException {
        if (this.statement[1].tok != 4) {
            this.filenameExpected();
        }
        this.pushContext();
        String filename = (String)this.statement[1].value;
        if (!this.loadScriptFileInternal(filename)) {
            this.errorLoadingScript(this.errorMessage);
        }
        this.instructionDispatchLoop();
        this.popContext();
    }

    void history(int pt) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (pt == 2) {
            this.checkLength3();
            int n = this.intParameter(2);
            if (n < 0) {
                this.invalidArgument();
            }
            this.viewer.getSetHistory(n == 0 ? 0 : -2 - n);
            return;
        }
        switch (this.statement[1].tok) {
            case 2070: 
            case 8193: {
                this.viewer.getSetHistory(Integer.MIN_VALUE);
                return;
            }
            case 8192: {
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
    }

    void hide() throws ScriptException {
        this.viewer.hide(this.statementLength == 1 ? null : this.expression(this.statement, 1), this.tQuiet);
    }

    void display() throws ScriptException {
        this.viewer.display(this.bsAll(), this.statementLength == 1 ? null : this.expression(this.statement, 1), this.tQuiet);
    }

    BitSet bsAll() {
        int atomCount = this.viewer.getAtomCount();
        BitSet bs = new BitSet(atomCount);
        int i = atomCount;
        while (--i >= 0) {
            bs.set(i);
        }
        return bs;
    }

    void select() throws ScriptException {
        if (this.statementLength == 5 && this.statement[2].tok == 34820 && this.statement[3].tok == 16455) {
            this.viewer.selectBonds((BitSet)this.statement[3].value);
            return;
        }
        this.viewer.select(this.statementLength == 1 ? null : this.expression(this.statement, 1), this.tQuiet);
    }

    void subset() throws ScriptException {
        this.bsSubset = this.statementLength == 1 ? null : this.expression(this.statement, -1);
        this.viewer.setSelectionSubset(this.bsSubset);
    }

    void translate() throws ScriptException {
        int percent;
        if (this.statementLength < 3) {
            this.badArgumentCount();
        }
        if (this.statement[2].tok != 2) {
            this.integerExpected();
        }
        if ((percent = this.statement[2].intValue) > 100 || percent < -100) {
            this.numberOutOfRange(-100, 100);
        }
        if (this.statement[1].tok == 1) {
            String str = (String)this.statement[1].value;
            if (str.equalsIgnoreCase("x")) {
                this.viewer.translateToXPercent(percent);
                return;
            }
            if (str.equalsIgnoreCase("y")) {
                this.viewer.translateToYPercent(percent);
                return;
            }
            if (str.equalsIgnoreCase("z")) {
                this.viewer.translateToZPercent(percent);
                return;
            }
        }
        this.axisExpected();
    }

    void translateSelected() throws ScriptException {
        this.viewer.setAtomCoordRelative(this.getCoordinate(1, true));
    }

    void zap() {
        this.viewer.zap();
        this.refresh();
    }

    void zoom(boolean isZoomTo) throws ScriptException {
        boolean isSameAtom;
        if (this.statementLength == 1) {
            if (isZoomTo) {
                this.viewer.moveTo(1.0f, null, new Point3f(0.0f, 0.0f, 0.0f), 0.0f, this.viewer.getZoomPercentFloat() * 2.0f, 0.0f, 0.0f, 0.0f);
            } else {
                this.viewer.setBooleanProperty("zoom", true);
            }
            return;
        }
        if (!isZoomTo) {
            switch (this.statement[1].tok) {
                case 8193: {
                    this.viewer.setBooleanProperty("zoom", true);
                    return;
                }
                case 8192: {
                    this.viewer.setBooleanProperty("zoom", false);
                    return;
                }
            }
        }
        float time = isZoomTo ? 1.0f : 0.0f;
        float zoom = this.viewer.getZoomPercentFloat();
        float factor = 0.0f;
        float radius = this.viewer.getRotationRadius();
        Point3f center = null;
        Point3f currentCenter = this.viewer.getRotationCenter();
        int i = 1;
        if (this.isFloatParameter(i) && isZoomTo) {
            time = this.floatParameter(i++);
        }
        int ptCenter = 0;
        if (this.isAtomCenterOrCoordinateNext(i)) {
            ptCenter = i;
            center = this.atomCenterOrCoordinateParameter(i);
            i = this.pcLastExpressionInstruction + 1;
        }
        boolean bl = isSameAtom = center != null && (double)currentCenter.distance(center) < 0.1;
        if (this.isFloatParameter(i)) {
            factor = this.floatParameter(i++);
        }
        if (factor < 0.0f) {
            factor += zoom;
        }
        if (factor == 0.0f) {
            factor = zoom;
            if (this.isFloatParameter(i + 1)) {
                float value = this.floatParameter(i + 1);
                switch (this.statement[i].tok) {
                    case 32783: {
                        factor /= value;
                        break;
                    }
                    case 32777: {
                        factor *= value;
                        break;
                    }
                    case 32775: {
                        factor += value;
                        break;
                    }
                    default: {
                        this.evalError(GT._("Invalid {0} command", "ZOOM"));
                        break;
                    }
                }
            } else if (isZoomTo) {
                if (center == null) {
                    factor /= 2.0f;
                } else if (isSameAtom) {
                    factor *= 2.0f;
                }
            }
        }
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        float max = this.viewer.getMaxZoomPercent();
        if (factor < 5.0f || factor > max) {
            this.numberOutOfRange(5.0f, max);
        }
        if (!this.viewer.isWindowCentered()) {
            if (center != null) {
                this.viewer.setCenterBitSet(this.expression(this.statement, ptCenter), false);
            }
            center = this.viewer.getRotationCenter();
            xTrans = this.viewer.getTranslationXPercent();
            yTrans = this.viewer.getTranslationYPercent();
        }
        this.viewer.moveTo(time, center, new Point3f(0.0f, 0.0f, 0.0f), Float.NaN, factor, xTrans, yTrans, radius);
    }

    void delay() throws ScriptException {
        long millis = 0L;
        Token token = this.statement[1];
        switch (token.tok) {
            case 2: 
            case 8193: {
                millis = token.intValue * 1000;
                break;
            }
            case 3: {
                millis = (long)(((Float)token.value).floatValue() * 1000.0f);
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.delay(millis);
    }

    void delay(long millis) {
        long timeBegin = System.currentTimeMillis();
        this.refresh();
        int seconds = (int)(millis -= System.currentTimeMillis() - timeBegin) / 1000;
        if ((millis -= (long)(seconds * 1000)) <= 0L) {
            millis = 1L;
        }
        while (seconds >= 0 && millis > 0L && !interruptExecution.booleanValue() && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint();
            try {
                Thread.sleep(seconds-- > 0 ? 1000L : millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint();
        }
    }

    void move() throws ScriptException {
        if (this.statementLength < 10 || this.statementLength > 12) {
            this.badArgumentCount();
        }
        Vector3f dRot = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        int dZoom = this.intParameter(4);
        Vector3f dTrans = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        int dSlab = this.intParameter(8);
        float floatSecondsTotal = this.floatParameter(9);
        int fps = 30;
        if (this.statementLength > 10) {
            fps = this.statement[10].intValue;
            if (this.statementLength > 11) {
                // empty if block
            }
        }
        this.refresh();
        this.viewer.move(dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
    }

    void slab() throws ScriptException {
        if (this.statement[1].tok == 2) {
            int percent = this.statement[1].intValue;
            if (percent < 0 || percent > 100) {
                this.numberOutOfRange(0, 100);
            }
            this.viewer.slabToPercent(percent);
            return;
        }
        switch (this.statement[1].tok) {
            case 8193: {
                this.viewer.setBooleanProperty("slab", true);
                break;
            }
            case 8192: {
                this.viewer.setBooleanProperty("slab", false);
                break;
            }
            default: {
                this.booleanOrPercentExpected();
            }
        }
    }

    void depth() throws ScriptException {
        this.viewer.depthToPercent(this.intParameter(1));
    }

    void star() throws ScriptException {
        int mad = 0;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (this.statementLength != 2 && (this.statementLength != 3 || tok != 2 || this.statement[2].tok != 49181)) {
                this.badArgumentCount();
            }
        }
        switch (tok) {
            case 8193: 
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 100) {
                    this.numberOutOfRange(0, 100);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(15, mad);
    }

    void halo() throws ScriptException {
        int mad = 0;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (this.statementLength != 2 && (this.statementLength != 3 || tok != 2 || this.statement[2].tok != 49181)) {
                this.badArgumentCount();
            }
        }
        switch (tok) {
            case 8193: {
                mad = -20;
                break;
            }
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 100) {
                    this.numberOutOfRange(0, 100);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(16, mad);
    }

    void spacefill() throws ScriptException {
        int mad = 0;
        boolean isSolventAccessibleSurface = false;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (!(this.statementLength == 2 || this.statementLength == 3 && (tok == 32775 && this.isFloatParameter(2) || tok == 2 && this.statement[2].tok == 49181))) {
                this.badArgumentCount();
            }
        }
        int i = 1;
        switch (tok) {
            case 8193: 
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 32775: {
                isSolventAccessibleSurface = true;
                ++i;
            }
            case 3: {
                float angstroms = this.floatParameter(i);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                if (!isSolventAccessibleSurface) break;
                mad = (short)(mad + 10000);
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -200) {
                        this.numberOutOfRange(-200, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 200) {
                    this.numberOutOfRange(0, 200);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(0, mad);
    }

    void wireframe() throws ScriptException {
        this.viewer.setShapeSize(1, this.getMadParameter(), this.viewer.getSelectedAtomsOrBonds());
    }

    void ssbond() throws ScriptException {
        this.viewer.loadShape(3);
        this.viewer.setShapeSize(3, this.getMadParameter());
    }

    void hbond(boolean isCommand) throws ScriptException {
        if (this.statementLength == 2 && this.statement[1].tok == 359) {
            this.viewer.autoHbond();
            return;
        }
        this.viewer.setShapeSize(2, this.getMadParameter());
    }

    void configuration() throws ScriptException {
        BitSet bsConfigurations;
        if (this.viewer.getDisplayModelIndex() <= -2) {
            this.evalError(GT._("{0} not allowed with background model displayed", "\"CONFIGURATION\""));
        }
        if (this.statementLength == 1) {
            bsConfigurations = this.viewer.setConformation();
            this.viewer.addStateScript("configuration;");
        } else {
            this.checkLength2();
            int n = this.intParameter(1);
            bsConfigurations = this.viewer.setConformation(n - 1);
            this.viewer.addStateScript("configuration " + n + ";");
        }
        boolean addHbonds = this.viewer.hbondsAreVisible();
        this.viewer.setShapeSize(2, 0, bsConfigurations);
        if (addHbonds) {
            this.viewer.autoHbond(bsConfigurations, bsConfigurations);
        }
        this.viewer.select(bsConfigurations, this.tQuiet);
    }

    void vector() throws ScriptException {
        int mad = 1;
        if (this.statementLength > 1) {
            switch (this.statement[1].tok) {
                case 8193: {
                    break;
                }
                case 8192: {
                    mad = 0;
                    break;
                }
                case 2: {
                    int diameterPixels = this.statement[1].intValue;
                    if (diameterPixels < 0 || diameterPixels >= 20) {
                        this.numberOutOfRange(0, 19);
                    }
                    mad = (short)diameterPixels;
                    break;
                }
                case 3: {
                    float angstroms = this.floatParameter(1);
                    if (angstroms > 3.0f) {
                        this.numberOutOfRange(0.0f, 3.0f);
                    }
                    mad = (short)(angstroms * 1000.0f * 2.0f);
                    break;
                }
                case 1: {
                    String cmd = (String)this.statement[1].value;
                    if (cmd.equalsIgnoreCase("scale")) {
                        this.checkLength3();
                        float scale = this.floatParameter(2);
                        if (scale < -10.0f || scale > 10.0f) {
                            this.numberOutOfRange(-10.0f, 10.0f);
                        }
                        this.viewer.setFloatProperty("vectorScale", scale);
                        return;
                    }
                    this.unrecognizedSubcommand(cmd);
                }
                default: {
                    this.booleanOrNumberExpected();
                }
            }
            this.checkLength2();
        }
        this.viewer.setShapeSize(5, mad);
    }

    void dipole() throws ScriptException {
        String propertyName = null;
        Object propertyValue = null;
        boolean iHaveAtoms = false;
        boolean iHaveCoord = false;
        this.viewer.loadShape(24);
        this.viewer.setShapeProperty(24, "init", null);
        if (this.statementLength == 1) {
            this.viewer.setShapeProperty(24, "thisID", null);
            return;
        }
        block11: for (int i = 1; i < this.statementLength; ++i) {
            propertyName = null;
            propertyValue = null;
            Token token = this.statement[i];
            switch (token.tok) {
                case 8193: {
                    propertyName = "on";
                    break;
                }
                case 8192: {
                    propertyName = "off";
                    break;
                }
                case 16426: {
                    propertyName = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    propertyName = "dipoleValue";
                    propertyValue = new Float(this.floatParameter(i));
                    break;
                }
                case 32868: {
                    propertyValue = this.expression(this.statement, i);
                    i = this.pcLastExpressionInstruction;
                    propertyName = iHaveAtoms || iHaveCoord ? "endSet" : "startSet";
                    iHaveAtoms = true;
                    break;
                }
                case 32785: {
                    Point3f pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction;
                    propertyName = iHaveAtoms || iHaveCoord ? "endCoord" : "startCoord";
                    propertyValue = pt;
                    iHaveCoord = true;
                    break;
                }
                case 10498: 
                case 34820: {
                    propertyName = "bonds";
                    break;
                }
                case 359: {
                    continue block11;
                }
                case 1: {
                    String cmd = (String)token.value;
                    if (cmd.equalsIgnoreCase("cross")) {
                        propertyName = "cross";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("noCross")) {
                        propertyName = "cross";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (cmd.equalsIgnoreCase("offset")) {
                        float v = this.floatParameter(++i);
                        if (this.statement[i].tok == 2) {
                            propertyName = "dipoleOffsetPercent";
                            propertyValue = new Integer((int)v);
                            break;
                        }
                        propertyName = "dipoleOffset";
                        propertyValue = new Float(v);
                        break;
                    }
                    if (cmd.equalsIgnoreCase("value")) {
                        propertyName = "dipoleValue";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("offsetSide")) {
                        propertyName = "offsetSide";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("width")) {
                        propertyName = "dipoleWidth";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    propertyName = "thisID";
                    propertyValue = ((String)token.value).toLowerCase();
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(24, propertyName, propertyValue);
        }
        if (iHaveCoord || iHaveAtoms) {
            this.viewer.setShapeProperty(24, "set", null);
        }
    }

    void animationMode() throws ScriptException {
        float startDelay = 1.0f;
        float endDelay = 1.0f;
        if (this.statementLength < 3 || this.statementLength > 5) {
            this.badArgumentCount();
        }
        int animationMode = 0;
        switch (this.statement[2].tok) {
            case 317: {
                ++animationMode;
                break;
            }
            case 1: {
                String cmd = (String)this.statement[2].value;
                if (cmd.equalsIgnoreCase("once")) {
                    endDelay = 0.0f;
                    startDelay = 0.0f;
                    break;
                }
                if (cmd.equalsIgnoreCase("palindrome")) {
                    animationMode = 2;
                    break;
                }
                this.unrecognizedSubcommand(cmd);
            }
        }
        if (this.statementLength >= 4) {
            startDelay = endDelay = this.floatParameter(3);
            if (this.statementLength == 5) {
                endDelay = this.floatParameter(4);
            }
        }
        this.viewer.setAnimationReplayMode(animationMode, startDelay, endDelay);
    }

    void vibration() throws ScriptException {
        if (this.statementLength < 2) {
            this.subcommandExpected();
        }
        Token token = this.statement[1];
        float period = 0.0f;
        switch (token.tok) {
            case 2: 
            case 8192: 
            case 8193: {
                period = token.intValue;
                break;
            }
            case 3: {
                period = this.floatParameter(1);
                break;
            }
            case 1: {
                String cmd = (String)this.statement[1].value;
                if (cmd.equalsIgnoreCase("scale")) {
                    this.vibrationScale();
                    return;
                }
            }
            default: {
                this.unrecognizedSubcommand(token.toString());
            }
        }
        this.viewer.setFloatProperty("vibrationPeriod", period);
    }

    void vibrationScale() throws ScriptException {
        this.checkLength3();
        float scale = this.floatParameter(2);
        if (scale < -10.0f || scale > 10.0f) {
            this.numberOutOfRange(-10.0f, 10.0f);
        }
        this.viewer.setFloatProperty("vibrationScale", scale);
    }

    void animationDirection() throws ScriptException {
        int direction;
        this.checkStatementLength(4);
        boolean negative = false;
        if (this.statement[2].tok == 32770) {
            negative = true;
        } else if (this.statement[2].tok != 32775) {
            this.invalidArgument();
        }
        if (this.statement[3].tok != 2) {
            this.invalidArgument();
        }
        if ((direction = this.statement[3].intValue) != 1) {
            this.numberMustBe(-1, 1);
        }
        if (negative) {
            direction = -direction;
        }
        this.viewer.setAnimationDirection(direction);
    }

    void calculate() throws ScriptException {
        if (this.statementLength == 1) {
            this.evalError(GT._("Calculate what?") + "hbonds?  surface? structure?");
        }
        switch (this.statement[1].tok) {
            case 294924: {
                this.dots(2, 2);
                this.viewer.addStateScript("calculate surface");
                return;
            }
            case 10509: {
                this.viewer.autoHbond();
                return;
            }
            case 296: {
                this.viewer.calculateStructures();
                return;
            }
        }
    }

    void dots(int ipt, int dotsMode) throws ScriptException {
        this.viewer.loadShape(7);
        this.viewer.setShapeProperty(7, "init", new Integer(dotsMode));
        if (this.statementLength == ipt) {
            this.viewer.setShapeSize(7, 1);
            return;
        }
        int mad = 0;
        switch (this.statement[ipt].tok) {
            case 8193: 
            case 16438: {
                mad = 1;
                break;
            }
            case 16439: {
                mad = -1;
                break;
            }
            case 8192: {
                break;
            }
            case 32775: {
                float radius = this.floatParameter(++ipt);
                if (radius < 0.0f || radius > 10.0f) {
                    this.numberOutOfRange(0.0f, 2.0f);
                }
                mad = (short)(radius == 0.0f ? 0.0f : radius * 1000.0f + 11002.0f);
                break;
            }
            case 3: {
                float radius = this.floatParameter(ipt);
                if (radius < 0.0f || radius > 10.0f) {
                    this.numberOutOfRange(0.0f, 10.0f);
                }
                mad = (short)(radius == 0.0f ? 0.0f : radius * 1000.0f + 1002.0f);
                break;
            }
            case 2: {
                int dotsParam = this.intParameter(ipt);
                if (dotsParam < 0 || dotsParam > 1000) {
                    this.numberOutOfRange(0, 1000);
                }
                mad = (short)(dotsParam == 0 ? 0 : dotsParam + 1);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(7, mad);
    }

    void proteinShape(int shapeType) throws ScriptException {
        int mad = 0;
        int tok = this.statement[1].tok;
        switch (tok) {
            case 8193: {
                mad = -1;
                break;
            }
            case 8192: {
                break;
            }
            case 296: {
                mad = -2;
                break;
            }
            case 16418: 
            case 98308: {
                mad = -4;
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (radiusRasMol >= 500) {
                    this.numberOutOfRange(0, 499);
                }
                mad = (short)(radiusRasMol * 4 * 2);
                break;
            }
            case 3: {
                float angstroms = ((Float)this.statement[1].value).floatValue();
                if (angstroms > 4.0f) {
                    this.numberOutOfRange(0.0f, 4.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(shapeType, mad);
    }

    void animation() throws ScriptException {
        if (this.statementLength < 2) {
            this.subcommandExpected();
        }
        int tok = this.statement[1].tok;
        boolean animate = false;
        switch (tok) {
            case 8193: {
                animate = true;
            }
            case 8192: {
                this.viewer.setAnimationOn(animate);
                break;
            }
            case 324: {
                this.frame(2, false);
                break;
            }
            case 16415: {
                this.animationMode();
                break;
            }
            case 16416: {
                this.animationDirection();
                break;
            }
            case 1: {
                String str = (String)this.statement[1].value;
                if (str.equalsIgnoreCase("fps")) {
                    this.checkLength3();
                    this.viewer.setIntProperty("animationFps", this.intParameter(2));
                    break;
                }
            }
            default: {
                this.frameControl(this.statement[1], true);
            }
        }
    }

    void frame(int offset, boolean useModelNumber) throws ScriptException {
        useModelNumber = true;
        if (this.statementLength <= offset) {
            this.badArgumentCount();
        }
        if (this.statement[offset].tok == 32770) {
            this.checkStatementLength(++offset + 1);
            if (this.statement[offset].tok != 2 || this.statement[offset].intValue != 1) {
                this.invalidArgument();
            }
            this.viewer.setAnimationPrevious();
            return;
        }
        int frameNumber = -1;
        int frameNumber2 = -1;
        boolean isPlay = false;
        boolean isRange = false;
        boolean isAll = false;
        while (offset < this.statementLength) {
            Token cmd = this.statement[offset];
            int tok = cmd.tok;
            switch (tok) {
                case 36875: {
                    isAll = true;
                }
                case 32777: {
                    break;
                }
                case 49157: {
                    break;
                }
                case 2: {
                    if (frameNumber == -1) {
                        frameNumber = cmd.intValue;
                        break;
                    }
                    frameNumber2 = cmd.intValue;
                    break;
                }
                case 16441: {
                    isPlay = true;
                    break;
                }
                case 16446: {
                    isRange = true;
                    break;
                }
                default: {
                    this.frameControl(cmd, false);
                    return;
                }
            }
            if (offset == this.statementLength - 1) {
                int modelIndex;
                if (isAll) {
                    this.viewer.setAnimationRange(-1, -1);
                    this.viewer.setDisplayModelIndex(-1);
                    return;
                }
                int n = modelIndex = useModelNumber ? this.viewer.getModelNumberIndex(frameNumber) : frameNumber - 1;
                if (!isPlay && !isRange || modelIndex >= 0) {
                    this.viewer.setDisplayModelIndex(modelIndex);
                }
                if (isPlay || isRange) {
                    if (isRange || frameNumber2 >= 0) {
                        int modelIndex2 = useModelNumber ? this.viewer.getModelNumberIndex(frameNumber2) : frameNumber2 - 1;
                        this.viewer.setAnimationDirection(1);
                        this.viewer.setAnimationRange(modelIndex, modelIndex2);
                    }
                    if (isPlay) {
                        this.viewer.resumeAnimation();
                    }
                }
            }
            ++offset;
        }
    }

    void frameControl(Token token, boolean isSubCmd) throws ScriptException {
        switch (token.tok) {
            case 16445: {
                this.viewer.reverseAnimation();
            }
            case 16440: 
            case 16441: {
                this.viewer.resumeAnimation();
                return;
            }
            case 16659: {
                this.viewer.pauseAnimation();
                return;
            }
            case 16442: {
                this.viewer.setAnimationNext();
                return;
            }
            case 16443: {
                this.viewer.setAnimationPrevious();
                return;
            }
            case 16444: {
                this.viewer.rewindAnimation();
                return;
            }
        }
        this.evalError(GT._("invalid {0} control keyword", "frame") + ": " + token.toString());
    }

    int getShapeType(int tok) throws ScriptException {
        if (tok == 343) {
            return -JmolConstants.shapeTokenIndex(8458);
        }
        int iShape = JmolConstants.shapeTokenIndex(tok);
        if (iShape < 0) {
            this.unrecognizedObject();
        }
        return iShape;
    }

    void font() throws ScriptException {
        int shapeType = 0;
        int fontsize = 0;
        String fontface = "SansSerif";
        String fontstyle = "Plain";
        switch (this.statementLength) {
            case 5: {
                if (this.statement[4].tok != 1) {
                    this.keywordExpected();
                }
                fontstyle = (String)this.statement[4].value;
            }
            case 4: {
                if (this.statement[3].tok != 1) {
                    this.keywordExpected();
                }
                fontface = (String)this.statement[3].value;
            }
            case 3: {
                if (this.statement[2].tok != 2) {
                    this.integerExpected();
                }
                fontsize = this.statement[2].intValue;
                shapeType = this.getShapeType(this.statement[1].tok);
                break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        Font3D font3d = this.viewer.getFont3D(fontface, fontstyle, fontsize);
        this.viewer.setShapeProperty(shapeType, "font", font3d);
    }

    void set() throws ScriptException {
        switch (this.statement[1].tok) {
            case 2305: {
                this.setAxes(2);
                break;
            }
            case 2051: {
                this.setBondmode();
                break;
            }
            case 6405: {
                this.setBoundbox(2);
                break;
            }
            case 18471: 
            case 526598: {
                this.setDefaultColors();
                break;
            }
            case 2409: 
            case 2923: {
                this.setSelectionHalo(2);
                break;
            }
            case 1050891: {
                this.setEcho();
                break;
            }
            case 2056: {
                this.setFontsize();
                break;
            }
            case 10509: {
                this.setHbond();
                break;
            }
            case 6506: {
                this.history(2);
                break;
            }
            case 15634: {
                this.setMonitor(2);
                break;
            }
            case 2077: {
                this.setProperty();
                break;
            }
            case 2076: {
                this.setScale3d();
                break;
            }
            case 10535: {
                this.setStrands();
                break;
            }
            case 2112832: {
                this.setSpin();
                break;
            }
            case 10532: {
                this.setSsbond();
                break;
            }
            case 301332: {
                this.setUnitcell(2);
                break;
            }
            case 2062: {
                this.setPicking();
                break;
            }
            case 2081: {
                this.setPickingStyle();
                break;
            }
            case 100371: {
                this.viewer.setFormalCharges(this.intParameter(2));
                break;
            }
            case 1: 
            case 2048: 
            case 2050: 
            case 2058: 
            case 2059: 
            case 2060: 
            case 2061: 
            case 2063: 
            case 2064: 
            case 2065: 
            case 2066: 
            case 2067: 
            case 2069: 
            case 2075: 
            case 2078: 
            case 2307: 
            case 2335: 
            case 2349: 
            case 34820: 
            case 100355: 
            case 296961: 
            case 296962: 
            case 296964: 
            case 1050894: {
                String str = (String)this.statement[1].value;
                if (str.toLowerCase().indexOf("label") == 0) {
                    this.setLabel(str.substring(5));
                    break;
                }
                if (str.equalsIgnoreCase("toggleLabel")) {
                    this.viewer.togglePickingLabel(this.expression(this.statement, 2));
                    break;
                }
                if (str.equalsIgnoreCase("measurementNumbers")) {
                    this.setMonitor(2);
                    break;
                }
                if (str.equalsIgnoreCase("historyLevel")) {
                    this.commandHistoryLevelMax = this.intParameter(2);
                    break;
                }
                if (str.equalsIgnoreCase("defaultLattice")) {
                    Point3f pt;
                    if (this.statementLength < 3) {
                        this.badArgumentCount();
                    }
                    if (this.statement[2].tok == 2) {
                        int i = this.statement[2].intValue;
                        pt = new Point3f(i, i, i);
                    } else {
                        pt = this.getCoordinate(2, false);
                    }
                    this.viewer.setDefaultLattice(pt);
                    break;
                }
                if (str.equalsIgnoreCase("dipoleScale")) {
                    this.checkLength3();
                    float scale = this.floatParameter(2);
                    if (scale < -10.0f || scale > 10.0f) {
                        this.numberOutOfRange(-10.0f, 10.0f);
                    }
                    this.viewer.setFloatProperty("dipoleScale", scale);
                    break;
                }
                if (str.equalsIgnoreCase("logLevel")) {
                    int ilevel = this.intParameter(2);
                    Viewer.setLogLevel(ilevel);
                    Logger.info("logging level set to " + ilevel);
                    break;
                }
                if (this.statementLength == 2) {
                    this.viewer.setBooleanProperty((String)this.statement[1].value, this.booleanParameter(2));
                    break;
                }
                this.checkLength3();
                int tok = this.statement[2].tok;
                if (tok == 3) {
                    this.viewer.setFloatProperty((String)this.statement[1].value, ((Float)this.statement[2].value).floatValue());
                    break;
                }
                if (tok == 2) {
                    this.viewer.setIntProperty((String)this.statement[1].value, this.statement[2].intValue);
                    break;
                }
                if (tok != 8193 && tok != 8192 && this.statement[2].value instanceof String) {
                    this.viewer.setStringProperty((String)this.statement[1].value, (String)this.statement[2].value);
                    break;
                }
                this.viewer.setBooleanProperty((String)this.statement[1].value, this.booleanParameter(2));
                break;
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setAxes(int cmdPt) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setShapeSize(17, 1);
            return;
        }
        if (this.statementLength == cmdPt + 2 && this.statement[cmdPt].tok == 1 && ((String)this.statement[cmdPt].value).equalsIgnoreCase("scale")) {
            this.viewer.setShapeProperty(17, "scale", new Float(this.floatParameter(cmdPt + 1)));
            return;
        }
        this.viewer.setShapeSize(17, this.getSetAxesTypeMad(cmdPt));
    }

    void setBoundbox(int cmdPt) throws ScriptException {
        this.viewer.setShapeSize(18, this.getSetAxesTypeMad(cmdPt));
    }

    void setUnitcell(int cmdPt) throws ScriptException {
        if (this.statementLength == cmdPt + 1) {
            if (this.statement[cmdPt].tok == 2 && this.statement[cmdPt].intValue >= 111) {
                this.viewer.setCurrentUnitCellOffset(this.intParameter(cmdPt));
            } else {
                this.viewer.setShapeSize(19, this.getSetAxesTypeMad(cmdPt));
            }
            return;
        }
        this.viewer.setCurrentUnitCellOffset(this.getCoordinate(cmdPt, true, false, true));
    }

    void setFrank(int cmdPt) throws ScriptException {
        this.viewer.setBooleanProperty("frank", this.booleanParameter(cmdPt));
    }

    void setDefaultColors() throws ScriptException {
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 16392: 
            case 16430: {
                this.viewer.setStringProperty("defaultColorScheme", (String)this.statement[2].value);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setBondmode() throws ScriptException {
        this.checkLength3();
        boolean bondmodeOr = false;
        switch (this.statement[2].tok) {
            case 32771: {
                break;
            }
            case 32772: {
                bondmodeOr = true;
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setBooleanProperty("bondSelelectionModeOr", bondmodeOr);
    }

    void setSelectionHalo(int pt) throws ScriptException {
        if (pt == this.statementLength) {
            this.viewer.setBooleanProperty("selectionHalos", true);
            return;
        }
        if (pt + 1 < this.statementLength) {
            this.checkLength3();
        }
        boolean showHalo = false;
        switch (this.statement[pt].tok) {
            case 8193: 
            case 299011: {
                showHalo = true;
            }
            case 8192: 
            case 16391: 
            case 49157: {
                this.viewer.setBooleanProperty("selectionHalos", showHalo);
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
    }

    void setEcho() throws ScriptException {
        int i;
        String propertyName = "target";
        Object propertyValue = null;
        boolean echoShapeActive = true;
        if (this.statementLength < 3) {
            this.badArgumentCount();
        }
        switch (this.statement[2].tok) {
            case 8192: {
                this.checkLength3();
                echoShapeActive = false;
                propertyName = "allOff";
                break;
            }
            case 49157: {
                this.checkLength3();
                echoShapeActive = false;
            }
            case 36875: {
                this.checkLength3();
            }
            case 1: 
            case 6916: 
            case 16449: 
            case 16450: 
            case 16453: 
            case 16454: {
                propertyValue = this.statement[2].value;
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
        this.viewer.setEchoStateActive(echoShapeActive);
        this.viewer.loadShape(21);
        this.viewer.setShapeProperty(21, propertyName, propertyValue);
        if (this.statementLength == 3) {
            return;
        }
        propertyName = "align";
        if (this.statementLength == 4) {
            switch (this.statement[3].tok) {
                case 8192: {
                    propertyName = "off";
                    break;
                }
                case 1: 
                case 6916: 
                case 16449: 
                case 16450: 
                case 16453: 
                case 16454: {
                    propertyValue = this.statement[3].value;
                    break;
                }
                default: {
                    this.keywordExpected();
                }
            }
            this.viewer.setShapeProperty(21, propertyName, propertyValue);
            return;
        }
        if (this.statementLength < 5) {
            this.badArgumentCount();
        }
        if (this.isAtomCenterOrCoordinateNext(i = 3)) {
            this.viewer.setShapeProperty(21, "xyz", this.atomCenterOrCoordinateParameter(i));
            return;
        }
        int pos = this.intParameter(i++);
        propertyValue = new Integer(pos);
        String type = i < this.statementLength && this.statement[i].tok == 49181 ? "%xpos" : "xpos";
        this.viewer.setShapeProperty(21, type, propertyValue);
        int n = ++i;
        pos = this.intParameter(n);
        propertyValue = new Integer(pos);
        if (++i < this.statementLength && this.statement[i].tok == 49181) {
            type = "%ypos";
            ++i;
        } else {
            type = "ypos";
        }
        this.viewer.setShapeProperty(21, type, propertyValue);
    }

    void setFontsize() throws ScriptException {
        int rasmolSize = 8;
        if (this.statementLength == 3) {
            rasmolSize = this.intParameter(2);
            if ((rasmolSize += 5) < 6 || rasmolSize > 63) {
                this.numberOutOfRange(6, 6);
            }
        }
        this.viewer.loadShape(4);
        this.viewer.setShapeProperty(4, "fontsize", new Integer(rasmolSize));
    }

    void setLabel(String str) throws ScriptException {
        this.viewer.loadShape(4);
        if (str.equals("offset")) {
            this.checkLength4();
            int xOffset = this.intParameter(2);
            int yOffset = this.intParameter(3);
            if (xOffset > 100 || yOffset > 100 || xOffset < -100 || yOffset < -100) {
                this.numberOutOfRange(-100, 100);
            }
            int offset = (xOffset & 0xFF) << 8 | yOffset & 0xFF;
            this.viewer.setShapeProperty(4, "offset", new Integer(offset));
            return;
        }
        if (str.equals("alignment")) {
            this.checkLength3();
            switch (this.statement[2].tok) {
                case 6916: 
                case 16449: 
                case 16450: {
                    this.viewer.setShapeProperty(4, "align", this.statement[2].value);
                    return;
                }
            }
            this.invalidArgument();
        }
        if (str.equals("pointer")) {
            this.checkLength3();
            int flags = 0;
            switch (this.statement[2].tok) {
                case 8192: 
                case 49157: {
                    break;
                }
                case 4718849: {
                    flags |= 2;
                }
                case 8193: {
                    flags |= 1;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(4, "pointer", new Integer(flags));
            return;
        }
        this.checkLength2();
        if (str.equals("atom")) {
            this.viewer.setShapeProperty(4, "front", Boolean.FALSE);
            return;
        }
        if (str.equals("front")) {
            this.viewer.setShapeProperty(4, "front", Boolean.TRUE);
            return;
        }
        if (str.equals("group")) {
            this.viewer.setShapeProperty(4, "group", Boolean.TRUE);
            return;
        }
        this.invalidArgument();
    }

    void setMonitor(int cmdPt) throws ScriptException {
        boolean showMeasurementNumbers = false;
        this.checkLength3();
        switch (this.statement[cmdPt].tok) {
            case 8193: {
                showMeasurementNumbers = true;
            }
            case 8192: {
                this.viewer.setShapeProperty(6, "showMeasurementNumbers", showMeasurementNumbers ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                if (!this.viewer.setMeasureDistanceUnits((String)this.statement[cmdPt].value)) {
                    this.unrecognizedSetParameter();
                }
                return;
            }
        }
        this.viewer.setShapeSize(6, this.getSetAxesTypeMad(cmdPt));
    }

    void setProperty() throws ScriptException {
        this.checkLength4();
        if (this.statement[2].tok != 1) {
            this.propertyNameExpected();
        }
        String propertyName = (String)this.statement[2].value;
        switch (this.statement[3].tok) {
            case 8193: {
                this.viewer.setBooleanProperty(propertyName, true);
                break;
            }
            case 8192: {
                this.viewer.setBooleanProperty(propertyName, false);
                break;
            }
            case 2: {
                this.viewer.setIntProperty(propertyName, this.statement[3].intValue);
                break;
            }
            case 3: {
                this.viewer.setFloatProperty(propertyName, this.floatParameter(3));
                break;
            }
            case 4: {
                this.viewer.setStringProperty(propertyName, this.stringParameter(3));
                break;
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setStrands() throws ScriptException {
        int strandCount = 5;
        if (this.statementLength == 3) {
            if (this.statement[2].tok != 2) {
                this.integerExpected();
            }
            if ((strandCount = this.statement[2].intValue) < 0 || strandCount > 20) {
                this.numberOutOfRange(0, 20);
            }
        }
        this.viewer.setShapeProperty(11, "strandCount", new Integer(strandCount));
    }

    void setSpin() throws ScriptException {
        this.checkLength4();
        int value = (int)this.floatParameter(3);
        if (this.statement[2].tok == 1) {
            String str = (String)this.statement[2].value;
            if (str.equalsIgnoreCase("x")) {
                this.viewer.setSpinX(value);
                return;
            }
            if (str.equalsIgnoreCase("y")) {
                this.viewer.setSpinY(value);
                return;
            }
            if (str.equalsIgnoreCase("z")) {
                this.viewer.setSpinZ(value);
                return;
            }
            if (str.equalsIgnoreCase("fps")) {
                this.viewer.setSpinFps(value);
                return;
            }
        }
        this.unrecognizedSetParameter();
    }

    void setSsbond() throws ScriptException {
        this.checkLength3();
        boolean ssbondsBackbone = false;
        this.viewer.loadShape(3);
        switch (this.statement[2].tok) {
            case 303360: {
                ssbondsBackbone = true;
                break;
            }
            case 294917: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setBooleanProperty("ssbondsBackbone", ssbondsBackbone);
    }

    void setHbond() throws ScriptException {
        this.checkLength3();
        boolean bool = false;
        switch (this.statement[2].tok) {
            case 303360: {
                bool = true;
            }
            case 294917: {
                this.viewer.setBooleanProperty("hbondsBackbone", bool);
                break;
            }
            case 16429: {
                bool = true;
            }
            case 16414: {
                this.viewer.setBooleanProperty("hbondsSolid", bool);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setScale3d() throws ScriptException {
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.viewer.setFloatProperty("scaleAngstromsPerInch", this.floatParameter(2));
    }

    void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.viewer.setStringProperty("picking", "ident");
            return;
        }
        this.checkLength34();
        switch (this.statement[2].tok) {
            case 798: 
            case 15634: 
            case 2112832: {
                break;
            }
            default: {
                this.checkLength3();
            }
        }
        String str = null;
        Token token = this.statement[this.statementLength - 1];
        int tok = token.tok;
        switch (tok) {
            case 8193: 
            case 16391: {
                str = "ident";
                break;
            }
            case 49157: {
                str = "off";
                break;
            }
            case 798: {
                str = "atom";
                break;
            }
            case 34820: {
                str = "bond";
                break;
            }
            case 2112832: {
                int rate = 10;
                if (this.statementLength == 4) {
                    rate = this.intParameter(3);
                }
                this.viewer.setIntProperty("pickingSpinRate", rate);
                return;
            }
        }
        if (token.value instanceof String) {
            str = (String)token.value;
        } else {
            this.invalidArgument();
        }
        if (JmolConstants.GetPickingMode(str) < 0) {
            this.invalidArgument();
        }
        this.viewer.setStringProperty("picking", str);
    }

    void setPickingStyle() throws ScriptException {
        this.checkLength34();
        boolean isMeasure = this.statement[2].tok == 15634;
        String str = null;
        Token token = this.statement[this.statementLength - 1];
        int tok = token.tok;
        switch (tok) {
            case 8192: 
            case 49157: {
                str = isMeasure ? "measureoff" : "toggle";
                break;
            }
            case 8193: {
                if (!isMeasure) {
                    this.invalidArgument();
                }
                str = "measure";
            }
        }
        try {
            if (str == null) {
                str = (String)token.value;
            }
        }
        catch (Exception e) {
            this.invalidArgument();
        }
        if (JmolConstants.GetPickingStyle(str) < 0) {
            this.invalidArgument();
        }
        this.viewer.setStringProperty("pickingStyle", str);
    }

    void save() throws ScriptException {
        if (this.statementLength > 1) {
            String saveName = this.parameterAsString(2);
            switch (this.statement[1].tok) {
                case 4111: {
                    this.viewer.saveOrientation(saveName);
                    return;
                }
                case 34820: {
                    this.viewer.saveBonds(saveName);
                    return;
                }
                case 4113: {
                    this.viewer.saveState(saveName);
                    return;
                }
                case 1: {
                    if (!((String)this.statement[1].value).equalsIgnoreCase("selection")) break;
                    this.viewer.saveSelection(saveName);
                    return;
                }
            }
        }
        this.evalError(GT._("save what?") + " bonds? orientation? selection? state?");
    }

    void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String saveName = this.parameterAsString(2);
            switch (this.statement[1].tok) {
                case 4111: {
                    float timeSeconds = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    this.viewer.restoreOrientation(saveName, timeSeconds);
                    return;
                }
                case 34820: {
                    this.viewer.restoreBonds(saveName);
                    return;
                }
                case 4113: {
                    String state = this.viewer.getSavedState(saveName);
                    if (state == null) {
                        this.invalidArgument();
                    }
                    this.runScript(state);
                    return;
                }
                case 1: {
                    if (!((String)this.statement[1].value).equalsIgnoreCase("selection")) break;
                    this.viewer.restoreSelection(saveName);
                    return;
                }
            }
        }
        this.evalError(GT._("restore what?") + " bonds? orientation? selection?");
    }

    void write() throws ScriptException {
        String type;
        int tok;
        if (this.viewer.isApplet()) {
            this.evalError(GT._("The {0} command is not available for the applet.", "WRITE"));
        }
        int n = tok = this.statementLength == 1 ? 0 : this.statement[1].tok;
        if (this.statementLength == 1 || tok == 261) {
            this.viewer.createImage(null, "CLIP", 100);
            return;
        }
        this.checkLength3();
        String string = type = tok == 1 ? (String)this.statement[1].value : this.stringParameter(1);
        if (";JPEG;JPG64;JPG;PDF;PNG;".indexOf((";" + type + ";").toUpperCase()) < 0) {
            this.evalError(GT._("write what? {0} or {1} \"filename\"", new Object[]{"CLIPBOARD", "JPG|JPG64|PNG|PPM"}));
        }
        String fileName = this.statement[2].tok == 1 ? (String)this.statement[2].value : this.stringParameter(2);
        this.viewer.createImage(fileName, type, 100);
    }

    void show() throws ScriptException {
        if (this.statementLength == 1) {
            this.badArgumentCount();
        }
        switch (this.statement[1].tok) {
            case 4113: {
                this.checkLength23();
                if (this.statementLength == 2) {
                    this.showString(this.viewer.getStateInfo());
                    return;
                }
                this.showString(this.viewer.getSavedState(this.parameterAsString(2)));
                return;
            }
            case 4380: {
                this.showString(this.viewer.listSavedStates());
                return;
            }
            case 4360: {
                String type = this.statementLength == 3 ? this.stringParameter(2) : null;
                String[] data = type == null ? this.dataLabelString : this.viewer.getData(type);
                this.showString(data == null ? "no data" : "data \"" + data[0] + "\"\n" + data[1]);
                return;
            }
            case 301332: {
                this.showString(this.viewer.getUnitCellInfoText());
                return;
            }
            case 6178: {
                if (this.statementLength == 2) {
                    this.showString(this.viewer.getSpaceGroupInfoText(null));
                    return;
                }
                if (this.statementLength == 3 && this.statement[2].tok == 4) {
                    String sg = this.viewer.simpleReplace((String)this.statement[2].value, "''", "\"");
                    this.showString(this.viewer.getSpaceGroupInfoText(sg));
                    return;
                }
                this.invalidArgument();
            }
            case 8392723: {
                int shapeType = this.setShapeByNameParameter(2);
                this.showString((String)this.viewer.getShapeProperty(shapeType, shapeType == 27 ? "jvxlFileData" : "command"));
                return;
            }
            case 6405: {
                this.showString("boundbox: " + this.viewer.getBoundBoxCenter() + " " + this.viewer.getBoundBoxCornerVector());
                return;
            }
            case 6916: {
                Point3f pt = this.viewer.getRotationCenter();
                this.showString("center {" + pt.x + " " + pt.y + " " + pt.z + "}");
                return;
            }
            case 2626911: {
                this.showString((String)this.viewer.getShapeProperty(29, "command"));
                return;
            }
            case 4112: {
                if (this.statementLength == 2) {
                    this.showString(this.viewer.getCurrentFileAsString());
                    return;
                }
                if (this.statementLength == 3 && this.statement[2].tok == 4) {
                    String fileName = (String)this.statement[2].value;
                    this.showString(this.viewer.getFileAsString(fileName));
                    return;
                }
                this.invalidArgument();
            }
            case 6506: {
                int n;
                int n2 = n = this.statementLength == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n < 1) {
                    this.invalidArgument();
                }
                this.viewer.removeCommand();
                this.showString(this.viewer.getSetHistory(n));
                return;
            }
            case 2626910: {
                this.showString((String)this.viewer.getShapeProperty(27, "jvxlFileData"));
                return;
            }
            case 2625891: {
                Hashtable moData;
                this.viewer.loadShape(26);
                int modelIndex = this.viewer.getDisplayModelIndex();
                if (modelIndex < 0) {
                    this.evalError(GT._("MO isosurfaces require that only one model be displayed"));
                }
                if ((moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "moData")) == null) {
                    this.evalError(GT._("no MO basis/coefficient data available for this frame"));
                }
                this.viewer.setShapeProperty(26, "moData", moData);
                this.showString((String)this.viewer.getShapeProperty(26, "showMO", this.statementLength > 2 ? this.intParameter(2) : Integer.MAX_VALUE));
                return;
            }
            case 102661: {
                this.showString(this.viewer.getModelInfoAsString());
                return;
            }
            case 15634: {
                this.showString(this.viewer.getMeasurementInfoAsString());
                return;
            }
            case 4111: {
                this.showString(this.viewer.getOrientationText());
                return;
            }
            case 36876: {
                this.showString(this.viewer.getPDBHeader());
                return;
            }
            case 299016: {
                this.showString(this.viewer.getSymmetryInfoAsString());
                return;
            }
            case 4110: {
                this.showString("transform:\n" + this.viewer.getTransformText());
                return;
            }
            case 4107: {
                if (this.statementLength == 2) {
                    this.viewer.showUrl(this.viewer.getFullPathName());
                    return;
                }
                if (this.statementLength == 3 && this.statement[2].tok == 4) {
                    String fileName = (String)this.statement[2].value;
                    this.viewer.showUrl(fileName);
                    return;
                }
                this.invalidArgument();
            }
            case 2102575: {
                this.showString("zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomPercentSetting() : "off"));
                return;
            }
            case 4099: 
            case 4105: {
                this.evalError(GT._("use {0}") + "\"show ORIENTATION\"");
            }
            case 4106: 
            case 36868: 
            case 36869: 
            case 36871: {
                this.evalError(GT._("unrecognized {0} parameter --  use {1}", new Object[]{"SHOW", "\"getProperty CHAININFO\""}));
            }
            case 299011: {
                this.evalError(GT._("unrecognized {0} parameter --  use {1}", new Object[]{"SHOW", "\"getProperty ATOMINFO (selected)\""}));
            }
            case 4102: {
                this.evalError(GT._("unrecognized {0} parameter --  use {1}", new Object[]{"SHOW", "\"getProperty ATOMINFO (atom expression)\""}));
            }
            case 4096: 
            case 4097: 
            case 4098: 
            case 4417: 
            case 6169: 
            case 36875: 
            case 2112832: {
                this.notImplemented(1);
                break;
            }
            default: {
                this.evalError(GT._("unrecognized {0} parameter", "SHOW"));
            }
        }
    }

    void showString(String str) {
        Logger.warn(str);
        this.viewer.scriptEcho(str);
    }

    /*
     * Unable to fully structure code
     */
    void pmesh() throws ScriptException {
        this.viewer.loadShape(25);
        this.viewer.setShapeProperty(25, "init", null);
        block4: for (i = 1; i < this.statementLength; ++i) {
            propertyName = null;
            propertyValue = null;
            tok = this.statement[i].tok;
            switch (tok) {
                case 1: {
                    propertyValue = this.statement[i].value;
                    str = (String)propertyValue;
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    propertyName = "thisID";
                    break;
                }
                case 4: {
                    filename = (String)this.statement[i].value;
                    propertyName = "bufferedReader";
                    if (!filename.equalsIgnoreCase("inline")) ** GOTO lbl41
                    if (i + 1 < this.statementLength && this.statement[i + 1].tok == 4) {
                        data = (String)this.statement[++i].value;
                        if (data.indexOf("|") < 0 && data.indexOf("\n") < 0) {
                            data = this.viewer.simpleReplace(data, " ", "\n");
                            propertyName = "bufferedReaderOnePerLine";
                        }
                        data = this.viewer.simpleReplace(data, "{", " ");
                        data = this.viewer.simpleReplace(data, ",", " ");
                        data = this.viewer.simpleReplace(data, "}", " ");
                        data = this.viewer.simpleReplace(data, "|", "\n");
                        data = this.viewer.simpleReplace(data, "\n\n", "\n");
                        if (this.logMessages) {
                            Logger.debug("pmesh inline data:\n" + data);
                        }
                        t = this.viewer.getBufferedReaderForString(data);
                    } else {
                        this.stringOrIdentifierExpected();
                        break;
lbl41:
                        // 1 sources

                        t = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(filename);
                        if (t instanceof String) {
                            this.fileNotFoundException(filename + ":" + t);
                        }
                    }
                    propertyValue = t;
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(25, tok)) continue block4;
                    this.invalidArgument(i, this.statement[i] + " not recognized");
                    continue block4;
                }
            }
            this.viewer.setShapeProperty(25, propertyName, propertyValue);
        }
    }

    void draw() throws ScriptException {
        this.viewer.loadShape(29);
        this.viewer.setShapeProperty(29, "init", null);
        boolean havePoints = false;
        boolean isInitialized = false;
        int intScale = 0;
        block13: for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            int tok = this.statement[i].tok;
            block0 : switch (tok) {
                case 1: {
                    Point3f pt;
                    propertyName = "thisID";
                    propertyValue = this.statement[i].value;
                    String str = (String)propertyValue;
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("PLANE")) {
                        propertyName = "plane";
                        break;
                    }
                    if (str.equalsIgnoreCase("CROSSED")) {
                        propertyName = "crossed";
                        break;
                    }
                    if (str.equalsIgnoreCase("CURVE")) {
                        propertyName = "curve";
                        break;
                    }
                    if (str.equalsIgnoreCase("ARROW")) {
                        propertyName = "arrow";
                        break;
                    }
                    if (str.equalsIgnoreCase("CIRCLE")) {
                        propertyName = "circle";
                        break;
                    }
                    if (str.equalsIgnoreCase("VERTICES")) {
                        propertyName = "vertices";
                        break;
                    }
                    if (str.equalsIgnoreCase("REVERSE")) {
                        propertyName = "reverse";
                        break;
                    }
                    if (str.equalsIgnoreCase("ROTATE45")) {
                        propertyName = "rotate45";
                        break;
                    }
                    if (str.equalsIgnoreCase("PERP") || str.equalsIgnoreCase("PERPENDICULAR")) {
                        propertyName = "perp";
                        break;
                    }
                    if (str.equalsIgnoreCase("OFFSET")) {
                        pt = this.getCoordinate(++i, true);
                        i = this.pcLastExpressionInstruction;
                        propertyName = "offset";
                        propertyValue = pt;
                        break;
                    }
                    if (str.equalsIgnoreCase("SCALE")) {
                        this.checkStatementLength(++i + 1);
                        switch (this.statement[i].tok) {
                            case 2: {
                                intScale = this.intParameter(i);
                                break block0;
                            }
                            case 3: {
                                intScale = (int)(this.floatParameter(i) * 100.0f);
                                break block0;
                            }
                        }
                        this.numberExpected();
                        break;
                    }
                    if (!str.equalsIgnoreCase("LENGTH")) break;
                    propertyValue = new Float(this.floatParameter(++i));
                    propertyName = "length";
                    break;
                }
                case 8392723: {
                    propertyValue = this.objectNameParameter(++i);
                    propertyName = "identifier";
                    havePoints = true;
                    break;
                }
                case 526598: {
                    if (++i < this.statementLength && this.statement[i].tok == 540692) {
                        this.viewer.setShapeProperty(29, "colorRGB", new Integer(this.getArgbParam(i)));
                        continue block13;
                    }
                    this.invalidArgument();
                }
                case 3: {
                    propertyValue = new Float(this.floatParameter(i));
                    propertyName = "length";
                    break;
                }
                case 2: {
                    intScale = this.intParameter(i);
                    break;
                }
                case 32785: {
                    Point3f pt = this.getCoordinate(i, true);
                    i = this.pcLastExpressionInstruction;
                    propertyName = "coord";
                    propertyValue = pt;
                    havePoints = true;
                    break;
                }
                case 32868: {
                    propertyName = "atomSet";
                    propertyValue = this.expression(this.statement, i + 1);
                    i = this.pcLastExpressionInstruction;
                    havePoints = true;
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(29, tok)) break;
                    this.invalidArgument();
                }
            }
            if (havePoints && !isInitialized) {
                this.viewer.setShapeProperty(29, "points", new Integer(intScale));
                isInitialized = true;
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(29, propertyName, propertyValue);
        }
        if (havePoints) {
            this.viewer.setShapeProperty(29, "set", null);
        } else if (intScale != 0) {
            this.viewer.setShapeProperty(29, "scale", new Integer(intScale));
        }
    }

    void polyhedra() throws ScriptException {
        boolean needsGenerating = false;
        boolean onOffDelete = false;
        boolean typeSeen = false;
        boolean edgeParameterSeen = false;
        boolean isDesignParameter = false;
        int nAtomSets = 0;
        this.viewer.loadShape(23);
        this.viewer.setShapeProperty(23, "init", null);
        String setPropertyName = "centers";
        String decimalPropertyName = "radius_";
        String translucency = "";
        int color = Integer.MIN_VALUE;
        block13: for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            Token token = this.statement[i];
            switch (token.tok) {
                case 32772: 
                case 163844: {
                    continue block13;
                }
                case 34820: {
                    if (nAtomSets > 0) {
                        this.invalidParameterOrder();
                    }
                    needsGenerating = true;
                    propertyName = "bonds";
                    break;
                }
                case 100355: {
                    decimalPropertyName = "radius";
                    continue block13;
                }
                case 16425: {
                    translucency = "translucent";
                    continue block13;
                }
                case 16424: {
                    translucency = "opaque";
                    continue block13;
                }
                case 540692: {
                    color = this.getArgbParam(i);
                    continue block13;
                }
                case 1: {
                    String str = (String)token.value;
                    if ("collapsed".equalsIgnoreCase(str)) {
                        propertyName = "collapsed";
                        propertyValue = Boolean.TRUE;
                        if (typeSeen) {
                            this.incompatibleArguments();
                        }
                        typeSeen = true;
                        break;
                    }
                    if ("flat".equalsIgnoreCase(str)) {
                        propertyName = "collapsed";
                        propertyValue = Boolean.FALSE;
                        if (typeSeen) {
                            this.incompatibleArguments();
                        }
                        typeSeen = true;
                        break;
                    }
                    if ("edges".equalsIgnoreCase(str) || "noedges".equalsIgnoreCase(str) || "frontedges".equalsIgnoreCase(str)) {
                        if (edgeParameterSeen) {
                            this.incompatibleArguments();
                        }
                        propertyName = (String)token.value;
                        edgeParameterSeen = true;
                        break;
                    }
                    if (!needsGenerating) {
                        this.insufficientArguments();
                    }
                    if ("to".equalsIgnoreCase(str)) {
                        if (nAtomSets > 1) {
                            this.invalidParameterOrder();
                        }
                        if (this.statementLength > i + 2 && this.statement[i + 2].tok == 16455) {
                            propertyName = "toBitSet";
                            propertyValue = this.statement[i + 2].value;
                            i += 3;
                            needsGenerating = true;
                            break;
                        }
                        setPropertyName = "to";
                        continue block13;
                    }
                    if ("faceCenterOffset".equalsIgnoreCase(str)) {
                        decimalPropertyName = "faceCenterOffset";
                        isDesignParameter = true;
                        continue block13;
                    }
                    if ("distanceFactor".equalsIgnoreCase(str)) {
                        decimalPropertyName = "distanceFactor";
                        isDesignParameter = true;
                        continue block13;
                    }
                    this.unrecognizedSubcommand(str);
                }
                case 2: {
                    if (nAtomSets > 0 && !isDesignParameter) {
                        this.invalidParameterOrder();
                    }
                    if (decimalPropertyName == "radius_") {
                        propertyName = "nVertices";
                        propertyValue = new Integer(token.intValue);
                        needsGenerating = true;
                        break;
                    }
                }
                case 3: {
                    if (nAtomSets > 0 && !isDesignParameter) {
                        this.invalidParameterOrder();
                    }
                    propertyName = decimalPropertyName == "radius_" ? "radius" : decimalPropertyName;
                    propertyValue = new Float(this.floatParameter(i));
                    decimalPropertyName = "radius_";
                    isDesignParameter = false;
                    needsGenerating = true;
                    break;
                }
                case 8192: 
                case 8193: 
                case 16426: {
                    if (++i != this.statementLength || needsGenerating || nAtomSets > 1 || nAtomSets == 0 && setPropertyName == "to") {
                        this.incompatibleArguments();
                    }
                    propertyName = (String)token.value;
                    onOffDelete = true;
                    break;
                }
                case 32868: {
                    if (typeSeen) {
                        this.invalidParameterOrder();
                    }
                    if (++nAtomSets > 2) {
                        this.badArgumentCount();
                    }
                    if (setPropertyName == "to") {
                        needsGenerating = true;
                    }
                    propertyName = setPropertyName;
                    setPropertyName = "to";
                    propertyValue = this.expression(this.statement, ++i);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(23, propertyName, propertyValue);
            if (!onOffDelete) continue;
            return;
        }
        if (!(needsGenerating || typeSeen || edgeParameterSeen)) {
            this.insufficientArguments();
        }
        if (needsGenerating) {
            this.viewer.setShapeProperty(23, "generate", null);
        }
        if (color != Integer.MIN_VALUE) {
            this.viewer.setShapeProperty(23, "colorThis", new Integer(color));
        }
        if (translucency.length() > 0) {
            this.viewer.setShapeProperty(23, "translucencyThis", translucency);
        }
    }

    /*
     * Unable to fully structure code
     */
    void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(28);
        this.viewer.setShapeProperty(28, "init", null);
        if (this.statementLength == 1) {
            this.endOfStatementUnexpected();
        }
        block11: for (i = 1; i < this.statementLength; ++i) {
            token = this.statement[i];
            tok = token.tok;
            propertyName = null;
            propertyValue = null;
            switch (tok) {
                case 8193: {
                    propertyName = "on";
                    ** GOTO lbl53
                }
                case 8192: {
                    propertyName = "off";
                    ** GOTO lbl53
                }
                case 16426: {
                    propertyName = "delete";
                    ** GOTO lbl53
                }
                case 2: 
                case 3: {
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(++i));
                    ** GOTO lbl53
                }
                case 526598: {
                    if (++i < this.statementLength && this.statement[i].tok == 540692) {
                        this.viewer.setShapeProperty(28, "colorRGB", new Integer(this.getArgbParam(i)));
                        this.viewer.setShapeProperty(28, "colorRGB", new Integer(this.getArgbParam(i + 1 < this.statementLength && this.statement[i + 1].tok == 540692 ? ++i : i)));
                        continue block11;
                    }
                    this.invalidArgument();
                }
                case 4: {
                    propertyName = "create";
                    propertyValue = this.stringParameter(i);
                    if (i + 1 < this.statementLength && this.statement[i + 1].tok == 1 && ((String)this.statement[i + 1].value).equalsIgnoreCase("molecular")) {
                        this.viewer.setShapeProperty(28, "molecular", null);
                    }
                    ** GOTO lbl53
                }
                case 798: {
                    propertyName = "select";
                    propertyValue = this.stringParameter(++i);
                    ** GOTO lbl53
                }
                case 1: {
                    str = (String)token.value;
                    if (!str.equalsIgnoreCase("SCALE")) ** GOTO lbl46
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(++i));
                    ** GOTO lbl53
lbl46:
                    // 1 sources

                    if (!str.equalsIgnoreCase("CREATE")) ** GOTO lbl50
                    propertyName = "create";
                    propertyValue = this.stringParameter(++i);
                    ** GOTO lbl53
lbl50:
                    // 1 sources

                    propertyValue = str;
                }
                case 36875: {
                    propertyName = "lcaoID";
                }
lbl53:
                // 10 sources

                default: {
                    if (propertyName == null) {
                        this.invalidArgument(i, token.toString());
                    }
                    this.viewer.setShapeProperty(28, propertyName, propertyValue);
                }
            }
        }
    }

    void mo() throws ScriptException {
        int moNumber;
        this.viewer.loadShape(26);
        this.viewer.setShapeProperty(26, "init", "mo_model" + (this.viewer.getDisplayModelIndex() + 1));
        Integer index = null;
        String title = null;
        try {
            index = (Integer)this.viewer.getShapeProperty(26, "moNumber");
        }
        catch (Exception e) {
            // empty catch block
        }
        int n = moNumber = index == null ? Integer.MAX_VALUE : index;
        if (moNumber == Integer.MAX_VALUE) {
            this.lastMoNumber = 0;
        }
        if (this.statementLength == 1) {
            this.endOfStatementUnexpected();
        }
        Token token = this.statement[1];
        int tok = token.tok;
        String propertyName = null;
        Object propertyValue = null;
        switch (tok) {
            case 2: {
                moNumber = this.intParameter(1);
                break;
            }
            case 16442: {
                moNumber = this.lastMoNumber + 1;
                break;
            }
            case 16443: {
                moNumber = this.lastMoNumber - 1;
                break;
            }
            case 526598: {
                if (2 < this.statementLength && this.statement[2].tok == 540692) {
                    this.viewer.setShapeProperty(26, "colorRGB", new Integer(this.getArgbParam(2)));
                    if (3 >= this.statementLength || this.statement[3].tok != 540692) break;
                    this.viewer.setShapeProperty(26, "colorRGB", new Integer(this.getArgbParam(3)));
                    break;
                }
                this.invalidArgument();
            }
            case 1: {
                String str = (String)token.value;
                if (str.equalsIgnoreCase("CUTOFF")) {
                    if (2 < this.statementLength && this.statement[2].tok == 32775) {
                        propertyName = "cutoffPositive";
                        propertyValue = new Float(this.floatParameter(3));
                        break;
                    }
                    propertyName = "cutoff";
                    propertyValue = new Float(this.floatParameter(2));
                    break;
                }
                if (str.equalsIgnoreCase("RESOLUTION")) {
                    propertyName = "resolution";
                    propertyValue = new Float(this.floatParameter(2));
                    break;
                }
                if (str.equalsIgnoreCase("SCALE")) {
                    propertyName = "scale";
                    propertyValue = new Float(this.floatParameter(2));
                    break;
                }
                if (str.equalsIgnoreCase("TITLEFORMAT")) {
                    if (2 >= this.statementLength || this.statement[2].tok != 4) break;
                    propertyName = "titleFormat";
                    propertyValue = this.stringParameter(2);
                    break;
                }
                if (str.equalsIgnoreCase("DEBUG")) {
                    propertyName = "debug";
                    break;
                }
                if (str.equalsIgnoreCase("plane")) {
                    propertyName = "plane";
                    propertyValue = this.planeParameter(2);
                    break;
                }
                if (str.equalsIgnoreCase("noplane")) {
                    propertyName = "plane";
                    propertyValue = null;
                    break;
                }
                this.invalidArgument(1, str);
            }
            default: {
                if (!this.setMeshDisplayProperty(26, tok)) {
                    this.invalidArgument(1, this.statement[1] + " not recognized");
                }
                return;
            }
        }
        if (propertyName != null) {
            this.viewer.setShapeProperty(26, propertyName, propertyValue);
        }
        if (moNumber != Integer.MAX_VALUE) {
            if (2 < this.statementLength && this.statement[2].tok == 4) {
                title = this.stringParameter(2);
            }
            this.setMoData(26, moNumber, title);
        }
    }

    void setMoData(int shape, int moNumber, String title) throws ScriptException {
        Vector mos;
        int nOrb;
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            this.evalError(GT._("MO isosurfaces require that only one model be displayed"));
        }
        Hashtable moData = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "moData");
        Hashtable surfaceInfo = (Hashtable)this.viewer.getModelAuxiliaryInfo(modelIndex, "jmolSurfaceInfo");
        if (surfaceInfo != null && ((String)surfaceInfo.get("surfaceDataType")).equals("mo")) {
            this.viewer.loadShape(27);
            this.viewer.setShapeProperty(27, "init", null);
            this.viewer.setShapeProperty(27, "sign", Boolean.TRUE);
            this.viewer.setShapeProperty(27, "getSurface", surfaceInfo);
            return;
        }
        if (moData == null) {
            this.evalError(GT._("no MO basis/coefficient data available for this frame"));
        }
        int n = nOrb = (mos = (Vector)moData.get("mos")) == null ? 0 : mos.size();
        if (nOrb == 0) {
            this.evalError(GT._("no MO coefficient data available"));
        }
        if (nOrb == 1 && moNumber > 1) {
            this.evalError(GT._("Only one molecular orbital is available in this file"));
        }
        if (moNumber < 1 || moNumber > nOrb) {
            this.evalError(GT._("An MO index from 1 to {0} is required", nOrb));
        }
        this.lastMoNumber = moNumber;
        this.viewer.setShapeProperty(shape, "moData", moData);
        if (title != null) {
            this.viewer.setShapeProperty(shape, "title", title);
        }
        this.viewer.setShapeProperty(shape, "molecularOrbital", new Integer(moNumber));
    }

    void isosurface() throws ScriptException {
        this.viewer.loadShape(27);
        this.viewer.setShapeProperty(27, "init", null);
        this.viewer.setShapeProperty(27, "title", new String[]{this.script});
        int colorRangeStage = 0;
        int signPt = 0;
        boolean surfaceObjectSeen = false;
        boolean planeSeen = false;
        float[] nlmZ = new float[5];
        int modelIndex = this.viewer.getDisplayModelIndex();
        if (modelIndex < 0) {
            this.evalError(GT._("the {0} command requires that only one model be displayed", "ISOSURFACE"));
        }
        block31: for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            Token token = this.statement[i];
            block1 : switch (token.tok) {
                case 798: {
                    propertyName = "select";
                    propertyValue = this.expression(this.statement, ++i + 1);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 6916: {
                    propertyName = "center";
                    switch (this.statement[++i].tok) {
                        case 8392723: {
                            String id = this.objectNameParameter(++i);
                            propertyValue = this.viewer.getDrawObjectCenter(id);
                            if (propertyValue != null) break block1;
                            this.drawObjectNotDefined(id);
                            break;
                        }
                        case 32785: 
                        case 32868: {
                            propertyValue = this.atomCenterOrCoordinateParameter(i);
                            i = this.pcLastExpressionInstruction;
                            break;
                        }
                        default: {
                            this.coordinateOrNameOrExpressionRequired();
                            break;
                        }
                    }
                    break;
                }
                case 526598: {
                    if (i + 1 == this.statementLength) {
                        this.invalidArgument(i, " COLOR keyword not in context");
                    }
                    colorRangeStage = 0;
                    switch (this.statement[i + 1].tok) {
                        case 16431: {
                            ++i;
                            colorRangeStage = 1;
                            break;
                        }
                        case 540692: {
                            signPt = i + 1;
                        }
                    }
                    continue block31;
                }
                case 4112: {
                    continue block31;
                }
                case 32775: {
                    if (colorRangeStage != 0) break;
                    propertyName = "cutoffPositive";
                    propertyValue = new Float(this.floatParameter(++i));
                    break;
                }
                case 2: 
                case 3: {
                    propertyName = colorRangeStage == 1 ? "red" : (colorRangeStage == 2 ? "blue" : "cutoff");
                    propertyValue = new Float(this.floatParameter(i));
                    if (colorRangeStage <= 0) break;
                    ++colorRangeStage;
                    break;
                }
                case 540692: {
                    if (i != signPt && i != signPt + 1) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "colorRGB";
                    propertyValue = new Integer(this.getArgbParam(i));
                    break;
                }
                case 16439: {
                    propertyName = "ionicRadius";
                    propertyValue = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 16438: {
                    propertyName = "vdwRadius";
                    propertyValue = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 1: {
                    String str = (String)token.value;
                    if (str.equalsIgnoreCase("REMAPPABLE")) {
                        propertyName = "remappable";
                        break;
                    }
                    if (str.equalsIgnoreCase("IGNORE")) {
                        propertyName = "ignore";
                        propertyValue = this.expression(this.statement, ++i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("CUTOFF")) {
                        if (++i < this.statementLength && this.statement[i].tok == 32775) {
                            propertyName = "cutoffPositive";
                            propertyValue = new Float(this.floatParameter(++i));
                            break;
                        }
                        propertyName = "cutoff";
                        propertyValue = new Float(this.floatParameter(i));
                        break;
                    }
                    if (str.equalsIgnoreCase("SCALE")) {
                        propertyName = "scale";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("ANGSTROMS")) {
                        propertyName = "angstroms";
                        break;
                    }
                    if (str.equalsIgnoreCase("RESOLUTION")) {
                        propertyName = "resolution";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("ANISOTROPY")) {
                        propertyName = "anisotropy";
                        propertyValue = this.getCoordinate(i + 1, false);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("ECCENTRICITY")) {
                        propertyName = "eccentricity";
                        propertyValue = this.getPoint4f(i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("FIXED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("MODELBASED")) {
                        propertyName = "fixed";
                        propertyValue = Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("SIGN")) {
                        signPt = i + 1;
                        propertyName = "sign";
                        propertyValue = Boolean.TRUE;
                        colorRangeStage = 1;
                        break;
                    }
                    if (str.equalsIgnoreCase("INSIDEOUT")) {
                        propertyName = "insideOut";
                        break;
                    }
                    if (str.equalsIgnoreCase("REVERSECOLOR")) {
                        propertyName = "reverseColor";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("ADDHYDROGENS")) {
                        propertyName = "addHydrogens";
                        propertyValue = Boolean.TRUE;
                        break;
                    }
                    if (str.equalsIgnoreCase("COLORSCHEME")) {
                        propertyName = "setColorScheme";
                        propertyValue = this.stringParameter(++i);
                        break;
                    }
                    if (str.equalsIgnoreCase("DEBUG") || str.equalsIgnoreCase("NODEBUG")) {
                        propertyName = "debug";
                        propertyValue = str.equalsIgnoreCase("DEBUG") ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (str.equalsIgnoreCase("GRIDPOINTS")) {
                        propertyName = "gridPoints";
                        break;
                    }
                    if (str.equalsIgnoreCase("CONTOUR")) {
                        propertyName = "contour";
                        propertyValue = new Integer(i + 1 < this.statementLength && this.statement[i + 1].tok == 2 ? this.intParameter(++i) : 0);
                        break;
                    }
                    if (str.equalsIgnoreCase("PHASE")) {
                        propertyName = "phase";
                        propertyValue = i + 1 < this.statementLength && this.statement[i + 1].tok == 4 ? this.stringParameter(++i) : "_orb";
                        break;
                    }
                    if (str.equalsIgnoreCase("MAP")) {
                        surfaceObjectSeen = true;
                        propertyName = "map";
                        break;
                    }
                    if (str.equalsIgnoreCase("plane")) {
                        planeSeen = true;
                        propertyName = "plane";
                        propertyValue = this.planeParameter(++i);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("hkl")) {
                        planeSeen = true;
                        propertyName = "plane";
                        propertyValue = this.hklParameter(++i);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("sphere")) {
                        surfaceObjectSeen = true;
                        propertyName = "sphere";
                        propertyValue = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (str.equalsIgnoreCase("ellipsoid")) {
                        surfaceObjectSeen = true;
                        propertyName = "ellipsoid";
                        propertyValue = this.getPoint4f(i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("lobe")) {
                        surfaceObjectSeen = true;
                        propertyName = "lobe";
                        propertyValue = this.getPoint4f(i + 1);
                        i = this.pcLastExpressionInstruction;
                        break;
                    }
                    if (str.equalsIgnoreCase("AtomicOrbital") || str.equalsIgnoreCase("orbital")) {
                        surfaceObjectSeen = true;
                        nlmZ[0] = this.intParameter(++i);
                        nlmZ[1] = this.intParameter(++i);
                        nlmZ[2] = this.intParameter(++i);
                        nlmZ[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                        propertyName = "hydrogenOrbital";
                        propertyValue = nlmZ;
                        break;
                    }
                    if (str.equalsIgnoreCase("functionXY")) {
                        surfaceObjectSeen = true;
                        Vector<Object> v = new Vector<Object>();
                        if (++i == this.statementLength) {
                            this.badArgumentCount();
                        }
                        if (this.statement[i].tok != 4) {
                            this.invalidArgument(i, "function name in quotation marks expected");
                        }
                        v.add(this.statement[i++].value);
                        v.add(this.getCoordinate(i, false));
                        v.add(this.getPoint4f(this.pcLastExpressionInstruction + 1));
                        v.add(this.getPoint4f(this.pcLastExpressionInstruction + 1));
                        v.add(this.getPoint4f(this.pcLastExpressionInstruction + 1));
                        i = this.pcLastExpressionInstruction;
                        propertyName = "functionXY";
                        propertyValue = v;
                        break;
                    }
                    if (str.equalsIgnoreCase("molecular")) {
                        surfaceObjectSeen = true;
                        propertyName = "molecular";
                        propertyValue = new Float(1.4);
                        break;
                    }
                    propertyValue = token.value;
                }
                case 36875: {
                    propertyName = "thisID";
                    break;
                }
                case 524644: {
                    surfaceObjectSeen = true;
                    String lcaoType = this.stringParameter(++i);
                    this.viewer.setShapeProperty(27, "lcaoType", lcaoType);
                    switch (this.statement[++i].tok) {
                        case 32868: {
                            propertyName = "lcaoCartoon";
                            int atomIndex = this.viewer.firstAtomOf(this.expression(this.statement, ++i));
                            if (atomIndex < 0) {
                                this.expressionExpected();
                            }
                            this.viewer.setShapeProperty(27, "modelIndex", new Integer(this.viewer.getAtomModelIndex(atomIndex)));
                            Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.viewer.getAtomPoint3f(atomIndex))};
                            this.viewer.getPrincipalAxes(atomIndex, axes[0], axes[1], lcaoType, false);
                            i = this.pcLastExpressionInstruction;
                            propertyValue = axes;
                            break block1;
                        }
                    }
                    this.expressionExpected();
                    break;
                }
                case 2625891: {
                    if (++i == this.statementLength) {
                        this.badArgumentCount();
                    }
                    int moNumber = this.intParameter(i);
                    this.setMoData(27, moNumber, null);
                    surfaceObjectSeen = true;
                    continue block31;
                }
                case 2072: {
                    float[] partialCharges = null;
                    try {
                        partialCharges = this.viewer.getFrame().partialCharges;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (partialCharges == null) {
                        this.evalError(GT._("No partial charges were read from the file; Jmol needs these to render the MEP data."));
                    }
                    surfaceObjectSeen = true;
                    propertyName = "mep";
                    propertyValue = partialCharges;
                    break;
                }
                case 16448: 
                case 296964: {
                    surfaceObjectSeen = true;
                    propertyName = token.tok == 16448 ? "sasurface" : "solvent";
                    float radius = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    propertyValue = new Float(radius);
                    break;
                }
                case 4: {
                    Object t;
                    propertyName = surfaceObjectSeen || planeSeen ? "mapColor" : "getSurface";
                    String filename = (String)token.value;
                    if (filename.length() == 0) {
                        if (surfaceObjectSeen || planeSeen) {
                            propertyValue = this.viewer.getModelAuxiliaryInfo(modelIndex, "jmolMappedDataInfo");
                        }
                        if (propertyValue == null) {
                            propertyValue = this.viewer.getModelAuxiliaryInfo(modelIndex, "jmolSurfaceInfo");
                        }
                        surfaceObjectSeen = true;
                        if (propertyValue != null) break;
                        filename = this.viewer.getFullPathName();
                    }
                    surfaceObjectSeen = true;
                    if (i + 1 < this.statementLength && this.statement[i + 1].tok == 2) {
                        this.viewer.setShapeProperty(27, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    if ((t = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(filename)) instanceof String) {
                        this.fileNotFoundException(filename + ":" + t);
                    }
                    Logger.info("reading isosurface data from " + filename);
                    propertyValue = t;
                    break;
                }
                default: {
                    if (this.setMeshDisplayProperty(27, token.tok)) break;
                    this.invalidArgument(i, this.statement[i] + " not recognized");
                }
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(27, propertyName, propertyValue);
        }
        if (planeSeen && !surfaceObjectSeen) {
            this.viewer.setShapeProperty(27, "nomap", new Float(0.0f));
        }
    }

    boolean setMeshDisplayProperty(int shape, int tok) {
        String propertyName = null;
        Object propertyValue = null;
        switch (tok) {
            case 8193: {
                propertyName = "on";
                break;
            }
            case 8192: {
                propertyName = "off";
                break;
            }
            case 16426: {
                propertyName = "delete";
                break;
            }
            case 8458: {
                propertyValue = Boolean.TRUE;
            }
            case 16433: {
                propertyName = "dots";
                break;
            }
            case 16434: {
                propertyValue = Boolean.TRUE;
            }
            case 16435: {
                propertyName = "mesh";
                break;
            }
            case 16436: {
                propertyValue = Boolean.TRUE;
            }
            case 16437: {
                propertyName = "fill";
                break;
            }
            case 16425: {
                propertyName = "translucency";
                propertyValue = "translucent";
                break;
            }
            case 16424: {
                propertyName = "translucency";
                propertyValue = "opaque";
            }
        }
        if (propertyName == null) {
            return false;
        }
        this.viewer.setShapeProperty(shape, propertyName, propertyValue);
        return true;
    }

    void evalError(String message) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        String s = this.viewer.removeCommand();
        this.viewer.addCommand(s + "#??");
        throw new ScriptException(message, this.getLine(), this.filename, this.getLinenumber());
    }

    void unrecognizedCommand(Token token) throws ScriptException {
        this.evalError(GT._("unrecognized command") + ": " + token.value);
    }

    void unrecognizedAtomProperty(int propnum) throws ScriptException {
        this.evalError(GT._("unrecognized atom property") + ": " + propnum);
    }

    void filenameExpected() throws ScriptException {
        this.evalError(GT._("filename expected"));
    }

    void booleanExpected() throws ScriptException {
        this.evalError(GT._("boolean expected"));
    }

    void booleanOrPercentExpected() throws ScriptException {
        this.evalError(GT._("boolean or percent expected"));
    }

    void booleanOrNumberExpected() throws ScriptException {
        this.evalError(GT._("boolean or number expected"));
    }

    void booleanOrNumberExpected(String orWhat) throws ScriptException {
        this.evalError(GT._("boolean, number, or {0} expected", "\"" + orWhat + "\""));
    }

    void expressionOrDecimalExpected() throws ScriptException {
        this.evalError(GT._("(atom expression) or decimal number expected"));
    }

    void expressionOrIntegerExpected() throws ScriptException {
        this.evalError(GT._("(atom expression) or integer expected"));
    }

    void expressionExpected() throws ScriptException {
        this.evalError(GT._("valid (atom expression) expected"));
    }

    void rotationPointsIdentical() throws ScriptException {
        this.evalError(GT._("rotation points cannot be identical"));
    }

    void integerExpected() throws ScriptException {
        this.evalError(GT._("integer expected"));
    }

    void numberExpected() throws ScriptException {
        this.evalError(GT._("number expected"));
    }

    void stringExpected() throws ScriptException {
        this.evalError(GT._("quoted string expected"));
    }

    void stringOrIdentifierExpected() throws ScriptException {
        this.evalError(GT._("quoted string or identifier expected"));
    }

    void propertyNameExpected() throws ScriptException {
        this.evalError(GT._("property name expected"));
    }

    void axisExpected() throws ScriptException {
        this.evalError(GT._("x y z axis expected"));
    }

    void colorExpected() throws ScriptException {
        this.evalError(GT._("color expected"));
    }

    void keywordExpected() throws ScriptException {
        this.evalError(GT._("keyword expected"));
    }

    void unrecognizedObject() throws ScriptException {
        this.evalError(GT._("unrecognized object"));
    }

    void unrecognizedExpression() throws ScriptException {
        this.evalError(GT._("runtime unrecognized expression"));
    }

    void undefinedVariable(String varName) throws ScriptException {
        this.evalError(GT._("variable undefined") + ": " + varName);
    }

    void endOfStatementUnexpected() throws ScriptException {
        this.evalError(GT._("unexpected end of script command"));
    }

    void badArgumentCount() throws ScriptException {
        this.evalError(GT._("bad argument count"));
    }

    void invalidArgument() throws ScriptException {
        String str = "";
        for (int i = 0; i < this.statementLength; ++i) {
            str = str + "\n" + this.statement[i].toString();
        }
        this.evalError(GT._("invalid argument") + str);
    }

    void invalidArgument(int ipt, String info) throws ScriptException {
        String str = "";
        for (int i = 0; i <= ipt; ++i) {
            str = str + "\n" + this.statement[i].toString();
        }
        this.evalError(GT._("invalid argument") + " - " + info + str);
    }

    void unrecognizedSetParameter() throws ScriptException {
        this.evalError(GT._("unrecognized {0} parameter", "SET"));
    }

    void unrecognizedSubcommand(String cmd) throws ScriptException {
        this.evalError(GT._("unrecognized subcommand") + ": " + cmd);
    }

    void subcommandExpected() throws ScriptException {
        this.evalError(GT._("subcommand expected"));
    }

    void setspecialShouldNotBeHere() throws ScriptException {
        this.evalError(GT._("interpreter error - setspecial should not be here"));
    }

    void numberOutOfRange() throws ScriptException {
        this.evalError(GT._("number out of range"));
    }

    void numberOutOfRange(int min, int max) throws ScriptException {
        this.evalError(GT._("integer out of range ({0} - {1})", new Object[]{new Integer(min), new Integer(max)}));
    }

    void numberOutOfRange(float min, float max) throws ScriptException {
        this.evalError(GT._("decimal number out of range ({0} - {1})", new Object[]{new Float(min), new Float(max)}));
    }

    void numberMustBe(int a, int b) throws ScriptException {
        this.evalError(GT._("number must be ({0} or {1})", new Object[]{new Integer(a), new Integer(b)}));
    }

    void badAtomNumber() throws ScriptException {
        this.evalError(GT._("bad atom number"));
    }

    void errorLoadingScript(String msg) throws ScriptException {
        this.evalError(GT._("error loading script") + " -> " + msg);
    }

    void fileNotFoundException(String filename) throws ScriptException {
        this.evalError(GT._("file not found") + ": " + filename);
    }

    void drawObjectNotDefined(String drawID) throws ScriptException {
        this.evalError(GT._("draw object not defined") + ": " + drawID);
    }

    void objectNameExpected() throws ScriptException {
        this.evalError(GT._("object name expected after '$'"));
    }

    void coordinateExpected() throws ScriptException {
        this.evalError(GT._("{ number number number } expected"));
    }

    void coordinateOrNameOrExpressionRequired() throws ScriptException {
        this.evalError(GT._(" {x y z} or $name or (atom expression) required"));
    }

    void tooManyRotationPoints() throws ScriptException {
        this.evalError(GT._("too many rotation points were specified"));
    }

    void keywordExpected(String what) throws ScriptException {
        this.evalError(GT._("keyword expected") + ": " + what);
    }

    void notImplemented(int itoken) {
        this.notImplemented(this.statement[itoken]);
    }

    void notImplemented(Token token) {
        this.viewer.scriptStatus("script ERROR: " + token.value + " not implemented in command:" + this.statement[0].value);
    }

    void invalidParameterOrder() throws ScriptException {
        this.evalError(GT._("invalid parameter order"));
    }

    void incompatibleArguments() throws ScriptException {
        this.evalError(GT._("incompatible arguments"));
    }

    void insufficientArguments() throws ScriptException {
        this.evalError(GT._("insufficient arguments"));
    }

    class ScriptException
    extends Exception {
        String message;
        String line;
        String fileName;
        int linenumber;

        ScriptException(String message, String line, String filename, int linenumber) {
            this.message = message;
            this.line = line;
            this.fileName = filename;
            this.linenumber = linenumber;
            Logger.error(this.toString());
        }

        public String toString() {
            String str = "ScriptException:" + this.message;
            if (this.line != null) {
                str = str + "\n    Script line:" + this.line;
            }
            if (this.fileName != null) {
                str = str + "\n           File:" + this.fileName + " Line number:" + this.linenumber;
            }
            return str;
        }
    }
}

