/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.util.Logger;

public final class JmolConstants {
    public static final String copyright = "(C) 2006 Jmol Development";
    public static final String version = "10.9.98";
    public static final String cvsDate = "$Date: 2006-11-13 18:23:40 +0100 (lun., 13 nov. 2006) $";
    public static final String date;
    public static final boolean officialRelease = false;
    public static final String DEFAULT_HELP_PATH = "http://www.stolaf.edu/academics/chemapps/jmol/docs/index.htm?search=";
    public static final int DEFAULT_PERCENT_VDW_ATOM = 20;
    public static final float DEFAULT_BOND_RADIUS = 0.15f;
    public static final short DEFAULT_BOND_MILLIANGSTROM_RADIUS = 150;
    public static final float DEFAULT_BOND_TOLERANCE = 0.45f;
    public static final float DEFAULT_MIN_BOND_DISTANCE = 0.4f;
    public static final int DELETE_BONDS = 0;
    public static final int MODIFY_ONLY = 1;
    public static final int CREATE_ONLY = 2;
    public static final int MODIFY_OR_CREATE = 3;
    public static final int AUTO_BOND = 4;
    public static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    public static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;
    private static final String[] connectOperationStrings;
    public static final short MAR_DELETED = Short.MIN_VALUE;
    public static final int MOUSE_NONE = -1;
    public static final int MOUSE_ROTATE = 0;
    public static final int MOUSE_ZOOM = 1;
    public static final int MOUSE_XLATE = 2;
    public static final int MOUSE_PICK = 3;
    public static final int MOUSE_DELETE = 4;
    public static final int MOUSE_MEASURE = 5;
    public static final int MOUSE_ROTATE_Z = 6;
    public static final int MOUSE_SLAB_PLANE = 7;
    public static final int MOUSE_POPUP_MENU = 8;
    public static final byte MULTIBOND_NEVER = 0;
    public static final byte MULTIBOND_WIREFRAME = 1;
    public static final byte MULTIBOND_NOTSMALL = 2;
    public static final byte MULTIBOND_ALWAYS = 3;
    public static final short madMultipleBondSmallMaximum = 500;
    public static final int AXES_MODE_BOUNDBOX = 0;
    public static final int AXES_MODE_MOLECULAR = 1;
    public static final int AXES_MODE_UNITCELL = 2;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENT = 1;
    public static final int PICKING_LABEL = 2;
    public static final int PICKING_CENTER = 3;
    public static final int PICKING_DRAW = 4;
    public static final int PICKING_SPIN = 5;
    public static final int PICKING_SELECT_ATOM = 8;
    public static final int PICKING_SELECT_GROUP = 9;
    public static final int PICKING_SELECT_CHAIN = 10;
    public static final int PICKING_SELECT_MOLECULE = 11;
    public static final int PICKING_SELECT_SITE = 12;
    public static final int PICKING_SELECT_ELEMENT = 13;
    public static final int PICKING_MEASURE = 14;
    public static final int PICKING_MEASURE_DISTANCE = 15;
    public static final int PICKING_MEASURE_ANGLE = 16;
    public static final int PICKING_MEASURE_TORSION = 17;
    private static final String[] pickingModeNames;
    public static final int PICKINGSTYLE_SELECT_JMOL = 0;
    public static final int PICKINGSTYLE_SELECT_CHIME = 0;
    public static final int PICKINGSTYLE_SELECT_RASMOL = 1;
    public static final int PICKINGSTYLE_SELECT_PFAAT = 2;
    public static final int PICKINGSTYLE_MEASURE_ON = 3;
    public static final int PICKINGSTYLE_MEASURE_OFF = 4;
    private static final String[] pickingStyleNames;
    public static final short BOND_ORDER_NULL = -1;
    public static final short BOND_COVALENT_SINGLE = 1;
    public static final short BOND_COVALENT_DOUBLE = 2;
    public static final short BOND_COVALENT_TRIPLE = 3;
    public static final short BOND_COVALENT_MASK = 3;
    public static final short BOND_AROMATIC_MASK = 4;
    public static final short BOND_AROMATIC = 5;
    public static final short BOND_STEREO_MASK = 24;
    public static final short BOND_STEREO_NEAR = 9;
    public static final short BOND_STEREO_FAR = 18;
    public static final short BOND_SULFUR_MASK = 32;
    public static final short BOND_HBOND_SHIFT = 6;
    public static final short BOND_HYDROGEN_MASK = 960;
    public static final short BOND_H_REGULAR = 64;
    public static final short BOND_H_PLUS_2 = 128;
    public static final short BOND_H_PLUS_3 = 192;
    public static final short BOND_H_PLUS_4 = 256;
    public static final short BOND_H_PLUS_5 = 320;
    public static final short BOND_H_MINUS_3 = 384;
    public static final short BOND_H_MINUS_4 = 448;
    public static final short BOND_H_NUCLEOTIDE = 512;
    public static final short BOND_PARTIAL01 = 1025;
    public static final short BOND_PARTIAL12 = 2050;
    public static final short BOND_PARTIAL_MASK = 3072;
    public static final short BOND_ALL_MASK = -1;
    static final String[] bondOrderNames;
    static final short[] bondOrderValues;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public static final int[] argbsHbondType;
    private static final String[] elementSymbols;
    public static final int elementNumberMax;
    private static Hashtable htElementMap;
    private static final String[] elementNames;
    private static final String naturalIsotopes = "1H,12C,14N,";
    private static final short[] altElementNumbers;
    private static final String[] altElementSymbols;
    private static final String[] altElementNames;
    public static final int[] altArgbsCpk;
    public static final int firstIsotope = 4;
    public static final int altElementMax;
    public static final short[] vanderwaalsMars;
    private static final short[] covalentMars;
    public static final int FORMAL_CHARGE_MIN = -4;
    public static final int FORMAL_CHARGE_MAX = 7;
    private static final short[] cationLookupTable;
    private static final short[] anionLookupTable;
    static BitSet bsCations;
    static BitSet bsAnions;
    public static final int MAXIMUM_AUTO_BOND_COUNT = 20;
    private static final String[] paletteNames;
    public static final int PALETTE_NONE = 0;
    public static final int PALETTE_CPK = 1;
    public static final int PALETTE_PARTIAL_CHARGE = 2;
    public static final int PALETTE_FORMAL_CHARGE = 3;
    public static final int PALETTE_TEMP = 4;
    public static final int PALETTE_FIXEDTEMP = 5;
    public static final int PALETTE_SURFACE = 6;
    public static final int PALETTE_STRUCTURE = 7;
    public static final int PALETTE_AMINO = 8;
    public static final int PALETTE_SHAPELY = 9;
    public static final int PALETTE_CHAIN = 10;
    public static final int PALETTE_GROUP = 11;
    public static final int PALETTE_MONOMER = 12;
    public static final int PALETTE_MOLECULE = 13;
    public static final int PALETTE_ALTLOC = 14;
    public static final int PALETTE_INSERTION = 15;
    public static final int PALETTE_JMOL = 16;
    public static final int PALETTE_RASMOL = 17;
    public static final int PALETTE_TYPE = 18;
    private static final int paletteCount;
    public static final int[] argbsCpk;
    public static final int[] argbsCpkRasmol;
    public static final byte PROTEIN_STRUCTURE_NONE = 0;
    public static final byte PROTEIN_STRUCTURE_TURN = 1;
    public static final byte PROTEIN_STRUCTURE_SHEET = 2;
    public static final byte PROTEIN_STRUCTURE_HELIX = 3;
    public static final byte PROTEIN_STRUCTURE_DNA = 4;
    public static final byte PROTEIN_STRUCTURE_RNA = 5;
    public static final int[] argbsStructure;
    public static final int[] argbsAmino;
    public static final int argbShapelyBackbone = -4671304;
    public static final int argbShapelySpecial = -10616738;
    public static final int argbShapelyDefault = -65281;
    public static final int[] argbsShapely;
    public static final int[] argbsChainAtom;
    public static final int[] argbsChainHetero;
    public static final short FORMAL_CHARGE_COLIX_RED;
    public static final short FORMAL_CHARGE_COLIX_WHITE;
    public static final short FORMAL_CHARGE_COLIX_BLUE;
    public static final int FORMAL_CHARGE_RANGE_SIZE = 12;
    public static final int[] argbsFormalCharge;
    public static final int FORMAL_CHARGE_INDEX_WHITE = 4;
    public static final int FORMAL_CHARGE_INDEX_MAX;
    public static final short PARTIAL_CHARGE_COLIX_RED;
    public static final short PARTIAL_CHARGE_COLIX_WHITE;
    public static final short PARTIAL_CHARGE_COLIX_BLUE;
    public static final int PARTIAL_CHARGE_RANGE_SIZE = 31;
    public static final int[] argbsRwbScale;
    public static final int[] argbsRoygbScale;
    public static final int[] argbsIsosurfacePositive;
    public static final int[] argbsIsosurfaceNegative;
    public static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    private static final String allCarbohydrates = ",[AFL],[AGC],[AHR],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLB],[GLC],[GUP],[LXC],[MAN],[RAA],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[ASF],[GCU],[MTL],[NAG],[NAM],[RHA],[SOR],[XYL]";
    public static final byte ATOMID_AMINO_NITROGEN = 1;
    public static final byte ATOMID_ALPHA_CARBON = 2;
    public static final byte ATOMID_CARBONYL_CARBON = 3;
    public static final byte ATOMID_O5_PRIME = 5;
    public static final byte ATOMID_C5_PRIME = 6;
    public static final byte ATOMID_C3_PRIME = 8;
    public static final byte ATOMID_O3_PRIME = 9;
    public static final byte ATOMID_NUCLEIC_PHOSPHORUS = 12;
    public static final byte ATOMID_TERMINATING_OXT = 32;
    public static final byte ATOMID_CARBONYL_OXYGEN = 40;
    public static final byte ATOMID_O1 = 41;
    public static final byte ATOMID_H5T_TERMINUS = 45;
    public static final byte ATOMID_O5T_TERMINUS = 46;
    public static final byte ATOMID_RNA_O2PRIME = 50;
    public static final byte ATOMID_H3T_TERMINUS = 59;
    public static final byte ATOMID_N1 = 64;
    public static final byte ATOMID_C2 = 65;
    public static final byte ATOMID_N3 = 66;
    public static final byte ATOMID_C4 = 67;
    public static final byte ATOMID_C5 = 68;
    public static final byte ATOMID_C6 = 69;
    public static final byte ATOMID_O2 = 70;
    public static final byte ATOMID_N7 = 71;
    public static final byte ATOMID_C8 = 72;
    public static final byte ATOMID_N9 = 73;
    public static final byte ATOMID_N4 = 74;
    public static final byte ATOMID_N2 = 75;
    public static final byte ATOMID_N6 = 76;
    public static final byte ATOMID_C5M = 77;
    public static final byte ATOMID_O6 = 78;
    public static final byte ATOMID_O4 = 79;
    public static final byte ATOMID_S4 = 80;
    public static final byte ATOMID_NUCLEIC_WING = 69;
    public static final int ATOMID_PROTEIN_MASK = 14;
    public static final int ATOMID_ALPHA_ONLY_MASK = 4;
    public static final int ATOMID_NUCLEIC_MASK = 4064;
    public static final int ATOMID_PHOSPHORUS_ONLY_MASK = 4096;
    public static final int ATOMID_DISTINGUISHING_ATOM_MAX = 32;
    public static final int ATOMID_BACKBONE_MAX = 64;
    public static final int GROUPID_PROLINE = 15;
    public static final int GROUPID_PURINE_MIN = 24;
    public static final int GROUPID_PURINE_LAST = 29;
    public static final int GROUPID_PYRIMIDINE_MIN = 30;
    public static final int GROUPID_PYRIMIDINE_LAST = 35;
    public static final int GROUPID_GUANINE = 26;
    public static final int GROUPID_PLUS_GUANINE = 27;
    public static final int GROUPID_GUANINE_1_MIN = 40;
    public static final int GROUPID_GUANINE_1_LAST = 46;
    public static final int GROUPID_GUANINE_2_MIN = 55;
    public static final int GROUPID_GUANINE_2_LAST = 57;
    public static final short GROUPID_AMINO_MAX = 23;
    public static final short GROUPID_SHAPELY_MAX = 36;
    public static final String[] predefinedGroup3Names;
    public static final String group3List;
    public static final int group3Count;
    public static final String[] predefinedGroup1Names;
    public static String[] predefinedSets;
    public static final String DEFAULT_FONTFACE = "SansSerif";
    public static final String DEFAULT_FONTSTYLE = "Plain";
    public static final int LABEL_MINIMUM_FONTSIZE = 6;
    public static final int LABEL_MAXIMUM_FONTSIZE = 63;
    public static final int LABEL_DEFAULT_FONTSIZE = 13;
    public static final int LABEL_DEFAULT_X_OFFSET = 4;
    public static final int LABEL_DEFAULT_Y_OFFSET = 4;
    public static final int MEASURE_DEFAULT_FONTSIZE = 15;
    public static final int AXES_DEFAULT_FONTSIZE = 14;
    public static final int SHAPE_BALLS = 0;
    public static final int SHAPE_STICKS = 1;
    public static final int SHAPE_HSTICKS = 2;
    public static final int SHAPE_SSSTICKS = 3;
    public static final int SHAPE_LABELS = 4;
    public static final int SHAPE_VECTORS = 5;
    public static final int SHAPE_MEASURES = 6;
    public static final int SHAPE_DOTS = 7;
    public static final int SHAPE_MIN_SECONDARY = 8;
    public static final int SHAPE_BACKBONE = 8;
    public static final int SHAPE_TRACE = 9;
    public static final int SHAPE_CARTOON = 10;
    public static final int SHAPE_STRANDS = 11;
    public static final int SHAPE_MESHRIBBON = 12;
    public static final int SHAPE_RIBBONS = 13;
    public static final int SHAPE_ROCKETS = 14;
    public static final int SHAPE_MAX_SECONDARY = 15;
    public static final int SHAPE_STARS = 15;
    public static final int SHAPE_HALOS = 16;
    public static final int SHAPE_MIN_SELECTION_INDEPENDENT = 17;
    public static final int SHAPE_AXES = 17;
    public static final int SHAPE_BBCAGE = 18;
    public static final int SHAPE_UCCAGE = 19;
    public static final int SHAPE_FRANK = 20;
    public static final int SHAPE_ECHO = 21;
    public static final int SHAPE_HOVER = 22;
    public static final int SHAPE_POLYHEDRA = 23;
    public static final int SHAPE_MIN_NAMED_OBJECT = 24;
    public static final int SHAPE_DIPOLES = 24;
    public static final int SHAPE_MIN_MESH_COLLECTION = 25;
    public static final int SHAPE_PMESH = 25;
    public static final int SHAPE_MO = 26;
    public static final int SHAPE_ISOSURFACE = 27;
    public static final int SHAPE_LCAOCARTOON = 28;
    public static final int SHAPE_DRAW = 29;
    public static final int SHAPE_MAX = 30;
    public static final int ATOM_IN_MODEL = 1;
    public static final int ATOM_SLABBED = 2;
    public static final String[] shapeClassBases;
    public static final int[] shapeToks;
    public static final int STEREO_NONE = 0;
    public static final int STEREO_DOUBLE = 1;
    public static final int STEREO_REDCYAN = 2;
    public static final int STEREO_REDBLUE = 3;
    public static final int STEREO_REDGREEN = 4;
    public static final int STEREO_CUSTOM = 5;

    public static int connectOperationFromString(String connectOperationString) {
        int i = connectOperationStrings.length;
        while (--i >= 0 && !connectOperationStrings[i].equalsIgnoreCase(connectOperationString)) {
        }
        return i;
    }

    public static String connectOperationName(int i) {
        return connectOperationStrings[i];
    }

    public static final String getPickingModeName(int pickingMode) {
        return pickingMode < 0 || pickingMode >= pickingModeNames.length ? "off" : pickingModeNames[pickingMode];
    }

    public static final int GetPickingMode(String str) {
        int i = pickingModeNames.length;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(pickingModeNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static final String getPickingStyleName(int pickingStyle) {
        return pickingStyle < 0 || pickingStyle >= pickingStyleNames.length ? "toggle" : pickingModeNames[pickingStyle];
    }

    public static final int GetPickingStyle(String str) {
        int i = pickingStyleNames.length;
        while (--i >= 0) {
            if (!str.equalsIgnoreCase(pickingStyleNames[i])) continue;
            return i;
        }
        return -1;
    }

    public static final short getBondOrderFromString(String bondOrderString) {
        int i = bondOrderNames.length;
        while (--i >= 0) {
            if (!bondOrderNames[i].equalsIgnoreCase(bondOrderString)) continue;
            return bondOrderValues[i];
        }
        return -1;
    }

    public static final String getBondOrderNameFromOrder(short order) {
        if (order == -1) {
            return "";
        }
        if ((order & 0x3C0) != 0) {
            return "hbond";
        }
        if ((order & 0x20) != 0) {
            return "single";
        }
        int i = bondOrderValues.length;
        while (--i >= 0) {
            if (bondOrderValues[i] != order) continue;
            return bondOrderNames[i];
        }
        return "?";
    }

    public static final short elementNumberFromSymbol(String elementSymbol) {
        if (htElementMap == null) {
            Integer boxed;
            String symbol;
            Hashtable<String, Integer> map = new Hashtable<String, Integer>();
            int elementNumber = elementNumberMax;
            while (--elementNumber >= 0) {
                symbol = elementSymbols[elementNumber];
                boxed = new Integer(elementNumber);
                map.put(symbol, boxed);
                if (symbol.length() != 2) continue;
                map.put(symbol.toUpperCase(), boxed);
            }
            int i = altElementMax;
            while (--i >= 4) {
                symbol = altElementSymbols[i];
                boxed = new Integer(altElementNumbers[i]);
                map.put(symbol, boxed);
                if (symbol.length() != 2) continue;
                map.put(symbol.toUpperCase(), boxed);
            }
            htElementMap = map;
        }
        if (elementSymbol == null) {
            return 0;
        }
        Integer boxedAtomicNumber = (Integer)htElementMap.get(elementSymbol);
        if (boxedAtomicNumber != null) {
            return (short)boxedAtomicNumber.intValue();
        }
        Logger.error("" + elementSymbol + "' is not a recognized symbol");
        return 0;
    }

    public static final String elementSymbolFromNumber(int elementNumber) {
        if (elementNumber >= elementNumberMax) {
            int j = altElementMax;
            while (--j >= 0) {
                if (elementNumber != altElementNumbers[j]) continue;
                return altElementSymbols[j];
            }
            elementNumber %= 128;
        }
        if (elementNumber < 0 || elementNumber >= elementNumberMax) {
            elementNumber = 0;
        }
        return elementSymbols[elementNumber];
    }

    public static final String elementNameFromNumber(int elementNumber) {
        if (elementNumber >= elementNumberMax) {
            int j = altElementMax;
            while (--j >= 0) {
                if (elementNumber != altElementNumbers[j]) continue;
                return altElementNames[j];
            }
            elementNumber %= 128;
        }
        if (elementNumber < 0 || elementNumber >= elementNumberMax) {
            elementNumber = 0;
        }
        return elementNames[elementNumber];
    }

    public static final String altElementNameFromIndex(int i) {
        return altElementNames[i];
    }

    public static final short altElementNumberFromIndex(int i) {
        return altElementNumbers[i];
    }

    public static final String altElementSymbolFromIndex(int i) {
        return altElementSymbols[i];
    }

    public static final String altIsotopeSymbolFromIndex(int i) {
        short code = altElementNumbers[i];
        return (code >> 8) + JmolConstants.elementSymbolFromNumber(code);
    }

    public static final int altElementIndexFromNumber(int atomicAndIsotopeNumber) {
        for (int i = 0; i < altElementMax; ++i) {
            if (altElementNumbers[i] != atomicAndIsotopeNumber) continue;
            return i;
        }
        return 0;
    }

    public static final boolean isNaturalIsotope(String isotopeSymbol) {
        return naturalIsotopes.indexOf(isotopeSymbol + ",") >= 0;
    }

    public static short getBondingMar(int atomicNumber, int charge) {
        if (charge > 0 && bsCations.get(atomicNumber)) {
            return JmolConstants.getBondingMar(atomicNumber, charge, cationLookupTable);
        }
        if (charge < 0 && bsAnions.get(atomicNumber)) {
            return JmolConstants.getBondingMar(atomicNumber, charge, anionLookupTable);
        }
        return covalentMars[atomicNumber];
    }

    public static short getBondingMar(int atomicNumber, int charge, short[] table) {
        short ionic = (short)((atomicNumber << 4) + (charge + 4));
        short iVal = 0;
        int iMid = 0;
        int iMin = 0;
        int iMax = table.length / 2;
        while (iMin != iMax) {
            iMid = (iMin + iMax) / 2;
            iVal = table[iMid << 1];
            if (iVal > ionic) {
                iMax = iMid;
                continue;
            }
            if (iVal < ionic) {
                iMin = iMid + 1;
                continue;
            }
            return table[(iMid << 1) + 1];
        }
        if (iVal > ionic) {
            --iMid;
        }
        if (atomicNumber != (iVal = table[iMid << 1]) >> 4) {
            ++iMid;
        }
        return table[(iMid << 1) + 1];
    }

    public static final int getPaletteID(String paletteName) {
        for (int i = 0; i < paletteCount; ++i) {
            if (!paletteNames[i].equalsIgnoreCase(paletteName)) continue;
            return i;
        }
        return -1;
    }

    public static final String getPaletteName(int pid) {
        return pid < 0 || pid >= paletteNames.length ? null : paletteNames[pid];
    }

    public static final boolean checkCarbohydrate(String group3) {
        if (group3 == null) {
            return false;
        }
        String str = "[" + group3.toUpperCase() + "]";
        return allCarbohydrates.indexOf(str) >= 0;
    }

    static String getGroup3List() {
        StringBuffer s = new StringBuffer();
        for (int i = 1; i < 24; ++i) {
            s.append(",[" + (predefinedGroup3Names[i] + "   ").substring(0, 3) + "]");
        }
        s.append(",[G  ],[C  ],[A  ],[T  ],[I  ],[U  ],[+G ],[+C ],[+A ],[+T ],[+I ],[+U ]");
        s.append(allCarbohydrates);
        return "" + s;
    }

    public static final boolean isHetero(String group3) {
        int pt = group3List.indexOf("[" + (group3 + "   ").substring(0, 3) + "]");
        return pt < 0 || pt / 6 > 35;
    }

    static final int getShapeVisibilityFlag(int shapeID) {
        return 4 << shapeID;
    }

    static final int shapeTokenIndex(int tok) {
        int i = shapeToks.length;
        while (--i >= 0) {
            if (tok != shapeToks[i]) continue;
            return i;
        }
        return -1;
    }

    static {
        int i;
        date = cvsDate.substring(7, 23);
        connectOperationStrings = new String[]{"delete", "modify", "create", "modifyOrCreate", "auto"};
        pickingModeNames = new String[]{"off", "ident", "label", "center", "draw", "spin", "coord NOT IMPLEMENTED", "bond NOT IMPLEMENTED", "atom", "group", "chain", "molecule", "site", "element", "measure", "distance", "angle", "torsion"};
        pickingStyleNames = new String[]{"toggle", "selectOrToggle", "extendedSelect", "measure", "measureoff"};
        bondOrderNames = new String[]{"single", "double", "triple", "aromatic", "hbond", "partial", "partialDouble"};
        bondOrderValues = new short[]{1, 2, 3, 5, 64, 1025, 2050};
        argbsHbondType = new int[]{-38476, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
        elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
        elementNumberMax = elementSymbols.length;
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        altElementNumbers = new short[]{0, 13, 16, 55, 257, 385, 1670, 1798, 1927};
        altElementSymbols = new String[]{"Xx", "Al", "S", "Cs", "D", "T", "13C", "14C", "15N"};
        altElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", ""};
        altArgbsCpk = new int[]{-60269, -4217178, -208, -11069553, -64, -96, -11513776, -12566464, -15708080};
        altElementMax = altElementNumbers.length;
        vanderwaalsMars = new short[]{1000, 1200, 1400, 1820, 1700, 2080, 1950, 1850, 1700, 1730, 1540, 2270, 1730, 2050, 2100, 2080, 2000, 1970, 1880, 2750, 1973, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1400, 1390, 1870, 1700, 1850, 1900, 2100, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1720, 1580, 1930, 2170, 2200, 2060, 2150, 2160, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1720, 1660, 1550, 1960, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1860, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700};
        covalentMars = new short[]{0, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600};
        cationLookupTable = new short[]{53, 680, 69, 440, 70, 350, 85, 350, 87, 230, 104, 160, 117, 250, 119, 160, 121, 130, 133, 220, 138, 90, 155, 80, 165, 1120, 181, 970, 197, 820, 198, 660, 215, 510, 229, 650, 232, 420, 247, 440, 249, 350, 262, 2190, 264, 370, 266, 300, 281, 340, 283, 270, 293, 1540, 309, 1330, 325, 1180, 326, 990, 343, 732, 357, 960, 358, 940, 359, 760, 360, 680, 374, 880, 375, 740, 376, 630, 377, 590, 389, 810, 390, 890, 391, 630, 394, 520, 406, 800, 407, 660, 408, 600, 411, 460, 422, 740, 423, 640, 438, 720, 439, 630, 454, 690, 469, 960, 470, 720, 485, 880, 486, 740, 501, 810, 503, 620, 518, 730, 520, 530, 535, 580, 537, 460, 549, 660, 552, 500, 554, 420, 569, 470, 571, 390, 597, 1470, 614, 1120, 631, 893, 645, 1090, 648, 790, 661, 1000, 664, 740, 665, 690, 677, 930, 680, 700, 682, 620, 699, 979, 712, 670, 727, 680, 742, 800, 744, 650, 757, 1260, 758, 890, 773, 1140, 774, 970, 791, 810, 806, 930, 808, 710, 823, 760, 825, 620, 837, 820, 840, 700, 842, 560, 857, 620, 859, 500, 885, 1670, 901, 1530, 902, 1340, 917, 1390, 919, 1016, 933, 1270, 935, 1034, 936, 920, 951, 1013, 952, 900, 967, 995, 983, 979, 999, 964, 1014, 1090, 1015, 950, 1031, 938, 1047, 923, 1048, 840, 1063, 908, 1079, 894, 1095, 881, 1111, 870, 1126, 930, 1127, 858, 1143, 850, 1160, 780, 1177, 680, 1192, 700, 1194, 620, 1208, 720, 1211, 560, 1224, 880, 1226, 690, 1240, 680, 1254, 800, 1256, 650, 1269, 1370, 1271, 850, 1285, 1270, 1286, 1100, 1301, 1470, 1303, 950, 1318, 1200, 1320, 840, 1333, 980, 1335, 960, 1337, 740, 1354, 670, 1371, 620, 1397, 1800, 1414, 1430, 1431, 1180, 1448, 1020, 1463, 1130, 1464, 980, 1465, 890, 1480, 970, 1482, 800, 1495, 1100, 1496, 950, 1499, 710, 1511, 1080, 1512, 930, 1527, 1070, 1528, 920};
        anionLookupTable = new short[]{19, 1540, 96, 2600, 113, 1710, 130, 1320, 131, 1760, 147, 1330, 224, 2710, 227, 3840, 241, 2120, 258, 1840, 275, 1810, 512, 2720, 529, 2220, 546, 1910, 547, 2320, 563, 1960, 800, 2940, 803, 3700, 817, 2450, 834, 2110, 835, 2500, 851, 2200};
        bsCations = new BitSet();
        bsAnions = new BitSet();
        for (i = 0; i < anionLookupTable.length; i += 2) {
            bsAnions.set(anionLookupTable[i] >> 4);
        }
        for (i = 0; i < cationLookupTable.length; i += 2) {
            bsCations.set(cationLookupTable[i] >> 4);
        }
        paletteNames = new String[]{"none", "cpk", "partialCharge", "formalCharge", "temperature", "fixedTemperature", "surfaceDistance", "structure", "amino", "shapely", "chain", "group", "monomer", "molecule", "altloc", "insertion", "jmol", "rasmol", "type"};
        paletteCount = paletteNames.length;
        argbsCpk = new int[]{-60269, -1, -2490369, -3374849, -3997952, -19019, -7303024, -13610760, -62195, -7282608, -4987915, -5546766, -7667968, -4217178, -997216, Short.MIN_VALUE, -208, -14684129, -8334877, -7388972, -12714240, -1644826, -4209977, -5855573, -7693881, -6522169, -2070989, -1011552, -11481008, -3637197, -8552272, -4026481, -10055793, -4357917, -24320, -5887703, -10700591, -9425232, -16711936, -7012353, -7020320, -9190711, -11225675, -12869986, -14381169, -16089716, -16750203, -4144960, -9841, -5868173, -10059648, -6397003, -2852352, -7077740, -12411216, -11069553, -16725760, -9382657, -57, -2490425, -3670073, -6029369, -7340089, -10354745, -12189753, -13566009, -14680121, -16711780, -16718219, -16722862, -16728264, -16733404, -11681025, -11688193, -14576426, -14254677, -14260586, -15248249, -3092256, -11997, -4671280, -5876659, -11052703, -6402123, -5547008, -9089211, -12418410, -12451738, -16745216, -9393158, -16729345, -16735745, -16740353, -16744193, -16749569, -11248398, -8889117, -7712797, -6211884, -5038124, -5038150, -5042778, -4387449, -3735450, -3407783, -3080113, -2555835, -2097096, -1703890, -1376218};
        argbsCpkRasmol = new int[]{16716947, 0x1FFFFFF, 50315467, 0x3B22222, 0x500FF00, 0x6C8C8C8, 0x78F8FFF, 0x8F00000, 165324064, 0xB0000FF, 203590434, 226525328, 249210144, 268412160, 285198386, 0x1100FF00, 343965840, 377520272, 411074704, 427851920, 452961536, 480586282, 497363498, 514140714, 598026794, 796950672, 899686640, 956278016, 1339729184};
        if (elementSymbols.length != elementNames.length || elementSymbols.length != vanderwaalsMars.length || elementSymbols.length != covalentMars.length || elementSymbols.length != argbsCpk.length) {
            Logger.error("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + elementSymbols.length + "\n elementNames.length=" + elementNames.length + "\n vanderwaalsMars.length=" + vanderwaalsMars.length + "\n covalentMars.length=" + covalentMars.length + "\n argbsCpk.length=" + argbsCpk.length);
        }
        argbsStructure = new int[]{-1, -10452737, -14336, -65408, -5373698, -196254};
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476};
        argbsShapely = new int[]{-65281, -7536756, -16777092, -33680, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -4677566, -11318190, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -6250241, -6250241, -36752, -36752, -8323073, -8323073, -29621, -29621, -6226016, -6226016, -32640, -32640};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        FORMAL_CHARGE_COLIX_RED = (short)elementSymbols.length;
        FORMAL_CHARGE_COLIX_WHITE = (short)(FORMAL_CHARGE_COLIX_RED + 4);
        FORMAL_CHARGE_COLIX_BLUE = (short)(FORMAL_CHARGE_COLIX_WHITE + 7);
        argbsFormalCharge = new int[]{-65536, -49088, -32640, -16192, -1, -2565889, -4934401, -7302913, -9671425, -12039937, -14408449, -16776961};
        FORMAL_CHARGE_INDEX_MAX = argbsFormalCharge.length;
        PARTIAL_CHARGE_COLIX_RED = (short)(FORMAL_CHARGE_COLIX_BLUE + 1);
        PARTIAL_CHARGE_COLIX_WHITE = (short)(PARTIAL_CHARGE_COLIX_RED + 15);
        PARTIAL_CHARGE_COLIX_BLUE = (short)(PARTIAL_CHARGE_COLIX_WHITE + 15);
        argbsRwbScale = new int[]{-65536, -61424, -57312, -53200, -49088, -44976, -40864, -36752, -32640, -28528, -24416, -20304, -16192, -12080, -7968, -1, -2039553, -3092225, -4144897, -5197569, -6250241, -7302913, -8355585, -9408257, -10460929, -11513601, -12566273, -13618945, -14671617, -15724289, -16776961};
        argbsRoygbScale = new int[]{-65536, -57344, -49152, -40960, Short.MIN_VALUE, -24576, -16384, -8192, -4096, -256, -987136, -2031872, -4129024, -6226176, -8323328, -10420480, -12517632, -14614784, -16711936, -16711904, -16711872, -16711840, -16711808, -16711776, -16711744, -16711712, -16711681, -16719617, -16727809, -16736001, -16744193, -16752385, -16760577, -16768769, -16776961};
        argbsIsosurfacePositive = new int[]{-11525984, -9420608, -7315232, -5209857};
        argbsIsosurfaceNegative = new int[]{-6283184, -4177808, -2072432, -32592};
        specialAtomNames = new String[]{null, "N", "CA", "C", null, "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "O", "O1", null, null, null, "H5T", "O5T", "O1P", "O2P", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4"};
        ATOMID_MAX = specialAtomNames.length;
        predefinedGroup3Names = new String[]{"", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "A", "+A", "G", "+G", "I", "+I", "C", "+C", "T", "+T", "U", "+U", "1MA", "AMO", "5MC", "OMC", "1MG", "2MG", "M2G", "7MG", "G7M", "OMG", "YG", "QUO", "H2U", "5MU", "4SU", "PSU", "AMP", "ADP", "ATP", "GMP", "GDP", "GTP", "IMP", "IDP", "ITP", "CMP", "CDP", "CTP", "TMP", "TDP", "TTP", "UMP", "UDP", "UTP", "HOH", "DOD", "WAT", "PO4", "SO4"};
        group3List = JmolConstants.getGroup3List();
        group3Count = group3List.length() / 6;
        predefinedGroup1Names = new String[]{"", "A", "R", "N", "D", "C", "Q", "E", "G", "H", "I", "L", "K", "M", "F", "P", "S", "T", "W", "Y", "V", "A", "G", "?", "A", "A", "G", "G", "I", "I", "C", "C", "T", "T", "U", "U"};
        predefinedSets = new String[]{"@_1H _H & !(_2H,_3H)", "@_12C _C & !(_13C,_14C)", "@_14N _N & !(_15N)", "@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface amino&!buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@ligand hetero & !solvent", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & within(group,_a=74)", "@g nucleic & within(group,_a=75)", "@cg c,g", "@a nucleic & within(group,_a=76)", "@t nucleic & within(group,_a=77)", "@at a,t", "@i nucleic & within(group,_a=78) & !g", "@u nucleic & within(group,_a=79) & !t", "@tu nucleic & within(group,_a=80)", "@solvent _g>=70 & _g<=74", "@hoh water", "@water _g>=70 & _g<=72, oxygen & connected(2, hydrogen or deuterium or tritium), (hydrogen or deuterium and tritium) & connected(oxygen & connected(2, hydrogen or deuterium or tritium))", "@ions _g=73,_g=74", "@alpha _a=2", "@backbone (protein,nucleic) & _a>0 & _a<=63", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone", "@turn _structure=1", "@sheet _structure=2", "@helix _structure=3", "@bonded _bondedcount>0"};
        shapeClassBases = new String[]{"Balls", "Sticks", "Hsticks", "Sssticks", "Labels", "Vectors", "Measures", "Dots", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Stars", "Halos", "Axes", "Bbcage", "Uccage", "Frank", "Echo", "Hover", "Polyhedra", "Dipoles", "Pmesh", "MolecularOrbital", "Isosurface", "LcaoCartoon", "Draw"};
        if (shapeClassBases.length != 30) {
            Logger.error("the shapeClassBases array has the wrong length");
            throw new NullPointerException();
        }
        shapeToks = new int[]{4102, 34820, 10509, 10532, 0x10010F, 2097491, 15634, 8458, 303360, 8489, 2307, 10535, 340, 8474, 342, 307, 341, 2305, 6405, 301332, 2335, 1050891, 0x100151, 525660, 2098529, 347, 2625891, 2626910, 524644, 2626911};
        if (shapeToks.length != 30) {
            Logger.error("the shapeToks array has the wrong length");
            throw new NullPointerException();
        }
        if (argbsFormalCharge.length != 12) {
            Logger.error("formal charge color table length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 30) {
            Logger.error("graphicBaseClasses wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 23) {
            Logger.error("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsShapely.length != 36) {
            Logger.error("argbsShapely wrong length");
            throw new NullPointerException();
        }
    }
}

