/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.FontMetrics;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Labels;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Text;

class LabelsRenderer
extends ShapeRenderer {
    byte fidPrevious;
    Font3D font3d;
    FontMetrics fontMetrics;
    int ascent;
    int descent;
    int msgWidth;

    LabelsRenderer() {
    }

    void render() {
        this.fidPrevious = 0;
        Labels labels = (Labels)this.shape;
        String[] labelStrings = labels.strings;
        short[] colixes = labels.colixes;
        short[] bgcolixes = labels.bgcolixes;
        byte[] fids = labels.fids;
        int[] offsets = labels.offsets;
        if (labelStrings == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int i = labelStrings.length;
        while (--i >= 0) {
            Text text;
            int zBox;
            String label;
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.frame.bsHidden.get(i) || (label = labelStrings[i]) == null || label.length() == 0) continue;
            short colix = colixes == null || i >= colixes.length ? (short)0 : colixes[i];
            colix = Graphics3D.inheritColix(colix, atom.colixAtom);
            short bgcolix = bgcolixes == null || i >= bgcolixes.length ? (short)0 : bgcolixes[i];
            byte fid = fids == null || i >= fids.length || fids[i] == 0 ? labels.zeroFontId : fids[i];
            int offsetFull = offsets == null || i >= offsets.length ? 0 : offsets[i];
            boolean labelsFront = (offsetFull & 0x20) != 0;
            boolean labelsGroup = (offsetFull & 0x10) != 0;
            int offset = offsetFull >> 6;
            int textAlign = offsetFull >> 2 & 3;
            int pointer = offsetFull & 3;
            int zSlab = atom.getScreenZ() - atom.getScreenD() / 2 - 2;
            if (zSlab < 1) {
                zSlab = 1;
            }
            int n = labelsFront ? 1 : (zBox = labelsGroup && atom.group != null ? atom.group.minZ : zSlab);
            if (zBox < 1) {
                zBox = 1;
            }
            boolean isSimple = textAlign == 0 && label.indexOf("|") < 0;
            Text text2 = text = isSimple ? null : (Text)labels.atomLabels.get(atom);
            if (text != null) {
                text.setColix(colix);
                text.setXYZs(atom.screenX, atom.screenY, zBox, zSlab);
                text.render();
                continue;
            }
            if (fid != this.fidPrevious) {
                this.g3d.setFont(fid);
                this.fidPrevious = fid;
                this.font3d = this.g3d.getFont3DCurrent();
                if (textAlign == 0) {
                    this.fontMetrics = this.font3d.fontMetrics;
                    this.ascent = this.fontMetrics.getAscent();
                    this.descent = this.fontMetrics.getDescent();
                }
            }
            if (isSimple) {
                boolean doPointer = (pointer & 1) != 0;
                short pointercolix = (pointer & 2) != 0 && bgcolix != 0 ? bgcolix : colix;
                Text.renderSimple(this.g3d, this.font3d, label, colix, bgcolix, atom.screenX, atom.screenY, zBox, zSlab, Text.getXOffset(offset), Text.getYOffset(offset), this.ascent, this.descent, doPointer, pointercolix);
                continue;
            }
            text = new Text(this.g3d, this.font3d, label, colix, bgcolix, atom.screenX, atom.screenY, zBox, zSlab, textAlign);
            labels.atomLabels.put(atom, text);
            text.setOffset(offset);
            text.render();
        }
    }
}

