/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Closest;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;

abstract class Mps
extends Shape {
    Mmset mmset;
    Mpsmodel[] mpsmodels;

    Mps() {
    }

    final void initShape() {
        this.mmset = this.frame.mmset;
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        this.initialize();
        int m = this.mpsmodels.length;
        while (--m >= 0) {
            this.mpsmodels[m].setMad(mad, bsSelected);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        this.initialize();
        if ("color" == propertyName) {
            int pid = value instanceof Byte ? ((Byte)value).intValue() : -1;
            short colix = Graphics3D.getColix(value);
            int m = this.mpsmodels.length;
            while (--m >= 0) {
                this.mpsmodels[m].setColix(colix, pid, bs);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int m = this.mpsmodels.length;
            while (--m >= 0) {
                this.mpsmodels[m].setTranslucent(isTranslucent, bs);
            }
        }
    }

    String getShapeState() {
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        int m = this.mpsmodels.length;
        while (--m >= 0) {
            this.mpsmodels[m].setShapeState(temp, temp2);
        }
        return Shape.getShapeCommands(temp, temp2, this.frame.atomCount);
    }

    abstract Mpspolymer allocateMpspolymer(Polymer var1);

    void initialize() {
        if (this.mpsmodels == null) {
            int modelCount = this.mmset == null ? 0 : this.mmset.getModelCount();
            Model[] models = this.mmset.getModels();
            this.mpsmodels = new Mpsmodel[modelCount];
            int i = modelCount;
            while (--i >= 0) {
                this.mpsmodels[i] = new Mpsmodel(models[i]);
            }
        }
    }

    int getMpsmodelCount() {
        return this.mpsmodels.length;
    }

    Mpsmodel getMpsmodel(int i) {
        return this.mpsmodels[i];
    }

    void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
        int i = this.mpsmodels.length;
        while (--i >= 0) {
            this.mpsmodels[i].findNearestAtomIndex(xMouse, yMouse, closest);
        }
    }

    void setModelClickability() {
        int i = this.mpsmodels.length;
        while (--i >= 0) {
            this.mpsmodels[i].setModelClickability();
        }
    }

    abstract class Mpspolymer {
        Polymer polymer;
        Mesh[] meshes;
        boolean[] meshReady;
        short madOn;
        short madHelixSheet;
        short madTurnRandom;
        short madDnaRna;
        int monomerCount;
        Monomer[] monomers;
        short[] colixes;
        short[] mads;
        short[] paletteIDs;
        Point3f[] leadMidpoints;
        Point3f[] leadPoints;
        Vector3f[] wingVectors;
        BitSet bsSizeSetMps;
        BitSet bsColixSetMps;
        boolean hasBfactorRange = false;
        int bfactorMin;
        int bfactorMax;
        int range;
        float floatRange;
        private static final double eightPiSquared100 = 7895.6835208714865;

        Mpspolymer(Polymer polymer, int madOn, int madHelixSheet, int madTurnRandom, int madDnaRna) {
            this.polymer = polymer;
            this.madOn = (short)madOn;
            this.madHelixSheet = (short)madHelixSheet;
            this.madTurnRandom = (short)madTurnRandom;
            this.madDnaRna = (short)madDnaRna;
            int n = this.monomerCount = polymer == null ? 0 : polymer.monomerCount;
            if (this.monomerCount > 0) {
                this.colixes = new short[this.monomerCount];
                this.paletteIDs = new short[this.monomerCount];
                this.mads = new short[this.monomerCount + 1];
                this.monomers = polymer.monomers;
                this.meshReady = new boolean[this.monomerCount];
                this.meshes = new Mesh[this.monomerCount];
                this.leadPoints = polymer.getLeadPoints();
                this.leadMidpoints = polymer.getLeadMidpoints();
                this.wingVectors = polymer.getWingVectors();
            }
        }

        short getMadSpecial(short mad, int groupIndex) {
            switch (mad) {
                case -1: {
                    if (this.madOn >= 0) {
                        return this.madOn;
                    }
                    if (this.madOn != -2) {
                        Logger.error("not supported?");
                        return 0;
                    }
                }
                case -2: {
                    switch (this.monomers[groupIndex].getProteinStructureType()) {
                        case 2: 
                        case 3: {
                            return this.madHelixSheet;
                        }
                        case 4: 
                        case 5: {
                            return this.madDnaRna;
                        }
                    }
                    return this.madTurnRandom;
                }
                case -3: {
                    if (!this.hasBfactorRange) {
                        this.calcBfactorRange();
                    }
                    Atom atom = this.monomers[groupIndex].getLeadAtom();
                    int bfactor100 = atom.getBfactor100();
                    int scaled = bfactor100 - this.bfactorMin;
                    if (this.range == 0) {
                        return 0;
                    }
                    float percentile = (float)scaled / this.floatRange;
                    if (percentile < 0.0f || percentile > 1.0f) {
                        Logger.error("Que ha ocurrido? " + percentile);
                    }
                    return (short)(1750.0f * percentile + 250.0f);
                }
                case -4: {
                    Atom atom = this.monomers[groupIndex].getLeadAtom();
                    return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
                }
            }
            Logger.error("unrecognized Mps.getSpecial(" + mad + ")");
            return 0;
        }

        void calcBfactorRange() {
            this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
            int i = this.monomerCount;
            while (--i > 0) {
                int bfactor = this.monomers[i].getLeadAtom().getBfactor100();
                if (bfactor < this.bfactorMin) {
                    this.bfactorMin = bfactor;
                    continue;
                }
                if (bfactor <= this.bfactorMax) continue;
                this.bfactorMax = bfactor;
            }
            this.range = this.bfactorMax - this.bfactorMin;
            this.floatRange = this.range;
            this.hasBfactorRange = true;
        }

        void setMad(short mad, BitSet bsSelected) {
            if (this.bsSizeSetMps == null) {
                this.bsSizeSetMps = new BitSet();
            }
            int[] leadAtomIndices = this.polymer.getLeadAtomIndices();
            int i = this.monomerCount;
            while (--i >= 0) {
                int leadAtomIndex = leadAtomIndices[i];
                if (!bsSelected.get(leadAtomIndex)) continue;
                this.mads[i] = mad >= 0 ? mad : this.getMadSpecial(mad, i);
                boolean isVisible = this.mads[i] > 0;
                this.bsSizeSetMps.set(i, isVisible);
                this.monomers[i].setShapeVisibility(Mps.this.myVisibilityFlag, isVisible);
                Mps.this.frame.atoms[leadAtomIndex].setShapeVisibility(Mps.this.myVisibilityFlag, isVisible);
                this.falsifyMesh(i, true);
            }
            if (this.monomerCount > 1) {
                this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
            }
        }

        void setColix(short colix, int pid, BitSet bsSelected) {
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            if (this.bsColixSetMps == null) {
                this.bsColixSetMps = new BitSet();
            }
            int i = this.monomerCount;
            while (--i >= 0) {
                int atomIndex = atomIndices[i];
                if (!bsSelected.get(atomIndex)) continue;
                this.colixes[i] = colix != 3 ? colix : Mps.this.viewer.getColixAtomPalette(Mps.this.frame.getAtomAt(atomIndex), pid);
                this.paletteIDs[i] = (short)pid;
                this.bsColixSetMps.set(i, this.colixes[i] != 0 || Graphics3D.isColixTranslucent(this.colixes[i]));
            }
        }

        void setTranslucent(boolean isTranslucent, BitSet bsSelected) {
            int[] atomIndices = this.polymer.getLeadAtomIndices();
            int i = this.monomerCount;
            while (--i >= 0) {
                int atomIndex = atomIndices[i];
                if (!bsSelected.get(atomIndex)) continue;
                this.colixes[i] = Graphics3D.setTranslucent(this.colixes[i], isTranslucent);
            }
        }

        void setShapeState(Hashtable temp, Hashtable temp2) {
            if (this.bsSizeSetMps == null) {
                return;
            }
            String type = JmolConstants.shapeClassBases[Mps.this.shapeID];
            for (int i = 0; i < this.monomerCount; ++i) {
                int atomIndex1 = this.monomers[i].firstAtomIndex;
                int atomIndex2 = this.monomers[i].lastAtomIndex;
                if (!this.bsSizeSetMps.get(i)) continue;
                Shape.setStateInfo(temp, atomIndex1, atomIndex2, type + " " + (float)this.mads[i] / 2000.0f);
                if (this.bsColixSetMps == null || !this.bsColixSetMps.get(i)) continue;
                Shape.setStateInfo(temp2, atomIndex1, atomIndex2, Mps.this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
            }
        }

        void falsifyMesh(int index, boolean andNearby) {
            if (this.meshReady == null) {
                return;
            }
            this.meshReady[index] = false;
            if (!andNearby) {
                return;
            }
            if (index > 0) {
                this.meshReady[index - 1] = false;
            }
            if (index < this.monomerCount - 1) {
                this.meshReady[index + 1] = false;
            }
        }

        short calcMeanPositionalDisplacement(int bFactor100) {
            return (short)(Math.sqrt((double)bFactor100 / 7895.6835208714865) * 1000.0);
        }

        void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
            this.polymer.findNearestAtomIndex(xMouse, yMouse, closest, this.mads, Mps.this.myVisibilityFlag);
        }

        void setModelClickability() {
            if (this.wingVectors == null) {
                return;
            }
            boolean isNucleicPolymer = this.polymer instanceof NucleicPolymer;
            if (!isNucleicPolymer) {
                return;
            }
            int i = this.monomerCount;
            while (--i >= 0) {
                NucleicMonomer group;
                if (this.mads[i] <= 0 || Mps.this.frame.bsHidden.get((group = (NucleicMonomer)this.monomers[i]).getLeadAtomIndex())) continue;
                group.setModelClickability();
            }
        }
    }

    class Mpsmodel {
        Mpspolymer[] mpspolymers;
        int modelIndex;
        int modelVisibilityFlags = 0;

        Mpsmodel(Model model) {
            this.mpspolymers = new Mpspolymer[model.getPolymerCount()];
            this.modelIndex = model.modelIndex;
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i] = Mps.this.allocateMpspolymer(model.getPolymer(i));
            }
        }

        void setMad(short mad, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setMad(mad, bsSelected);
            }
        }

        void setColix(short colix, int pid, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setColix(colix, pid, bsSelected);
            }
        }

        void setTranslucent(boolean isTranslucent, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setTranslucent(isTranslucent, bsSelected);
            }
        }

        void setShapeState(Hashtable temp, Hashtable temp2) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                Mpspolymer polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setShapeState(temp, temp2);
            }
        }

        int getMpspolymerCount() {
            return this.mpspolymers.length;
        }

        Mpspolymer getMpspolymer(int i) {
            return this.mpspolymers[i];
        }

        void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i].findNearestAtomIndex(xMouse, yMouse, closest);
            }
        }

        void setModelClickability() {
            int displayModelIndex = Mps.this.viewer.getDisplayModelIndex();
            this.modelVisibilityFlags = displayModelIndex >= 0 && displayModelIndex != this.modelIndex ? 0 : Mps.this.myVisibilityFlag;
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i].setModelClickability();
            }
        }
    }
}

