/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;

class Sticks
extends Shape {
    short myMask;
    boolean reportAll;
    BitSet bsOrderSet;
    BitSet bsSizeSet;
    BitSet bsColixSet;

    Sticks() {
    }

    void initShape() {
        this.myMask = (short)3;
        this.reportAll = false;
    }

    void setSize(int size, BitSet bsSelected) {
        boolean isBonds;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        BondIterator iter = (isBonds = this.viewer.isBondSelection()) ? this.frame.getBondIterator(bsSelected) : this.frame.getBondIterator(this.myMask, bsSelected);
        short mad = (short)size;
        while (iter.hasNext()) {
            this.bsSizeSet.set(iter.nextIndex());
            iter.next().setMad(mad);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Logger.debug(propertyName + " " + value + " " + bsSelected);
        boolean isBonds = this.viewer.isBondSelection();
        if ("reportAll" == propertyName) {
            this.reportAll = true;
            return;
        }
        if ("reset" == propertyName) {
            this.bsOrderSet = null;
            this.bsSizeSet = null;
            this.bsColixSet = null;
            return;
        }
        if ("bondOrder" == propertyName) {
            BondIterator iter;
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            short order = (Short)value;
            BondIterator bondIterator = iter = isBonds ? this.frame.getBondIterator(bsSelected) : this.frame.getBondIterator(this.myMask, bsSelected);
            while (iter.hasNext()) {
                this.bsOrderSet.set(iter.nextIndex());
                iter.next().setOrder(order);
            }
            return;
        }
        if ("color" == propertyName) {
            BondIterator iter;
            int pid;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short colix = Graphics3D.getColix(value);
            int n = pid = value instanceof Byte ? ((Byte)value).intValue() : -1;
            if (pid == 18) {
                BondIterator iter2;
                BondIterator bondIterator = iter2 = isBonds ? this.frame.getBondIterator(bsSelected) : this.frame.getBondIterator(this.myMask, bsSelected);
                while (iter2.hasNext()) {
                    this.bsColixSet.set(iter2.nextIndex());
                    Bond bond = iter2.next();
                    bond.setColix(this.viewer.getColixHbondType(bond.order));
                }
                return;
            }
            if (colix == 3) {
                return;
            }
            BondIterator bondIterator = iter = isBonds ? this.frame.getBondIterator(bsSelected) : this.frame.getBondIterator(this.myMask, bsSelected);
            while (iter.hasNext()) {
                int iBond = iter.nextIndex();
                Bond bond = iter.next();
                bond.setColix(colix);
                this.bsColixSet.set(iBond, colix != 0 || bond.isTranslucent());
            }
            return;
        }
        if ("translucency" == propertyName) {
            BondIterator iter;
            boolean isTranslucent = ((String)value).equals("translucent");
            BondIterator bondIterator = iter = isBonds ? this.frame.getBondIterator(bsSelected) : this.frame.getBondIterator(this.myMask, bsSelected);
            while (iter.hasNext()) {
                this.bsColixSet.set(iter.nextIndex());
                iter.next().setTranslucent(isTranslucent);
            }
            return;
        }
        super.setProperty(propertyName, value, bsSelected);
    }

    void setModelClickability() {
        Bond[] bonds = this.frame.bonds;
        int i = this.frame.bondCount;
        while (--i >= 0) {
            Bond bond = bonds[i];
            if ((bond.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(bond.atom1.atomIndex) || this.frame.bsHidden.get(bond.atom2.atomIndex)) continue;
            bond.atom1.clickabilityFlags |= this.myVisibilityFlag;
            bond.atom2.clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    String getShapeState() {
        Hashtable temp = new Hashtable();
        Bond[] bonds = this.frame.bonds;
        int i = this.frame.bondCount;
        while (--i >= 0) {
            Bond bond = bonds[i];
            if (this.reportAll || this.bsSizeSet != null && this.bsSizeSet.get(i)) {
                Shape.setStateInfo(temp, i, "wireframe " + (float)bond.mad / 2000.0f);
            }
            if (this.reportAll || this.bsOrderSet != null && this.bsOrderSet.get(i)) {
                Shape.setStateInfo(temp, i, "bondOrder " + JmolConstants.getBondOrderNameFromOrder(bond.order));
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
            Shape.setStateInfo(temp, i, this.getColorCommand("bonds", bond.colix));
        }
        return Shape.getShapeCommands(temp, null, -1, "select BONDS") + "\n";
    }
}

