/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

class TransformManager {
    Viewer viewer;
    static final float twoPI = (float)Math.PI * 2;
    float spinX;
    float spinY = 30.0f;
    float spinZ;
    float spinFps = 30.0f;
    boolean haveNotifiedNaN = false;
    boolean haveNotifiedCamera = false;
    boolean isSpinInternal = false;
    boolean isSpinFixed = false;
    final Point3f fixedRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    AxisAngle4f fixedRotationAxis;
    float fixedRotationAngle = 0.0f;
    float fixedRotationAngleFramed = 0.0f;
    float rotationRadius;
    Point3f rotationCenterDefault;
    float rotationRadiusDefault;
    AxisAngle4f internalRotationAxis;
    final Point3f internalRotationCenter = new Point3f(0.0f, 0.0f, 0.0f);
    float internalRotationAngle = 0.0f;
    private final Matrix3f matrixRotate = new Matrix3f();
    private final Matrix3f matrixTemp3 = new Matrix3f();
    private final Matrix4f matrixTemp4 = new Matrix4f();
    final AxisAngle4f axisangleT = new AxisAngle4f();
    final Vector3f vectorT = new Vector3f();
    final Vector3f vectorT2 = new Vector3f();
    final Point3f pointT = new Point3f();
    final Point3f pointT2 = new Point3f();
    static final float radiansPerDegree = (float)Math.PI / 180;
    static final float degreesPerRadian = 57.29578f;
    static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    static final int MAXIMUM_ZOOM_PERSPECTIVE_DEPTH = 10000;
    Vector3f rotationAxis = new Vector3f();
    float rotationRate = 0.0f;
    float xFixedTranslation;
    float yFixedTranslation;
    boolean zoomEnabled = true;
    float zoomPercent = 100.0f;
    float zoomPercentSetting = 100.0f;
    boolean slabEnabled = false;
    int slabPercentSetting = 100;
    int depthPercentSetting = 0;
    int slabValue;
    int depthValue;
    private boolean perspectiveDepth = true;
    private float cameraDepth = 3.0f;
    private int cameraDistance = 1000;
    private float cameraDistanceFloat = 1000.0f;
    boolean tOversample;
    int width;
    int height;
    int width1;
    int height1;
    int width4;
    int height4;
    int screenPixelCount;
    float scalePixelsPerAngstrom;
    float scaleDefaultPixelsPerAngstrom;
    final Matrix4f matrixTransform = new Matrix4f();
    private final Point3f point3fVibrationTemp = new Point3f();
    private final Point3f point3fScreenTemp = new Point3f();
    private final Point3i point3iScreenTemp = new Point3i();
    private final Matrix4f matrixTemp = new Matrix4f();
    private final Vector3f vectorTemp = new Vector3f();
    boolean axesOrientationRasmol = false;
    boolean increaseRotationRadius;
    float minimumZ;
    private final Vector3f perspectiveOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    AxisAngle4f aaMoveTo;
    AxisAngle4f aaStep;
    AxisAngle4f aaTotal;
    Matrix3f matrixStart;
    Matrix3f matrixInverse;
    Matrix3f matrixStep;
    Matrix3f matrixEnd;
    Vector3f aaStepCenter;
    Point3f ptCenter;
    boolean spinOn;
    SpinThread spinThread;
    boolean vibrationOn;
    float vibrationPeriod;
    int vibrationPeriodMs;
    float vibrationAmplitude;
    float vibrationRadians;
    float vectorScale = 1.0f;
    float vibrationScale = 1.0f;
    VibrationThread vibrationThread;
    int stereoMode;
    int[] stereoColors;
    float stereoDegrees = 5.0f;
    float stereoRadians = 0.08726646f;
    boolean stereoFrame;
    private final Matrix3f matrixStereo = new Matrix3f();
    boolean windowCentered;

    TransformManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void homePosition() {
        this.setDefaultRotation();
        this.setRotationCenterAndRadiusXYZ(null, true);
        this.translateCenterTo(0, 0);
        this.matrixRotate.setIdentity();
        this.setZoomEnabled(true);
        this.zoomToPercent(100.0f);
        this.scaleFitToScreen();
    }

    void clear() {
        this.clearVibration();
        this.clearSpin();
        this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
    }

    String getState() {
        StringBuffer commands = new StringBuffer("# orientation/center/spin state:\nset refreshing false;\n");
        if (!this.isWindowCentered()) {
            commands.append("set windowCentered false;\n");
        }
        commands.append("center " + StateManager.encloseCoord(this.fixedRotationCenter) + ";\n");
        commands.append(this.getMoveToText(0.0f));
        commands.append("slab " + this.slabPercentSetting + ";depth " + this.depthPercentSetting + (this.slabEnabled ? ";slab on" : "") + ";\n");
        commands.append("set spin X " + (int)this.spinX);
        commands.append(";set spin Y " + (int)this.spinY);
        commands.append(";set spin Z " + (int)this.spinZ);
        commands.append(";set spin fps " + (int)this.spinFps + "\n");
        if (this.spinOn) {
            commands.append("set refreshing true;refresh;\n");
            if (this.isSpinInternal) {
                Point3f pt = new Point3f(this.internalRotationCenter);
                pt.add(this.rotationAxis);
                commands.append("spin " + this.rotationRate + " " + StateManager.encloseCoord(this.internalRotationCenter) + " " + StateManager.encloseCoord(pt));
            } else if (this.isSpinFixed) {
                commands.append("spin axisangle " + StateManager.encloseCoord(this.rotationAxis) + " " + this.rotationRate);
            } else {
                commands.append("spin on");
            }
            commands.append(";\n");
        }
        commands.append("\n");
        return commands.toString();
    }

    private void setFixedRotationCenter(Point3f center) {
        if (center == null) {
            return;
        }
        this.fixedRotationCenter.set(center);
    }

    void setRotationPointXY(Point3f center) {
        Point3i newCenterScreen = this.transformPoint(center);
        this.translateCenterTo(newCenterScreen.x, newCenterScreen.y);
    }

    float setRotateInternal(Point3f center, Vector3f axis, float degrees) {
        this.internalRotationCenter.set(center);
        this.rotationAxis.set(axis);
        if (this.internalRotationAxis == null) {
            this.internalRotationAxis = new AxisAngle4f();
        }
        float radians = degrees * ((float)Math.PI / 180);
        this.rotationRate = degrees;
        this.internalRotationAxis.set(axis, radians);
        return radians;
    }

    float setRotateFixed(Point3f center, Vector3f axis, float degrees) {
        this.setFixedRotationCenter(center);
        this.rotationAxis.set(axis);
        if (this.fixedRotationAxis == null) {
            this.fixedRotationAxis = new AxisAngle4f();
        }
        float radians = degrees * ((float)Math.PI / 180);
        this.rotationRate = degrees;
        this.fixedRotationAxis.set(axis, radians);
        return radians;
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.rotateXRadians((float)yDelta * ((float)Math.PI / 180));
        this.rotateYRadians((float)xDelta * ((float)Math.PI / 180));
    }

    void rotateZBy(int zDelta) {
        this.rotateZRadians((float)Math.PI * (float)zDelta / 180.0f);
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateToX(float angleRadians) {
        this.matrixRotate.rotX(angleRadians);
    }

    void rotateToY(float angleRadians) {
        this.matrixRotate.rotY(angleRadians);
    }

    void rotateToZ(float angleRadians) {
        this.matrixRotate.rotZ(angleRadians);
    }

    synchronized void rotateXRadians(float angleRadians) {
        this.matrixTemp3.rotX(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    synchronized void rotateYRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotY(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    synchronized void rotateZRadians(float angleRadians) {
        if (this.axesOrientationRasmol) {
            angleRadians = -angleRadians;
        }
        this.matrixTemp3.rotZ(angleRadians);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotateAxisAngle(Vector3f rotAxis, int degrees) {
        this.axisangleT.set(rotAxis, (float)degrees * ((float)Math.PI / 180));
        this.rotateAxisAngle(this.axisangleT);
    }

    synchronized void rotateAxisAngle(AxisAngle4f axisAngle) {
        this.matrixTemp3.setIdentity();
        this.matrixTemp3.set(axisAngle);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
    }

    void rotateTo(float x, float y, float z, float degrees) {
        if ((double)degrees < 0.01 && (double)degrees > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.axisangleT.set(x, y, z, degrees * ((float)Math.PI / 180));
            this.matrixRotate.set(this.axisangleT);
        }
    }

    void rotateTo(AxisAngle4f axisAngle) {
        if ((double)axisAngle.angle < 0.01 && (double)axisAngle.angle > -0.01) {
            this.matrixRotate.setIdentity();
        } else {
            this.matrixRotate.set(axisAngle);
        }
    }

    void rotateAxisAngleAtCenter(Point3f rotCenter, Vector3f rotAxis, float degrees, float endDegrees, boolean isSpin) {
        if (rotCenter != null) {
            this.moveRotationCenter(rotCenter, true);
        }
        this.setSpinOn(false);
        if (degrees == 0.0f) {
            return;
        }
        if (rotCenter != null) {
            this.setRotationPointXY(rotCenter);
        }
        float angle = this.setRotateFixed(rotCenter, rotAxis, degrees);
        if (isSpin) {
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.setSpinOn(true, endDegrees);
            return;
        }
        this.rotateAxisAngleRadiansFixed(angle);
    }

    synchronized void rotateAxisAngleRadiansFixed(float angleRadians) {
        this.fixedRotationAngle = angleRadians;
        this.axisangleT.set(this.fixedRotationAxis);
        this.axisangleT.angle = angleRadians;
        this.rotateAxisAngle(this.axisangleT);
    }

    void rotateAboutPointsInternal(Point3f point1, Point3f point2, float degrees, float endDegrees, boolean isClockwise, boolean isSpin) {
        this.setSpinOn(false);
        if (degrees == 0.0f) {
            return;
        }
        Vector3f axis = new Vector3f(point1);
        axis.sub(point2);
        if (isClockwise) {
            axis.scale(-1.0f);
        }
        float angle = this.setRotateInternal(point1, axis, degrees);
        if (isSpin) {
            this.isSpinInternal = true;
            this.isSpinFixed = false;
            this.setSpinOn(true, endDegrees);
            return;
        }
        this.rotateAxisAngleRadiansInternal(angle);
    }

    synchronized void rotateAxisAngleRadiansInternal(float radians) {
        this.internalRotationAngle = radians;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.transform(this.vectorT, this.vectorT2);
        this.axisangleT.set(this.vectorT2, radians);
        this.matrixTemp3.set(this.axisangleT);
        this.matrixRotate.mul(this.matrixTemp3, this.matrixRotate);
        this.getNewFixedRotationCenter();
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.set(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.set(this.axisangleT);
        this.vectorT.set(this.internalRotationCenter);
        this.pointT2.set(this.fixedRotationCenter);
        this.pointT2.sub(this.vectorT);
        this.matrixTemp4.transform(this.pointT2, this.pointT);
        this.pointT.add(this.vectorT);
        this.setRotationCenterAndRadiusXYZ(this.pointT, false);
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.xFixedTranslation += (float)xDelta;
        this.yFixedTranslation += (float)yDelta;
    }

    void translateToXPercent(float percent) {
        this.xFixedTranslation = (float)(this.width / 2) + (float)this.width * percent / 100.0f;
    }

    void translateToYPercent(float percent) {
        this.yFixedTranslation = (float)(this.height / 2) + (float)this.height * percent / 100.0f;
    }

    void translateToZPercent(float percent) {
    }

    float getTranslationXPercent() {
        return (this.xFixedTranslation - (float)(this.width / 2)) * 100.0f / (float)this.width;
    }

    float getTranslationYPercent() {
        return (this.yFixedTranslation - (float)(this.height / 2)) * 100.0f / (float)this.height;
    }

    float getTranslationZPercent() {
        return 0.0f;
    }

    String getTranslationScript() {
        String info = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            info = info + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            info = info + "translate y " + f + ";";
        }
        return info;
    }

    void translateCenterTo(int x, int y) {
        this.xFixedTranslation = x;
        this.yFixedTranslation = y;
    }

    String getOrientationText() {
        return this.getMoveToText() + "\nOR\n" + this.getRotateZyzText(true);
    }

    Hashtable getOrientationInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("moveTo", this.getMoveToText());
        info.put("center", "center " + this.getCenterText());
        info.put("rotateZYZ", this.getRotateZyzText(false));
        info.put("rotateXYZ", this.getRotateXyzText());
        info.put("transXPercent", new Float(this.getTranslationXPercent()));
        info.put("transYPercent", new Float(this.getTranslationYPercent()));
        info.put("zoom", new Float(this.zoomPercent));
        return info;
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        axisAngle.set(this.matrixRotate);
    }

    String getTransformText() {
        return this.matrixRotate.toString();
    }

    Matrix3f getMatrixRotate() {
        return this.matrixRotate;
    }

    void setRotation(Matrix3f matrixRotation) {
        this.matrixRotate.set(matrixRotation);
    }

    void getRotation(Matrix3f matrixRotation) {
        matrixRotation.set(this.matrixRotate);
    }

    void zoomBy(int pixels) {
        if (pixels > 20) {
            pixels = 20;
        } else if (pixels < -20) {
            pixels = -20;
        }
        float deltaPercent = (float)pixels * this.zoomPercentSetting / 50.0f;
        if (deltaPercent == 0.0f) {
            deltaPercent = pixels > 0 ? 1 : (deltaPercent < 0.0f ? -1 : 0);
        }
        float percent = deltaPercent + this.zoomPercentSetting;
        this.zoomToPercent(percent);
    }

    int getZoomPercent() {
        return (int)this.zoomPercent;
    }

    float getZoomPercentFloat() {
        return this.zoomPercent;
    }

    float getZoomPercentSetting() {
        return this.zoomPercentSetting;
    }

    void zoomToPercent(float percentZoom) {
        this.zoomPercentSetting = percentZoom;
        this.calcScale("zoomToPercent");
    }

    void zoomByPercent(float percentZoom) {
        float delta = percentZoom * this.zoomPercentSetting / 100.0f;
        if (delta == 0.0f) {
            delta = percentZoom < 0.0f ? -1.0f : 1.0f;
        }
        this.zoomPercentSetting += delta;
        this.calcScale("zoomByPercent");
    }

    private void setZoomParameters() {
        if (this.zoomPercentSetting < 5.0f) {
            this.zoomPercentSetting = 5.0f;
        }
        if (this.zoomPercentSetting > 200000.0f) {
            this.zoomPercentSetting = 200000.0f;
        }
        this.zoomPercent = this.zoomEnabled ? this.zoomPercentSetting : 100.0f;
    }

    private void calcScale(String from) {
        this.setZoomParameters();
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom * this.zoomPercent / 100.0f;
    }

    void setZoomEnabled(boolean zoomEnabled) {
        if (this.zoomEnabled != zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
            this.calcScale("setZoomEnabled");
        }
    }

    void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.scalePixelsPerAngstrom = this.scaleDefaultPixelsPerAngstrom = 72.0f / angstromsPerInch;
    }

    int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int percentage) {
        this.slabPercentSetting += percentage;
        if (this.slabPercentSetting < 1) {
            this.slabPercentSetting = 1;
        } else if (this.slabPercentSetting > 100) {
            this.slabPercentSetting = 100;
        }
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void depthByPercentagePoints(int percentage) {
        this.depthPercentSetting += percentage;
        if (this.depthPercentSetting < 0) {
            this.depthPercentSetting = 0;
        } else if (this.depthPercentSetting > 99) {
            this.depthPercentSetting = 99;
        }
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    void slabDepthByPercentagePoints(int percentage) {
        if (percentage > 0) {
            if (this.slabPercentSetting + percentage > 100) {
                percentage = 100 - this.slabPercentSetting;
            }
        } else if (this.depthPercentSetting + percentage < 0) {
            percentage = 0 - this.depthPercentSetting;
        }
        this.slabPercentSetting += percentage;
        this.depthPercentSetting += percentage;
    }

    void slabToPercent(int percentSlab) {
        int n = percentSlab < 1 ? 1 : (this.slabPercentSetting = percentSlab > 100 ? 100 : percentSlab);
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    void setSlabEnabled(boolean slabEnabled) {
        this.slabEnabled = slabEnabled;
    }

    void depthToPercent(int percentDepth) {
        int n = percentDepth < 0 ? 0 : (this.depthPercentSetting = percentDepth > 99 ? 99 : percentDepth);
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
    }

    private void calcSlabAndDepthValues() {
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
        if (this.slabEnabled) {
            int radius = (int)(this.rotationRadius * this.scalePixelsPerAngstrom);
            this.slabValue = (100 - this.slabPercentSetting) * 2 * radius / 100 + this.cameraDistance;
            this.depthValue = (100 - this.depthPercentSetting) * 2 * radius / 100 + this.cameraDistance;
        }
    }

    void setPerspectiveDepth(boolean perspectiveDepth) {
        if (this.perspectiveDepth == perspectiveDepth) {
            return;
        }
        this.perspectiveDepth = perspectiveDepth;
        this.scaleFitToScreen();
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    void checkCameraDistance() {
        if (!this.increaseRotationRadius || !this.windowCentered) {
            return;
        }
        float backupDistance = (float)this.cameraDistance - this.minimumZ + 1.0f;
        this.rotationRadius += backupDistance / this.scalePixelsPerAngstrom;
    }

    void setScreenDimension(int width, int height) {
        this.width1 = this.width = width;
        this.width4 = width + width;
        this.height1 = this.height = height;
        this.height4 = height + height;
    }

    void setOversample(boolean tOversample) {
        if (this.tOversample == tOversample) {
            return;
        }
        this.tOversample = tOversample;
        if (tOversample) {
            this.width = this.width4;
            this.height = this.height4;
        } else {
            this.width = this.width1;
            this.height = this.height1;
        }
        this.scaleFitToScreen();
    }

    private void setTranslationCenterToScreen() {
        this.xFixedTranslation = this.width / 2;
        this.yFixedTranslation = this.height / 2;
        this.screenPixelCount = this.width;
        boolean isByLarger = this.viewer.getZoomLarge();
        if (this.height != this.width && (isByLarger && this.height > this.width || !isByLarger && this.height < this.width)) {
            this.screenPixelCount = this.height;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
    }

    float defaultScaleToScreen(float radius) {
        return (float)this.screenPixelCount / 2.0f / radius * this.cameraScaleFactor();
    }

    private float cameraScaleFactor() {
        if (!this.perspectiveDepth) {
            return 1.0f;
        }
        this.cameraDistance = (int)(this.cameraDepth * (float)this.screenPixelCount);
        this.cameraDistanceFloat = this.cameraDistance;
        float scaleFactor = (float)(this.cameraDistance + this.screenPixelCount / 2) / this.cameraDistanceFloat;
        scaleFactor = (float)((double)scaleFactor + 0.02);
        return scaleFactor;
    }

    void scaleFitToScreen() {
        if (this.width == 0 || this.height == 0 || !this.viewer.haveFrame()) {
            return;
        }
        this.setTranslationCenterToScreen();
        this.scaleDefaultPixelsPerAngstrom = this.defaultScaleToScreen(this.rotationRadius);
        this.calcScale("scaleFitToScreen rotrad=" + this.rotationRadius);
    }

    float scaleToScreen(int z, float sizeAngstroms) {
        if (z <= 0) {
            z = 1;
        }
        float pixelSize = sizeAngstroms * this.scalePixelsPerAngstrom;
        if (this.perspectiveDepth) {
            float factor = this.cameraDistanceFloat / (float)z;
            if (this.zoomPercent >= 10000.0f) {
                factor += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - factor);
            }
            pixelSize *= factor;
        }
        return pixelSize;
    }

    short scaleToScreen(int z, int milliAngstroms) {
        if (z <= 0) {
            z = 1;
        }
        if (milliAngstroms == 0) {
            return 0;
        }
        int pixelSize = (int)((float)milliAngstroms * this.scalePixelsPerAngstrom / 1000.0f);
        if (this.perspectiveDepth) {
            float factor = this.cameraDistanceFloat / (float)z;
            if (this.zoomPercent >= 10000.0f) {
                factor += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - factor);
            }
            pixelSize = (int)((float)pixelSize * factor);
        }
        if (pixelSize == 0) {
            return 1;
        }
        return (short)pixelSize;
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        if (z <= 0) {
            z = 1;
        }
        if (!this.perspectiveDepth) {
            return sizeAngstroms;
        }
        float factor = this.cameraDistanceFloat / (float)z;
        if (this.zoomPercent >= 10000.0f) {
            factor += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - factor);
        }
        return sizeAngstroms * factor;
    }

    void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.axesOrientationRasmol = axesOrientationRasmol;
    }

    synchronized void finalizeTransformParameters() {
        this.calcTransformMatrix();
        this.calcSlabAndDepthValues();
        this.increaseRotationRadius = false;
        this.minimumZ = Float.MAX_VALUE;
        this.haveNotifiedNaN = false;
        this.haveNotifiedCamera = false;
        if (this.windowCentered) {
            this.matrixTransform.transform(this.rotationCenterDefault, this.pointT);
            this.matrixTransform.transform(this.fixedRotationCenter, this.pointT2);
            this.perspectiveOffset.sub(this.pointT, this.pointT2);
        }
        this.perspectiveOffset.x = this.xFixedTranslation;
        this.perspectiveOffset.y = this.yFixedTranslation;
        if (this.windowCentered || !this.viewer.isCameraAdjustable()) {
            this.perspectiveOffset.z = 0.0f;
        }
    }

    private synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.set(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
        this.vectorTemp.x = 0.0f;
        this.vectorTemp.y = 0.0f;
        this.vectorTemp.z = this.rotationRadius + this.cameraDistanceFloat / this.scalePixelsPerAngstrom;
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        if (this.axesOrientationRasmol) {
            this.matrixTransform.add(this.matrixTemp);
        } else {
            this.matrixTransform.sub(this.matrixTemp);
        }
        this.matrixTemp.setZero();
        this.matrixTemp.set(this.scalePixelsPerAngstrom);
        if (!this.axesOrientationRasmol) {
            this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        }
        this.matrixTransform.mul(this.matrixTemp, this.matrixTransform);
    }

    Matrix4f getUnscaledTransformMatrix() {
        Matrix4f unscaled = new Matrix4f();
        unscaled.setIdentity();
        this.vectorTemp.set(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        unscaled.sub(this.matrixTemp);
        this.matrixTemp.set(this.matrixRotate);
        unscaled.mul(this.matrixTemp, unscaled);
        return unscaled;
    }

    void transformPoints(int count, Point3f[] angstroms, Point3i[] screens) {
        int i = count;
        while (--i >= 0) {
            screens[i].set(this.transformPoint(angstroms[i]));
        }
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms));
    }

    synchronized Point3i transformPoint(Point3f pointAngstroms) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        return this.adjustedTemporaryScreenPoint(pointAngstroms);
    }

    Point3i adjustedTemporaryScreenPoint(Point3f pointAngstroms) {
        float z = this.point3fScreenTemp.z - this.perspectiveOffset.z;
        if (z < (float)this.cameraDistance) {
            if (Float.isNaN(this.point3fScreenTemp.z)) {
                if (!this.haveNotifiedNaN) {
                    Logger.debug("NaN seen in TransformPoint");
                }
                this.haveNotifiedNaN = true;
                z = 1.0f;
            } else {
                if (!this.spinOn && !this.haveNotifiedCamera) {
                    Logger.debug("need to back up the camera");
                    Logger.debug("point3fScreenTemp.z=" + this.point3fScreenTemp.z + " -> z=" + z);
                    this.haveNotifiedCamera = true;
                }
                this.increaseRotationRadius = true;
                if (z < this.minimumZ) {
                    this.minimumZ = z;
                }
                if (z <= 0.0f) {
                    if (!this.spinOn && !this.haveNotifiedCamera) {
                        Logger.debug("WARNING! DANGER! z <= 0! transformPoint() point=" + pointAngstroms + "  ->  " + this.point3fScreenTemp);
                        this.haveNotifiedCamera = true;
                    }
                    z = 1.0f;
                }
            }
        }
        this.point3fScreenTemp.z = z;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / z;
            if (this.zoomPercent >= 10000.0f) {
                perspectiveFactor += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - perspectiveFactor);
            }
            this.point3fScreenTemp.x *= perspectiveFactor;
            this.point3fScreenTemp.y *= perspectiveFactor;
        }
        this.point3fScreenTemp.x += this.perspectiveOffset.x;
        this.point3fScreenTemp.y += this.perspectiveOffset.y;
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            Logger.debug("NaN found in transformPoint ");
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.x = (int)this.point3fScreenTemp.x;
        this.point3iScreenTemp.y = (int)this.point3fScreenTemp.y;
        this.point3iScreenTemp.z = (int)this.point3fScreenTemp.z;
        return this.point3iScreenTemp;
    }

    void unTransformPoint(Point3i screenPt, Point3f coordPt) {
        Point3f pt = new Point3f();
        pt.set(screenPt.x, screenPt.y, screenPt.z);
        pt.x -= this.perspectiveOffset.x;
        pt.y -= this.perspectiveOffset.y;
        if (this.perspectiveDepth) {
            float perspectiveFactor = this.cameraDistanceFloat / pt.z;
            if (this.zoomPercent >= 10000.0f) {
                perspectiveFactor += (this.zoomPercent - 10000.0f) / 190000.0f * (1.0f - perspectiveFactor);
            }
            pt.x /= perspectiveFactor;
            pt.y /= perspectiveFactor;
        }
        pt.z += this.perspectiveOffset.z;
        Matrix4f m = new Matrix4f();
        m.invert(this.matrixTransform);
        m.transform(pt, coordPt);
    }

    void transformPoint(Point3f pointAngstroms, Point3f screen) {
        this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        this.adjustedTemporaryScreenPoint(pointAngstroms);
        screen.set(this.point3fScreenTemp);
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        if (!this.vibrationOn || vibrationVector == null) {
            this.matrixTransform.transform(pointAngstroms, this.point3fScreenTemp);
        } else {
            this.point3fVibrationTemp.scaleAdd(this.vibrationAmplitude, vibrationVector, pointAngstroms);
            this.matrixTransform.transform(this.point3fVibrationTemp, this.point3fScreenTemp);
        }
        return this.adjustedTemporaryScreenPoint(pointAngstroms);
    }

    void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        pointScreen.set(this.transformPoint(pointAngstroms, vibrationVector));
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.matrixTransform.transform(vectorAngstroms, vectorTransformed);
    }

    void move(Vector3f dRot, int dZoom, Vector3f dTrans, int dSlab, float floatSecondsTotal, int fps) {
        int slab = this.getSlabPercentSetting();
        float transX = this.getTranslationXPercent();
        float transY = this.getTranslationYPercent();
        float transZ = this.getTranslationZPercent();
        long timeBegin = System.currentTimeMillis();
        int timePerStep = 1000 / fps;
        int totalSteps = (int)((float)fps * floatSecondsTotal);
        float radiansPerDegreePerStep = (float)Math.PI / 180 / (float)totalSteps;
        float radiansXStep = radiansPerDegreePerStep * dRot.x;
        float radiansYStep = radiansPerDegreePerStep * dRot.y;
        float radiansZStep = radiansPerDegreePerStep * dRot.z;
        this.viewer.setInMotion(true);
        float zoomPercent0 = this.zoomPercent;
        if (totalSteps == 0) {
            totalSteps = 1;
        }
        for (int i = 1; i <= totalSteps; ++i) {
            int timeAllowed;
            int timeSpent;
            if (dRot.x != 0.0f) {
                this.rotateXRadians(radiansXStep);
            }
            if (dRot.y != 0.0f) {
                this.rotateYRadians(radiansYStep);
            }
            if (dRot.z != 0.0f) {
                this.rotateZRadians(radiansZStep);
            }
            if (dZoom != 0) {
                this.zoomToPercent(zoomPercent0 + (float)(dZoom * i / totalSteps));
            }
            if (dTrans.x != 0.0f) {
                this.translateToXPercent(transX + dTrans.x * (float)i / (float)totalSteps);
            }
            if (dTrans.y != 0.0f) {
                this.translateToYPercent(transY + dTrans.y * (float)i / (float)totalSteps);
            }
            if (dTrans.z != 0.0f) {
                this.translateToZPercent(transZ + dTrans.z * (float)i / (float)totalSteps);
            }
            if (dSlab != 0) {
                this.slabToPercent(slab + dSlab * i / totalSteps);
            }
            if ((timeSpent = (int)(System.currentTimeMillis() - timeBegin)) >= (timeAllowed = i * timePerStep)) continue;
            this.viewer.requestRepaintAndWait();
            if (!this.viewer.isScriptExecuting()) break;
            timeSpent = (int)(System.currentTimeMillis() - timeBegin);
            int timeToSleep = timeAllowed - timeSpent;
            if (timeToSleep <= 0) continue;
            try {
                Thread.sleep(timeToSleep);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.viewer.requestRepaintAndWait();
    }

    void initializeMoveTo() {
        if (this.aaMoveTo != null) {
            return;
        }
        this.aaMoveTo = new AxisAngle4f();
        this.aaStep = new AxisAngle4f();
        this.aaTotal = new AxisAngle4f();
        this.matrixStart = new Matrix3f();
        this.matrixEnd = new Matrix3f();
        this.matrixStep = new Matrix3f();
        this.matrixInverse = new Matrix3f();
        this.aaStepCenter = new Vector3f();
    }

    void moveTo(float floatSecondsTotal, Point3f center, Point3f pt, float degrees, float zoom, float xTrans, float yTrans, float newRotationRadius) {
        Vector3f axis = new Vector3f(pt);
        this.initializeMoveTo();
        if (Float.isNaN(degrees)) {
            this.getRotation(this.matrixEnd);
        } else if (degrees < 0.01f && degrees > -0.01f) {
            this.matrixEnd.setIdentity();
        } else {
            if (axis.x == 0.0f && axis.y == 0.0f && axis.z == 0.0f) {
                int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
                if (sleepTime > 0) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                return;
            }
            this.aaMoveTo.set(axis, degrees * (float)Math.PI / 180.0f);
            this.matrixEnd.set(this.aaMoveTo);
        }
        this.moveTo(floatSecondsTotal, null, center, zoom, xTrans, yTrans, newRotationRadius);
    }

    void moveTo(float floatSecondsTotal, Matrix3f end, Point3f center, float zoom, float xTrans, float yTrans, float newRotationRadius) {
        this.initializeMoveTo();
        if (end != null) {
            this.matrixEnd.set(end);
        }
        this.ptCenter = center == null ? this.fixedRotationCenter : center;
        float startRotationRadius = this.rotationRadius;
        float targetRotationRadius = center == null ? this.rotationRadius : (newRotationRadius <= 0.0f ? this.viewer.calcRotationRadius(center) : newRotationRadius);
        float startPixelScale = this.scaleDefaultPixelsPerAngstrom;
        float targetPixelScale = center == null ? startPixelScale : this.defaultScaleToScreen(targetRotationRadius);
        this.getRotation(this.matrixStart);
        this.matrixInverse.invert(this.matrixStart);
        this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
        this.aaTotal.set(this.matrixStep);
        int fps = 30;
        int totalSteps = (int)(floatSecondsTotal * (float)fps);
        this.viewer.setInMotion(true);
        if (totalSteps > 1) {
            int frameTimeMillis = 1000 / fps;
            long targetTime = System.currentTimeMillis();
            float zoomStart = this.zoomPercent;
            float zoomDelta = zoom - zoomStart;
            float xTransStart = this.getTranslationXPercent();
            float xTransDelta = xTrans - xTransStart;
            float yTransStart = this.getTranslationYPercent();
            float yTransDelta = yTrans - yTransStart;
            this.aaStepCenter.set(this.ptCenter);
            this.aaStepCenter.sub(this.fixedRotationCenter);
            this.aaStepCenter.scale(1.0f / (float)totalSteps);
            float pixelScaleDelta = targetPixelScale - startPixelScale;
            float rotationRadiusDelta = targetRotationRadius - startRotationRadius;
            for (int iStep = 1; iStep < totalSteps; ++iStep) {
                this.getRotation(this.matrixStart);
                this.matrixInverse.invert(this.matrixStart);
                this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
                this.aaTotal.set(this.matrixStep);
                this.aaStep.set(this.aaTotal);
                this.aaStep.angle /= (float)(totalSteps - iStep);
                if (this.aaStep.angle == 0.0f) {
                    this.matrixStep.setIdentity();
                } else {
                    this.matrixStep.set(this.aaStep);
                }
                this.matrixStep.mul(this.matrixStart);
                float fStep = (float)iStep / ((float)totalSteps - 1.0f);
                this.rotationRadius = startRotationRadius + rotationRadiusDelta * fStep;
                this.scaleDefaultPixelsPerAngstrom = startPixelScale + pixelScaleDelta * fStep;
                this.zoomToPercent(zoomStart + zoomDelta * fStep);
                this.translateToXPercent(xTransStart + xTransDelta * fStep);
                this.translateToYPercent(yTransStart + yTransDelta * fStep);
                this.setRotation(this.matrixStep);
                if (center != null) {
                    this.fixedRotationCenter.add(this.aaStepCenter);
                }
                if (System.currentTimeMillis() >= (targetTime += (long)frameTimeMillis)) continue;
                this.viewer.requestRepaintAndWait();
                if (this.viewer.isScriptExecuting()) {
                    int sleepTime = (int)(targetTime - System.currentTimeMillis());
                    if (sleepTime <= 0) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        } else {
            int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
            if (sleepTime > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.rotationRadius = targetRotationRadius;
        this.scaleDefaultPixelsPerAngstrom = targetPixelScale;
        if (center != null) {
            this.moveRotationCenter(center, !this.windowCentered);
        }
        this.zoomToPercent(zoom);
        this.translateToXPercent(xTrans);
        this.translateToYPercent(yTrans);
        this.setRotation(this.matrixEnd);
        this.viewer.setInMotion(false);
    }

    String getMoveToText(float timespan) {
        this.axisangleT.set(this.matrixRotate);
        float degrees = this.axisangleT.angle * 57.29578f;
        StringBuffer sb = new StringBuffer();
        sb.append("moveto " + timespan);
        if (degrees < 0.01f) {
            sb.append(" {0 0 1 0}");
        } else {
            this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
            this.vectorT.normalize();
            this.vectorT.scale(1000.0f);
            sb.append(" {");
            TransformManager.truncate0(sb, this.vectorT.x);
            TransformManager.truncate0(sb, this.vectorT.y);
            TransformManager.truncate0(sb, this.vectorT.z);
            TransformManager.truncate1(sb, degrees);
            sb.append("}");
        }
        float tX = this.getTranslationXPercent();
        float tY = this.getTranslationYPercent();
        if (this.zoomPercent != 100.0f || tX != 0.0f || tY != 0.0f) {
            TransformManager.truncate1(sb, this.zoomPercent);
            if (tX != 0.0f || tY != 0.0f) {
                TransformManager.truncate1(sb, tX);
                TransformManager.truncate1(sb, tY);
            }
        }
        sb.append(" ");
        sb.append(this.getCenterText());
        TransformManager.truncate1(sb, this.rotationRadius);
        return "" + sb + ";";
    }

    String getCenterText() {
        return StateManager.encloseCoord(this.fixedRotationCenter);
    }

    String getMoveToText() {
        return this.getMoveToText(1.0f);
    }

    String getRotateXyzText() {
        float tY;
        float tX;
        float rZ;
        float rX;
        StringBuffer sb = new StringBuffer();
        float m20 = this.matrixRotate.m20;
        float rY = -((float)Math.asin(m20)) * 57.29578f;
        if (m20 > 0.999f || m20 < -0.999f) {
            rX = -((float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11)) * 57.29578f;
            rZ = 0.0f;
        } else {
            rX = (float)Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29578f;
            rZ = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29578f;
        }
        sb.append("reset");
        sb.append(";center " + this.getCenterText());
        if (rX != 0.0f) {
            sb.append("; rotate x");
            TransformManager.truncate1(sb, rX);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate1(sb, rY);
        }
        if (rZ != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ);
        }
        sb.append(";");
        if (this.zoomPercent != 100.0f) {
            sb.append(" zoom ");
            TransformManager.truncate1(sb, this.zoomPercent);
            sb.append(";");
        }
        if ((tX = this.getTranslationXPercent()) != 0.0f) {
            sb.append(" translate x ");
            sb.append(tX);
            sb.append(";");
        }
        if ((tY = this.getTranslationYPercent()) != 0.0f) {
            sb.append(" translate y ");
            sb.append(tY);
            sb.append(";");
        }
        return "" + sb;
    }

    String getRotateZyzText(boolean iAddComment) {
        int tY;
        int tX;
        float rZ2;
        float rZ1;
        StringBuffer sb = new StringBuffer();
        float m22 = this.matrixRotate.m22;
        float rY = (float)Math.acos(m22) * 57.29578f;
        if (m22 > 0.999f || m22 < -0.999f) {
            rZ1 = (float)Math.atan2(this.matrixRotate.m10, this.matrixRotate.m11) * 57.29578f;
            rZ2 = 0.0f;
        } else {
            rZ1 = (float)Math.atan2(this.matrixRotate.m21, -this.matrixRotate.m20) * 57.29578f;
            rZ2 = (float)Math.atan2(this.matrixRotate.m12, this.matrixRotate.m02) * 57.29578f;
        }
        if (rZ1 != 0.0f && rY != 0.0f && rZ2 != 0.0f && iAddComment) {
            sb.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        sb.append("reset");
        sb.append(";center " + this.getCenterText());
        if (rZ1 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ1);
        }
        if (rY != 0.0f) {
            sb.append("; rotate y");
            TransformManager.truncate1(sb, rY);
        }
        if (rZ2 != 0.0f) {
            sb.append("; rotate z");
            TransformManager.truncate1(sb, rZ2);
        }
        if (this.zoomPercent != 100.0f) {
            sb.append("; zoom");
            TransformManager.truncate1(sb, this.zoomPercent);
        }
        if ((tX = (int)this.getTranslationXPercent()) != 0) {
            sb.append("; translate x ");
            sb.append(tX);
        }
        if ((tY = (int)this.getTranslationYPercent()) != 0) {
            sb.append("; translate y ");
            sb.append(tY);
        }
        sb.append(';');
        return "" + sb;
    }

    static void truncate0(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append(Math.round(val));
    }

    static void truncate1(StringBuffer sb, float val) {
        sb.append(' ');
        sb.append((float)Math.round(val * 10.0f) / 10.0f);
    }

    void setSpinX(float degrees) {
        this.spinX = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinY(float degrees) {
        this.spinY = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinZ(float degrees) {
        this.spinZ = degrees;
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 50) {
            value = 50;
        }
        this.spinFps = value;
    }

    void clearSpin() {
        this.setSpinOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    void setSpinOn(boolean spinOn) {
        this.setSpinOn(spinOn, Float.MAX_VALUE);
    }

    void setSpinOn(boolean spinOn, float endDegrees) {
        this.spinOn = spinOn;
        if (spinOn) {
            if (this.spinThread == null) {
                this.spinThread = new SpinThread(endDegrees);
                this.spinThread.start();
            }
        } else if (this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationPeriod(float period) {
        if (period <= 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
            this.clearVibration();
        } else {
            this.vibrationPeriod = period;
            this.vibrationPeriodMs = (int)(period * 1000.0f);
            this.setVibrationOn(this.viewer.modelHasVibrationVectors(this.viewer.getCurrentModelIndex()));
        }
    }

    void setVibrationT(float t) {
        this.vibrationRadians = t * ((float)Math.PI * 2);
        this.vibrationAmplitude = (float)Math.cos(this.vibrationRadians) * this.vibrationScale;
    }

    void setVectorScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vectorScale = scale;
        }
    }

    void setVibrationScale(float scale) {
        if (scale >= -10.0f && scale <= 10.0f) {
            this.vibrationScale = scale;
        }
    }

    private void setVibrationOn(boolean vibrationOn) {
        if (!vibrationOn || !this.viewer.haveFrame()) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = new VibrationThread();
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    void clearVibration() {
        this.setVibrationOn(false);
    }

    void setStereoMode(int[] twoColors) {
        this.stereoMode = 5;
        this.stereoColors = twoColors;
    }

    void setStereoMode(int stereoMode) {
        this.stereoColors = null;
        this.stereoMode = stereoMode;
    }

    void setStereoDegrees(float stereoDegrees) {
        this.stereoDegrees = stereoDegrees;
        this.stereoRadians = stereoDegrees * ((float)Math.PI / 180);
    }

    synchronized Matrix3f getStereoRotationMatrix(boolean stereoFrame) {
        this.stereoFrame = stereoFrame;
        if (stereoFrame) {
            this.matrixTemp3.rotY(this.axesOrientationRasmol ? this.stereoRadians : -this.stereoRadians);
            this.matrixStereo.mul(this.matrixTemp3, this.matrixRotate);
        } else {
            this.matrixStereo.set(this.matrixRotate);
        }
        return this.matrixStereo;
    }

    boolean isWindowCentered() {
        return this.windowCentered;
    }

    void setWindowCentered(boolean TF) {
        this.windowCentered = TF;
    }

    void setDefaultRotation() {
        this.rotationCenterDefault = this.viewer.getBoundBoxCenter();
        this.setFixedRotationCenter(this.rotationCenterDefault);
        this.rotationRadius = this.rotationRadiusDefault = this.viewer.calcRotationRadius(this.rotationCenterDefault);
        this.windowCentered = true;
    }

    Point3f getRotationCenter() {
        return this.fixedRotationCenter;
    }

    float getRotationRadius() {
        return this.rotationRadius;
    }

    private void setRotationCenterAndRadiusXYZ(Point3f newCenterOfRotation, boolean andRadius) {
        if (newCenterOfRotation == null) {
            this.setFixedRotationCenter(this.rotationCenterDefault);
            this.rotationRadius = this.rotationRadiusDefault;
            return;
        }
        this.setFixedRotationCenter(newCenterOfRotation);
        if (andRadius && this.windowCentered) {
            this.rotationRadius = this.viewer.calcRotationRadius(this.fixedRotationCenter);
        }
    }

    private void setRotationCenterAndRadiusXYZ(String relativeTo, Point3f pt) {
        Point3f pointT = new Point3f(pt);
        if (relativeTo == "average") {
            pointT.add(this.viewer.getAverageAtomPoint());
        } else if (relativeTo == "boundbox") {
            pointT.add(this.viewer.getBoundBoxCenter());
        } else if (relativeTo != "absolute") {
            pointT.set(this.rotationCenterDefault);
        }
        this.setRotationCenterAndRadiusXYZ(pointT, true);
    }

    void setCenterBitSet(BitSet bsCenter, boolean doScale) {
        Point3f center = bsCenter != null && this.viewer.cardinalityOf(bsCenter) > 0 ? this.viewer.getAtomSetCenter(bsCenter) : this.rotationCenterDefault;
        this.setNewRotationCenter(center, doScale);
    }

    void setNewRotationCenter(Point3f center, boolean doScale) {
        if (this.windowCentered) {
            this.translateToXPercent(0.0f);
            this.translateToYPercent(0.0f);
            this.setRotationCenterAndRadiusXYZ(center, true);
            if (doScale) {
                this.scaleFitToScreen();
            }
        } else {
            this.moveRotationCenter(center, true);
        }
    }

    private void moveRotationCenter(Point3f center, boolean toXY) {
        this.setRotationCenterAndRadiusXYZ(center, false);
        if (toXY) {
            this.setRotationPointXY(this.fixedRotationCenter);
        }
    }

    void setCenter() {
        this.setRotationCenterAndRadiusXYZ(this.fixedRotationCenter, true);
    }

    void setCenter(String relativeTo, Point3f pt) {
        this.setRotationCenterAndRadiusXYZ(relativeTo, pt);
        this.scaleFitToScreen();
    }

    class VibrationThread
    extends Thread
    implements Runnable {
        VibrationThread() {
        }

        public void run() {
            long startTime;
            long lastRepaintTime = startTime = System.currentTimeMillis();
            try {
                do {
                    long currentTime;
                    int elapsed;
                    int sleepTime;
                    if ((sleepTime = 33 - (elapsed = (int)((currentTime = System.currentTimeMillis()) - lastRepaintTime))) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    lastRepaintTime = currentTime = System.currentTimeMillis();
                    elapsed = (int)(currentTime - startTime);
                    float t = (float)(elapsed % TransformManager.this.vibrationPeriodMs) / (float)TransformManager.this.vibrationPeriodMs;
                    TransformManager.this.setVibrationT(t);
                    TransformManager.this.viewer.refresh(0, "TransformationManager:VibrationThread:run()");
                } while (!this.isInterrupted());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    class SpinThread
    extends Thread
    implements Runnable {
        float endDegrees;
        float nDegrees = 0.0f;

        SpinThread(float endDegrees) {
            this.endDegrees = Math.abs(endDegrees);
        }

        public void run() {
            float myFps = TransformManager.this.spinFps;
            TransformManager.this.viewer.setBooleanProperty("isSpinning", true);
            int i = 0;
            long timeBegin = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                int targetTime;
                int sleepTime;
                boolean refreshNeeded;
                if (myFps != TransformManager.this.spinFps) {
                    myFps = TransformManager.this.spinFps;
                    i = 0;
                    timeBegin = System.currentTimeMillis();
                }
                if (myFps == 0.0f || !TransformManager.this.spinOn) {
                    TransformManager.this.setSpinOn(false);
                    return;
                }
                boolean bl = refreshNeeded = TransformManager.this.isSpinInternal && TransformManager.this.internalRotationAxis.angle != 0.0f || TransformManager.this.isSpinFixed && TransformManager.this.fixedRotationAxis != null && TransformManager.this.fixedRotationAxis.angle != 0.0f || !TransformManager.this.isSpinFixed && !TransformManager.this.isSpinInternal && TransformManager.this.spinX + TransformManager.this.spinY + TransformManager.this.spinZ != 0.0f;
                int currentTime = (int)(System.currentTimeMillis() - timeBegin);
                if ((sleepTime = (targetTime = (int)((float)(++i * 1000) / myFps)) - currentTime) <= 0) continue;
                if (refreshNeeded && TransformManager.this.spinOn) {
                    float angle = 0.0f;
                    if (TransformManager.this.isSpinInternal || TransformManager.this.isSpinFixed) {
                        angle = (TransformManager.this.isSpinInternal ? TransformManager.this.internalRotationAxis : TransformManager.this.fixedRotationAxis).angle / myFps;
                        if (TransformManager.this.isSpinInternal) {
                            TransformManager.this.rotateAxisAngleRadiansInternal(angle);
                        } else {
                            TransformManager.this.rotateAxisAngleRadiansFixed(angle);
                        }
                        this.nDegrees += Math.abs(angle / ((float)Math.PI * 2) * 360.0f);
                    } else {
                        if (TransformManager.this.spinX != 0.0f) {
                            TransformManager.this.rotateXRadians(TransformManager.this.spinX * ((float)Math.PI / 180) / myFps);
                        }
                        if (TransformManager.this.spinY != 0.0f) {
                            TransformManager.this.rotateYRadians(TransformManager.this.spinY * ((float)Math.PI / 180) / myFps);
                        }
                        if (TransformManager.this.spinZ != 0.0f) {
                            TransformManager.this.rotateZRadians(TransformManager.this.spinZ * ((float)Math.PI / 180) / myFps);
                        }
                    }
                    TransformManager.this.viewer.refresh(1, "TransformationManager:SpinThread:run()");
                    if ((double)this.nDegrees >= (double)this.endDegrees - 1.0E-5) {
                        TransformManager.this.setSpinOn(false);
                    }
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            TransformManager.this.viewer.setBooleanProperty("isSpinning", false);
        }
    }
}

