/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.vecmath.Point3fi;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Viewer;

public final class Atom
extends Point3fi
implements Tuple {
    static final byte VIBRATION_VECTOR_FLAG = 2;
    static final byte IS_HETERO_FLAG = 4;
    static final byte FORMALCHARGE_FLAGS = 7;
    Group group;
    int atomIndex;
    BitSet atomSymmetry;
    int atomSite;
    short screenDiameter;
    short modelIndex;
    private short atomicAndIsotopeNumber;
    byte formalChargeAndFlags;
    byte alternateLocationID;
    short madAtom;
    short colixAtom;
    short paletteID = 1;
    Bond[] bonds;
    int nBondsDisplayed = 0;
    int nBackbonesDisplayed = 0;
    int clickabilityFlags;
    int shapeVisibilityFlags;
    boolean isSimple = false;
    private static Hashtable htAtom = new Hashtable();

    Atom(Point3f pt) {
        this.isSimple = true;
        ((Tuple3f)this).x = pt.x;
        ((Tuple3f)this).y = pt.y;
        ((Tuple3f)this).z = pt.z;
        this.formalChargeAndFlags = 0;
        this.madAtom = 0;
    }

    Atom(Viewer viewer, Frame frame, int modelIndex, int atomIndex, BitSet atomSymmetry, int atomSite, short atomicAndIsotopeNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, String group3, float vibrationX, float vibrationY, float vibrationZ, char alternateLocationID, Object clientAtomReference) {
        byte specialAtomID;
        this.modelIndex = (short)modelIndex;
        this.atomSymmetry = atomSymmetry;
        this.atomSite = atomSite;
        this.atomIndex = atomIndex;
        this.atomicAndIsotopeNumber = atomicAndIsotopeNumber;
        this.setFormalCharge(formalCharge);
        this.colixAtom = viewer.getColixAtomPalette(this, 1);
        this.alternateLocationID = (byte)alternateLocationID;
        this.setMadAtom(viewer.getMadAtom());
        ((Tuple3f)this).x = x;
        ((Tuple3f)this).y = y;
        ((Tuple3f)this).z = z;
        if (isHetero) {
            this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 4);
        }
        if (atomName != null) {
            if (frame.atomNames == null) {
                frame.atomNames = new String[frame.atoms.length];
            }
            frame.atomNames[atomIndex] = atomName.intern();
        }
        if ((specialAtomID = this.lookupSpecialAtomID(atomName)) == 2 && group3.equalsIgnoreCase("CA")) {
            specialAtomID = 0;
        }
        if (specialAtomID != 0) {
            if (frame.specialAtomIDs == null) {
                frame.specialAtomIDs = new byte[frame.atoms.length];
            }
            frame.specialAtomIDs[atomIndex] = specialAtomID;
        }
        if (occupancy < 0) {
            occupancy = 0;
        } else if (occupancy > 100) {
            occupancy = 100;
        }
        if (occupancy != 100) {
            if (frame.occupancies == null) {
                frame.occupancies = new byte[frame.atoms.length];
            }
            frame.occupancies[atomIndex] = (byte)occupancy;
        }
        if (atomSerial != Integer.MIN_VALUE) {
            if (frame.atomSerials == null) {
                frame.atomSerials = new int[frame.atoms.length];
            }
            frame.atomSerials[atomIndex] = atomSerial;
        }
        if (!Float.isNaN(partialCharge)) {
            if (frame.partialCharges == null) {
                frame.partialCharges = new float[frame.atoms.length];
            }
            frame.partialCharges[atomIndex] = partialCharge;
        }
        if (!Float.isNaN(bfactor) && bfactor != 0.0f) {
            if (frame.bfactor100s == null) {
                frame.bfactor100s = new short[frame.atoms.length];
            }
            frame.bfactor100s[atomIndex] = (short)(bfactor * 100.0f);
        }
        if (!(Float.isNaN(vibrationX) || Float.isNaN(vibrationY) || Float.isNaN(vibrationZ))) {
            if (frame.vibrationVectors == null) {
                frame.vibrationVectors = new Vector3f[frame.atoms.length];
            }
            frame.vibrationVectors[atomIndex] = new Vector3f(vibrationX, vibrationY, vibrationZ);
            this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 2);
        }
        if (clientAtomReference != null) {
            if (frame.clientAtomReferences == null) {
                frame.clientAtomReferences = new Object[frame.atoms.length];
            }
            frame.clientAtomReferences[atomIndex] = clientAtomReference;
        }
    }

    final void setShapeVisibility(int shapeVisibilityFlag, boolean isVisible) {
        this.shapeVisibilityFlags = isVisible ? (this.shapeVisibilityFlags |= shapeVisibilityFlag) : (this.shapeVisibilityFlags &= ~shapeVisibilityFlag);
    }

    void setFormalCharge(int charge) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 7 | charge << 3);
    }

    void setGroup(Group group) {
        this.group = group;
    }

    boolean isBonded(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i].getOtherAtom(this) != atomOther) continue;
                return true;
            }
        }
        return false;
    }

    Bond getBond(Atom atomOther) {
        if (this.bonds != null) {
            int i = this.bonds.length;
            while (--i >= 0) {
                if (this.bonds[i].getOtherAtom(atomOther) == null) continue;
                return this.bonds[i];
            }
        }
        return null;
    }

    void addDisplayedBond(int stickVisibilityFlag, boolean isVisible) {
        this.nBondsDisplayed += isVisible ? 1 : -1;
        this.setShapeVisibility(stickVisibilityFlag, isVisible);
    }

    void addDisplayedBackbone(int backboneVisibilityFlag, boolean isVisible) {
        this.nBackbonesDisplayed += isVisible ? 1 : -1;
        this.setShapeVisibility(backboneVisibilityFlag, isVisible);
    }

    void deleteBond(Bond bond) {
        int i = this.bonds.length;
        while (--i >= 0) {
            if (this.bonds[i] != bond) continue;
            this.deleteBond(i);
            return;
        }
    }

    private void deleteBond(int i) {
        int j;
        int newLength = this.bonds.length - 1;
        if (newLength == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondsNew = new Bond[newLength];
        for (j = 0; j < i; ++j) {
            bondsNew[j] = this.bonds[j];
        }
        while (j < newLength) {
            bondsNew[j] = this.bonds[j + 1];
            ++j;
        }
        this.bonds = bondsNew;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int bondIndex) {
        return this.bonds[bondIndex].getOtherAtom((Atom)this).atomIndex;
    }

    void setMadAtom(short madAtom) {
        if (this.madAtom == Short.MIN_VALUE) {
            return;
        }
        this.madAtom = this.convertEncodedMad(madAtom);
    }

    short convertEncodedMad(int size) {
        if (size == 0) {
            return 0;
        }
        if (size == -1000) {
            int diameter = this.getBfactor100() * 10 * 2;
            if (diameter > 4000) {
                diameter = 4000;
            }
            size = diameter;
        } else if (size == -1001) {
            size = this.getBondingMar() * 2;
        } else if (size < 0) {
            if ((size = -size) > 200) {
                size = 200;
            }
            size = (int)((float)size / 100.0f * (float)this.getVanderwaalsMar() * 2.0f);
        } else if (size >= 10000) {
            size = size - 10000 + this.getVanderwaalsMar() * 2;
        }
        return (short)size;
    }

    int getRasMolRadius() {
        if (this.madAtom == Short.MIN_VALUE) {
            return 0;
        }
        return this.madAtom / 8;
    }

    int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if ((this.bonds[i].order & 3) == 0) continue;
            ++n;
        }
        return n;
    }

    int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int i = this.bonds.length;
        while (--i >= 0) {
            if ((this.bonds[i].order & 3) == 0 || this.bonds[i].getOtherAtom(this).getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    Bond[] getBonds() {
        return this.bonds;
    }

    void setColixAtom(short colixAtom) {
        this.colixAtom = colixAtom;
    }

    void setPaletteID(short paletteID) {
        this.paletteID = paletteID;
    }

    void setTranslucent(boolean isTranslucent) {
        this.colixAtom = Graphics3D.setTranslucent((short)this.colixAtom, (boolean)isTranslucent);
    }

    boolean isTranslucent() {
        return Graphics3D.isColixTranslucent((short)this.colixAtom);
    }

    Vector3f getVibrationVector() {
        if (this.group == null) {
            return null;
        }
        Vector3f[] vibrationVectors = this.group.chain.frame.vibrationVectors;
        return vibrationVectors == null ? null : vibrationVectors[this.atomIndex];
    }

    void setLabel(String strLabel) {
        if (this.group == null) {
            return;
        }
        this.group.chain.frame.setLabel(strLabel, this.atomIndex);
    }

    /*
     * Unable to fully structure code
     */
    void transform(Viewer viewer) {
        if ((this.formalChargeAndFlags & 2) == 0) ** GOTO lbl-1000
        vibrationVectors = this.group.chain.frame.vibrationVectors;
        if (this.group.chain.frame.vibrationVectors == null) lbl-1000:
        // 2 sources

        {
            screen = viewer.transformPoint((Point3f)this);
        } else {
            screen = viewer.transformPoint((Point3f)this, vibrationVectors[this.atomIndex]);
        }
        this.screenX = screen.x;
        this.screenY = screen.y;
        this.screenZ = screen.z;
        this.screenDiameter = viewer.scaleToScreen(this.screenZ, this.madAtom);
    }

    short getElementNumber() {
        return (short)(this.atomicAndIsotopeNumber % 128);
    }

    short getIsotopeNumber() {
        return (short)(this.atomicAndIsotopeNumber >> 7);
    }

    short getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    String getElementSymbol() {
        return JmolConstants.elementSymbolFromNumber(this.atomicAndIsotopeNumber);
    }

    String getAtomNameOrNull() {
        if (this.group == null) {
            return null;
        }
        String[] atomNames = this.group.chain.frame.atomNames;
        return atomNames == null ? null : atomNames[this.atomIndex];
    }

    String getAtomName() {
        String atomName = this.getAtomNameOrNull();
        return atomName != null ? atomName : this.getElementSymbol();
    }

    String getPdbAtomName4() {
        String atomName = this.getAtomNameOrNull();
        return atomName != null ? atomName : "";
    }

    String getGroup3() {
        if (this.group == null) {
            return null;
        }
        return this.group.getGroup3();
    }

    String getGroup1() {
        if (this.group == null) {
            return null;
        }
        return this.group.getGroup1();
    }

    boolean isGroup3(String group3) {
        if (this.group == null) {
            return false;
        }
        return this.group.isGroup3(group3);
    }

    boolean isGroup3Match(String strWildcard) {
        if (this.group == null) {
            return false;
        }
        return this.group.isGroup3Match(strWildcard);
    }

    int getSeqcode() {
        if (this.group == null) {
            return -1;
        }
        return this.group.getSeqcode();
    }

    int getResno() {
        if (this.group == null) {
            return -1;
        }
        return this.group.getResno();
    }

    boolean isGroup3OrNameMatch(String strPattern) {
        return this.getGroup3().length() > 0 ? this.isGroup3Match(strPattern) : this.isAtomNameMatch(strPattern);
    }

    boolean isAtomNameMatch(String strPattern) {
        int ich;
        String atomName = this.getAtomNameOrNull();
        int cchAtomName = atomName == null ? 0 : atomName.length();
        int cchPattern = strPattern.length();
        for (ich = 0; ich < cchPattern; ++ich) {
            char charWild = strPattern.charAt(ich);
            if (charWild == '?' || ich < cchAtomName && charWild == Character.toUpperCase(atomName.charAt(ich))) continue;
            return false;
        }
        return ich >= cchAtomName;
    }

    boolean isAlternateLocationMatch(String strPattern) {
        if (strPattern == null) {
            return this.alternateLocationID == 0;
        }
        if (strPattern.length() != 1) {
            return false;
        }
        char ch = strPattern.charAt(0);
        return ch == '*' || ch == '?' && this.alternateLocationID != 0 || this.alternateLocationID == ch;
    }

    int getAtomNumber() {
        if (this.group == null) {
            return 1;
        }
        int[] atomSerials = this.group.chain.frame.atomSerials;
        if (atomSerials != null) {
            return atomSerials[this.atomIndex];
        }
        if (this.group.chain.frame.isZeroBased) {
            return this.atomIndex;
        }
        return this.atomIndex + 1;
    }

    boolean isHetero() {
        return (this.formalChargeAndFlags & 4) != 0;
    }

    int getFormalCharge() {
        return this.formalChargeAndFlags >> 3;
    }

    boolean isClickable() {
        if (!this.isModelVisible()) {
            return false;
        }
        int flags = this.shapeVisibilityFlags;
        if (this.group != null) {
            flags |= this.group.shapeVisibilityFlags;
        }
        return (flags & this.clickabilityFlags) != 0;
    }

    boolean isVisible() {
        if (!this.isModelVisible() || this.group.chain.frame.bsHidden.get(this.atomIndex)) {
            return false;
        }
        int flags = this.shapeVisibilityFlags;
        if (this.group != null) {
            flags |= this.group.shapeVisibilityFlags;
        }
        return (flags & 0xFFFFFFFE) != 0;
    }

    boolean isModelVisible() {
        return (this.shapeVisibilityFlags & 1) != 0;
    }

    boolean isShapeVisible(int shapeVisibilityFlag) {
        return this.isModelVisible() && (this.shapeVisibilityFlags & shapeVisibilityFlag) != 0;
    }

    float getPartialCharge() {
        if (this.group == null) {
            return 0.0f;
        }
        float[] partialCharges = this.group.chain.frame.partialCharges;
        return partialCharges == null ? 0.0f : partialCharges[this.atomIndex];
    }

    Point3f getPoint3f() {
        return this;
    }

    float getAtomX() {
        return ((Tuple3f)this).x;
    }

    float getAtomY() {
        return ((Tuple3f)this).y;
    }

    float getAtomZ() {
        return ((Tuple3f)this).z;
    }

    public float getDimensionValue(int dimension) {
        return dimension == 0 ? ((Tuple3f)this).x : (dimension == 1 ? ((Tuple3f)this).y : ((Tuple3f)this).z);
    }

    short getVanderwaalsMar() {
        return JmolConstants.vanderwaalsMars[this.atomicAndIsotopeNumber % 128];
    }

    float getVanderwaalsRadiusFloat() {
        return (float)JmolConstants.vanderwaalsMars[this.atomicAndIsotopeNumber % 128] / 1000.0f;
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, this.formalChargeAndFlags >> 3);
    }

    float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    Bond getLongestBondToDiscard(Atom atomChallenger) {
        float dist2Longest = this.distanceSquared((Point3f)atomChallenger);
        Bond bondLongest = null;
        int i = this.bonds.length;
        while (--i >= 0) {
            Bond bond = this.bonds[i];
            float dist2 = this.distanceSquared((Point3f)bond.getOtherAtom(this));
            if (!(dist2 > dist2Longest)) continue;
            bondLongest = bond;
            dist2Longest = dist2;
        }
        return bondLongest;
    }

    short getColix() {
        return this.colixAtom;
    }

    short getPaletteID() {
        return this.paletteID;
    }

    int getArgb() {
        return this.group.chain.frame.viewer.getColixArgb(this.colixAtom);
    }

    float getRadius() {
        if (this.madAtom == Short.MIN_VALUE) {
            return 0.0f;
        }
        return (float)this.madAtom / 2000.0f;
    }

    float getGroupPhi() {
        return this.group.phi;
    }

    float getGroupPsi() {
        return this.group.psi;
    }

    char getChainID() {
        if (this.group == null) {
            return '\u0000';
        }
        return this.group.chain.chainID;
    }

    int getOccupancy() {
        if (this.group == null) {
            return 100;
        }
        byte[] occupancies = this.group.chain.frame.occupancies;
        return occupancies == null ? 100 : occupancies[this.atomIndex];
    }

    int getBfactor100() {
        if (this.group == null) {
            return 0;
        }
        short[] bfactor100s = this.group.chain.frame.bfactor100s;
        if (bfactor100s == null) {
            return 0;
        }
        return bfactor100s[this.atomIndex];
    }

    float getSurfaceDistance() {
        if (this.group == null) {
            return -1.0f;
        }
        return this.group.chain.frame.getSurfaceDistance(this.atomIndex);
    }

    Group getGroup() {
        return this.group;
    }

    int getPolymerLength() {
        if (this.group == null) {
            return 0;
        }
        return this.group.getPolymerLength();
    }

    int getPolymerIndex() {
        if (this.group == null) {
            return -1;
        }
        return this.group.getPolymerIndex();
    }

    int getSelectedGroupCountWithinChain() {
        if (this.group == null) {
            return 0;
        }
        return this.group.chain.getSelectedGroupCount();
    }

    int getSelectedGroupIndexWithinChain() {
        if (this.group == null) {
            return -1;
        }
        return this.group.chain.getSelectedGroupIndex(this.group);
    }

    int getSelectedMonomerCountWithinPolymer() {
        if (this.group instanceof Monomer) {
            return ((Monomer)this.group).polymer.selectedMonomerCount;
        }
        return 0;
    }

    int getSelectedMonomerIndexWithinPolymer() {
        if (this.group instanceof Monomer) {
            Monomer monomer = (Monomer)this.group;
            return monomer.polymer.getSelectedMonomerIndex(monomer);
        }
        return -1;
    }

    int getAtomIndex() {
        return this.atomIndex;
    }

    int getAtomSite() {
        return this.atomSite;
    }

    BitSet getAtomSymmetry() {
        return this.atomSymmetry;
    }

    int getSymmetryTranslation(int symop) {
        Frame.CellInfo[] c = this.group.chain.frame.cellInfos;
        if (c == null) {
            return 0;
        }
        Vector3f pt0 = new Vector3f((Tuple3f)this.getFractionalCoord());
        pt0.sub((Tuple3f)this.group.chain.frame.getSymmetryBaseAtom(this.modelIndex, this.atomSite, symop).getFractionalCoord());
        return (int)((double)pt0.x + 5.01) * 100 + (int)((double)pt0.y + 5.01) * 10 + (int)((double)pt0.z + 5.01);
    }

    String getSymmetryOperatorList() {
        String str = "";
        if (this.atomSymmetry == null) {
            return str;
        }
        for (int i = 0; i < this.atomSymmetry.size(); ++i) {
            if (!this.atomSymmetry.get(i)) continue;
            str = str + "," + (i + 1);
        }
        return str.substring(1);
    }

    Chain getChain() {
        if (this.group == null) {
            return null;
        }
        return this.group.chain;
    }

    Model getModel() {
        if (this.group == null) {
            return null;
        }
        return this.group.chain.model;
    }

    int getModelIndex() {
        return this.modelIndex;
    }

    int getModelNumber() {
        return this.modelIndex + 1;
    }

    String getClientAtomStringProperty(String propertyName) {
        if (this.group == null) {
            return null;
        }
        Object[] clientAtomReferences = this.group.chain.frame.clientAtomReferences;
        return clientAtomReferences == null || clientAtomReferences.length <= this.atomIndex ? null : this.group.chain.frame.viewer.getClientAtomStringProperty(clientAtomReferences[this.atomIndex], propertyName);
    }

    boolean isDeleted() {
        return this.madAtom == Short.MIN_VALUE;
    }

    byte getProteinStructureType() {
        if (this.group == null) {
            return 0;
        }
        return this.group.getProteinStructureType();
    }

    short getGroupID() {
        if (this.group == null) {
            return -1;
        }
        return this.group.groupID;
    }

    String getSeqcodeString() {
        if (this.group == null) {
            return null;
        }
        return this.group.getSeqcodeString();
    }

    int getSeqNumber() {
        if (this.group == null) {
            return 0;
        }
        return this.group.getSeqNumber();
    }

    char getInsertionCode() {
        if (this.group == null) {
            return '\u0000';
        }
        return this.group.getInsertionCode();
    }

    String getModelTag() {
        if (this.group == null) {
            return null;
        }
        return this.group.chain.model.modelTag;
    }

    int getModelTagNumber() {
        if (this.group == null) {
            return 0;
        }
        if (this.group.chain.model.isPDB) {
            try {
                return Integer.parseInt(this.group.chain.model.modelTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getModelNumber();
    }

    byte getSpecialAtomID() {
        if (this.group == null) {
            return 0;
        }
        byte[] specialAtomIDs = this.group.chain.frame.specialAtomIDs;
        return specialAtomIDs == null ? (byte)0 : specialAtomIDs[this.atomIndex];
    }

    void demoteSpecialAtomImposter() {
        if (this.group == null) {
            return;
        }
        this.group.chain.frame.specialAtomIDs[this.atomIndex] = 0;
    }

    static String generateStarredAtomName(String primedAtomName) {
        int primeIndex = primedAtomName.indexOf(39);
        if (primeIndex < 0) {
            return null;
        }
        return primedAtomName.replace('\'', '*');
    }

    static String generatePrimeAtomName(String starredAtomName) {
        int starIndex = starredAtomName.indexOf(42);
        if (starIndex < 0) {
            return starredAtomName;
        }
        return starredAtomName.replace('*', '\'');
    }

    byte lookupSpecialAtomID(String atomName) {
        Integer boxedAtomID;
        if (atomName != null && (boxedAtomID = (Integer)htAtom.get(atomName = Atom.generatePrimeAtomName(atomName))) != null) {
            return (byte)boxedAtomID.intValue();
        }
        return 0;
    }

    String formatLabel(String strFormat) {
        int ichPercent;
        if (strFormat == null || strFormat.equals("")) {
            return null;
        }
        String strLabel = "";
        int ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) != -1) {
            if (ich != ichPercent) {
                strLabel = strLabel + strFormat.substring(ich, ichPercent);
            }
            ich = ichPercent + 1;
            try {
                char ch;
                String strT = "";
                float floatT = 0.0f;
                boolean floatIsSet = false;
                boolean alignLeft = false;
                if (strFormat.charAt(ich) == '-') {
                    alignLeft = true;
                    ++ich;
                }
                boolean zeroPad = false;
                if (strFormat.charAt(ich) == '0') {
                    zeroPad = true;
                    ++ich;
                }
                int width = 0;
                while ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                    width = 10 * width + (ch - 48);
                    ++ich;
                }
                int precision = -1;
                if (strFormat.charAt(ich) == '.' && (ch = strFormat.charAt(++ich)) >= '0' && ch <= '9') {
                    precision = ch - 48;
                }
                int n = ++ich;
                ++ich;
                ch = strFormat.charAt(n);
                switch (ch) {
                    case 'i': {
                        strT = "" + this.getAtomNumber();
                        break;
                    }
                    case 'A': {
                        strT = this.alternateLocationID != 0 ? (char)this.alternateLocationID + "" : "";
                        break;
                    }
                    case 'a': {
                        strT = this.getAtomName();
                        break;
                    }
                    case 'e': {
                        strT = this.getElementSymbol();
                        break;
                    }
                    case 'x': {
                        floatT = ((Tuple3f)this).x;
                        floatIsSet = true;
                        break;
                    }
                    case 'y': {
                        floatT = ((Tuple3f)this).y;
                        floatIsSet = true;
                        break;
                    }
                    case 'z': {
                        floatT = ((Tuple3f)this).z;
                        floatIsSet = true;
                        break;
                    }
                    case 'X': 
                    case 'Y': 
                    case 'Z': {
                        floatT = this.getFractionalCoord(ch);
                        floatIsSet = true;
                        break;
                    }
                    case 'D': {
                        strT = "" + this.atomIndex;
                        break;
                    }
                    case 'C': {
                        int formalCharge = this.getFormalCharge();
                        if (formalCharge > 0) {
                            strT = "" + formalCharge + "+";
                            break;
                        }
                        if (formalCharge < 0) {
                            strT = "" + -formalCharge + "-";
                            break;
                        }
                        strT = "0";
                        break;
                    }
                    case 'o': {
                        strT = this.getSymmetryOperatorList();
                        break;
                    }
                    case 'P': {
                        floatT = this.getPartialCharge();
                        floatIsSet = true;
                        break;
                    }
                    case 'V': {
                        floatT = this.getVanderwaalsRadiusFloat();
                        floatIsSet = true;
                        break;
                    }
                    case 'I': {
                        floatT = this.getBondingRadiusFloat();
                        floatIsSet = true;
                        break;
                    }
                    case 'b': 
                    case 't': {
                        floatT = (float)this.getBfactor100() / 100.0f;
                        floatIsSet = true;
                        break;
                    }
                    case 'q': {
                        strT = "" + this.getOccupancy();
                        break;
                    }
                    case 'c': 
                    case 's': {
                        strT = "" + this.getChainID();
                        break;
                    }
                    case 'S': {
                        strT = "" + this.atomSite;
                        break;
                    }
                    case 'L': {
                        strT = "" + this.getPolymerLength();
                        break;
                    }
                    case 'M': {
                        strT = "" + this.getModelTagNumber();
                        break;
                    }
                    case 'm': {
                        strT = this.getGroup1();
                        break;
                    }
                    case 'n': {
                        strT = this.getGroup3();
                        break;
                    }
                    case 'r': {
                        strT = this.getSeqcodeString();
                        break;
                    }
                    case 'U': {
                        strT = this.getIdentity();
                        break;
                    }
                    case 'u': {
                        floatT = this.getSurfaceDistance();
                        floatIsSet = true;
                        break;
                    }
                    case 'N': {
                        strT = "" + this.getMoleculeNumber();
                        break;
                    }
                    case '%': {
                        strT = "%";
                        break;
                    }
                    case '{': {
                        int ichCloseBracket = strFormat.indexOf(125, ich);
                        if (ichCloseBracket > ich) {
                            String propertyName = strFormat.substring(ich, ichCloseBracket);
                            String value = this.getClientAtomStringProperty(propertyName);
                            if (value != null) {
                                strT = value;
                            }
                            ich = ichCloseBracket + 1;
                            break;
                        }
                    }
                    default: {
                        strT = "%" + ch;
                    }
                }
                if (floatIsSet) {
                    strLabel = strLabel + this.format(floatT, width, precision, alignLeft, zeroPad);
                    continue;
                }
                if (strT == null) continue;
                strLabel = strLabel + Atom.format(strT, width, precision, alignLeft, zeroPad);
            }
            catch (IndexOutOfBoundsException ioobe) {
                ich = ichPercent;
                break;
            }
        }
        if ((strLabel = strLabel + strFormat.substring(ich)).length() == 0) {
            return null;
        }
        return strLabel.intern();
    }

    String format(float value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return Atom.format(this.group.chain.frame.viewer.formatDecimal(value, precision), width, 0, alignLeft, zeroPad);
    }

    static String format(String value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        int padLength;
        if (value == null) {
            return "";
        }
        if (precision > value.length()) {
            value = value.substring(0, precision);
        }
        if ((padLength = width - value.length()) <= 0) {
            return value;
        }
        boolean isNeg = zeroPad && !alignLeft && value.charAt(0) == '-';
        char padChar = zeroPad ? (char)'0' : ' ';
        char padChar0 = isNeg ? (char)'-' : padChar;
        StringBuffer sb = new StringBuffer();
        if (alignLeft) {
            sb.append(value);
        }
        sb.append(padChar0);
        int i = padLength;
        while (--i > 0) {
            sb.append(padChar);
        }
        if (!alignLeft) {
            sb.append(isNeg ? padChar + value.substring(1) : value);
        }
        return "" + sb;
    }

    private float getFractionalCoord(char ch) {
        Point3f pt = this.getFractionalCoord();
        return ch == 'X' ? pt.x : (ch == 'Y' ? pt.y : pt.z);
    }

    Point3f getFractionalCoord() {
        Frame.CellInfo[] c = this.group.chain.frame.cellInfos;
        if (c == null) {
            return this;
        }
        Point3f pt = new Point3f((Point3f)this);
        c[this.modelIndex].toFractional(pt);
        return pt;
    }

    boolean isInLatticeCell(Point3f cell) {
        return this.isInLatticeCell(cell, 0.02f);
    }

    boolean isInLatticeCell(Point3f cell, float slop) {
        Point3f pt = this.getFractionalCoord();
        if (pt.x < cell.x - 1.0f - slop || pt.x > cell.x + slop) {
            return false;
        }
        if (pt.y < cell.y - 1.0f - slop || pt.y > cell.y + slop) {
            return false;
        }
        return !(pt.z < cell.z - 1.0f - slop) && !(pt.z > cell.z + slop);
    }

    String getInfo() {
        return this.getIdentity();
    }

    String getInfoXYZ() {
        return this.getIdentity() + " " + ((Tuple3f)this).x + " " + ((Tuple3f)this).y + " " + ((Tuple3f)this).z;
    }

    String getIdentity() {
        String atomName;
        StringBuffer info = new StringBuffer();
        String group3 = this.getGroup3();
        String seqcodeString = this.getSeqcodeString();
        char chainID = this.getChainID();
        if (group3 != null && group3.length() > 0) {
            info.append("[");
            info.append(group3);
            info.append("]");
        }
        if (seqcodeString != null) {
            info.append(seqcodeString);
        }
        if (chainID != '\u0000' && chainID != ' ') {
            info.append(":");
            info.append(chainID);
        }
        if ((atomName = this.getAtomNameOrNull()) != null) {
            if (info.length() > 0) {
                info.append(".");
            }
            info.append(atomName);
        }
        if (info.length() == 0) {
            info.append(this.getElementSymbol());
            info.append(" ");
            info.append(this.getAtomNumber());
        }
        if (this.alternateLocationID > 0) {
            info.append("%");
            info.append((char)this.alternateLocationID);
        }
        if (this.group != null && this.group.chain != null && this.group.chain.frame.getModelCount() > 1) {
            info.append("/");
            info.append(this.getModelTagNumber());
        }
        info.append(" #");
        info.append(this.getAtomNumber());
        return "" + info;
    }

    int getMoleculeNumber() {
        return this.group.chain.frame.getMoleculeIndex(this.atomIndex) + 1;
    }

    boolean isCursorOnTopOfClickableAtom(int xCursor, int yCursor, int minRadius, Atom competitor) {
        return this.isClickable() && this.isCursorOnTop(xCursor, yCursor, minRadius, competitor);
    }

    boolean isCursorOnTop(int xCursor, int yCursor, int minRadius, Atom competitor) {
        int r2;
        int dx;
        int dx2;
        int r = this.screenDiameter / 2;
        if (r < minRadius) {
            r = minRadius;
        }
        if ((dx2 = (dx = this.screenX - xCursor) * dx) > (r2 = r * r)) {
            return false;
        }
        int dy = this.screenY - yCursor;
        int dy2 = dy * dy;
        int dz2 = r2 - (dx2 + dy2);
        if (dz2 < 0) {
            return false;
        }
        if (competitor == null) {
            return true;
        }
        int z = this.screenZ;
        int zCompetitor = competitor.screenZ;
        int rCompetitor = competitor.screenDiameter / 2;
        if (z < zCompetitor - rCompetitor) {
            return true;
        }
        int dxCompetitor = competitor.screenX - xCursor;
        int dx2Competitor = dxCompetitor * dxCompetitor;
        int dyCompetitor = competitor.screenY - yCursor;
        int dy2Competitor = dyCompetitor * dyCompetitor;
        int r2Competitor = rCompetitor * rCompetitor;
        int dz2Competitor = r2Competitor - (dx2Competitor + dy2Competitor);
        return (double)z - Math.sqrt(dz2) < (double)zCompetitor - Math.sqrt(dz2Competitor);
    }

    int getScreenX() {
        return this.screenX;
    }

    int getScreenY() {
        return this.screenY;
    }

    int getScreenZ() {
        return this.screenZ;
    }

    int getScreenD() {
        return this.screenDiameter;
    }

    boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    boolean isNucleic() {
        return this.group.isNucleic();
    }

    boolean isDna() {
        return this.group.isDna();
    }

    boolean isRna() {
        return this.group.isRna();
    }

    boolean isPurine() {
        return this.group.isPurine();
    }

    boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    static {
        int i = JmolConstants.specialAtomNames.length;
        while (--i >= 0) {
            String specialAtomName = JmolConstants.specialAtomNames[i];
            if (specialAtomName == null) continue;
            Integer boxedI = new Integer(i);
            htAtom.put(specialAtomName, boxedI);
        }
    }
}

