/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Viewer;

class Dipole
extends Shape {
    String thisID = "";
    short mad;
    short colix = 0;
    short type;
    Point3f origin;
    Point3f center;
    Vector3f vector;
    String dipoleInfo = "";
    float dipoleValue;
    float offsetSide;
    float offsetAngstroms;
    int offsetPercent;
    int visibilityFlags;
    int modelIndex;
    boolean visible;
    boolean noCross;
    Atom[] atoms = new Atom[2];
    Bond bond;
    static final short DIPOLE_TYPE_UNKNOWN = 0;
    static final short DIPOLE_TYPE_POINTS = 1;
    static final short DIPOLE_TYPE_ATOMS = 2;
    static final short DIPOLE_TYPE_BOND = 3;
    static final short DIPOLE_TYPE_MOLECULAR = 4;
    static final short DIPOLE_TYPE_POINTVECTOR = 5;

    Dipole() {
    }

    Dipole(Viewer viewer, String thisID, String dipoleInfo, Graphics3D g3d, short colix, short mad, boolean visible) {
        this.viewer = viewer;
        this.modelIndex = viewer.getDisplayModelIndex();
        if (this.modelIndex < -1) {
            this.modelIndex = -2 - this.modelIndex;
        }
        this.thisID = thisID;
        this.dipoleInfo = dipoleInfo;
        this.g3d = g3d;
        this.colix = colix;
        this.mad = mad;
        this.visible = visible;
        this.type = 0;
    }

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
    }

    void setTranslucent(boolean isTranslucent) {
        this.colix = Graphics3D.setTranslucent((short)this.colix, (boolean)isTranslucent);
    }

    void set(String thisID, String dipoleInfo, Atom[] atoms, float dipoleValue, short mad, float offsetAngstroms, float offsetSide, Point3f origin, Vector3f vector) {
        this.thisID = thisID;
        this.dipoleInfo = dipoleInfo;
        this.dipoleValue = dipoleValue;
        this.mad = mad;
        this.offsetAngstroms = offsetAngstroms;
        this.offsetSide = offsetSide;
        this.vector = new Vector3f(vector);
        this.origin = new Point3f(origin);
        if (atoms[0] != null) {
            this.atoms[0] = atoms[0];
            this.atoms[1] = atoms[1];
            this.centerDipole();
        }
    }

    private void set(Point3f pt1, Point3f pt2) {
        if (this.dipoleValue < 0.0f) {
            this.origin = new Point3f(pt2);
            this.vector = new Vector3f((Tuple3f)pt1);
            this.dipoleValue = -this.dipoleValue;
        } else {
            this.origin = new Point3f(pt1);
            this.vector = new Vector3f((Tuple3f)pt2);
        }
        this.dipoleInfo = "" + this.origin + this.vector;
        this.vector.sub((Tuple3f)this.origin);
        if (this.dipoleValue == 0.0f) {
            this.dipoleValue = this.vector.length();
        } else {
            this.vector.scale(this.dipoleValue / this.vector.length());
        }
        this.type = 1;
    }

    void set(float value) {
        float d = this.dipoleValue;
        this.dipoleValue = value;
        if (this.vector == null) {
            return;
        }
        this.vector.scale(this.dipoleValue / this.vector.length());
        if (d * this.dipoleValue < 0.0f) {
            this.origin.sub((Tuple3f)this.vector);
        }
    }

    void set(Point3f pt1, Point3f pt2, float value) {
        this.dipoleValue = value;
        this.atoms[0] = null;
        this.set(pt1, pt2);
    }

    void set(Point3f pt1, Vector3f dipole) {
        this.set(dipole.length());
        Point3f pt2 = new Point3f(pt1);
        pt2.add((Tuple3f)dipole);
        this.set(pt1, pt2);
        this.type = (short)5;
    }

    void set(Atom atom1, Atom atom2, float value) {
        this.set(value);
        this.set((Point3f)atom1, (Point3f)atom2);
        this.offsetSide = 0.4f;
        this.mad = (short)5;
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.centerDipole();
    }

    void centerDipole() {
        float f = this.atoms[0].distance((Point3f)this.atoms[1]) / (2.0f * this.dipoleValue) - 0.5f;
        this.origin.scaleAdd(f, (Tuple3f)this.vector, (Tuple3f)this.atoms[0]);
        this.center = new Point3f();
        this.center.scaleAdd(0.5f, (Tuple3f)this.vector, (Tuple3f)this.origin);
        this.bond = this.atoms[0].getBond(this.atoms[1]);
        this.type = (short)(this.bond == null ? 2 : 3);
    }

    boolean isBondType() {
        return this.type == 2 || this.type == 3;
    }
}

