/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.SphereIterator;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.BondIterator;
import org.jmol.viewer.CarbohydrateMonomer;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Dipole;
import org.jmol.viewer.Dipoles;
import org.jmol.viewer.FrameExportJmolAdapter;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public final class Frame {
    Viewer viewer;
    FrameRenderer frameRenderer;
    private String modelSetTypeName;
    boolean isXYZ;
    boolean isPDB;
    boolean isMultiFile;
    boolean isArrayOfFiles;
    boolean isZeroBased;
    Mmset mmset;
    Graphics3D g3d;
    float maxBondingRadius = Float.MIN_VALUE;
    float maxVanderwaalsRadius = Float.MIN_VALUE;
    CellInfo[] cellInfos;
    int atomCount;
    public Atom[] atoms;
    int bondCount;
    Bond[] bonds;
    int groupCount;
    Group[] groups;
    int moleculeCount;
    Molecule[] molecules = new Molecule[4];
    int modelCount;
    private BitSet elementsPresent;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    float[] surfaceDistances;
    int[] surfaceAtoms;
    String[] atomNames;
    int[] atomSerials;
    byte[] specialAtomIDs;
    String[] group3Lists;
    int[][] group3Counts;
    BitSet bsHidden = new BitSet();
    private static final int growthIncrement = 250;
    float[] notionalUnitcell;
    boolean someModelsHaveSymmetry;
    boolean someModelsHaveUnitcells;
    boolean someModelsHaveFractionalCoordinates;
    boolean hasVibrationVectors;
    boolean fileHasHbonds;
    boolean structuresDefined;
    boolean hasBfactorRange;
    int bfactor100Lo;
    int bfactor100Hi;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    int currentModelIndex;
    Model currentModel;
    char currentChainID;
    Chain currentChain;
    int currentGroupSequenceNumber;
    char currentGroupInsertionCode;
    String currentGroup3;
    private final Hashtable htAtomMap = new Hashtable();
    short defaultCovalentMad;
    static final int defaultGroupCount = 32;
    Chain[] chains;
    String[] group3s;
    int[] seqcodes;
    int[] firstAtomIndexes;
    final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    FrameExportJmolAdapter exportJmolAdapter;
    final Shape[] shapes = new Shape[30];
    final Point3f averageAtomPoint = new Point3f();
    final Point3f centerBoundBox = new Point3f();
    final Vector3f boundBoxCornerVector = new Vector3f();
    final Point3f minBoundBox = new Point3f();
    final Point3f maxBoundBox = new Point3f();
    static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};
    final Point3f[] bboxVertices = new Point3f[8];
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = null;
    final Closest closest = new Closest();
    static final int minimumPixelSelectionRadius = 6;
    final BitSet bsEmpty = new BitSet();
    final BitSet bsFoundRectangle = new BitSet();
    Bspf bspf;
    private static final boolean MIX_BSPT_ORDER = false;
    private final WithinModelIterator withinModelIterator = new WithinModelIterator();
    private final WithinAnyModelIterator withinAnyModelIterator = new WithinAnyModelIterator();
    static final boolean showRebondTimes = true;
    boolean haveWarned = false;
    float hbondMax = 3.25f;
    float hbondMin = 2.5f;
    float hbondMin2 = this.hbondMin * this.hbondMin;
    boolean hbondsCalculated;
    boolean useRasMolHbondsCalculation = true;
    Vector stateScripts = new Vector();
    int thisFrame = 0;
    BitSet selectedMolecules = new BitSet();
    BitSet bsTemp = new BitSet();
    int selectedMoleculeCount;
    BitSet bsSurfaceSet;
    float surfaceDistanceMax;
    Vector3f vectorBA;
    Vector3f vectorBC;
    static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    static final int MAX_NUM_TO_CACHE = 200;
    int[] numCached = new int[5];
    Bond[][][] freeBonds = new Bond[5][][];
    static final float E_ANG_PER_DEBYE = 0.208194f;
    static final float toRadians = (float)Math.PI / 180;
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    boolean reportFormalCharges;
    String hybridization;
    boolean selectionHaloEnabled;
    boolean echoShapeActive;

    Frame(Viewer viewer, String name) {
        int i = 5;
        while (--i > 0) {
            this.freeBonds[i] = new Bond[200][];
        }
        this.reportFormalCharges = false;
        this.selectionHaloEnabled = false;
        this.echoShapeActive = false;
        this.viewer = viewer;
        this.initializeFrame(name, 1, null, null);
        this.initializeModel(null, null);
    }

    Frame(Viewer viewer, JmolAdapter adapter, Object clientFile) {
        int i = 5;
        while (--i > 0) {
            this.freeBonds[i] = new Bond[200][];
        }
        this.reportFormalCharges = false;
        this.selectionHaloEnabled = false;
        this.echoShapeActive = false;
        this.viewer = viewer;
        this.initializeFrame(adapter.getFileTypeName(clientFile).toLowerCase().intern(), adapter.getEstimatedAtomCount(clientFile), adapter.getAtomSetCollectionProperties(clientFile), adapter.getAtomSetCollectionAuxiliaryInfo(clientFile));
        this.initializeModel(adapter, clientFile);
        adapter.finish(clientFile);
    }

    void initializeFrame(String name, int nAtoms, Properties properties, Hashtable info) {
        this.modelSetTypeName = name;
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.isArrayOfFiles = this.modelSetTypeName == "array";
        this.setZeroBased();
        this.mmset = new Mmset(this);
        this.frameRenderer = this.viewer.getFrameRenderer();
        this.g3d = this.viewer.getGraphics3D();
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(2);
        this.loadShape(6);
        this.loadShape(19);
        this.initializeBuild(nAtoms);
        this.mmset.setModelSetProperties(properties);
        this.mmset.setModelSetAuxiliaryInfo(info);
        this.isMultiFile = this.mmset.getModelSetAuxiliaryInfoBoolean("isMultiFile");
        this.isPDB = this.mmset.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.someModelsHaveSymmetry = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        this.fileHasHbonds = false;
    }

    void initializeModel(JmolAdapter adapter, Object clientFile) {
        this.modelCount = adapter == null ? 1 : adapter.getAtomSetCount(clientFile);
        this.mmset.setModelCount(this.modelCount);
        Logger.info((String)("frame: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates));
        if (this.modelCount > 0 && adapter != null) {
            Logger.info((String)(this.modelCount + " model" + (this.modelCount == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them."));
        }
        this.currentModelIndex = -1;
        if (adapter == null) {
            this.mmset.setModelNameNumberProperties(0, "", 1, null, null, false);
        } else {
            JmolAdapter.StructureIterator iterStructure;
            this.group3Lists = new String[this.modelCount + 1];
            this.group3Counts = new int[this.modelCount + 1][];
            for (int i = 0; i < this.modelCount; ++i) {
                Hashtable modelAuxiliaryInfo;
                Properties modelProperties;
                boolean isPDBModel;
                int modelNumber = adapter.getAtomSetNumber(clientFile, i);
                String modelName = adapter.getAtomSetName(clientFile, i);
                if (modelName == null) {
                    modelName = "" + modelNumber;
                }
                if (!(isPDBModel = this.mmset.setModelNameNumberProperties(i, modelName, modelNumber, modelProperties = adapter.getAtomSetProperties(clientFile, i), modelAuxiliaryInfo = adapter.getAtomSetAuxiliaryInfo(clientFile, i), this.isPDB))) continue;
                this.group3Lists[i] = JmolConstants.group3List;
                this.group3Counts[i] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[this.modelCount] != null) continue;
                this.group3Lists[this.modelCount] = JmolConstants.group3List;
                this.group3Counts[this.modelCount] = new int[JmolConstants.group3Count + 10];
            }
            JmolAdapter.AtomIterator iterAtom = adapter.getAtomIterator(clientFile);
            while (iterAtom.hasNext()) {
                short elementNumber = (short)iterAtom.getElementNumber();
                if (elementNumber <= 0) {
                    elementNumber = JmolConstants.elementNumberFromSymbol(iterAtom.getElementSymbol());
                }
                char alternateLocation = iterAtom.getAlternateLocationID();
                this.addAtom(iterAtom.getAtomSetIndex(), iterAtom.getAtomSymmetry(), iterAtom.getAtomSite(), iterAtom.getUniqueID(), elementNumber, iterAtom.getAtomName(), iterAtom.getFormalCharge(), iterAtom.getPartialCharge(), iterAtom.getOccupancy(), iterAtom.getBfactor(), iterAtom.getX(), iterAtom.getY(), iterAtom.getZ(), iterAtom.getIsHetero(), iterAtom.getAtomSerial(), iterAtom.getChainID(), iterAtom.getGroup3(), iterAtom.getSequenceNumber(), iterAtom.getInsertionCode(), iterAtom.getVectorX(), iterAtom.getVectorY(), iterAtom.getVectorZ(), alternateLocation, iterAtom.getClientAtomReference());
            }
            JmolAdapter.BondIterator iterBond = adapter.getBondIterator(clientFile);
            if (iterBond != null) {
                while (iterBond.hasNext()) {
                    this.bondAtoms(iterBond.getAtomUniqueID1(), iterBond.getAtomUniqueID2(), (short)iterBond.getEncodedOrder());
                }
            }
            if ((iterStructure = adapter.getStructureIterator(clientFile)) != null) {
                while (iterStructure.hasNext()) {
                    if (iterStructure.getStructureType().equals("turn")) continue;
                    this.defineStructure(iterStructure.getModelIndex(), iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
                }
            }
            if ((iterStructure = adapter.getStructureIterator(clientFile)) != null) {
                while (iterStructure.hasNext()) {
                    if (!iterStructure.getStructureType().equals("turn")) continue;
                    this.defineStructure(iterStructure.getModelIndex(), iterStructure.getStructureType(), iterStructure.getStartChainID(), iterStructure.getStartSequenceNumber(), iterStructure.getStartInsertionCode(), iterStructure.getEndChainID(), iterStructure.getEndSequenceNumber(), iterStructure.getEndInsertionCode());
                }
            }
        }
        this.doUnitcellStuff();
        this.doAutobond();
        this.finalizeGroupBuild();
        this.saveGroup3Info();
        this.buildPolymers();
        this.freeze();
        this.finalizeBuild();
        this.calcAverageAtomPoint();
        this.calcBoundBoxDimensions();
    }

    void dumpAtomSetNameDiagnostics(JmolAdapter adapter, Object clientFile) {
        int frameModelCount = this.getModelCount();
        int adapterAtomSetCount = adapter.getAtomSetCount(clientFile);
        Logger.debug((String)("----------------\ndebugging of AtomSetName stuff\n\nframeModelCount=" + frameModelCount + "\nadapterAtomSetCount=" + adapterAtomSetCount + "\n -- \n"));
        for (int i = 0; i < adapterAtomSetCount; ++i) {
            Logger.debug((String)("atomSetName[" + i + "]=" + adapter.getAtomSetName(clientFile, i) + " atomSetNumber[" + i + "]=" + adapter.getAtomSetNumber(clientFile, i)));
        }
    }

    void initializeBuild(int atomCountEstimate) {
        if (atomCountEstimate <= 0) {
            atomCountEstimate = 2000;
        }
        this.atoms = new Atom[atomCountEstimate];
        this.bonds = new Bond[250 + atomCountEstimate];
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    void finalizeBuild() {
        this.currentModel = null;
        this.currentChain = null;
        this.htAtomMap.clear();
    }

    void addAtom(int modelIndex, BitSet atomSymmetry, int atomSite, Object atomUid, short atomicAndIsotopeNumber, String atomName, int formalCharge, float partialCharge, int occupancy, float bfactor, float x, float y, float z, boolean isHetero, int atomSerial, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode, float vectorX, float vectorY, float vectorZ, char alternateLocationID, Object clientAtomReference) {
        Atom atom;
        this.checkNewGroup(this.atomCount, modelIndex, chainID, group3, groupSequenceNumber, groupInsertionCode);
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays(2000);
        }
        this.atoms[this.atomCount] = atom = new Atom(this.viewer, this, this.currentModelIndex, this.atomCount, atomSymmetry, atomSite, atomicAndIsotopeNumber, atomName, formalCharge, partialCharge, occupancy, bfactor, x, y, z, isHetero, atomSerial, chainID, group3, vectorX, vectorY, vectorZ, alternateLocationID, clientAtomReference);
        ++this.atomCount;
        this.htAtomMap.put(atomUid, atom);
    }

    void checkNewGroup(int atomIndex) {
        Atom atom = this.atoms[atomIndex];
        if (atom.group == null) {
            this.checkNewGroup(atomIndex, atom.modelIndex, '\u0000', null, 0, '\u0000');
        } else {
            this.checkNewGroup(atomIndex, atom.modelIndex, atom.getChainID(), atom.getGroup3(), atom.getSeqNumber(), atom.getInsertionCode());
        }
    }

    void checkNewGroup(int atomIndex, int modelIndex, char chainID, String group3, int groupSequenceNumber, char groupInsertionCode) {
        String group3i;
        String string = group3i = group3 == null ? null : group3.intern();
        if (modelIndex != this.currentModelIndex) {
            this.currentModel = this.mmset.getModel(modelIndex);
            this.currentModelIndex = modelIndex;
            this.currentChainID = (char)65535;
        }
        if (chainID != this.currentChainID) {
            this.currentChainID = chainID;
            this.currentChain = this.currentModel.getOrAllocateChain(chainID);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (groupSequenceNumber != this.currentGroupSequenceNumber || groupInsertionCode != this.currentGroupInsertionCode || group3i != this.currentGroup3) {
            this.currentGroupSequenceNumber = groupSequenceNumber;
            this.currentGroupInsertionCode = groupInsertionCode;
            this.currentGroup3 = group3i;
            this.startGroup(this.currentChain, group3, groupSequenceNumber, groupInsertionCode, atomIndex);
        }
    }

    void bondAtoms(Object atomUid1, Object atomUid2, short order) {
        Atom atom1;
        if (this.defaultCovalentMad == 0) {
            this.defaultCovalentMad = this.viewer.getMadBond();
        }
        if ((atom1 = (Atom)((Object)this.htAtomMap.get(atomUid1))) == null) {
            Logger.error((String)("bondAtoms cannot find atomUid1?:" + atomUid1));
            return;
        }
        Atom atom2 = (Atom)((Object)this.htAtomMap.get(atomUid2));
        if (atom2 == null) {
            Logger.error((String)("bondAtoms cannot find atomUid2?:" + atomUid2));
            return;
        }
        Bond bond = this.bondMutually(atom1, atom2, order, this.getDefaultMadFromOrder(order));
        if (bond == null) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength((Object)this.bonds, (int)(this.bondCount + 4000));
        }
        this.bonds[this.bondCount++] = bond;
        if ((order & 0x3C0) != 0) {
            this.fileHasHbonds = true;
        }
    }

    void growAtomArrays(int byHowMuch) {
        int newLength = this.atomCount + byHowMuch;
        this.atoms = (Atom[])ArrayUtil.setLength((Object)this.atoms, (int)newLength);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])ArrayUtil.setLength((Object)this.clientAtomReferences, (int)newLength);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength((Object)this.vibrationVectors, (int)newLength);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength((byte[])this.occupancies, (int)newLength);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength((short[])this.bfactor100s, (int)newLength);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength((float[])this.partialCharges, (int)newLength);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength((String[])this.atomNames, (int)newLength);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength((int[])this.atomSerials, (int)newLength);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = ArrayUtil.setLength((byte[])this.specialAtomIDs, (int)newLength);
        }
    }

    void initializeGroupBuild() {
        this.groupCount = 0;
        this.chains = new Chain[32];
        this.group3s = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentModelIndex = -1;
        this.currentModel = null;
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
    }

    void startGroup(Chain chain, String group3, int groupSequenceNumber, char groupInsertionCode, int firstAtomIndex) {
        if (this.groupCount == this.group3s.length) {
            this.chains = (Chain[])ArrayUtil.doubleLength((Object)this.chains);
            this.group3s = ArrayUtil.doubleLength((String[])this.group3s);
            this.seqcodes = ArrayUtil.doubleLength((int[])this.seqcodes);
            this.firstAtomIndexes = ArrayUtil.doubleLength((int[])this.firstAtomIndexes);
        }
        this.firstAtomIndexes[this.groupCount] = firstAtomIndex;
        this.chains[this.groupCount] = chain;
        this.group3s[this.groupCount] = group3;
        this.seqcodes[this.groupCount] = Group.getSeqcode(groupSequenceNumber, groupInsertionCode);
        ++this.groupCount;
    }

    void finalizeGroupBuild() {
        this.groups = new Group[this.groupCount];
        for (int i = 0; i < this.groupCount; ++i) {
            this.distinguishAndPropagateGroup(i, this.chains[i], this.group3s[i], this.seqcodes[i], this.firstAtomIndexes[i], i == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[i + 1]);
            this.chains[i] = null;
            this.group3s[i] = null;
        }
        this.chains = null;
        this.group3s = null;
    }

    void saveGroup3Info() {
        if (this.group3Lists == null) {
            return;
        }
        Hashtable info = this.getModelSetAuxiliaryInfo();
        if (info == null) {
            return;
        }
        info.put("group3Lists", this.group3Lists);
        info.put("group3Counts", this.group3Counts);
    }

    void distinguishAndPropagateGroup(int groupIndex, Chain chain, String group3, int seqcode, int firstAtomIndex, int maxAtomIndex) {
        Group group = null;
        int lastAtomIndex = maxAtomIndex - 1;
        if (group3 != null) {
            int distinguishingBits = 0;
            int i = JmolConstants.ATOMID_MAX;
            while (--i >= 0) {
                this.specialAtomIndexes[i] = Integer.MIN_VALUE;
            }
            if (this.specialAtomIDs != null) {
                i = maxAtomIndex;
                while (--i >= firstAtomIndex) {
                    byte specialAtomID = this.specialAtomIDs[i];
                    if (specialAtomID <= 0) continue;
                    if (specialAtomID < 32) {
                        int bit = 1 << specialAtomID;
                        distinguishingBits |= bit;
                    }
                    this.specialAtomIndexes[specialAtomID] = i;
                }
            }
            if (lastAtomIndex < firstAtomIndex) {
                throw new NullPointerException();
            }
            if ((distinguishingBits & 0xE) == 14) {
                group = AminoMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
                this.countGroup(this.atoms[firstAtomIndex].modelIndex, "p>", group3);
            } else if (distinguishingBits == 4) {
                group = AlphaMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
                this.countGroup(this.atoms[firstAtomIndex].modelIndex, "p>", group3);
            } else if ((distinguishingBits & 0xFE0) == 4064) {
                group = NucleicMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
                this.countGroup(this.atoms[firstAtomIndex].modelIndex, "n>", group3);
            } else if (distinguishingBits == 4096) {
                group = PhosphorusMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
                this.countGroup(this.atoms[firstAtomIndex].modelIndex, "n>", group3);
            } else if (JmolConstants.checkCarbohydrate(group3)) {
                group = CarbohydrateMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, this.specialAtomIndexes, this.atoms);
                this.countGroup(this.atoms[firstAtomIndex].modelIndex, "c>", group3);
            }
        }
        if (group == null) {
            group = new Group(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
            if (group3 != null) {
                this.countGroup(this.atoms[firstAtomIndex].modelIndex, "o>", group3);
            }
        }
        chain.addGroup(group);
        this.groups[groupIndex] = group;
        int i = maxAtomIndex;
        while (--i >= firstAtomIndex) {
            this.atoms[i].setGroup(group);
        }
    }

    void countGroup(int modelIndex, String code, String group3) {
        if (this.group3Lists == null || this.group3Lists[modelIndex] == null) {
            return;
        }
        String g3code = (group3 + "   ").substring(0, 3);
        int pt = this.group3Lists[modelIndex].indexOf(g3code);
        if (pt < 0) {
            int n = modelIndex;
            this.group3Lists[n] = this.group3Lists[n] + ",[" + g3code + "]";
            pt = this.group3Lists[modelIndex].indexOf(g3code);
            this.group3Counts[modelIndex] = ArrayUtil.setLength((int[])this.group3Counts[modelIndex], (int)(this.group3Counts[modelIndex].length + 10));
        }
        int[] nArray = this.group3Counts[modelIndex];
        int n = pt / 6;
        nArray[n] = nArray[n] + 1;
        pt = this.group3Lists[modelIndex].indexOf(",[" + g3code);
        if (pt >= 0) {
            this.group3Lists[modelIndex] = this.group3Lists[modelIndex].substring(0, pt) + code + this.group3Lists[modelIndex].substring(pt + 2);
        }
        if (modelIndex < this.modelCount) {
            this.countGroup(this.modelCount, code, group3);
        }
    }

    void buildPolymers() {
        for (int i = 0; i < this.groupCount; ++i) {
            Group group = this.groups[i];
            if (!(group instanceof Monomer)) continue;
            Monomer monomer = (Monomer)group;
            if (monomer.polymer != null) continue;
            Polymer.allocatePolymer(this.groups, i);
        }
    }

    void clearPolymers() {
        for (int i = 0; i < this.groupCount; ++i) {
            Group group = this.groups[i];
            if (!(group instanceof Monomer)) continue;
            Monomer monomer = (Monomer)group;
            if (monomer.polymer == null) continue;
            monomer.polymer = null;
        }
    }

    JmolAdapter getExportJmolAdapter() {
        if (this.exportJmolAdapter == null) {
            this.exportJmolAdapter = new FrameExportJmolAdapter(this.viewer, this);
        }
        return this.exportJmolAdapter;
    }

    void freeze() {
        if (this.atomCount < this.atoms.length) {
            this.growAtomArrays(0);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength((Object)this.bonds, (int)this.bondCount);
        }
        this.freeBondsCache();
        this.hasVibrationVectors = this.vibrationVectors != null;
        this.setAtomNamesAndNumbers();
        this.findElementsPresent();
        this.calculateStructures(false);
    }

    void calculateStructures(boolean rebuild) {
        if (rebuild) {
            int i = 15;
            while (--i >= 8) {
                this.shapes[i] = null;
            }
            this.clearPolymers();
            this.mmset.clearStructures();
            this.initializeGroupBuild();
            for (i = 0; i < this.atomCount; ++i) {
                this.checkNewGroup(i);
            }
            this.finalizeGroupBuild();
            this.buildPolymers();
            this.structuresDefined = false;
            this.moleculeCount = 0;
        }
        if (!this.structuresDefined) {
            this.mmset.calculateStructures();
        }
        this.mmset.freeze();
    }

    BitSet setConformation(int modelIndex, int conformationIndex) {
        BitSet bs = new BitSet();
        String altLocs = this.getAltLocListInModel(modelIndex);
        if (altLocs.length() > 0) {
            BitSet bsConformation = this.getModelAtomBitSet(modelIndex);
            if (conformationIndex >= 0) {
                int c = this.getAltLocCountInModel(modelIndex);
                while (--c >= 0) {
                    if (c == conformationIndex) continue;
                    bsConformation.andNot(this.getSpecAlternate(altLocs.substring(c, c + 1)));
                }
            }
            if (bsConformation.length() > 0) {
                this.setConformation(modelIndex, bsConformation);
                bs.or(bsConformation);
            }
        }
        return bs;
    }

    void setConformation(int modelIndex, BitSet bsConformation) {
        this.mmset.setConformation(modelIndex, bsConformation);
    }

    void setZeroBased() {
        this.isZeroBased = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
    }

    /*
     * WARNING - void declaration
     */
    private void setAtomNamesAndNumbers() {
        void var1_4;
        if (this.atomSerials == null) {
            int n = Integer.MAX_VALUE;
            int modelAtomIndex = 0;
            this.atomSerials = new int[this.atomCount];
            for (int i = 0; i < this.atomCount; ++i) {
                short s;
                Atom atom = this.atoms[i];
                if (atom.modelIndex != s) {
                    s = atom.modelIndex;
                    modelAtomIndex = this.isZeroBased ? 0 : 1;
                }
                this.atomSerials[i] = modelAtomIndex++;
            }
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        boolean bl = false;
        while (var1_4 < this.atomCount) {
            if (this.atomNames[var1_4] == null) {
                Atom atom = this.atoms[var1_4];
                this.atomNames[var1_4] = atom.getElementSymbol() + atom.getAtomNumber();
            }
            ++var1_4;
        }
    }

    void defineStructure(int modelIndex, String structureType, char startChainID, int startSequenceNumber, char startInsertionCode, char endChainID, int endSequenceNumber, char endInsertionCode) {
        this.structuresDefined = true;
        this.mmset.defineStructure(modelIndex, structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode);
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].getAtomNumber() != atomNumber) continue;
            return i;
        }
        return -1;
    }

    int getAltLocIndexInModel(int modelIndex, char alternateLocationID) {
        if (alternateLocationID == '\u0000') {
            return 0;
        }
        String altLocList = this.getAltLocListInModel(modelIndex);
        if (altLocList.length() == 0) {
            return 0;
        }
        return altLocList.indexOf(alternateLocationID) + 1;
    }

    int getInsertionCodeIndexInModel(int modelIndex, char insertionCode) {
        if (insertionCode == '\u0000') {
            return 0;
        }
        String codeList = this.getInsertionListInModel(modelIndex);
        if (codeList.length() == 0) {
            return 0;
        }
        return codeList.indexOf(insertionCode) + 1;
    }

    String getAltLocListInModel(int modelIndex) {
        String str = (String)this.getModelAuxiliaryInfo(modelIndex, "altLocs");
        return str == null ? "" : str;
    }

    String getInsertionListInModel(int modelIndex) {
        String str = (String)this.getModelAuxiliaryInfo(modelIndex, "insertionCodes");
        return str == null ? "" : str;
    }

    String getModelSymmetryList(int modelIndex) {
        String[] list = (String[])this.getModelAuxiliaryInfo(modelIndex, "symmetryOperations");
        String str = "";
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                str = str + "\n" + list[i];
            }
        }
        return str;
    }

    int getAltLocCountInModel(int modelIndex) {
        return this.mmset.getNAltLocs(modelIndex);
    }

    int getInsertionCountInModel(int modelIndex) {
        return this.mmset.getNInsertions(modelIndex);
    }

    Properties getModelSetProperties() {
        return this.mmset.getModelSetProperties();
    }

    String getModelSetProperty(String propertyName) {
        return this.mmset.getModelSetProperty(propertyName);
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.mmset.getModelSetAuxiliaryInfo();
    }

    Object getModelSetAuxiliaryInfo(String keyName) {
        return this.mmset.getModelSetAuxiliaryInfo(keyName);
    }

    boolean modelSetHasVibrationVectors() {
        return this.hasVibrationVectors;
    }

    boolean modelHasVibrationVectors(int modelIndex) {
        if (this.vibrationVectors != null) {
            int i = this.atomCount;
            while (--i >= 0) {
                if (modelIndex >= 0 && this.atoms[i].modelIndex != modelIndex || this.vibrationVectors[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    int getModelCount() {
        return this.mmset.getModelCount();
    }

    int getModelNumber(int modelIndex) {
        return this.mmset.getModelNumber(modelIndex);
    }

    String getModelName(int modelIndex) {
        return this.mmset.getModelName(modelIndex);
    }

    String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    Properties getModelProperties(int modelIndex) {
        return this.mmset.getModelProperties(modelIndex);
    }

    String getModelProperty(int modelIndex, String propertyName) {
        return this.mmset.getModelProperty(modelIndex, propertyName);
    }

    Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.mmset.getModelAuxiliaryInfo(modelIndex);
    }

    Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.mmset.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    Model getModel(int modelIndex) {
        return this.mmset.getModel(modelIndex);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.mmset.getModelNumberIndex(modelNumber);
    }

    int getChainCount() {
        return this.mmset.getChainCount();
    }

    int getPolymerCount() {
        return this.mmset.getPolymerCount();
    }

    int getChainCountInModel(int modelIndex) {
        return this.mmset.getChainCountInModel(modelIndex);
    }

    int getPolymerCountInModel(int modelIndex) {
        return this.mmset.getPolymerCountInModel(modelIndex);
    }

    Polymer getPolymerAt(int modelIndex, int polymerIndex) {
        return this.mmset.getPolymerAt(modelIndex, polymerIndex);
    }

    int getGroupCount() {
        return this.mmset.getGroupCount();
    }

    int getGroupCountInModel(int modelIndex) {
        return this.mmset.getGroupCountInModel(modelIndex);
    }

    int getAtomCount() {
        return this.atomCount;
    }

    int getAtomCountInModel(int modelIndex) {
        int n = 0;
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].modelIndex != modelIndex) continue;
            ++n;
        }
        return n;
    }

    Atom[] getAtoms() {
        return this.atoms;
    }

    Atom getAtomAt(int atomIndex) {
        return this.atoms[atomIndex];
    }

    Point3f getAtomPoint3f(int atomIndex) {
        return this.atoms[atomIndex];
    }

    int getBondCount() {
        return this.bondCount;
    }

    int getBondCountInModel(int modelIndex) {
        int n = 0;
        int i = this.bondCount;
        while (--i >= 0) {
            if (modelIndex >= 0 && this.bonds[i].atom1.modelIndex != modelIndex) continue;
            ++n;
        }
        return n;
    }

    Bond getBondAt(int bondIndex) {
        return this.bonds[bondIndex];
    }

    short getDefaultMadFromOrder(short order) {
        return (order & 0x3C0) > 0 ? (short)1 : this.defaultCovalentMad;
    }

    private Bond bondMutually(Atom atom, Atom atomOther, short order, short mad) {
        if (atom.isBonded(atomOther)) {
            return null;
        }
        Bond bond = new Bond(atom, atomOther, order, mad, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atomOther, bond);
        return bond;
    }

    private Bond addBond(Bond bond) {
        if (bond == null) {
            return null;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength((Object)this.bonds, (int)(this.bondCount + 250));
        }
        Bond bond2 = bond;
        this.bonds[this.bondCount++] = bond2;
        return bond2;
    }

    Bond bondAtoms(Atom atom1, Atom atom2, short order, short mad) {
        return this.addBond(this.bondMutually(atom1, atom2, order, mad));
    }

    void addHydrogenBond(Atom atom1, Atom atom2, short order, BitSet bsA, BitSet bsB) {
        boolean atom2InSetB;
        boolean atom1InSetA = bsA == null || bsA.get(atom1.atomIndex);
        boolean atom1InSetB = bsB == null || bsB.get(atom1.atomIndex);
        boolean atom2InSetA = bsA == null || bsA.get(atom2.atomIndex);
        boolean bl = atom2InSetB = bsB == null || bsB.get(atom2.atomIndex);
        if (atom1InSetA & atom2InSetB || atom1InSetB & atom2InSetA) {
            this.addBond(this.bondMutually(atom1, atom2, order, (short)1));
        }
    }

    Shape allocateShape(int shapeID) {
        String classBase = JmolConstants.shapeClassBases[shapeID];
        String className = "org.jmol.viewer." + classBase;
        try {
            Class<?> shapeClass = Class.forName(className);
            Shape shape = (Shape)shapeClass.newInstance();
            shape.setViewerG3dFrame(this.viewer, this.g3d, this, shapeID);
            return shape;
        }
        catch (Exception e) {
            Logger.error((String)("Could not instantiate shape:" + classBase), (Throwable)e);
            return null;
        }
    }

    void loadShape(int shapeID) {
        if (this.shapes[shapeID] == null) {
            this.shapes[shapeID] = this.allocateShape(shapeID);
        }
    }

    void setShapeSize(int shapeID, int size, BitSet bsSelected) {
        if (size != 0) {
            this.loadShape(shapeID);
        }
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setSize(size, bsSelected);
        }
    }

    void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bsSelected) {
        if (this.shapes[shapeID] != null) {
            this.shapes[shapeID].setProperty(propertyName, value, bsSelected);
        }
    }

    Object getShapeProperty(int shapeID, String propertyName, int index) {
        return this.shapes[shapeID] == null ? null : this.shapes[shapeID].getProperty(propertyName, index);
    }

    Point3f getBoundBoxCenter() {
        return this.centerBoundBox;
    }

    Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    Vector3f getBoundBoxCornerVector() {
        return this.boundBoxCornerVector;
    }

    private void calcAverageAtomPoint() {
        Point3f average = this.averageAtomPoint;
        average.set(0.0f, 0.0f, 0.0f);
        if (this.atomCount == 0) {
            return;
        }
        int i = this.atomCount;
        while (--i >= 0) {
            average.add((Tuple3f)this.atoms[i]);
        }
        average.scale(1.0f / (float)this.atomCount);
    }

    private void calcBoundBoxDimensions() {
        this.calcAtomsMinMax(this.minBoundBox, this.maxBoundBox);
        this.calcUnitCellMinMax(this.minBoundBox, this.maxBoundBox);
        this.centerBoundBox.add((Tuple3f)this.minBoundBox, (Tuple3f)this.maxBoundBox);
        this.centerBoundBox.scale(0.5f);
        this.boundBoxCornerVector.sub((Tuple3f)this.maxBoundBox, (Tuple3f)this.centerBoundBox);
        int i = 8;
        while (--i >= 0) {
            Point3f bbcagePoint = this.bboxVertices[i] = new Point3f(unitBboxPoints[i]);
            bbcagePoint.x *= this.boundBoxCornerVector.x;
            bbcagePoint.y *= this.boundBoxCornerVector.y;
            bbcagePoint.z *= this.boundBoxCornerVector.z;
            bbcagePoint.add((Tuple3f)this.centerBoundBox);
        }
    }

    float calcRotationRadius(Point3f center) {
        float maxRadius = 0.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            float radiusVdw;
            Atom atom = this.atoms[i];
            float distAtom = center.distance((Point3f)atom);
            float outerVdw = distAtom + (radiusVdw = atom.getVanderwaalsRadiusFloat());
            if (!(outerVdw > maxRadius)) continue;
            maxRadius = outerVdw;
        }
        return maxRadius == 0.0f ? 10.0f : maxRadius;
    }

    boolean frankClicked(int x, int y) {
        Shape frankShape = this.shapes[20];
        if (frankShape == null) {
            return false;
        }
        return frankShape.wasClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest.atom = null;
        this.findNearestAtomIndex(x, y, this.closest);
        for (int i = 0; i < this.shapes.length && this.closest.atom == null; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            shape.findNearestAtomIndex(x, y, this.closest);
        }
        int closestIndex = this.closest.atom == null ? -1 : this.closest.atom.atomIndex;
        this.closest.atom = null;
        return closestIndex;
    }

    void findNearestAtomIndex(int x, int y, Closest closest) {
        Atom champion = null;
        int i = this.atomCount;
        while (--i >= 0) {
            Atom contender = this.atoms[i];
            if (!contender.isCursorOnTopOfClickableAtom(x, y, 6, champion)) continue;
            champion = contender;
        }
        closest.atom = champion;
    }

    BitSet findAtomsInRectangle(Rectangle rect) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if (!rect.contains(atom.getScreenX(), atom.getScreenY())) continue;
            this.bsFoundRectangle.set(i);
        }
        return this.bsFoundRectangle;
    }

    BondIterator getBondIterator(short bondType, BitSet bsSelected) {
        return new SelectedBondIterator(bondType, bsSelected);
    }

    BondIterator getBondIterator(BitSet bsSelected) {
        return new SelectedBondIterator(bsSelected);
    }

    void initializeBspf() {
        if (this.bspf == null) {
            long timeBegin = 0L;
            timeBegin = System.currentTimeMillis();
            this.bspf = new Bspf(3);
            Logger.debug((String)"sequential bspt order");
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom = this.atoms[i];
                if (atom.isDeleted()) continue;
                this.bspf.addTuple((int)atom.modelIndex, (Tuple)atom);
            }
            long timeEnd = System.currentTimeMillis();
            Logger.debug((String)("time to build bspf=" + (timeEnd - timeBegin) + " ms"));
            this.bspf.stats();
        }
    }

    int getBsptCount() {
        if (this.bspf == null) {
            this.initializeBspf();
        }
        return this.bspf.getBsptCount();
    }

    AtomIterator getWithinModelIterator(Atom atomCenter, float radius) {
        this.withinModelIterator.initialize(atomCenter.modelIndex, atomCenter, radius);
        return this.withinModelIterator;
    }

    AtomIterator getWithinAnyModelIterator(Atom atomCenter, float radius) {
        this.withinAnyModelIterator.initialize(atomCenter, radius);
        return this.withinAnyModelIterator;
    }

    void doAutobond() {
        boolean doBond;
        boolean bl = doBond = this.bondCount == 0 || this.isMultiFile || this.isPDB && this.bondCount < this.atomCount / 2;
        if (this.viewer.getForceAutoBond() || doBond && this.viewer.getAutoBond() && this.getModelSetProperty("noautobond") == null) {
            this.autoBond(null, null);
        }
        this.viewer.setShapeProperty(1, "reset", null);
    }

    void rebond() {
        this.stateScripts.add("connect;");
        this.deleteAllBonds();
        this.autoBond(null, null);
    }

    int autoBond(short order, BitSet bsA, BitSet bsB) {
        if (order == -1) {
            return this.autoBond(bsA, bsB);
        }
        if (order == 64) {
            return this.autoHbond(bsA, bsB);
        }
        Logger.warn((String)("autoBond() unknown order: " + order));
        return 0;
    }

    private int autoBond(BitSet bsA, BitSet bsB) {
        if (this.atomCount == 0) {
            return 0;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float bondTolerance = this.viewer.getBondTolerance();
        float minBondDistance = this.viewer.getMinBondDistance();
        float minBondDistance2 = minBondDistance * minBondDistance;
        short mad = this.viewer.getMadBond();
        int nNew = 0;
        this.initializeBspf();
        long timeBegin = 0L;
        timeBegin = System.currentTimeMillis();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom;
            float myBondingRadius;
            boolean isAtomInSetB;
            boolean isAtomInSetA = bsA == null || bsA.get(i);
            if (!isAtomInSetA & !(isAtomInSetB = bsB == null || bsB.get(i)) || (myBondingRadius = (atom = this.atoms[i]).getBondingRadiusFloat()) == 0.0f) continue;
            float searchRadius = myBondingRadius + this.maxBondingRadius + bondTolerance;
            SphereIterator iter = this.bspf.getSphereIterator((int)atom.modelIndex);
            iter.initializeHemisphere((Tuple)atom, searchRadius);
            while (iter.hasMoreElements()) {
                short order;
                boolean isNearInSetB;
                Atom atomNear = (Atom)iter.nextElement();
                if (atomNear == atom) continue;
                int atomIndexNear = atomNear.atomIndex;
                boolean isNearInSetA = bsA == null || bsA.get(atomIndexNear);
                if (!isNearInSetA & !(isNearInSetB = bsB == null || bsB.get(atomIndexNear)) || !(isAtomInSetA & isNearInSetB) && !(isAtomInSetB & isNearInSetA) || (order = this.getBondOrder(atom, myBondingRadius, atomNear, atomNear.getBondingRadiusFloat(), iter.foundDistance2(), minBondDistance2, bondTolerance)) <= 0) continue;
                this.checkValencesAndBond(atom, atomNear, order, mad);
                ++nNew;
            }
            iter.release();
        }
        long timeEnd = System.currentTimeMillis();
        Logger.debug((String)("Time to autoBond=" + (timeEnd - timeBegin)));
        return nNew;
    }

    private short getBondOrder(Atom atomA, float bondingRadiusA, Atom atomB, float bondingRadiusB, float distance2, float minBondDistance2, float bondTolerance) {
        if (bondingRadiusA == 0.0f || bondingRadiusB == 0.0f) {
            return 0;
        }
        float maxAcceptable = bondingRadiusA + bondingRadiusB + bondTolerance;
        float maxAcceptable2 = maxAcceptable * maxAcceptable;
        if (distance2 < minBondDistance2) {
            return 0;
        }
        if (distance2 <= maxAcceptable2) {
            return 1;
        }
        return 0;
    }

    void checkValencesAndBond(Atom atomA, Atom atomB, short order, short mad) {
        if (atomA.getCurrentBondCount() > 20 || atomB.getCurrentBondCount() > 20) {
            if (!this.haveWarned) {
                Logger.warn((String)"maximum auto bond count reached");
            }
            this.haveWarned = true;
            return;
        }
        int formalChargeA = atomA.getFormalCharge();
        if (formalChargeA != 0) {
            int formalChargeB = atomB.getFormalCharge();
            if (formalChargeA < 0 && formalChargeB < 0 || formalChargeA > 0 && formalChargeB > 0) {
                return;
            }
        }
        if (atomA.alternateLocationID != atomB.alternateLocationID && atomA.alternateLocationID != 0 && atomB.alternateLocationID != 0) {
            return;
        }
        this.addBond(this.bondMutually(atomA, atomB, order, mad));
    }

    int autoHbond(BitSet bsA, BitSet bsB) {
        if (this.useRasMolHbondsCalculation && this.bondCount > 0) {
            if (this.mmset != null) {
                this.mmset.calcHydrogenBonds(bsA, bsB);
            }
            return 0;
        }
        int nNew = 0;
        this.initializeBspf();
        long timeBegin = 0L;
        timeBegin = System.currentTimeMillis();
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            short elementNumber = atom.getElementNumber();
            if (elementNumber != 7 && elementNumber != 8) continue;
            SphereIterator iter = this.bspf.getSphereIterator((int)atom.modelIndex);
            iter.initializeHemisphere((Tuple)atom, this.hbondMax);
            while (iter.hasMoreElements()) {
                Atom atomNear = (Atom)iter.nextElement();
                short elementNumberNear = atomNear.getElementNumber();
                if (elementNumberNear != 7 && elementNumberNear != 8 || atomNear == atom || iter.foundDistance2() < this.hbondMin2 || atom.isBonded(atomNear)) continue;
                this.addBond(this.bondMutually(atom, atomNear, (short)64, (short)1));
                ++nNew;
            }
            iter.release();
        }
        long timeEnd = System.currentTimeMillis();
        Logger.debug((String)("Time to hbond=" + (timeEnd - timeBegin)));
        return nNew;
    }

    void deleteAllBonds() {
        this.stateScripts.clear();
        this.viewer.setShapeProperty(1, "reset", null);
        int i = this.bondCount;
        while (--i >= 0) {
            this.bonds[i].deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = 0;
    }

    void deleteBonds(BitSet bs) {
        int iDst = 0;
        for (int iSrc = 0; iSrc < this.bondCount; ++iSrc) {
            Bond bond = this.bonds[iSrc];
            if (!bs.get(iSrc)) {
                this.bonds[iDst++] = bond;
                continue;
            }
            bond.deleteAtomReferences();
        }
        int i = this.bondCount;
        while (--i >= iDst) {
            this.bonds[i] = null;
        }
        this.bondCount = iDst;
    }

    void deleteCovalentBonds() {
        int indexNoncovalent = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            Bond bond = this.bonds[i];
            if (bond == null) continue;
            if (!bond.isCovalent()) {
                if (i == indexNoncovalent) continue;
                this.bonds[indexNoncovalent++] = bond;
                this.bonds[i] = null;
                continue;
            }
            bond.deleteAtomReferences();
            this.bonds[i] = null;
        }
        this.bondCount = indexNoncovalent;
    }

    void addStateScript(String script) {
        int iFrame = this.viewer.getDisplayModelIndex();
        if (this.thisFrame != iFrame) {
            this.thisFrame = iFrame;
            script = "frame " + this.getModelNumber(iFrame) + ";\n" + script;
        }
        this.stateScripts.add(script);
    }

    int makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB) {
        String stateScript = "connect " + minDistance + " " + maxDistance + " " + StateManager.encodeBitset(bsA) + " " + StateManager.encodeBitset(bsB) + " " + JmolConstants.getBondOrderNameFromOrder(order) + " " + JmolConstants.connectOperationName(connectOperation) + ";";
        this.stateScripts.add(stateScript);
        Logger.debug((String)("makeConnections(" + minDistance + "," + maxDistance + "," + order + "," + connectOperation + "," + bsA + "," + bsB + ")"));
        if (connectOperation == 0) {
            return this.deleteConnections(minDistance, maxDistance, order, bsA, bsB);
        }
        if (connectOperation == 4) {
            return this.autoBond(order, bsA, bsB);
        }
        if (order == -1) {
            order = 1;
        }
        float minDistanceSquared = minDistance * minDistance;
        float maxDistanceSquared = maxDistance * maxDistance;
        this.defaultCovalentMad = this.viewer.getMadBond();
        short mad = this.getDefaultMadFromOrder(order);
        int nNew = 0;
        int nModified = 0;
        int iA = this.atomCount;
        while (--iA >= 0) {
            Atom atomA;
            if (!bsA.get(iA)) continue;
            Atom pointA = atomA = this.atoms[iA];
            int iB = this.atomCount;
            while (--iB >= 0) {
                float distanceSquared;
                if (iB == iA || !bsB.get(iB)) continue;
                Atom atomB = this.atoms[iB];
                if (atomA.modelIndex != atomB.modelIndex || atomA.alternateLocationID != atomB.alternateLocationID && atomA.alternateLocationID != 0 && atomB.alternateLocationID != 0) continue;
                Bond bondAB = atomA.getBond(atomB);
                if (1 == connectOperation && bondAB == null || 2 == connectOperation && bondAB != null || (distanceSquared = pointA.distanceSquared((Point3f)atomB)) < minDistanceSquared || distanceSquared > maxDistanceSquared) continue;
                if (bondAB != null) {
                    bondAB.setOrder(order);
                    ++nNew;
                    continue;
                }
                this.bondAtoms(atomA, atomB, order, mad);
                ++nModified;
            }
        }
        Logger.info((String)(nNew + " new bonds; " + nModified + " modified"));
        return nNew + nModified;
    }

    int deleteConnections(float minDistance, float maxDistance, short order, BitSet bsA, BitSet bsB) {
        BitSet bsDelete = new BitSet();
        float minDistanceSquared = minDistance * minDistance;
        float maxDistanceSquared = maxDistance * maxDistance;
        if (order != -1 && (order & 0x3C0) != 0) {
            order = (short)960;
        }
        int nDeleted = 0;
        int i = this.bondCount;
        while (--i >= 0) {
            float distanceSquared;
            Bond bond = this.bonds[i];
            Atom atom1 = bond.atom1;
            Atom atom2 = bond.atom2;
            if ((!bsA.get(atom1.atomIndex) || !bsB.get(atom2.atomIndex)) && (!bsA.get(atom2.atomIndex) || !bsB.get(atom1.atomIndex)) || !bond.atom1.isBonded(bond.atom2) || !((distanceSquared = atom1.distanceSquared((Point3f)atom2)) >= minDistanceSquared) || !(distanceSquared <= maxDistanceSquared) || order != -1 && order != (bond.order & 0xFFFFFFDF) && (order & bond.order & 0x3C0) == 0) continue;
            bsDelete.set(i);
            ++nDeleted;
        }
        this.deleteBonds(bsDelete);
        Logger.info((String)(nDeleted + " bonds deleted"));
        return nDeleted;
    }

    float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    ShapeRenderer getRenderer(int shapeID) {
        return this.frameRenderer.getRenderer(shapeID, this.g3d);
    }

    void doUnitcellStuff() {
        int i;
        int i2;
        if (this.someModelsHaveUnitcells) {
            boolean doPdbScale = this.modelCount == 1;
            this.cellInfos = new CellInfo[this.modelCount];
            for (i2 = 0; i2 < this.modelCount; ++i2) {
                this.cellInfos[i2] = new CellInfo(i2, doPdbScale);
            }
        }
        if (this.someModelsHaveSymmetry) {
            for (i = 0; i < this.modelCount; ++i) {
                this.mmset.setSymmetryAtomInfo(i, this.mmset.getModelAuxiliaryInfoInt(i, "presymmetryAtomIndex"), this.mmset.getModelAuxiliaryInfoInt(i, "presymmetryAtomCount"));
            }
        } else {
            int ipt = 0;
            for (i2 = 0; i2 < this.modelCount; ++i2) {
                ipt = this.mmset.setSymmetryAtomInfo(i2, ipt, this.getAtomCountInModel(i2));
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            i = this.atomCount;
            while (--i >= 0) {
                short modelIndex = this.atoms[i].modelIndex;
                if (!this.cellInfos[modelIndex].coordinatesAreFractional) continue;
                this.cellInfos[modelIndex].toCartesian((Point3f)this.atoms[i]);
                if (!Logger.isActiveLevel((int)0)) continue;
                Logger.debug((String)("atom " + i + ": " + (Object)((Object)this.atoms[i])));
            }
        }
    }

    void calcAtomsMinMax(Point3f pointMin, Point3f pointMax) {
        if (this.atomCount < 2) {
            pointMin.set(-10.0f, -10.0f, -10.0f);
            pointMax.set(10.0f, 10.0f, 10.0f);
            return;
        }
        pointMin.set((Tuple3f)this.atoms[0]);
        pointMax.set((Tuple3f)this.atoms[0]);
        int i = this.atomCount;
        while (--i > 0) {
            this.checkMinMax((Point3f)this.atoms[i], pointMin, pointMax);
        }
    }

    void calcUnitCellMinMax(Point3f pointMin, Point3f pointMax) {
        if (this.cellInfos == null) {
            return;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.cellInfos[i].coordinatesAreFractional) continue;
            Point3f[] vertices = this.cellInfos[i].unitCell.getVertices();
            for (int j = 0; j < 8; ++j) {
                this.checkMinMax(vertices[j], pointMin, pointMax);
            }
        }
    }

    void checkMinMax(Point3f pt, Point3f pointMin, Point3f pointMax) {
        float t = pt.x;
        if (t < pointMin.x) {
            pointMin.x = t;
        } else if (t > pointMax.x) {
            pointMax.x = t;
        }
        t = pt.y;
        if (t < pointMin.y) {
            pointMin.y = t;
        } else if (t > pointMax.y) {
            pointMax.y = t;
        }
        t = pt.z;
        if (t < pointMin.z) {
            pointMin.z = t;
        } else if (t > pointMax.z) {
            pointMax.z = t;
        }
    }

    Point3f getAtomSetCenter(BitSet bs) {
        Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
        int nPoints = this.viewer.cardinalityOf(bs);
        if (nPoints == 0) {
            return ptCenter;
        }
        int i = this.atomCount;
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            ptCenter.add((Tuple3f)this.atoms[i]);
        }
        ptCenter.scale(1.0f / (float)nPoints);
        return ptCenter;
    }

    int firstAtomOf(BitSet bs) {
        if (bs == null) {
            return -1;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            return i;
        }
        return -1;
    }

    Atom getSymmetryBaseAtom(int modelIndex, int site, int symop) {
        CellInfo[] c = this.cellInfos;
        if (c != null) {
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.atoms[i].modelIndex != modelIndex || this.atoms[i].atomSite != site || !this.atoms[i].atomSymmetry.get(symop)) continue;
                return this.atoms[i];
            }
        }
        return null;
    }

    BitSet getAtomBits(String setType) {
        if (setType.equals("specialPosition")) {
            return this.getSpecialPosition();
        }
        if (setType.equals("symmetry")) {
            return this.getSymmetrySet();
        }
        if (setType.equals("unitcell")) {
            return this.getUnitCellSet();
        }
        if (setType.equals("hetero")) {
            return this.getHeteroSet();
        }
        if (setType.equals("hydrogen")) {
            return this.getHydrogenSet();
        }
        if (setType.equals("protein")) {
            return this.getProteinSet();
        }
        if (setType.equals("carbohydrate")) {
            return this.getCarbohydrateSet();
        }
        if (setType.equals("nucleic")) {
            return this.getNucleicSet();
        }
        if (setType.equals("dna")) {
            return this.getDnaSet();
        }
        if (setType.equals("rna")) {
            return this.getRnaSet();
        }
        if (setType.equals("purine")) {
            return this.getPurineSet();
        }
        if (setType.equals("pyrimidine")) {
            return this.getPyrimidineSet();
        }
        return null;
    }

    private BitSet getSpecialPosition() {
        BitSet bs = new BitSet(this.atomCount);
        int i = this.atomCount;
        while (--i >= 0) {
            BitSet bsSym = this.atoms[i].getAtomSymmetry();
            if (bsSym == null || this.viewer.cardinalityOf(bsSym) <= 1) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getUnitCellSet() {
        BitSet bsCell = new BitSet();
        UnitCell unitcell = this.viewer.getCurrentUnitCell();
        if (unitcell == null) {
            return bsCell;
        }
        Point3f cell = new Point3f(unitcell.getFractionalOffset());
        cell.x += 1.0f;
        cell.y += 1.0f;
        cell.z += 1.0f;
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isInLatticeCell(cell)) continue;
            bsCell.set(i);
        }
        return bsCell;
    }

    private BitSet getSymmetrySet() {
        BitSet bs = new BitSet(this.atomCount);
        int i = this.atomCount;
        while (--i >= 0) {
            bs.set(i);
        }
        for (i = 0; i < this.modelCount; ++i) {
            int atomIndex = this.mmset.getPreSymmetryAtomIndex(i);
            int preSymAtomCount = this.mmset.getPreSymmetryAtomCount(i);
            if (atomIndex < 0) continue;
            int iatom = atomIndex + preSymAtomCount;
            while (--iatom >= atomIndex) {
                bs.clear(iatom);
            }
        }
        return bs;
    }

    private BitSet getHeteroSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isHetero()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getHydrogenSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getElementNumber() != 1) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getProteinSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isProtein()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getCarbohydrateSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isCarbohydrate()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getNucleicSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isNucleic()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getDnaSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isDna()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getRnaSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isRna()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getPurineSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isPurine()) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getPyrimidineSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isPyrimidine()) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getAtomBits(String setType, String specInfo) {
        if (setType.equals("IdentifierOrNull")) {
            return this.getIdentifierOrNull(specInfo);
        }
        if (setType.equals("SpecAtom")) {
            return this.getSpecAtom(specInfo);
        }
        if (setType.equals("SpecName")) {
            return this.getSpecName(specInfo);
        }
        if (setType.equals("SpecAlternate")) {
            return this.getSpecAlternate(specInfo);
        }
        if (setType.equals("SpecModel")) {
            return this.getSpecModel(specInfo);
        }
        return null;
    }

    private BitSet getIdentifierOrNull(String identifier) {
        int seqcode;
        BitSet bsInsert;
        BitSet bs = this.getSpecNameOrNull(identifier);
        if (bs != null || identifier.indexOf("?") > 0) {
            return bs;
        }
        int pt = identifier.indexOf("*");
        if (pt > 0) {
            return this.getSpecNameOrNull(identifier.substring(0, pt) + "??????????" + identifier.substring(pt + 1));
        }
        int len = identifier.length();
        for (pt = 0; pt < len && Character.isLetter(identifier.charAt(pt)); ++pt) {
        }
        bs = this.getSpecNameOrNull(identifier.substring(0, pt));
        if (pt == len) {
            return bs;
        }
        if (bs == null) {
            bs = new BitSet();
        }
        int pt0 = pt;
        while (pt < len && Character.isDigit(identifier.charAt(pt))) {
            ++pt;
        }
        int seqNumber = 0;
        try {
            seqNumber = Integer.parseInt(identifier.substring(pt0, pt));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        char insertionCode = ' ';
        if (pt < len && identifier.charAt(pt) == '^' && ++pt < len) {
            insertionCode = identifier.charAt(pt);
        }
        if ((bsInsert = this.getSpecSeqcode(seqcode = Group.getSeqcode(seqNumber, insertionCode), false)) == null) {
            if (insertionCode != ' ') {
                bsInsert = this.getSpecSeqcode(Character.toUpperCase(identifier.charAt(pt)), false);
            }
            if (bsInsert == null) {
                return null;
            }
            ++pt;
        }
        bs.and(bsInsert);
        if (pt >= len) {
            return bs;
        }
        char chainID = identifier.charAt(pt++);
        bs.and(this.getSpecChain(chainID));
        if (pt == len) {
            return bs;
        }
        return null;
    }

    private BitSet getSpecAtom(String atomSpec) {
        BitSet bs = new BitSet();
        atomSpec = atomSpec.toUpperCase();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isAtomNameMatch(atomSpec)) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getSpecName(String name) {
        BitSet bs = this.getSpecNameOrNull(name);
        if (bs != null) {
            return bs;
        }
        int pt = name.indexOf("*");
        if (pt > 0) {
            bs = this.getSpecNameOrNull(name.substring(0, pt) + "??????????" + name.substring(pt + 1));
        }
        return bs == null ? new BitSet() : bs;
    }

    private BitSet getSpecNameOrNull(String name) {
        BitSet bs = null;
        name = name.toUpperCase();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isGroup3OrNameMatch(name)) continue;
            if (bs == null) {
                bs = new BitSet(i + 1);
            }
            bs.set(i);
        }
        return bs;
    }

    private BitSet getSpecAlternate(String alternateSpec) {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isAlternateLocationMatch(alternateSpec)) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getSpecModel(String modelTag) {
        int modelNumber = -1;
        try {
            modelNumber = Integer.parseInt(modelTag);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getModelAtomBitSet(this.getModelNumberIndex(modelNumber));
    }

    BitSet getAtomBits(String setType, int specInfo) {
        if (setType.equals("SpecResid")) {
            return this.getSpecResid(specInfo);
        }
        if (setType.equals("SpecSeqcode")) {
            return this.getSpecSeqcode(specInfo, true);
        }
        if (setType.equals("SpecChain")) {
            return this.getSpecChain((char)specInfo);
        }
        if (setType.equals("atomno")) {
            return this.getSpecAtomNumber(specInfo);
        }
        return null;
    }

    private BitSet getSpecResid(int resid) {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getGroupID() != resid) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getSpecSeqcode(int seqcode, boolean returnEmpty) {
        BitSet bs = new BitSet();
        int seqNum = seqcode >> 8;
        boolean isEmpty = true;
        char insCode = Group.getInsertionCode(seqcode);
        switch (insCode) {
            case '?': {
                int i = this.atomCount;
                while (--i >= 0) {
                    int atomSeqcode = this.atoms[i].getSeqcode();
                    if (seqNum != 0 && seqNum != atomSeqcode >> 8 || (atomSeqcode & 0xFF) == 0) continue;
                    bs.set(i);
                    isEmpty = false;
                }
                break;
            }
            default: {
                int i = this.atomCount;
                while (--i >= 0) {
                    int atomSeqcode = this.atoms[i].getSeqcode();
                    if (seqcode != atomSeqcode && (seqNum != 0 || seqcode != (atomSeqcode & 0xFF)) && (insCode != '*' || seqNum != atomSeqcode >> 8)) continue;
                    bs.set(i);
                    isEmpty = false;
                }
                break block0;
            }
        }
        return !isEmpty || returnEmpty ? bs : null;
    }

    private BitSet getSpecChain(char chain) {
        boolean caseSensitive = this.viewer.getChainCaseSensitive();
        if (!caseSensitive) {
            chain = Character.toUpperCase(chain);
        }
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            char ch = this.atoms[i].getChainID();
            if (!caseSensitive) {
                ch = Character.toUpperCase(ch);
            }
            if (chain != ch) continue;
            bs.set(i);
        }
        return bs;
    }

    private BitSet getSpecAtomNumber(int atomno) {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].getAtomNumber() != atomno) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getAtomBits(String setType, int[] specInfo) {
        if (setType.equals("SpecSeqcodeRange")) {
            return this.getSpecSeqcodeRange(specInfo[0], specInfo[1]);
        }
        if (setType.equals("Cell")) {
            return this.getCellSet(specInfo[0], specInfo[1], specInfo[2]);
        }
        return null;
    }

    private BitSet getSpecSeqcodeRange(int seqcodeA, int seqcodeB) {
        BitSet bs = new BitSet();
        this.mmset.selectSeqcodeRange(seqcodeA, seqcodeB, bs);
        return bs;
    }

    private BitSet getCellSet(int ix, int jy, int kz) {
        BitSet bs = new BitSet();
        Point3f cell = new Point3f((float)ix / 1000.0f, (float)jy / 1000.0f, (float)kz / 1000.0f);
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isInLatticeCell(cell)) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getModelAtomBitSet(int modelIndex) {
        BitSet bs = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != modelIndex) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getModelBitSet(BitSet atomList) {
        BitSet bs = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!atomList.get(i)) continue;
            bs.set(this.atoms[i].modelIndex);
        }
        return bs;
    }

    void setLabel(String label, int atomIndex) {
    }

    void findElementsPresent() {
        this.elementsPresent = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            int n = this.atoms[i].getAtomicAndIsotopeNumber();
            if (n >= 128) {
                n = JmolConstants.elementNumberMax + JmolConstants.altElementIndexFromNumber(n);
            }
            this.elementsPresent.set(n);
        }
    }

    BitSet getElementsPresentBitSet() {
        return this.elementsPresent;
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        this.mmset.calcSelectedGroupsCount(bsSelected);
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        this.mmset.calcSelectedMonomersCount(bsSelected);
    }

    void calcSelectedMoleculesCount(BitSet bsSelected) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp.clear();
            this.bsTemp.or(bsSelected);
            this.bsTemp.and(this.molecules[i].atomList);
            if (this.bsTemp.length() <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    void findMaxRadii() {
        int i = this.atomCount;
        while (--i >= 0) {
            float vdwRadius;
            Atom atom = this.atoms[i];
            float bondingRadius = atom.getBondingRadiusFloat();
            if (bondingRadius > this.maxBondingRadius) {
                this.maxBondingRadius = bondingRadius;
            }
            if (!((vdwRadius = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = vdwRadius;
        }
    }

    void setSurfaceAtoms(BitSet bsSurface, BitSet bsEnclosed) {
        this.bsSurfaceSet = (BitSet)bsEnclosed.clone();
        this.surfaceDistances = null;
        int n = this.viewer.cardinalityOf(bsSurface);
        if (n == 0) {
            this.surfaceAtoms = null;
            return;
        }
        this.surfaceAtoms = new int[n];
        int i = this.atomCount;
        int pt = 0;
        while (--i >= 0) {
            if (!bsSurface.get(i)) continue;
            this.surfaceAtoms[pt++] = i;
        }
    }

    float getSurfaceDistance(int atomIndex) {
        if (this.surfaceAtoms == null) {
            return -1.0f;
        }
        if (this.surfaceDistances == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistances[atomIndex];
    }

    float getSurfaceDistanceMax() {
        if (this.surfaceDistances == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    private void calcSurfaceDistances() {
        this.surfaceDistanceMax = 0.0f;
        if (this.bsSurfaceSet == null) {
            return;
        }
        this.surfaceDistances = new float[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.surfaceDistances[i] = -1.0f;
            if (!this.bsSurfaceSet.get(i)) continue;
            float dMin = Float.MAX_VALUE;
            Atom atom = this.atoms[i];
            int j = this.surfaceAtoms.length;
            while (--j >= 0) {
                float d = this.atoms[this.surfaceAtoms[j]].distance((Point3f)atom);
                dMin = Math.min(d, dMin);
            }
            this.surfaceDistances[i] = dMin;
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, dMin);
        }
    }

    void calcBfactorRange() {
        this.calcBfactorRange(null);
    }

    void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    void calcBfactorRange(BitSet bs) {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = Integer.MAX_VALUE;
            this.bfactor100Hi = Integer.MIN_VALUE;
            int i = this.atomCount;
            while (--i > 0) {
                if (bs != null && !bs.get(i)) continue;
                int bf = this.atoms[i].getBfactor100();
                if (bf < this.bfactor100Lo) {
                    this.bfactor100Lo = bf;
                    continue;
                }
                if (bf <= this.bfactor100Hi) continue;
                this.bfactor100Hi = bf;
            }
            this.hasBfactorRange = true;
        }
    }

    int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.isRangeSelected()) {
                this.calcBfactorRange(this.viewer.getSelectionSet());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    BitSet getVisibleSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (!this.atoms[i].isVisible()) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getClickableSet() {
        BitSet bs = new BitSet();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].clickabilityFlags == 0) continue;
            bs.set(i);
        }
        return bs;
    }

    float getMeasurement(int[] countPlusIndices) {
        float value = Float.MAX_VALUE;
        if (countPlusIndices == null) {
            return value;
        }
        int count = countPlusIndices[0];
        if (count < 2) {
            return value;
        }
        int i = count;
        while (--i >= 0) {
            if (countPlusIndices[i + 1] >= 0) continue;
            return value;
        }
        switch (count) {
            case 2: {
                value = this.getDistance(countPlusIndices[1], countPlusIndices[2]);
                break;
            }
            case 3: {
                value = this.getAngle(countPlusIndices[1], countPlusIndices[2], countPlusIndices[3]);
                break;
            }
            case 4: {
                value = this.getTorsion(countPlusIndices[1], countPlusIndices[2], countPlusIndices[3], countPlusIndices[4]);
                break;
            }
            default: {
                Logger.error((String)("Invalid count in measurement calculation:" + count));
                throw new IndexOutOfBoundsException();
            }
        }
        return value;
    }

    float getDistance(int atomIndexA, int atomIndexB) {
        return this.atoms[atomIndexA].distance((Point3f)this.atoms[atomIndexB]);
    }

    float getAngle(int atomIndexA, int atomIndexB, int atomIndexC) {
        if (this.vectorBA == null) {
            this.vectorBA = new Vector3f();
            this.vectorBC = new Vector3f();
        }
        Atom pointA = this.atoms[atomIndexA];
        Atom pointB = this.atoms[atomIndexB];
        Atom pointC = this.atoms[atomIndexC];
        this.vectorBA.sub((Tuple3f)pointA, (Tuple3f)pointB);
        this.vectorBC.sub((Tuple3f)pointC, (Tuple3f)pointB);
        float angle = this.vectorBA.angle(this.vectorBC);
        float degrees = Frame.toDegrees(angle);
        return degrees;
    }

    float getTorsion(int atomIndexA, int atomIndexB, int atomIndexC, int atomIndexD) {
        return Frame.computeTorsion((Point3f)this.atoms[atomIndexA], (Point3f)this.atoms[atomIndexB], (Point3f)this.atoms[atomIndexC], (Point3f)this.atoms[atomIndexD]);
    }

    static float toDegrees(float angleRadians) {
        return angleRadians * 180.0f / (float)Math.PI;
    }

    static float computeTorsion(Point3f p1, Point3f p2, Point3f p3, Point3f p4) {
        float ci;
        float ijx = p1.x - p2.x;
        float ijy = p1.y - p2.y;
        float ijz = p1.z - p2.z;
        float kjx = p3.x - p2.x;
        float kjy = p3.y - p2.y;
        float kjz = p3.z - p2.z;
        float klx = p3.x - p4.x;
        float kly = p3.y - p4.y;
        float klz = p3.z - p4.z;
        float ax = ijy * kjz - ijz * kjy;
        float ay = ijz * kjx - ijx * kjz;
        float az = ijx * kjy - ijy * kjx;
        float cx = kjy * klz - kjz * kly;
        float cy = kjz * klx - kjx * klz;
        float cz = kjx * kly - kjy * klx;
        float ai2 = 1.0f / (ax * ax + ay * ay + az * az);
        float ci2 = 1.0f / (cx * cx + cy * cy + cz * cz);
        float cross = ax * cx + ay * cy + az * cz;
        float ai = (float)Math.sqrt(ai2);
        float denom = ai * (ci = (float)Math.sqrt(ci2));
        float cosang = cross * denom;
        if (cosang > 1.0f) {
            cosang = 1.0f;
        }
        if (cosang < -1.0f) {
            cosang = -1.0f;
        }
        float torsion = Frame.toDegrees((float)Math.acos(cosang));
        float dot = ijx * cx + ijy * cy + ijz * cz;
        float absDot = Math.abs(dot);
        torsion = dot / absDot > 0.0f ? torsion : -torsion;
        return torsion;
    }

    BitSet getMoleculeBitSet(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    BitSet getMoleculeBitSet(BitSet bs) {
        int iLastBit;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bsResult = (BitSet)bs.clone();
        BitSet bsInitial = (BitSet)bs.clone();
        while ((iLastBit = bsInitial.length()) > 0) {
            this.bsTemp = this.getMoleculeBitSet(iLastBit - 1);
            bsInitial.andNot(this.bsTemp);
            bsResult.or(this.bsTemp);
        }
        return bsResult;
    }

    private void getMolecules() {
        if (this.moleculeCount > 0) {
            return;
        }
        this.moleculeCount = 0;
        int atomCount = this.getAtomCount();
        BitSet atomlist = new BitSet(atomCount);
        BitSet bs = new BitSet(atomCount);
        int thisModelIndex = -1;
        int modelIndex = -1;
        int indexInModel = -1;
        int moleculeCount0 = -1;
        for (int i = 0; i < atomCount; ++i) {
            if (atomlist.get(i) || bs.get(i)) continue;
            modelIndex = this.atoms[i].modelIndex;
            if (modelIndex != thisModelIndex) {
                indexInModel = -1;
                this.mmset.getModel((int)modelIndex).firstMolecule = this.moleculeCount;
                moleculeCount0 = this.moleculeCount - 1;
                thisModelIndex = modelIndex;
            }
            ++indexInModel;
            bs = this.getConnectedBitSet(i);
            atomlist.or(bs);
            if (this.moleculeCount == this.molecules.length) {
                this.molecules = (Molecule[])ArrayUtil.setLength((Object)this.molecules, (int)(this.moleculeCount * 2));
            }
            this.molecules[this.moleculeCount] = new Molecule(this.moleculeCount, bs, thisModelIndex, indexInModel);
            this.mmset.getModel((int)thisModelIndex).moleculeCount = this.moleculeCount - moleculeCount0;
            ++this.moleculeCount;
        }
    }

    private BitSet getConnectedBitSet(int atomIndex) {
        int atomCount = this.getAtomCount();
        BitSet bs = new BitSet(atomCount);
        BitSet bsToTest = this.getModelAtomBitSet(this.atoms[atomIndex].modelIndex);
        this.getCovalentlyConnectedBitSet(this.atoms[atomIndex], bs, bsToTest);
        return bs;
    }

    private void getCovalentlyConnectedBitSet(Atom atom, BitSet bs, BitSet bsToTest) {
        int atomIndex = atom.atomIndex;
        if (!bsToTest.get(atomIndex)) {
            return;
        }
        bsToTest.clear(atomIndex);
        bs.set(atomIndex);
        if (atom.bonds == null) {
            return;
        }
        int i = atom.bonds.length;
        while (--i >= 0) {
            Bond bond = atom.bonds[i];
            if ((bond.order & 0x3C0) != 0) continue;
            if (bond.atom1 == atom) {
                this.getCovalentlyConnectedBitSet(bond.atom2, bs, bsToTest);
                continue;
            }
            this.getCovalentlyConnectedBitSet(bond.atom1, bs, bsToTest);
        }
    }

    int getMoleculeCount() {
        return this.moleculeCount;
    }

    Vector getMoleculeInfo(BitSet bsAtoms) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        Vector<Hashtable> V = new Vector<Hashtable>();
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp = (BitSet)bsAtoms.clone();
            this.bsTemp.and(this.molecules[i].atomList);
            if (this.bsTemp.length() <= 0) continue;
            V.add(this.molecules[i].getInfo());
        }
        return V;
    }

    int getMoleculeIndex(int atomIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(atomIndex)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    int getFirstMoleculeIndexInModel(int modelIndex) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        return this.mmset.getModel((int)modelIndex).firstMolecule;
    }

    int getMoleculeCountInModel(int modelIndex) {
        int n = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (modelIndex != i && modelIndex >= 0) continue;
            n += this.mmset.getModel((int)i).moleculeCount;
        }
        return n;
    }

    void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    Bond[] addToBonds(Bond newBond, Bond[] oldBonds) {
        Bond[] newBonds;
        if (oldBonds == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                newBonds = this.freeBonds[1][this.numCached[1]];
            } else {
                newBonds = new Bond[]{newBond};
            }
        } else {
            int oldLength = oldBonds.length;
            int newLength = oldLength + 1;
            if (newLength < 5 && this.numCached[newLength] > 0) {
                int n = newLength;
                int n2 = this.numCached[n] - 1;
                this.numCached[n] = n2;
                newBonds = this.freeBonds[newLength][n2];
            } else {
                newBonds = new Bond[newLength];
            }
            newBonds[oldLength] = newBond;
            int i = oldLength;
            while (--i >= 0) {
                newBonds[i] = oldBonds[i];
            }
            if (oldLength < 5 && this.numCached[oldLength] < 200) {
                int n = oldLength;
                int n3 = this.numCached[n];
                this.numCached[n] = n3 + 1;
                this.freeBonds[oldLength][n3] = oldBonds;
            }
        }
        return newBonds;
    }

    void freeBondsCache() {
        int i = 5;
        while (--i > 0) {
            this.numCached[i] = 0;
            Bond[][] bondsCache = this.freeBonds[i];
            int j = bondsCache.length;
            while (--j >= 0) {
                bondsCache[j] = null;
            }
        }
    }

    Point3f getAveragePosition(int atomIndex1, int atomIndex2) {
        Atom atom1 = this.atoms[atomIndex1];
        Atom atom2 = this.atoms[atomIndex2];
        return new Point3f((((Tuple3f)atom1).x + ((Tuple3f)atom2).x) / 2.0f, (((Tuple3f)atom1).y + ((Tuple3f)atom2).y) / 2.0f, (((Tuple3f)atom1).z + ((Tuple3f)atom2).z) / 2.0f);
    }

    Vector3f getAtomVector(int atomIndex1, int atomIndex2) {
        Vector3f V = new Vector3f((Tuple3f)this.atoms[atomIndex1]);
        V.sub((Tuple3f)this.atoms[atomIndex2]);
        return V;
    }

    Vector3f getModelDipole() {
        Vector3f dipole = (Vector3f)this.mmset.getModelSetAuxiliaryInfo("dipole");
        if (dipole == null) {
            dipole = (Vector3f)this.mmset.getModelSetAuxiliaryInfo("DIPOLE_VEC");
        }
        return dipole;
    }

    void getBondDipoles() {
        if (this.partialCharges == null) {
            return;
        }
        this.loadShape(24);
        Dipoles dipoles = (Dipoles)this.shapes[24];
        dipoles.clear(true);
        int i = this.bondCount;
        while (--i >= 0) {
            if (!this.bonds[i].isCovalent()) continue;
            Atom atom1 = this.bonds[i].atom1;
            Atom atom2 = this.bonds[i].atom2;
            float c1 = this.partialCharges[atom1.atomIndex];
            float c2 = this.partialCharges[atom2.atomIndex];
            if (c1 == c2) continue;
            Dipole dipole = dipoles.findDipole(atom1, atom2, true);
            float value = (c1 - c2) / 2.0f * atom1.distance((Point3f)atom2) / 0.208194f;
            if (value < 0.0f) {
                dipole.set(atom2, atom1, -value);
            } else {
                dipole.set(atom1, atom2, value);
            }
            dipole.type = (short)3;
            dipole.modelIndex = atom1.modelIndex;
        }
    }

    String getSymmetryInfoAsString(int modelIndex) {
        if (this.cellInfos == null) {
            return "no symmetry information";
        }
        return this.cellInfos[modelIndex].symmetryInfoString;
    }

    void convertFractionalCoordinates(int modelIndex, Point3f pt) {
        if (modelIndex < 0) {
            modelIndex = 0;
        }
        if (modelIndex >= this.cellInfos.length || this.cellInfos[modelIndex] == null) {
            return;
        }
        String str = "Frame convertFractional " + pt + "--->";
        this.cellInfos[modelIndex].toCartesian(pt);
        Logger.info((String)(str + pt));
    }

    void setFormalCharges(BitSet bs, int formalCharge) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bs.get(i)) continue;
            this.atoms[i].setFormalCharge(formalCharge);
        }
        this.reportFormalCharges = true;
    }

    void setAtomCoord(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.atomCount) {
            return;
        }
        ((Tuple3f)this.atoms[atomIndex]).x = x;
        ((Tuple3f)this.atoms[atomIndex]).y = y;
        ((Tuple3f)this.atoms[atomIndex]).z = z;
    }

    void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        if (atomIndex < 0 || atomIndex >= this.atomCount) {
            return;
        }
        ((Tuple3f)this.atoms[atomIndex]).x += x;
        ((Tuple3f)this.atoms[atomIndex]).y += y;
        ((Tuple3f)this.atoms[atomIndex]).z += z;
    }

    void setAtomCoordRelative(BitSet atomSet, float x, float y, float z) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!atomSet.get(i)) continue;
            this.setAtomCoordRelative(i, x, y, z);
        }
    }

    boolean getPrincipalAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoTypeRaw, boolean hybridizationCompatible) {
        String lcaoType = lcaoTypeRaw.length() > 0 && lcaoTypeRaw.charAt(0) == '-' ? lcaoTypeRaw.substring(1) : lcaoTypeRaw;
        Atom atom = this.atoms[atomIndex];
        this.hybridization = "";
        z.set(0.0f, 0.0f, 0.0f);
        x.set(0.0f, 0.0f, 0.0f);
        Atom atom1 = atom;
        Atom atom2 = atom;
        int nBonds = 0;
        float _180 = 2.984513f;
        Vector3f n = new Vector3f();
        Vector3f x2 = new Vector3f();
        Vector3f x3 = new Vector3f(3.14159f, 2.71828f, 1.41421f);
        Vector3f x4 = new Vector3f();
        Vector3f y1 = new Vector3f();
        Vector3f y2 = new Vector3f();
        if (atom.bonds != null) {
            int i = atom.bonds.length;
            block11: while (--i >= 0) {
                if (!atom.bonds[i].isCovalent()) continue;
                atom1 = atom.bonds[i].getOtherAtom(atom);
                n.sub((Tuple3f)atom, (Tuple3f)atom1);
                n.normalize();
                z.add((Tuple3f)n);
                switch (++nBonds) {
                    case 1: {
                        x.set((Tuple3f)n);
                        atom2 = atom1;
                        continue block11;
                    }
                    case 2: {
                        x2.set((Tuple3f)n);
                        continue block11;
                    }
                    case 3: {
                        x3.set((Tuple3f)n);
                        x4.set(-z.x, -z.y, -z.z);
                        continue block11;
                    }
                    case 4: {
                        x4.set((Tuple3f)n);
                        continue block11;
                    }
                }
                i = -1;
            }
        }
        switch (nBonds) {
            case 0: {
                z.set(0.0f, 0.0f, 1.0f);
                x.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (lcaoType.indexOf("sp3") == 0) {
                    this.hybridization = "sp3";
                    x.cross(x3, z);
                    y1.cross(z, x);
                    x.normalize();
                    y1.normalize();
                    y2.set((Tuple3f)x);
                    z.normalize();
                    x.scaleAdd(2.828f, (Tuple3f)x, (Tuple3f)z);
                    if (!lcaoType.equals("sp3a") && !lcaoType.equals("sp3")) {
                        x.normalize();
                        AxisAngle4f a = new AxisAngle4f(z.x, z.y, z.z, (float)(lcaoType.equals("sp3b") ? 1 : -1) * 2.0943952f);
                        Matrix3f m = new Matrix3f();
                        m.setIdentity();
                        m.set(a);
                        m.transform((Tuple3f)x);
                    }
                    z.set((Tuple3f)x);
                    x.cross(y1, z);
                    break;
                }
                this.hybridization = "sp";
                if (atom1.getCovalentBondCount() == 3) {
                    this.getPrincipalAxes(atom1.atomIndex, z, x3, lcaoType, false);
                    x3.set((Tuple3f)x);
                    if (lcaoType.indexOf("sp2") == 0) {
                        this.hybridization = "sp2";
                        z.scale(-1.0f);
                    }
                }
                x.cross(x3, z);
                break;
            }
            case 2: {
                if ((double)z.length() < 0.1) {
                    this.hybridization = "sp";
                    if (!lcaoType.equals("pz")) {
                        if (atom1.getCovalentBondCount() != 3) {
                            atom1 = atom2;
                        }
                        if (atom1.getCovalentBondCount() == 3) {
                            this.getPrincipalAxes(atom1.atomIndex, x, z, "pz", false);
                            if (lcaoType.equals("px")) {
                                x.scale(-1.0f);
                            }
                            z.set((Tuple3f)x2);
                            break;
                        }
                    }
                    z.set((Tuple3f)x);
                    x.cross(x3, z);
                    break;
                }
                this.hybridization = lcaoType.indexOf("sp3") == 0 ? "sp3" : "sp2";
                x3.cross(z, x);
                if (lcaoType.indexOf("sp") == 0) {
                    if (lcaoType.equals("sp2a") || lcaoType.equals("sp2b")) {
                        z.set((Tuple3f)(lcaoType.indexOf("b") >= 0 ? x2 : x));
                        z.scale(-1.0f);
                    }
                    x.cross(z, x3);
                    break;
                }
                if (lcaoType.indexOf("lp") == 0) {
                    this.hybridization = "lp";
                    x3.normalize();
                    z.normalize();
                    y1.scaleAdd(1.2f, (Tuple3f)x3, (Tuple3f)z);
                    y2.scaleAdd(-1.2f, (Tuple3f)x3, (Tuple3f)z);
                    z.set((Tuple3f)(lcaoType.indexOf("b") >= 0 ? y2 : y1));
                    x.cross(z, x3);
                    break;
                }
                this.hybridization = lcaoType;
                x.cross(z, x3);
                z.set((Tuple3f)x3);
                if (!(z.z < 0.0f)) break;
                z.set(-z.x, -z.y, -z.z);
                x.set(-x.x, -x.y, -x.z);
                break;
            }
            default: {
                if (x.angle(x2) < _180) {
                    y1.cross(x, x2);
                } else {
                    y1.cross(x, x3);
                }
                y1.normalize();
                if (x2.angle(x3) < _180) {
                    y2.cross(x2, x3);
                } else {
                    y2.cross(x, x3);
                }
                y2.normalize();
                if (Math.abs(y2.dot(y1)) < 0.95f) {
                    this.hybridization = "sp3";
                    if (lcaoType.indexOf("sp") == 0) {
                        z.set((Tuple3f)(lcaoType.equalsIgnoreCase("sp3") || lcaoType.indexOf("d") >= 0 ? x4 : (lcaoType.indexOf("c") >= 0 ? x3 : (lcaoType.indexOf("b") >= 0 ? x2 : x))));
                        z.scale(-1.0f);
                        x.set((Tuple3f)y1);
                        break;
                    }
                    x.cross(z, x);
                    break;
                }
                this.hybridization = "sp2";
                if (lcaoType.indexOf("sp") == 0) {
                    z.set((Tuple3f)(lcaoType.equalsIgnoreCase("sp3") || lcaoType.indexOf("d") >= 0 ? x4 : (lcaoType.indexOf("c") >= 0 ? x3 : (lcaoType.indexOf("b") >= 0 ? x2 : x))));
                    z.scale(-1.0f);
                    x.set((Tuple3f)y1);
                    break;
                }
                z.set((Tuple3f)y1);
                if (!(z.z < 0.0f)) break;
                z.set(-z.x, -z.y, -z.z);
                x.set(-x.x, -x.y, -x.z);
            }
        }
        x.normalize();
        z.normalize();
        Logger.debug((String)(atom.getIdentity() + " nBonds=" + nBonds + " " + this.hybridization));
        if (hybridizationCompatible) {
            if (this.hybridization == "") {
                return false;
            }
            if (lcaoType.indexOf("p") == 0 ? this.hybridization == "sp3" : lcaoType.indexOf(this.hybridization) < 0) {
                return false;
            }
        }
        return true;
    }

    Point3f[] getAdditionalHydrogens(BitSet atomSet) {
        int n = 0;
        Vector3f z = new Vector3f();
        Vector3f x = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            int nBonds;
            if (!atomSet.get(i) || this.atoms[i].getElementNumber() != 6) continue;
            Atom atom = this.atoms[i];
            int n2 = nBonds = atom.getCovalentHydrogenCount() > 0 ? 0 : atom.getCovalentBondCount();
            if (!(nBonds != 3 && nBonds != 2 || this.viewer.getPrincipalAxes(i, z, x, "sp3", true) && this.hybridization != "sp")) {
                nBonds = 0;
            }
            if (nBonds <= 0 || nBonds > 4) continue;
            n += 4 - nBonds;
        }
        Point3f[] hAtoms = new Point3f[n];
        n = 0;
        block6: for (int i = 0; i < this.atomCount; ++i) {
            if (!atomSet.get(i) || this.atoms[i].getElementNumber() != 6) continue;
            Atom atom = this.atoms[i];
            int nBonds = atom.getCovalentHydrogenCount() > 0 ? 0 : atom.getCovalentBondCount();
            switch (nBonds) {
                case 1: {
                    this.viewer.getPrincipalAxes(i, z, x, "sp3a", false);
                    Point3f pt = new Point3f((Tuple3f)z);
                    pt.scaleAdd(1.1f, (Tuple3f)atom);
                    hAtoms[n++] = pt;
                    this.viewer.getPrincipalAxes(i, z, x, "sp3b", false);
                    pt = new Point3f((Tuple3f)z);
                    pt.scaleAdd(1.1f, (Tuple3f)atom);
                    hAtoms[n++] = pt;
                    this.viewer.getPrincipalAxes(i, z, x, "sp3c", false);
                    pt = new Point3f((Tuple3f)z);
                    pt.scaleAdd(1.1f, (Tuple3f)atom);
                    hAtoms[n++] = pt;
                    continue block6;
                }
                case 2: {
                    if (!this.viewer.getPrincipalAxes(i, z, x, "sp3", true) || this.hybridization == "sp") continue block6;
                    this.viewer.getPrincipalAxes(i, z, x, "lpa", false);
                    Point3f pt = new Point3f((Tuple3f)z);
                    pt.scaleAdd(1.1f, (Tuple3f)atom);
                    hAtoms[n++] = pt;
                    this.viewer.getPrincipalAxes(i, z, x, "lpb", false);
                    pt = new Point3f((Tuple3f)z);
                    pt.scaleAdd(1.1f, (Tuple3f)atom);
                    hAtoms[n++] = pt;
                    continue block6;
                }
                case 3: {
                    if (!this.viewer.getPrincipalAxes(i, z, x, "sp3", true)) continue block6;
                    Point3f pt = new Point3f((Tuple3f)z);
                    pt.scaleAdd(1.1f, (Tuple3f)atom);
                    hAtoms[n++] = pt;
                }
            }
        }
        return hAtoms;
    }

    public void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        if (this.selectionHaloEnabled != selectionHaloEnabled) {
            this.selectionHaloEnabled = selectionHaloEnabled;
        }
    }

    boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean TF) {
        this.echoShapeActive = TF;
    }

    String getState() {
        int i;
        StringBuffer commands = new StringBuffer("# special commands:\n");
        if (this.reportFormalCharges) {
            Hashtable ht = new Hashtable();
            for (int i2 = 0; i2 < this.atomCount; ++i2) {
                StateManager.setStateInfo(ht, i2, i2, "set formalCharge " + this.atoms[i2].getFormalCharge());
            }
            commands.append(StateManager.getCommands(ht));
        }
        Vector fs = this.stateScripts;
        int len = fs.size();
        for (i = 0; i < len; ++i) {
            commands.append(fs.get(i) + "\n");
        }
        commands.append("\n# model state:\n");
        for (i = 0; i < 30; ++i) {
            String cmd;
            Shape shape = this.shapes[i];
            if (shape == null || (cmd = shape.getShapeState()) == null || cmd.length() <= 1) continue;
            commands.append(cmd);
        }
        commands.append("\n");
        return commands.toString();
    }

    class CellInfo {
        int modelIndex;
        boolean coordinatesAreFractional;
        String spaceGroup;
        int symmetryCount;
        String[] symmetryOperations;
        String symmetryInfoString;
        UnitCell unitCell;

        CellInfo(int modelIndex, boolean doPdbScale) {
            Frame.this.notionalUnitcell = (float[])Frame.this.mmset.getModelAuxiliaryInfo(modelIndex, "notionalUnitcell");
            this.modelIndex = modelIndex;
            this.spaceGroup = (String)Frame.this.getModelAuxiliaryInfo(modelIndex, "spaceGroup");
            if (this.spaceGroup == null || this.spaceGroup == "") {
                this.spaceGroup = "spacegroup unspecified";
            }
            this.symmetryCount = Frame.this.mmset.getModelAuxiliaryInfoInt(modelIndex, "symmetryCount");
            this.symmetryOperations = (String[])Frame.this.mmset.getModelAuxiliaryInfo(modelIndex, "symmetryOperations");
            this.symmetryInfoString = "Spacegroup: " + this.spaceGroup;
            if (this.symmetryOperations == null) {
                this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: ?\nSymmetry Operations: unspecified\n";
            } else {
                this.symmetryInfoString = this.symmetryInfoString + "\nNumber of symmetry operations: " + (this.symmetryCount == 0 ? 1 : this.symmetryCount) + "\nSymmetry Operations:";
                for (int i = 0; i < this.symmetryCount; ++i) {
                    this.symmetryInfoString = this.symmetryInfoString + "\n" + this.symmetryOperations[i];
                }
            }
            this.symmetryInfoString = this.symmetryInfoString + "\n";
            this.coordinatesAreFractional = Frame.this.mmset.getModelAuxiliaryInfoBoolean(modelIndex, "coordinatesAreFractional");
            if (Frame.this.notionalUnitcell == null || Frame.this.notionalUnitcell[0] == 0.0f) {
                return;
            }
            this.unitCell = new UnitCell(Frame.this.notionalUnitcell);
            this.showInfo();
        }

        UnitCell getUnitCell() {
            return this.unitCell;
        }

        float[] getNotionalUnitCell() {
            return this.unitCell == null ? null : this.unitCell.getNotionalUnitCell();
        }

        void toCartesian(Point3f pt) {
            this.unitCell.toCartesian(pt);
        }

        void toFractional(Point3f pt) {
            this.unitCell.toFractional(pt);
        }

        void showInfo() {
            if (Logger.isActiveLevel((int)0)) {
                Logger.debug((String)("cellInfos[" + this.modelIndex + "]:\n" + this.unitCell.dumpInfo(true)));
            }
        }

        String getUnitCellInfo() {
            return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
        }
    }

    class WithinAnyModelIterator
    implements AtomIterator {
        int bsptIndex;
        Tuple center;
        float radius;
        SphereIterator bsptIter;

        WithinAnyModelIterator() {
        }

        void initialize(Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = Frame.this.bspf.getBsptCount();
            this.bsptIter = null;
            this.center = center;
            this.radius = radius;
        }

        public boolean hasNext() {
            while (this.bsptIter == null || !this.bsptIter.hasMoreElements()) {
                if (--this.bsptIndex < 0) {
                    this.bsptIter = null;
                    return false;
                }
                this.bsptIter = Frame.this.bspf.getSphereIterator(this.bsptIndex);
                this.bsptIter.initialize(this.center, this.radius);
            }
            return true;
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class WithinModelIterator
    implements AtomIterator {
        int bsptIndex;
        Tuple center;
        float radius;
        SphereIterator bsptIter;

        WithinModelIterator() {
        }

        void initialize(int bsptIndex, Tuple center, float radius) {
            Frame.this.initializeBspf();
            this.bsptIndex = bsptIndex;
            this.bsptIter = Frame.this.bspf.getSphereIterator(bsptIndex);
            this.center = center;
            this.radius = radius;
            this.bsptIter.initialize(center, radius);
        }

        public boolean hasNext() {
            return this.bsptIter.hasMoreElements();
        }

        public Atom next() {
            return (Atom)this.bsptIter.nextElement();
        }

        public void release() {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }

    class SelectedBondIterator
    implements BondIterator {
        short bondType;
        int iBond;
        BitSet bsSelected;
        boolean bondSelectionModeOr;
        boolean isBondBitSet;

        SelectedBondIterator(short bondType, BitSet bsSelected) {
            this.bondType = bondType;
            this.bsSelected = bsSelected;
            this.isBondBitSet = false;
            this.iBond = 0;
            this.bondSelectionModeOr = Frame.this.viewer.getBondSelectionModeOr();
        }

        SelectedBondIterator(BitSet bsSelected) {
            this.bsSelected = bsSelected;
            this.iBond = 0;
            this.isBondBitSet = true;
        }

        public boolean hasNext() {
            while (this.iBond < Frame.this.bondCount) {
                Bond bond = Frame.this.bonds[this.iBond];
                if (this.isBondBitSet) {
                    if (this.bsSelected.get(this.iBond)) {
                        return true;
                    }
                } else if (this.bondType == -1 || (bond.order & this.bondType) != 0) {
                    boolean isSelected2;
                    boolean isSelected1;
                    if (!this.bondSelectionModeOr & (isSelected1 = this.bsSelected.get(bond.atom1.atomIndex)) & (isSelected2 = this.bsSelected.get(bond.atom2.atomIndex)) || this.bondSelectionModeOr & (isSelected1 | isSelected2)) {
                        return true;
                    }
                }
                ++this.iBond;
            }
            return false;
        }

        public int nextIndex() {
            return this.iBond;
        }

        public Bond next() {
            return Frame.this.bonds[this.iBond++];
        }
    }

    class Molecule {
        int moleculeIndex;
        int modelIndex;
        int indexInModel;
        int nAtoms;
        int nElements;
        int[] elementCounts = new int[JmolConstants.elementNumberMax];
        int[] altElementCounts = new int[JmolConstants.altElementMax];
        int elementNumberMax;
        int altElementMax;
        String mf;
        BitSet atomList;

        Hashtable getInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("number", new Integer(this.moleculeIndex + 1));
            info.put("modelNumber", new Integer(this.modelIndex + 1));
            info.put("numberInModel", new Integer(this.indexInModel + 1));
            info.put("nAtoms", new Integer(this.nAtoms));
            info.put("nElements", new Integer(this.nElements));
            info.put("mf", this.mf);
            return info;
        }

        Molecule(int moleculeIndex, BitSet atomList, int modelIndex, int indexInModel) {
            this.atomList = atomList;
            this.moleculeIndex = moleculeIndex;
            this.modelIndex = modelIndex;
            this.indexInModel = indexInModel;
            this.getElementAndAtomCount(atomList);
            this.mf = this.getMolecularFormula();
            if (Logger.isActiveLevel((int)0)) {
                Logger.debug((String)("new Molecule (" + this.mf + ") " + (indexInModel + 1) + "/" + (modelIndex + 1)));
            }
        }

        void getElementAndAtomCount(BitSet atomList) {
            for (int i = 0; i < Frame.this.atomCount; ++i) {
                if (!atomList.get(i)) continue;
                ++this.nAtoms;
                int n = Frame.this.atoms[i].getAtomicAndIsotopeNumber();
                if (n < 128) {
                    int n2 = n;
                    this.elementCounts[n2] = this.elementCounts[n2] + 1;
                    if (this.elementCounts[n] == 1) {
                        ++this.nElements;
                    }
                    this.elementNumberMax = Math.max(this.elementNumberMax, n);
                    continue;
                }
                int n3 = n = JmolConstants.altElementIndexFromNumber(n);
                this.altElementCounts[n3] = this.altElementCounts[n3] + 1;
                if (this.altElementCounts[n] == 1) {
                    ++this.nElements;
                }
                this.altElementMax = Math.max(this.altElementMax, n);
            }
        }

        String getMolecularFormula() {
            int nX;
            int i;
            String mf = "";
            String sep = "";
            for (i = 1; i <= this.elementNumberMax; ++i) {
                nX = this.elementCounts[i];
                if (nX == 0) continue;
                mf = mf + sep + JmolConstants.elementSymbolFromNumber(i) + " " + nX;
                sep = " ";
            }
            for (i = 1; i <= this.altElementMax; ++i) {
                nX = this.altElementCounts[i];
                if (nX == 0) continue;
                mf = mf + sep + JmolConstants.elementSymbolFromNumber(JmolConstants.altElementNumberFromIndex(i)) + " " + nX;
                sep = " ";
            }
            return mf;
        }
    }
}

