/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.api.JmolAdapter;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Viewer;

public final class FrameExportJmolAdapter
extends JmolAdapter {
    Viewer viewer;
    Frame frame;

    FrameExportJmolAdapter(Viewer viewer, Frame frame) {
        super("FrameExportJmolAdapter", null);
        this.viewer = viewer;
        this.frame = frame;
    }

    public String getAtomSetCollectionName(Object clientFile) {
        return this.viewer.getModelSetName();
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return this.frame.atomCount;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return this.frame.notionalUnitcell;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator();
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator();
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        int ibond;
        Bond bond;

        BondIterator() {
            super((JmolAdapter)FrameExportJmolAdapter.this);
        }

        public boolean hasNext() {
            if (this.ibond >= FrameExportJmolAdapter.this.frame.bondCount) {
                return false;
            }
            this.bond = FrameExportJmolAdapter.this.frame.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atom1.atomIndex);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atom2.atomIndex);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        int iatom;
        Atom atom;

        AtomIterator() {
            super((JmolAdapter)FrameExportJmolAdapter.this);
        }

        public boolean hasNext() {
            if (this.iatom == FrameExportJmolAdapter.this.frame.atomCount) {
                return false;
            }
            this.atom = FrameExportJmolAdapter.this.frame.atoms[this.iatom++];
            return true;
        }

        public Object getUniqueID() {
            return new Integer(this.iatom);
        }

        public int getElementNumber() {
            return this.atom.getElementNumber();
        }

        public String getElementSymbol() {
            return this.atom.getElementSymbol();
        }

        public int getFormalCharge() {
            return this.atom.getFormalCharge();
        }

        public float getPartialCharge() {
            return this.atom.getPartialCharge();
        }

        public float getX() {
            return this.atom.getAtomX();
        }

        public float getY() {
            return this.atom.getAtomY();
        }

        public float getZ() {
            return this.atom.getAtomZ();
        }
    }
}

