/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Viewer;

class FrameRenderer {
    boolean logTime;
    long timeBegin;
    Viewer viewer;
    ShapeRenderer[] renderers = new ShapeRenderer[30];

    FrameRenderer(Viewer viewer) {
        this.viewer = viewer;
    }

    void render(Graphics3D g3d, Rectangle rectClip, Frame frame, int displayModelIndex) {
        if (frame == null || !this.viewer.mustRenderFlag()) {
            return;
        }
        this.logTime = this.viewer.getTestFlag1();
        this.viewer.finalizeTransformParameters();
        if (this.logTime) {
            this.timeBegin = System.currentTimeMillis();
        }
        for (int i = 0; i < 30; ++i) {
            Shape shape = frame.shapes[i];
            if (shape == null) continue;
            this.getRenderer(i, g3d).render(g3d, rectClip, frame, displayModelIndex, shape);
        }
        if (this.logTime) {
            Logger.info((String)("render time: " + (System.currentTimeMillis() - this.timeBegin) + " ms"));
        }
    }

    ShapeRenderer getRenderer(int refShape, Graphics3D g3d) {
        if (this.renderers[refShape] == null) {
            this.renderers[refShape] = this.allocateRenderer(refShape, g3d);
        }
        return this.renderers[refShape];
    }

    void clear() {
        for (int i = 0; i < 30; ++i) {
            this.renderers[i] = null;
        }
    }

    ShapeRenderer allocateRenderer(int refShape, Graphics3D g3d) {
        String classBase = JmolConstants.shapeClassBases[refShape] + "Renderer";
        String className = "org.jmol.viewer." + classBase;
        try {
            Class<?> shapeClass = Class.forName(className);
            ShapeRenderer renderer = (ShapeRenderer)shapeClass.newInstance();
            renderer.setViewerFrameRenderer(this.viewer, this, g3d, refShape);
            return renderer;
        }
        catch (Exception e) {
            Logger.error((String)("Could not instantiate renderer:" + classBase), (Throwable)e);
            return null;
        }
    }
}

