/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MeshCollection;

class Pmesh
extends MeshCollection {
    boolean isOnePerLine;
    boolean isFixed;

    Pmesh() {
    }

    void initShape() {
        this.myType = "pmesh";
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("init" == propertyName) {
            this.isFixed = false;
            this.isOnePerLine = false;
            super.setProperty("thisID", null, null);
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            this.setModelIndex();
            return;
        }
        if ("bufferedReaderOnePerLine" == propertyName) {
            propertyName = "bufferedReader";
            this.isOnePerLine = true;
        }
        if ("bufferedReader" == propertyName) {
            BufferedReader br = (BufferedReader)value;
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            this.currentMesh.clear("pmesh");
            this.currentMesh.isValid = this.readPmesh(br);
            if (this.currentMesh.isValid) {
                this.currentMesh.initialize();
                this.currentMesh.visible = true;
            }
            this.setModelIndex();
        }
        super.setProperty(propertyName, value, bs);
    }

    boolean readPmesh(BufferedReader br) {
        try {
            this.readVertexCount(br);
            this.readVertices(br);
            this.readPolygonCount(br);
            this.readPolygonIndexes(br);
        }
        catch (Exception e) {
            this.viewer.scriptStatus("pmesh ERROR: read exception: " + e);
            return false;
        }
        return true;
    }

    void readVertexCount(BufferedReader br) throws Exception {
        this.currentMesh.setVertexCount(0);
        int n = this.parseInt(br.readLine());
        this.currentMesh.setVertexCount(n);
    }

    void readVertices(BufferedReader br) throws Exception {
        if (this.currentMesh.vertexCount <= 0) {
            return;
        }
        if (this.isOnePerLine) {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                float x = this.parseFloat(br.readLine());
                float y = this.parseFloat(br.readLine());
                float z = this.parseFloat(br.readLine());
                this.currentMesh.vertices[i] = new Point3f(x, y, z);
            }
        } else {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                String line = br.readLine();
                float x = this.parseFloat(line);
                float y = this.parseFloat(line, this.ichNextParse);
                float z = this.parseFloat(line, this.ichNextParse);
                this.currentMesh.vertices[i] = new Point3f(x, y, z);
            }
        }
    }

    void readPolygonCount(BufferedReader br) throws Exception {
        this.currentMesh.setPolygonCount(this.parseInt(br.readLine()));
    }

    void readPolygonIndexes(BufferedReader br) throws Exception {
        if (this.currentMesh.polygonCount > 0) {
            for (int i = 0; i < this.currentMesh.polygonCount; ++i) {
                this.currentMesh.polygonIndexes[i] = this.readPolygon(br);
            }
        }
    }

    int[] readPolygon(BufferedReader br) throws Exception {
        int i;
        int vertexIndexCount = this.parseInt(br.readLine());
        if (vertexIndexCount < 2) {
            this.viewer.scriptStatus("pmesh ERROR: each polygon must have at least two verticies indicated");
            this.currentMesh.isValid = false;
            return null;
        }
        int vertexCount = vertexIndexCount - 1;
        int nVertex = vertexCount < 3 ? 3 : vertexCount;
        int[] vertices = new int[nVertex];
        for (i = 0; i < vertexCount; ++i) {
            vertices[i] = this.parseInt(br.readLine());
        }
        for (i = vertexCount; i < nVertex; ++i) {
            vertices[i] = vertices[i - 1];
        }
        int extraVertex = this.parseInt(br.readLine());
        if (extraVertex != vertices[0]) {
            this.viewer.scriptStatus("pmesh Error: last polygon point reference (" + extraVertex + ") is not the same as the first (" + vertices[0] + ")");
            this.currentMesh.isValid = false;
            throw new NullPointerException();
        }
        return vertices;
    }

    void setModelIndex() {
        if (this.currentMesh == null) {
            return;
        }
        this.currentMesh.visible = true;
        int modelCount = this.viewer.getModelCount();
        if (modelCount < 2) {
            this.isFixed = true;
        }
        int modelIndex = -1;
        if (!this.isFixed && (modelIndex = this.viewer.getDisplayModelIndex()) < -1) {
            modelIndex = -2 - modelIndex;
        }
        this.currentMesh.modelIndex = modelIndex;
    }

    void setVisibilityFlags(BitSet bs) {
        int i = this.meshCount;
        while (--i >= 0) {
            Mesh mesh = this.meshes[i];
            mesh.visibilityFlags = mesh.visible && (mesh.modelIndex < 0 || bs.get(mesh.modelIndex)) ? this.myVisibilityFlag : 0;
        }
    }
}

