/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Polyhedra;
import org.jmol.viewer.ShapeRenderer;

class PolyhedraRenderer
extends ShapeRenderer {
    int drawEdges;

    PolyhedraRenderer() {
    }

    void render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedra.Polyhedron[] polyhedrons = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        int i = polyhedra.polyhedronCount;
        while (--i >= 0) {
            this.render1(polyhedrons[i]);
        }
    }

    void render1(Polyhedra.Polyhedron p) {
        if ((p.visibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(p.centralAtom.atomIndex)) {
            return;
        }
        short colix = Graphics3D.inheritColix((short)p.myColix, (short)p.centralAtom.colixAtom);
        Atom[] vertices = p.vertices;
        byte[] planes = p.planes;
        int i = vertices.length;
        while (--i >= 0) {
            if (!vertices[i].isSimple) continue;
            vertices[i].transform(this.viewer);
        }
        boolean isAll = this.drawEdges == 1;
        boolean isFrontOnly = this.drawEdges == 2;
        int i2 = 0;
        int j = 0;
        while (j < planes.length) {
            this.drawFace(colix, p.normixes[i2++], vertices[planes[j++]], vertices[planes[j++]], vertices[planes[j++]], isAll, isFrontOnly);
        }
        i2 = 0;
        j = 0;
        while (j < planes.length) {
            this.fillFace(colix, p.normixes[i2++], vertices[planes[j++]], vertices[planes[j++]], vertices[planes[j++]]);
        }
    }

    void drawFace(short colix, short normix, Atom atomA, Atom atomB, Atom atomC, boolean isAll, boolean isFrontOnly) {
        if (isAll || isFrontOnly && this.g3d.isDirectedTowardsCamera(normix)) {
            this.g3d.drawCylinderTriangle(Graphics3D.getOpaqueColix((short)colix), atomA.screenX, atomA.screenY, atomA.screenZ, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ, 3);
        }
    }

    void fillFace(short colix, short normix, Atom atomA, Atom atomB, Atom atomC) {
        this.g3d.fillTriangle(colix, normix, atomA.screenX, atomA.screenY, atomA.screenZ, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ);
    }
}

