/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

abstract class Shape {
    Viewer viewer;
    Frame frame;
    Graphics3D g3d;
    int shapeID;
    int myVisibilityFlag;

    Shape() {
    }

    final void setViewerG3dFrame(Viewer viewer, Graphics3D g3d, Frame frame, int shapeID) {
        this.viewer = viewer;
        this.g3d = g3d;
        this.frame = frame;
        this.shapeID = shapeID;
        this.myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(shapeID);
        this.initShape();
    }

    void initShape() {
    }

    void setSize(int size, BitSet bsSelected) {
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        Logger.warn((String)("unassigned shape setProperty:" + propertyName + ":" + value));
    }

    Object getProperty(String property, int index) {
        return null;
    }

    boolean wasClicked(int x, int y) {
        return false;
    }

    void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
    }

    void checkBoundsMinMax(Point3f pointMin, Point3f pointMax) {
    }

    void setModelClickability() {
    }

    void checkObjectClicked(int x, int y, int modifiers) {
    }

    void checkObjectDragged(int prevX, int prevY, int deltaX, int deltaY, int modifiers) {
    }

    Vector getShapeDetail() {
        return null;
    }

    String getShapeState() {
        return null;
    }

    void setVisibilityFlags(BitSet bs) {
    }

    static void setStateInfo(Hashtable ht, int i, String key) {
        Shape.setStateInfo(ht, i, i, key);
    }

    static void setStateInfo(Hashtable ht, int i1, int i2, String key) {
        StateManager.setStateInfo(ht, i1, i2, key);
    }

    static String getShapeCommands(Hashtable htDefine, Hashtable htMore, int atomCount) {
        return StateManager.getCommands(htDefine, htMore, atomCount);
    }

    static String getShapeCommands(Hashtable htDefine, Hashtable htMore, int count, String selectCmd) {
        return StateManager.getCommands(htDefine, htMore, count, selectCmd);
    }

    String encodeColor(short colix) {
        return (Graphics3D.isColixTranslucent((short)colix) ? "translucent " : "") + " [x" + this.g3d.getHexColorFromIndex(colix) + "]";
    }

    String getColorCommand(String type, short colix) {
        return this.getColorCommand(type, (short)-1, colix);
    }

    String getColorCommand(String type, short pid, short colix) {
        if (pid < 0 && colix == 0) {
            return "";
        }
        return "color " + type + " " + this.encodeTransColor(pid, colix) + ";\n";
    }

    String encodeTransColor(short colix) {
        return this.encodeTransColor((short)-1, colix);
    }

    String encodeTransColor(short pid, short colix) {
        if (pid < 0 && colix == 0) {
            return "";
        }
        String s = "";
        if (pid >= 0) {
            if (Graphics3D.isColixTranslucent((short)colix)) {
                s = s + "translucent ";
            }
            s = s + JmolConstants.getPaletteName(pid);
        } else {
            s = s + this.encodeColor(colix);
        }
        return s;
    }

    static String getFontCommand(String type, Font3D font) {
        if (font == null) {
            return "";
        }
        return "font " + type + " " + font.fontSize + " " + font.fontFace + " " + font.fontStyle + ";\n";
    }
}

