/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.AminoPolymer;
import org.jmol.viewer.ProteinStructure;

class Sheet
extends ProteinStructure {
    AminoPolymer aminoPolymer;
    Vector3f widthUnitVector;
    Vector3f heightUnitVector;

    Sheet(AminoPolymer aminoPolymer, int monomerIndex, int monomerCount) {
        super(aminoPolymer, (byte)2, monomerIndex, monomerCount);
        this.aminoPolymer = aminoPolymer;
    }

    void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.monomerCount == 2) {
            this.axisA = this.aminoPolymer.getLeadPoint(this.monomerIndex);
            this.axisB = this.aminoPolymer.getLeadPoint(this.monomerIndex + 1);
        } else {
            this.axisA = new Point3f();
            this.aminoPolymer.getLeadMidPoint(this.monomerIndex + 1, this.axisA);
            this.axisB = new Point3f();
            this.aminoPolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub((Tuple3f)this.axisB, (Tuple3f)this.axisA);
        this.axisUnitVector.normalize();
        Point3f tempA = new Point3f();
        this.aminoPolymer.getLeadMidPoint(this.monomerIndex, tempA);
        if (this.lowerNeighborIsHelixOrSheet()) {
            System.out.println("ok");
        } else {
            this.projectOntoAxis(tempA);
        }
        Point3f tempB = new Point3f();
        this.aminoPolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount, tempB);
        if (this.upperNeighborIsHelixOrSheet()) {
            System.out.println("ok");
        } else {
            this.projectOntoAxis(tempB);
        }
        this.axisA = tempA;
        this.axisB = tempB;
    }

    void calcSheetUnitVectors() {
        if (this.widthUnitVector == null) {
            Vector3f vectorCO = new Vector3f();
            Vector3f vectorCOSum = new Vector3f();
            AminoMonomer amino = (AminoMonomer)this.aminoPolymer.monomers[this.monomerIndex];
            vectorCOSum.sub((Tuple3f)amino.getCarbonylOxygenAtomPoint(), (Tuple3f)amino.getCarbonylCarbonAtomPoint());
            int i = this.monomerCount;
            while (--i > 0) {
                amino = (AminoMonomer)this.aminoPolymer.monomers[i];
                vectorCO.sub((Tuple3f)amino.getCarbonylOxygenAtomPoint(), (Tuple3f)amino.getCarbonylCarbonAtomPoint());
                if (vectorCOSum.angle(vectorCO) < 1.5707964f) {
                    vectorCOSum.add((Tuple3f)vectorCO);
                    continue;
                }
                vectorCOSum.sub((Tuple3f)vectorCO);
            }
            this.heightUnitVector = vectorCO;
            this.heightUnitVector.cross(this.axisUnitVector, vectorCOSum);
            this.heightUnitVector.normalize();
            this.widthUnitVector = vectorCOSum;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    Vector3f getWidthUnitVector() {
        if (this.widthUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.widthUnitVector;
    }

    Vector3f getHeightUnitVector() {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.heightUnitVector;
    }
}

