/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Bond;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.ShapeRenderer;

class SticksRenderer
extends ShapeRenderer {
    boolean showMultipleBonds;
    byte modeMultipleBond;
    boolean showHydrogens;
    byte endcaps;
    boolean ssbondsBackbone;
    boolean hbondsBackbone;
    boolean bondsBackbone;
    boolean hbondsSolid;
    boolean asBits;
    Atom atomA;
    Atom atomB;
    int xA;
    int yA;
    int zA;
    int xB;
    int yB;
    int zB;
    int dx;
    int dy;
    int mag2d;
    int mag2d2;
    short colixA;
    short colixB;
    int width;
    int bondOrder;
    short madBond;
    int cylinderNumber;
    int xAxis1;
    int yAxis1;
    int zAxis1;
    int xAxis2;
    int yAxis2;
    int zAxis2;
    int dxStep;
    int dyStep;
    Rectangle rectTemp = new Rectangle();
    private static float wideWidthAngstroms = 0.4f;

    SticksRenderer() {
    }

    void render() {
        this.asBits = this.viewer.getTestFlag2();
        this.endcaps = (byte)3;
        this.showMultipleBonds = this.viewer.getShowMultipleBonds();
        this.modeMultipleBond = this.viewer.getModeMultipleBond();
        this.ssbondsBackbone = this.viewer.getSsbondsBackbone();
        this.hbondsBackbone = this.viewer.getHbondsBackbone();
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.viewer.getHbondsSolid();
        Bond[] bonds = this.frame.bonds;
        int i = this.frame.bondCount;
        while (--i >= 0) {
            Bond bond = bonds[i];
            if ((bond.shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
            this.render(bond);
        }
    }

    void render(Bond bond) {
        this.madBond = bond.mad;
        short order = bond.order;
        Atom atomA = bond.atom1;
        Atom atomB = bond.atom2;
        if (!bond.atom1.isModelVisible() || !bond.atom2.isModelVisible() || !this.g3d.isInDisplayRange(atomA.screenX, atomA.screenY) || !this.g3d.isInDisplayRange(atomB.screenX, atomB.screenY) || this.frame.bsHidden.get(atomA.atomIndex) || this.frame.bsHidden.get(atomB.atomIndex)) {
            return;
        }
        this.colixA = Graphics3D.inheritColix((short)bond.colix, (short)atomA.colixAtom);
        this.colixB = Graphics3D.inheritColix((short)bond.colix, (short)atomB.colixAtom);
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (order & 0x20) != 0) {
                atomA = this.getBackboneAtom(atomA);
                atomB = this.getBackboneAtom(atomB);
            } else if (this.hbondsBackbone && (order & 0x3C0) != 0) {
                atomA = this.getBackboneAtom(atomA);
                atomB = this.getBackboneAtom(atomB);
            }
        }
        this.render(bond, atomA, atomB);
    }

    void render(Bond bond, Atom atomA, Atom atomB) {
        this.atomA = atomA;
        this.xA = atomA.screenX;
        this.yA = atomA.screenY;
        this.zA = atomA.screenZ;
        this.atomB = atomB;
        this.xB = atomB.screenX;
        this.yB = atomB.screenY;
        this.zB = atomB.screenZ;
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = this.viewer.scaleToScreen((this.zA + this.zB) / 2, bond.mad);
        this.bondOrder = this.getRenderBondOrder(bond.order);
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: {
                this.renderCylinder(0);
                break;
            }
            case 1025: {
                this.bondOrder = 1;
                this.renderCylinder(1);
                break;
            }
            case 5: 
            case 2050: {
                this.bondOrder = 2;
                this.renderCylinder(this.getAromaticDottedBondMask(bond));
                break;
            }
            case 9: 
            case 18: {
                this.renderTriangle(bond);
                break;
            }
            default: {
                if ((this.bondOrder & 0x3C0) == 0) break;
                if (this.hbondsSolid) {
                    this.bondOrder = 1;
                    this.renderCylinder(0);
                    break;
                }
                this.renderHbondDashed();
            }
        }
    }

    Atom getBackboneAtom(Atom atom) {
        if (atom.group instanceof Monomer) {
            return ((Monomer)atom.group).getLeadAtom();
        }
        return atom;
    }

    int getRenderBondOrder(int order) {
        if ((order & 0x20) != 0) {
            order &= 0xFFFFFFDF;
        }
        if ((order & 0xC00) != 0) {
            return order;
        }
        if ((order & 3) != 0 && (order == 1 || !this.showMultipleBonds || this.modeMultipleBond == 0 || this.modeMultipleBond == 2 && this.madBond > 500)) {
            return 1;
        }
        return order;
    }

    private void renderCylinder(int dottedMask) {
        boolean lineBond;
        boolean bl = lineBond = this.width <= 1;
        if (this.dx == 0 && this.dy == 0) {
            if (!lineBond) {
                int space = this.width / 8 + 3;
                int step = this.width + space;
                int y = this.yA - (this.bondOrder == 1 ? 0 : (this.bondOrder == 2 ? step / 2 : step));
                do {
                    this.g3d.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, y, this.zA, this.xA, y, this.zA);
                    y += step;
                } while (--this.bondOrder > 0);
            }
            return;
        }
        if (this.bondOrder == 1) {
            if ((dottedMask & 1) != 0) {
                this.drawDashed(lineBond, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else if (lineBond) {
                this.g3d.drawLine(this.colixA, this.colixB, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else if (this.asBits) {
                this.g3d.fillCylinderBits(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else {
                this.g3d.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        int dxB = this.dx * this.dx;
        int dyB = this.dy * this.dy;
        int mag2d2 = dxB + dyB;
        this.mag2d = (int)(Math.sqrt(mag2d2) + 0.5);
        this.resetAxisCoordinates(lineBond);
        while (true) {
            if ((dottedMask & 1) != 0) {
                this.drawDashed(lineBond, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            } else if (lineBond) {
                this.g3d.drawLine(this.colixA, this.colixB, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            } else {
                this.g3d.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            dottedMask >>= 1;
            if (--this.bondOrder == 0) break;
            this.stepAxisCoordinates();
        }
    }

    void resetAxisCoordinates(boolean lineBond) {
        this.cylinderNumber = 0;
        int space = this.mag2d >> 3;
        int step = this.width + space;
        this.dxStep = step * this.dy / this.mag2d;
        this.dyStep = step * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.zAxis1 = this.zA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        this.zAxis2 = this.zB;
        if (this.bondOrder == 2) {
            this.xAxis1 -= this.dxStep / 2;
            this.yAxis1 -= this.dyStep / 2;
            this.xAxis2 -= this.dxStep / 2;
            this.yAxis2 -= this.dyStep / 2;
        } else if (this.bondOrder == 3) {
            this.xAxis1 -= this.dxStep;
            this.yAxis1 -= this.dyStep;
            this.xAxis2 -= this.dxStep;
            this.yAxis2 -= this.dyStep;
        }
    }

    void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private void renderTriangle(Bond bond) {
        int dyWide;
        int dxWide;
        int mag2d = (int)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        int wideWidthPixels = (int)this.viewer.scaleToScreen(this.zB, wideWidthAngstroms);
        if (mag2d == 0) {
            dxWide = 0;
            dyWide = wideWidthPixels;
        } else {
            dxWide = wideWidthPixels * -this.dy / mag2d;
            dyWide = wideWidthPixels * this.dx / mag2d;
        }
        int xWideUp = this.xB + dxWide / 2;
        int xWideDn = xWideUp - dxWide;
        int yWideUp = this.yB + dyWide / 2;
        int yWideDn = yWideUp - dyWide;
        if (this.colixA == this.colixB) {
            this.g3d.drawfillTriangle(this.colixA, this.xA, this.yA, this.zA, xWideUp, yWideUp, this.zB, xWideDn, yWideDn, this.zB);
        } else {
            int xMidUp = (this.xA + xWideUp) / 2;
            int yMidUp = (this.yA + yWideUp) / 2;
            int zMid = (this.zA + this.zB) / 2;
            int xMidDn = (this.xA + xWideDn) / 2;
            int yMidDn = (this.yA + yWideDn) / 2;
            this.g3d.drawfillTriangle(this.colixA, this.xA, this.yA, this.zA, xMidUp, yMidUp, zMid, xMidDn, yMidDn, zMid);
            this.g3d.drawfillTriangle(this.colixB, xMidUp, yMidUp, zMid, xMidDn, yMidDn, zMid, xWideDn, yWideDn, this.zB);
            this.g3d.drawfillTriangle(this.colixB, xMidUp, yMidUp, zMid, xWideUp, yWideUp, this.zB, xWideDn, yWideDn, this.zB);
        }
    }

    void drawDottedCylinder(short colixA, short colixB, int width, int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int i = 8;
        while (--i >= 0) {
            int x = x1 + dx * i / 7;
            int y = y1 + dy * i / 7;
            int z = z1 + dz * i / 7;
            this.g3d.fillSphereCentered(i > 3 ? colixB : colixA, width, x, y, z);
        }
    }

    private int getAromaticDottedBondMask(Bond bond) {
        Atom atomC = this.findAromaticNeighbor(bond);
        if (atomC == null) {
            return 1;
        }
        int dxAC = atomC.getScreenX() - this.xA;
        int dyAC = atomC.getScreenY() - this.yA;
        return this.dx * dyAC - this.dy * dxAC >= 0 ? 2 : 1;
    }

    private Atom findAromaticNeighbor(Bond bond) {
        Bond[] bonds = this.atomB.bonds;
        int i = bonds.length;
        while (--i >= 0) {
            Bond bondT = bonds[i];
            if ((bondT.order & 5) == 0 || bondT == bond) continue;
            if (bondT.atom1 == this.atomB) {
                return bondT.atom2;
            }
            if (bondT.atom2 != this.atomB) continue;
            return bondT.atom1;
        }
        return null;
    }

    void drawDashed(boolean lineBond, int xA, int yA, int zA, int xB, int yB, int zB) {
        int dx = xB - xA;
        int dy = yB - yA;
        int dz = zB - zA;
        for (int i = 2; i <= 9; i += 2) {
            int xS = xA + dx * i / 12;
            int yS = yA + dy * i / 12;
            int zS = zA + dz * i / 12;
            int xE = xA + dx * (i += 3) / 12;
            int yE = yA + dy * i / 12;
            int zE = zA + dz * i / 12;
            if (lineBond) {
                this.g3d.drawLine(this.colixA, this.colixB, xS, yS, zS, xE, yE, zE);
                continue;
            }
            this.g3d.fillCylinder(this.colixA, this.colixB, (byte)2, this.width, xS, yS, zS, xE, yE, zE);
        }
    }

    void renderHbondDashed() {
        boolean lineBond = this.width <= 1;
        int dx = this.xB - this.xA;
        int dy = this.yB - this.yA;
        int dz = this.zB - this.zA;
        for (int i = 1; i < 10; ++i) {
            int xS = this.xA + dx * i / 10;
            int yS = this.yA + dy * i / 10;
            int zS = this.zA + dz * i / 10;
            short colixS = i < 5 ? this.colixA : this.colixB;
            int xE = this.xA + dx * (i += 2) / 10;
            int yE = this.yA + dy * i / 10;
            int zE = this.zA + dz * i / 10;
            short colixE = i < 5 ? this.colixA : this.colixB;
            if (lineBond) {
                this.g3d.drawLine(colixS, colixE, xS, yS, zS, xE, yE, zE);
                continue;
            }
            this.g3d.fillCylinder(colixS, colixE, (byte)2, this.width, xS, yS, zS, xE, yE, zE);
        }
    }
}

