/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Shape;

class Vectors
extends Shape {
    String[] strings;
    short[] mads;
    short[] colixes;

    Vectors() {
    }

    void initShape() {
        if (this.frame.hasVibrationVectors) {
            this.mads = new short[this.frame.atomCount];
            this.colixes = new short[this.frame.atomCount];
        }
    }

    void setSize(int size, BitSet bsSelected) {
        if (this.frame.hasVibrationVectors) {
            short mad = (short)size;
            int i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.mads[i] = mad;
                this.frame.atoms[i].setShapeVisibility(this.myVisibilityFlag, mad != 0);
            }
        }
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        if (this.frame.hasVibrationVectors && "color" == propertyName) {
            short colix = Graphics3D.getColix((Object)value);
            int i = this.frame.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.colixes[i] = colix;
            }
        }
    }

    void setModelClickability() {
        if (this.mads == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) == 0) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }
}

