/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Base64;
import org.jmol.util.CommandHistory;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.Eval;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Frame;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.ScriptManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TempManager;
import org.jmol.viewer.TransformManager;

public class Viewer
extends JmolViewer {
    private Component display;
    private Graphics3D g3d;
    private JmolAdapter modelAdapter;
    private CommandHistory commandHistory = new CommandHistory();
    private ColorManager colorManager;
    private Eval eval;
    private FileManager fileManager;
    private ModelManager modelManager;
    private MouseManager mouseManager;
    private PickingManager pickingManager;
    private PropertyManager propertyManager;
    private RepaintManager repaintManager;
    private ScriptManager scriptManager;
    private SelectionManager selectionManager;
    private StateManager stateManager;
    private StateManager.GlobalSettings global;
    private StatusManager statusManager;
    private TempManager tempManager;
    private TransformManager transformManager;
    private String strJavaVendor;
    private String strJavaVersion;
    private String strOSName;
    private String htmlName = "";
    private boolean jvm11orGreater = false;
    private boolean jvm12orGreater = false;
    private boolean jvm14orGreater = false;
    boolean isSilent = false;
    boolean isApplet = false;
    boolean autoExit = false;
    String writeInfo;
    boolean haveDisplay = true;
    boolean mustRender = true;
    final Hashtable imageCache = new Hashtable();
    static final float radiansPerDegree = (float)Math.PI / 180;
    String loadScript;
    static Hashtable dataValues = new Hashtable();
    boolean wasInMotion = false;
    int motionEventNumber;
    private boolean refreshing;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    final Rectangle rectClip = new Rectangle();
    int hoverAtomIndex = -1;
    private DecimalFormat[] formatters;
    private static String[] formattingStrings = new String[]{"0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"};
    boolean isTainted = true;

    public void finalize() {
        Logger.debug((String)("viewer finalize " + (Object)((Object)this)));
    }

    Viewer(Component display, JmolAdapter modelAdapter) {
        Logger.debug((String)("Viewer constructor " + (Object)((Object)this)));
        this.display = display;
        this.modelAdapter = modelAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        this.stateManager = new StateManager(this);
        this.g3d = new Graphics3D(display);
        this.colorManager = new ColorManager(this, this.g3d);
        this.resetAllParameters();
        this.statusManager = new StatusManager(this);
        this.scriptManager = new ScriptManager(this);
        this.transformManager = new TransformManager(this);
        this.selectionManager = new SelectionManager(this);
        this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(display, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(display, this) : new MouseManager10(display, this));
        this.modelManager = new ModelManager(this);
        this.propertyManager = new PropertyManager(this);
        this.tempManager = new TempManager(this);
        this.pickingManager = new PickingManager(this);
        this.fileManager = new FileManager(this, modelAdapter);
        this.repaintManager = new RepaintManager(this);
        this.eval = new Eval(this);
    }

    public static JmolViewer allocateViewer(Component display, JmolAdapter modelAdapter) {
        return new Viewer(display, modelAdapter);
    }

    public void setAppletContext(String htmlName, URL documentBase, URL codeBase, String appletProxyOrCommandOptions) {
        this.htmlName = htmlName;
        this.isApplet = documentBase != null;
        String str = appletProxyOrCommandOptions;
        if (!this.isApplet) {
            if (str.indexOf("-i") >= 0) {
                Viewer.setLogLevel(3);
                this.isSilent = true;
            }
            if (str.indexOf("-x") >= 0) {
                this.autoExit = true;
            }
            if (str.indexOf("-n") >= 0) {
                this.haveDisplay = false;
            }
            this.writeInfo = null;
            if (str.indexOf("-w") >= 0) {
                int i = str.indexOf("\u0001");
                int j = str.lastIndexOf("\u0001");
                this.writeInfo = str.substring(i + 1, j);
            }
            boolean bl = this.mustRender = this.haveDisplay || this.writeInfo != null;
        }
        if (!this.isSilent) {
            Logger.info((String)("(C) 2006 Jmol Development\nJmol Version " + this.getJmolVersion() + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName + "\n" + htmlName));
        }
        if (this.isApplet) {
            this.fileManager.setAppletContext(documentBase, codeBase, appletProxyOrCommandOptions);
        }
        this.zap();
    }

    String getHtmlName() {
        return this.htmlName;
    }

    boolean mustRenderFlag() {
        return this.mustRender && this.refreshing;
    }

    static void setLogLevel(int ilevel) {
        int i = 5;
        while (--i >= 0) {
            Logger.setActiveLevel((int)i, (5 - i <= ilevel ? 1 : 0) != 0);
        }
    }

    public Component getAwtComponent() {
        return this.display;
    }

    public boolean handleOldJvm10Event(Event e) {
        return this.mouseManager.handleOldJvm10Event(e);
    }

    void reset() {
        this.transformManager.homePosition();
        if (this.modelManager.modelsHaveSymmetry()) {
            this.stateManager.setCrystallographicDefaults();
        }
        this.refresh(1, "Viewer:homePosition()");
    }

    public void homePosition() {
        this.script("reset");
    }

    void flushCachedImages() {
        this.imageCache.clear();
        this.colorManager.flushCachedColors();
    }

    Hashtable getAppletInfo() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        info.put("htmlName", this.htmlName);
        info.put("version", "10.9.98");
        info.put("date", JmolConstants.date);
        info.put("javaVendor", this.strJavaVendor);
        info.put("javaVersion", this.strJavaVersion);
        info.put("operatingSystem", this.strOSName);
        return info;
    }

    String getJmolVersion() {
        return "10.9.98  " + JmolConstants.date;
    }

    void initialize() {
        this.resetAllParameters();
    }

    void resetAllParameters() {
        this.global = this.stateManager.getGlobalSettings();
        this.colorManager.resetElementColors();
    }

    String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    void saveOrientation(String saveName) {
        this.stateManager.saveOrientation(saveName);
    }

    boolean restoreOrientation(String saveName, float timeSeconds) {
        return this.stateManager.restoreOrientation(saveName, timeSeconds);
    }

    void saveBonds(String saveName) {
        this.stateManager.saveBonds(saveName);
    }

    boolean restoreBonds(String saveName) {
        return this.stateManager.restoreBonds(saveName);
    }

    void saveState(String saveName) {
        this.stateManager.saveState(saveName);
    }

    String getSavedState(String saveName) {
        return this.stateManager.getSavedState(saveName);
    }

    boolean restoreState(String saveName) {
        return this.stateManager.restoreState(saveName);
    }

    void saveSelection(String saveName) {
        this.stateManager.saveSelection(saveName, this.selectionManager.bsSelection);
        this.stateManager.restoreSelection(saveName);
    }

    boolean restoreSelection(String saveName) {
        return this.stateManager.restoreSelection(saveName);
    }

    public float getRotationRadius() {
        return this.transformManager.getRotationRadius();
    }

    Point3f getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    void setCenter(String relativeTo, Point3f pt) {
        this.transformManager.setCenter(relativeTo, pt);
        this.refresh(0, "Viewer:setCenter(" + relativeTo + ")");
    }

    void setCenterBitSet(BitSet bsCenter, boolean doScale) {
        this.transformManager.setCenterBitSet(bsCenter, doScale);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    void setNewRotationCenter(String axisID) {
        Point3f center = this.getDrawObjectCenter(axisID);
        if (center == null) {
            return;
        }
        this.setNewRotationCenter(center);
    }

    void setNewRotationCenter(Point3f center) {
        this.transformManager.setNewRotationCenter(center, true);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    void move(Vector3f dRot, int dZoom, Vector3f dTrans, int dSlab, float floatSecondsTotal, int fps) {
        this.transformManager.move(dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
    }

    public void moveTo(float floatSecondsTotal, Point3f center, Point3f pt, float degrees, float zoom, float xTrans, float yTrans, float rotationRadius) {
        this.transformManager.moveTo(floatSecondsTotal, center, pt, degrees, zoom, xTrans, yTrans, rotationRadius);
    }

    public void moveTo(float floatSecondsTotal, Matrix3f rotationMatrix, Point3f center, float zoom, float xTrans, float yTrans, float rotationRadius) {
        this.transformManager.moveTo(floatSecondsTotal, rotationMatrix, center, zoom, xTrans, yTrans, rotationRadius);
    }

    String getMoveToText(float timespan) {
        return this.transformManager.getMoveToText(timespan);
    }

    void rotateXYBy(int xDelta, int yDelta) {
        this.transformManager.rotateXYBy(xDelta, yDelta);
        this.refresh(1, "Viewer:rotateXYBy()");
    }

    void rotateZBy(int zDelta) {
        this.transformManager.rotateZBy(zDelta);
        this.refresh(1, "Viewer:rotateZBy()");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void rotateToX(float angleRadians) {
        this.transformManager.rotateToX(angleRadians);
        this.refresh(1, "Viewer:rotateToX()");
    }

    public void rotateToY(float angleRadians) {
        this.transformManager.rotateToY(angleRadians);
        this.refresh(1, "Viewer:rotateToY()");
    }

    public void rotateToZ(float angleRadians) {
        this.transformManager.rotateToZ(angleRadians);
        this.refresh(1, "Viewer:rotateToZ()");
    }

    public void rotateToX(int angleDegrees) {
        this.rotateToX((float)angleDegrees * ((float)Math.PI / 180));
    }

    public void rotateToY(int angleDegrees) {
        this.rotateToY((float)angleDegrees * ((float)Math.PI / 180));
    }

    void translateXYBy(int xDelta, int yDelta) {
        this.transformManager.translateXYBy(xDelta, yDelta);
        this.refresh(1, "Viewer:translateXYBy()");
    }

    void translateToXPercent(float percent) {
        this.transformManager.translateToXPercent(percent);
        this.refresh(1, "Viewer:translateToXPercent()");
    }

    void translateToYPercent(float percent) {
        this.transformManager.translateToYPercent(percent);
        this.refresh(1, "Viewer:translateToYPercent()");
    }

    void translateToZPercent(float percent) {
        this.transformManager.translateToZPercent(percent);
        this.refresh(1, "Viewer:translateToZPercent()");
    }

    float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    void zoomBy(int pixels) {
        this.transformManager.zoomBy(pixels);
        this.refresh(1, "Viewer:zoomBy()");
    }

    public int getZoomPercent() {
        return this.transformManager.getZoomPercent();
    }

    float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    float getZoomPercentSetting() {
        return this.transformManager.getZoomPercentSetting();
    }

    float getMaxZoomPercent() {
        return 200000.0f;
    }

    void zoomToPercent(float percent) {
        this.transformManager.zoomToPercent(percent);
        this.refresh(1, "Viewer:zoomToPercent()");
    }

    void zoomByPercent(int percent) {
        this.transformManager.zoomByPercent(percent);
        this.refresh(1, "Viewer:zoomByPercent()");
    }

    private void setZoomEnabled(boolean zoomEnabled) {
        this.transformManager.setZoomEnabled(zoomEnabled);
        this.refresh(1, "Viewer:setZoomEnabled()");
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    int getSlabPercentSetting() {
        return this.transformManager.slabPercentSetting;
    }

    void slabByPixels(int pixels) {
        this.transformManager.slabByPercentagePoints(pixels);
        this.refresh(0, "Viewer:slabByPixels()");
    }

    void depthByPixels(int pixels) {
        this.transformManager.depthByPercentagePoints(pixels);
        this.refresh(0, "Viewer:depthByPixels()");
    }

    void slabDepthByPixels(int pixels) {
        this.transformManager.slabDepthByPercentagePoints(pixels);
        this.refresh(0, "Viewer:slabDepthByPixels()");
    }

    void slabToPercent(int percentSlab) {
        this.transformManager.slabToPercent(percentSlab);
        this.refresh(0, "Viewer:slabToPercent()");
    }

    void depthToPercent(int percentDepth) {
        this.transformManager.depthToPercent(percentDepth);
        this.refresh(0, "Viewer:depthToPercent()");
    }

    private void setSlabEnabled(boolean slabEnabled) {
        this.transformManager.setSlabEnabled(slabEnabled);
        this.refresh(0, "Viewer:setSlabEnabled()");
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.g3d.setSlabAndDepthValues(this.transformManager.slabValue, this.transformManager.depthValue);
    }

    Point3i transformPoint(Point3f pointAngstroms) {
        return this.transformManager.transformPoint(pointAngstroms);
    }

    Point3i transformPoint(Point3f pointAngstroms, Vector3f vibrationVector) {
        return this.transformManager.transformPoint(pointAngstroms, vibrationVector);
    }

    void transformPoint(Point3f pointAngstroms, Vector3f vibrationVector, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, vibrationVector, pointScreen);
    }

    void transformPoint(Point3f pointAngstroms, Point3i pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    void transformPoint(Point3f pointAngstroms, Point3f pointScreen) {
        this.transformManager.transformPoint(pointAngstroms, pointScreen);
    }

    void transformPoints(Point3f[] pointsAngstroms, Point3i[] pointsScreens) {
        this.transformManager.transformPoints(pointsAngstroms.length, pointsAngstroms, pointsScreens);
    }

    void transformVector(Vector3f vectorAngstroms, Vector3f vectorTransformed) {
        this.transformManager.transformVector(vectorAngstroms, vectorTransformed);
    }

    void unTransformPoint(Point3i pointScreen, Point3f pointAngstroms) {
        this.transformManager.unTransformPoint(pointScreen, pointAngstroms);
    }

    float getScalePixelsPerAngstrom() {
        return this.transformManager.scalePixelsPerAngstrom;
    }

    float scaleToScreen(int z, float sizeAngstroms) {
        return this.transformManager.scaleToScreen(z, sizeAngstroms);
    }

    short scaleToScreen(int z, int milliAngstroms) {
        return this.transformManager.scaleToScreen(z, milliAngstroms);
    }

    float scaleToPerspective(int z, float sizeAngstroms) {
        return this.transformManager.scaleToPerspective(z, sizeAngstroms);
    }

    void scaleFitToScreen() {
        this.transformManager.scaleFitToScreen();
    }

    void checkCameraDistance() {
        if (!this.allowCameraMove()) {
            return;
        }
        this.transformManager.checkCameraDistance();
    }

    private void setScaleAngstromsPerInch(float angstromsPerInch) {
        this.transformManager.setScaleAngstromsPerInch(angstromsPerInch);
    }

    private void setVibrationPeriod(float period) {
        this.transformManager.setVibrationPeriod(period);
    }

    void setSpinX(int value) {
        this.transformManager.setSpinX(value);
    }

    float getSpinX() {
        return this.transformManager.spinX;
    }

    void setSpinY(int value) {
        this.transformManager.setSpinY(value);
    }

    float getSpinY() {
        return this.transformManager.spinY;
    }

    void setSpinZ(int value) {
        this.transformManager.setSpinZ(value);
    }

    float getSpinZ() {
        return this.transformManager.spinZ;
    }

    void setSpinFps(int value) {
        this.transformManager.setSpinFps(value);
    }

    float getSpinFps() {
        return this.transformManager.spinFps;
    }

    void setSpinOn(boolean spinOn) {
        this.transformManager.setSpinOn(spinOn);
    }

    boolean getSpinOn() {
        return this.transformManager.spinOn;
    }

    String getOrientationText() {
        return this.transformManager.getOrientationText();
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    void getAxisAngle(AxisAngle4f axisAngle) {
        this.transformManager.getAxisAngle(axisAngle);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void getRotation(Matrix3f matrixRotation) {
        this.transformManager.getRotation(matrixRotation);
    }

    private void setDefaultColors(String colorScheme) {
        this.colorManager.setDefaultColors(colorScheme);
    }

    int getColixArgb(short colix) {
        return this.g3d.getColixArgb(colix);
    }

    void setRubberbandArgb(int argb) {
        this.colorManager.setRubberbandArgb(argb);
    }

    short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    void setElementArgb(int elementNumber, int argb) {
        this.global.setParameterValue("_color " + JmolConstants.elementNameFromNumber(elementNumber), StateManager.encodeColor(argb));
        this.colorManager.setElementArgb(elementNumber, argb);
    }

    float getVectorScale() {
        return this.transformManager.vectorScale;
    }

    private void setVectorScale(float scale) {
        this.transformManager.setVectorScale(scale);
    }

    private void setVibrationScale(float scale) {
        this.transformManager.setVibrationScale(scale);
    }

    float getVibrationScale() {
        return this.transformManager.vibrationScale;
    }

    void setBackgroundArgb(int argb) {
        this.global.argbBackground = argb;
        this.g3d.setBackgroundArgb(argb);
        this.colorManager.setColixBackgroundContrast(argb);
        this.refresh(0, "Viewer:setBackgroundArgb()");
    }

    public int getBackgroundArgb() {
        return this.global.argbBackground;
    }

    private void setColorBackground(String colorName) {
        if (colorName != null && colorName.length() > 0) {
            this.setBackgroundArgb(Graphics3D.getArgbFromString((String)colorName));
        }
    }

    short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    int getArgbFromString(String colorName) {
        return Graphics3D.getArgbFromString((String)colorName);
    }

    private void setSpecular(boolean specular) {
        this.colorManager.setSpecular(specular);
    }

    boolean getSpecular() {
        return this.colorManager.getSpecular();
    }

    private void setSpecularPower(int specularPower) {
        this.colorManager.setSpecularPower(specularPower);
    }

    private void setAmbientPercent(int ambientPercent) {
        this.colorManager.setAmbientPercent(ambientPercent);
    }

    private void setDiffusePercent(int diffusePercent) {
        this.colorManager.setDiffusePercent(diffusePercent);
    }

    private void setSpecularPercent(int specularPercent) {
        this.colorManager.setSpecularPercent(specularPercent);
    }

    short getColixAtomPalette(Atom atom, int pid) {
        return this.colorManager.getColixAtomPalette(atom, pid);
    }

    short getColixHbondType(short order) {
        return this.colorManager.getColixHbondType(order);
    }

    short getColixFromPalette(float val, float rangeMin, float rangeMax, String palette) {
        return this.colorManager.getColixFromPalette(val, rangeMin, rangeMax, palette);
    }

    void select(BitSet bs, boolean isQuiet) {
        this.selectionManager.select(bs, isQuiet);
    }

    void selectBonds(BitSet bs) {
        this.selectionManager.selectBonds(bs);
    }

    boolean isBondSelection() {
        return !this.selectionManager.selectionModeAtoms;
    }

    BitSet getSelectedAtomsOrBonds() {
        return this.selectionManager.getSelectedAtomsOrBonds();
    }

    BitSet getSelectedBonds() {
        return this.selectionManager.bsBonds;
    }

    void hide(BitSet bs, boolean isQuiet) {
        this.selectionManager.hide(bs, isQuiet);
    }

    void display(BitSet bsAll, BitSet bs, boolean isQuiet) {
        this.selectionManager.display(bsAll, bs, isQuiet);
    }

    BitSet getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    boolean isSelected(int atomIndex) {
        return this.selectionManager.isSelected(atomIndex);
    }

    boolean isInSelectionSubset(int atomIndex) {
        return this.selectionManager.isInSelectionSubset(atomIndex);
    }

    void reportSelection(String msg) {
        if (this.modelManager.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        this.scriptStatus(msg);
    }

    public void selectAll() {
        this.selectionManager.selectAll();
        this.refresh(0, "Viewer:selectAll()");
    }

    public void clearSelection() {
        this.selectionManager.clearSelection();
        this.refresh(0, "Viewer:clearSelection()");
    }

    public void setSelectionSet(BitSet set) {
        this.selectionManager.setSelectionSet(set);
        this.refresh(0, "Viewer:setSelectionSet()");
    }

    void setSelectionSubset(BitSet subset) {
        this.selectionManager.setSelectionSubset(subset);
    }

    private void setHideNotSelected(boolean TF) {
        this.selectionManager.setHideNotSelected(TF);
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    void setFormalCharges(int formalCharge) {
        this.modelManager.setFormalCharges(this.selectionManager.bsSelection, formalCharge);
    }

    public void addSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    public void removeSelectionListener(JmolSelectionListener listener) {
        this.selectionManager.addListener(listener);
    }

    BitSet getAtomBitSet(String atomExpression) {
        return this.selectionManager.getAtomBitSet(atomExpression);
    }

    int firstAtomOf(BitSet bs) {
        return this.modelManager.firstAtomOf(bs);
    }

    Point3f getAtomSetCenter(BitSet bs) {
        return this.modelManager.getAtomSetCenter(bs);
    }

    Vector getAtomBitSetVector(String atomExpression) {
        return this.selectionManager.getAtomBitSetVector(atomExpression);
    }

    public void setModeMouse(int modeMouse) {
        this.mouseManager.setModeMouse(modeMouse);
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    private void setAppletProxy(String appletProxy) {
        this.fileManager.setAppletProxy(appletProxy);
    }

    public boolean isApplet() {
        return this.htmlName.length() > 0;
    }

    private void setDefaultDirectory(String dir) {
        this.global.defaultDirectory = dir == null || dir.length() == 0 ? null : dir;
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    Object getInputStreamOrErrorMessageFromName(String name) {
        return this.fileManager.getInputStreamOrErrorMessageFromName(name);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String name) {
        return this.fileManager.getUnzippedBufferedReaderOrErrorMessageFromName(name);
    }

    Object getBufferedReaderForString(String string) {
        return this.fileManager.getBufferedReaderForString(string);
    }

    public void openFile(String name) {
        this.openFile(name, null, null);
    }

    void openFile(String name, int[] params, String loadScript) {
        if (name == null) {
            return;
        }
        if (name.equalsIgnoreCase("string")) {
            this.openStringInline(this.fileManager.inlineData, params);
            return;
        }
        if (name.equalsIgnoreCase("string[]")) {
            this.openStringInline(this.fileManager.inlineDataArray, params);
            return;
        }
        this.zap();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openFile(name, params, loadScript);
        long ms = System.currentTimeMillis() - timeBegin;
        this.setStatusFileLoaded(1, name, "", this.modelManager.getModelSetName(), null, null);
        String sp = "";
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sp = sp + "," + params[i];
            }
        }
        Logger.info((String)("openFile(" + name + sp + ")" + ms + " ms"));
    }

    public void openFiles(String modelName, String[] names) {
        this.openFiles(modelName, names, null);
    }

    void openFiles(String modelName, String[] names, String loadScript) {
        this.zap();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openFiles(modelName, names, loadScript);
        long ms = System.currentTimeMillis() - timeBegin;
        for (int i = 0; i < names.length; ++i) {
            this.setStatusFileLoaded(1, names[i], "", this.modelManager.getModelSetName(), null, null);
        }
        Logger.info((String)("openFiles(" + names.length + ") " + ms + " ms"));
    }

    public void openStringInline(String strModel) {
        this.openStringInline(strModel, null);
    }

    private void openStringInline(String strModel, int[] params) {
        this.clear();
        this.fileManager.openStringInline(strModel, params);
        String errorMsg = this.getOpenFileError();
        if (errorMsg == null) {
            this.setStatusFileLoaded(1, "string", "", this.modelManager.getModelSetName(), null, null);
        }
    }

    private void openStringInline(String[] arrayModels, int[] params) {
        this.clear();
        this.fileManager.openStringInline(arrayModels, params);
        String errorMsg = this.getOpenFileError();
        if (errorMsg == null) {
            this.setStatusFileLoaded(1, "string[]", "", this.modelManager.getModelSetName(), null, null);
        }
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    public void loadInline(String strModel) {
        this.loadInline(strModel, this.global.inlineNewlineChar);
    }

    public void loadInline(String strModel, char newLine) {
        if (strModel == null) {
            return;
        }
        Logger.debug((String)strModel);
        if (newLine != '\u0000') {
            int i;
            int len = strModel.length();
            for (i = 0; i < len && strModel.charAt(i) == ' '; ++i) {
            }
            if (i < len && strModel.charAt(i) == newLine) {
                strModel = strModel.substring(i + 1);
            }
            strModel = strModel.replace(newLine, '\n');
        }
        int[] A = this.global.getDefaultLatticeArray();
        this.openStringInline(strModel, A);
    }

    public void loadInline(String[] arrayModels) {
        if (arrayModels == null || arrayModels.length == 0) {
            return;
        }
        int[] A = this.global.getDefaultLatticeArray();
        this.openStringInline(arrayModels, A);
    }

    public void openDOM(Object DOMNode) {
        this.clear();
        long timeBegin = System.currentTimeMillis();
        this.fileManager.openDOM(DOMNode);
        long ms = System.currentTimeMillis() - timeBegin;
        Logger.info((String)("openDOM " + ms + " ms"));
        this.setStatusFileLoaded(1, "JSNode", "", this.modelManager.getModelSetName(), null, this.getOpenFileError());
    }

    public void openReader(String fullPathName, String name, Reader reader) {
        this.clear();
        this.fileManager.openReader(fullPathName, name, reader);
        this.getOpenFileError();
        System.gc();
    }

    public String getOpenFileError() {
        String fullPathName = this.getFullPathName();
        String fileName = this.getFileName();
        Object clientFile = this.fileManager.waitForClientFileOrErrorMessage();
        if (clientFile instanceof String || clientFile == null) {
            String errorMsg = (String)clientFile;
            this.setStatusFileNotLoaded(fullPathName, errorMsg);
            if (errorMsg != null) {
                String msg = errorMsg;
                int pt = msg.lastIndexOf("/");
                if (pt > 0) {
                    msg = msg.substring(0, pt + 1) + '\n' + msg.substring(pt + 1);
                }
                if ((pt = msg.lastIndexOf("\\")) > 0) {
                    msg = msg.substring(0, pt + 1) + '\n' + msg.substring(pt + 1);
                }
                for (int i = 0; i < 2; ++i) {
                    pt = msg.indexOf(" ");
                    if (pt <= 0) continue;
                    msg = msg.substring(0, pt) + '\n' + msg.substring(pt + 1);
                }
                this.zap(msg);
            }
            return errorMsg;
        }
        this.openClientFile(fullPathName, fileName, clientFile);
        return null;
    }

    public void openClientFile(String fullPathName, String fileName, Object clientFile) {
        this.setStatusFileLoaded(2, fullPathName, fileName, this.modelManager.getModelSetName(), clientFile, null);
        this.pushHoldRepaint();
        this.modelManager.setClientFile(fullPathName, fileName, this.modelAdapter, clientFile);
        this.initializeModel();
        this.popHoldRepaint();
        this.setStatusFileLoaded(3, fullPathName, fileName, this.modelManager.getModelSetName(), clientFile, null);
    }

    public String getCurrentFileAsString() {
        if (this.getFullPathName() == "string") {
            return this.fileManager.inlineData;
        }
        if (this.getFullPathName() == "string[]") {
            int modelIndex = this.getDisplayModelIndex();
            if (modelIndex < 0) {
                return "";
            }
            return this.fileManager.inlineDataArray[modelIndex];
        }
        if (this.getFullPathName() == "JSNode") {
            return "<DOM NODE>";
        }
        String pathName = this.modelManager.getModelSetPathName();
        if (pathName == null) {
            return null;
        }
        return this.fileManager.getFileAsString(pathName);
    }

    public String getFileAsString(String pathName) {
        return this.fileManager.getFileAsString(pathName);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    void addStateScript(String script) {
        this.modelManager.addStateScript(script);
    }

    public boolean getEchoStateActive() {
        return this.modelManager.getEchoStateActive();
    }

    void setEchoStateActive(boolean TF) {
        this.modelManager.setEchoStateActive(TF);
    }

    public void zap() {
        this.clear();
        this.modelManager.zap();
        this.initializeModel();
    }

    private void zap(String msg) {
        this.zap();
        this.echoMessage(msg);
    }

    void echoMessage(String msg) {
        int iShape = 21;
        this.loadShape(iShape);
        this.setShapeProperty(iShape, "font", this.getFont3D("SansSerif", "Plain", 9));
        this.setShapeProperty(iShape, "target", "error");
        this.setShapeProperty(iShape, "text", msg);
    }

    private void clear() {
        this.repaintManager.clear();
        this.transformManager.clear();
        this.pickingManager.clear();
        this.modelManager.clear();
        this.selectionManager.clear();
        this.clearAllMeasurements();
        this.statusManager.clear();
        this.stateManager.clear(this.global);
        this.setRefreshing(true);
        this.refresh(0, "Viewer:clear()");
        System.gc();
    }

    private void initializeModel() {
        this.reset();
        this.selectAll();
        this.transformManager.setCenter();
        if (this.eval != null) {
            this.eval.clearDefinitionsAndLoadPredefined();
        }
        if (this.modelSetHasVibrationVectors()) {
            this.setShapeSize(5, this.global.defaultVectorMad);
        }
        this.setFrankOn(this.global.frankOn);
        this.repaintManager.initializePointers(1);
        this.setDisplayModelIndex(0);
        this.setBackgroundModelIndex(-1);
        this.setTainted(true);
    }

    public String getModelSetName() {
        return this.modelManager.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelManager.getUnitCellInfoText();
    }

    public String getSpaceGroupInfoText(String spaceGroup) {
        return this.modelManager.getSpaceGroupInfoText(spaceGroup);
    }

    public int getSpaceGroupIndexFromName(String spaceGroup) {
        return this.modelManager.getSpaceGroupIndexFromName(spaceGroup);
    }

    public String getModelSetProperty(String strProp) {
        return this.modelManager.getModelSetProperty(strProp);
    }

    public Object getModelSetAuxiliaryInfo(String strKey) {
        return this.modelManager.getModelSetAuxiliaryInfo(strKey);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelManager.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.modelManager.frame != null;
    }

    public void calculateStructures() {
        this.modelManager.calculateStructures();
        this.addStateScript("calculate structure");
    }

    void clearBfactorRange() {
        this.modelManager.clearBfactorRange();
    }

    boolean getPrincipalAxes(int atomIndex, Vector3f z, Vector3f x, String lcaoType, boolean hybridizationCompatible) {
        return this.modelManager.getPrincipalAxes(atomIndex, z, x, lcaoType, hybridizationCompatible);
    }

    BitSet getModelAtomBitSet(int modelIndex) {
        return this.modelManager.getModelAtomBitSet(modelIndex);
    }

    BitSet getModelBitSet(BitSet atomList) {
        return this.modelManager.getModelBitSet(atomList);
    }

    Object getClientFile() {
        return null;
    }

    String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        if (this.modelAdapter == null) {
            return null;
        }
        return this.modelAdapter.getClientAtomStringProperty(clientAtom, propertyName);
    }

    JmolAdapter getExportJmolAdapter() {
        return this.modelManager.getExportJmolAdapter();
    }

    public Frame getFrame() {
        return this.modelManager.getFrame();
    }

    Point3f getBoundBoxCenter() {
        return this.modelManager.getBoundBoxCenter();
    }

    Point3f getAverageAtomPoint() {
        return this.modelManager.getAverageAtomPoint();
    }

    float calcRotationRadius(Point3f center) {
        return this.modelManager.calcRotationRadius(center);
    }

    Vector3f getBoundBoxCornerVector() {
        return this.modelManager.getBoundBoxCornerVector();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelManager.getBoundBoxInfo();
    }

    int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelManager.getModelCount();
    }

    String getModelInfoAsString() {
        return this.modelManager.getModelInfoAsString();
    }

    String getSymmetryInfoAsString() {
        return this.modelManager.getSymmetryInfoAsString();
    }

    public Properties getModelSetProperties() {
        return this.modelManager.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelManager.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int modelIndex) {
        return this.modelManager.getModelNumber(modelIndex);
    }

    public String getModelName(int modelIndex) {
        return this.modelManager.getModelName(modelIndex);
    }

    public Properties getModelProperties(int modelIndex) {
        return this.modelManager.getModelProperties(modelIndex);
    }

    public String getModelProperty(int modelIndex, String propertyName) {
        return this.modelManager.getModelProperty(modelIndex, propertyName);
    }

    public Hashtable getModelAuxiliaryInfo(int modelIndex) {
        return this.modelManager.getModelAuxiliaryInfo(modelIndex);
    }

    public Object getModelAuxiliaryInfo(int modelIndex, String keyName) {
        return this.modelManager.getModelAuxiliaryInfo(modelIndex, keyName);
    }

    int getModelNumberIndex(int modelNumber) {
        return this.modelManager.getModelNumberIndex(modelNumber);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelManager.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int modelIndex) {
        return this.modelSetHasVibrationVectors() && this.modelManager.modelHasVibrationVectors(modelIndex);
    }

    public int getChainCount() {
        return this.modelManager.getChainCount();
    }

    public int getChainCountInModel(int modelIndex) {
        return this.modelManager.getChainCountInModel(modelIndex);
    }

    public int getGroupCount() {
        return this.modelManager.getGroupCount();
    }

    public int getGroupCountInModel(int modelIndex) {
        return this.modelManager.getGroupCountInModel(modelIndex);
    }

    public int getPolymerCount() {
        return this.modelManager.getPolymerCount();
    }

    public int getPolymerCountInModel(int modelIndex) {
        return this.modelManager.getPolymerCountInModel(modelIndex);
    }

    public int getAtomCount() {
        return this.modelManager.getAtomCount();
    }

    public int getAtomCountInModel(int modelIndex) {
        return this.modelManager.getAtomCountInModel(modelIndex);
    }

    public int getBondCount() {
        return this.modelManager.getBondCount();
    }

    public int getBondCountInModel(int modelIndex) {
        return this.modelManager.getBondCountInModel(modelIndex);
    }

    boolean frankClicked(int x, int y) {
        return this.modelManager.frankClicked(x, y);
    }

    int findNearestAtomIndex(int x, int y) {
        return this.modelManager.findNearestAtomIndex(x, y);
    }

    BitSet findAtomsInRectangle(Rectangle rectRubberBand) {
        return this.modelManager.findAtomsInRectangle(rectRubberBand);
    }

    void convertFractionalCoordinates(Point3f pt) {
        int modelIndex = this.getDisplayModelIndex();
        if (modelIndex < 0) {
            return;
        }
        this.modelManager.convertFractionalCoordinates(modelIndex, pt);
    }

    public void setCenterSelected() {
        this.script("center (selected)");
    }

    public void rebond() {
        this.modelManager.rebond();
        this.refresh(0, "Viewer:rebond()");
    }

    private void setBondTolerance(float bondTolerance) {
        this.global.bondTolerance = bondTolerance;
    }

    public float getBondTolerance() {
        return this.global.bondTolerance;
    }

    private void setMinBondDistance(float minBondDistance) {
        this.global.minBondDistance = minBondDistance;
    }

    public float getMinBondDistance() {
        return this.global.minBondDistance;
    }

    BitSet getAtomBits(String setType) {
        return this.modelManager.getAtomBits(setType);
    }

    BitSet getAtomBits(String setType, String specInfo) {
        return this.modelManager.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int specInfo) {
        return this.modelManager.getAtomBits(setType, specInfo);
    }

    BitSet getAtomBits(String setType, int[] specInfo) {
        return this.modelManager.getAtomBits(setType, specInfo);
    }

    BitSet getAtomsWithin(String withinWhat, BitSet bs) {
        return this.modelManager.getAtomsWithin(withinWhat, bs);
    }

    BitSet getAtomsWithin(float distance, Point3f coord) {
        return this.modelManager.getAtomsWithin(distance, coord);
    }

    BitSet getAtomsWithin(String withinWhat, String specInfo, BitSet bs) {
        return this.modelManager.getAtomsWithin(withinWhat, specInfo, bs);
    }

    BitSet getAtomsWithin(float distance, BitSet bs) {
        return this.modelManager.getAtomsWithin(distance, bs);
    }

    BitSet getAtomsConnected(float min, float max, BitSet bs) {
        return this.modelManager.getAtomsConnected(min, max, bs);
    }

    int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.modelManager.getAtomIndexFromAtomNumber(atomNumber);
    }

    public BitSet getElementsPresentBitSet() {
        return this.modelManager.getElementsPresentBitSet();
    }

    public Hashtable getHeteroList(int modelIndex) {
        return this.modelManager.getHeteroList(modelIndex);
    }

    BitSet getVisibleSet() {
        return this.modelManager.getVisibleSet();
    }

    BitSet getClickableSet() {
        return this.modelManager.getClickableSet();
    }

    void calcSelectedGroupsCount() {
        this.modelManager.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelManager.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMoleculesCount() {
        this.modelManager.calcSelectedMoleculesCount(this.selectionManager.bsSelection);
    }

    String getFileHeader() {
        return this.modelManager.getFileHeader();
    }

    String getPDBHeader() {
        return this.modelManager.getPDBHeader();
    }

    public Hashtable getModelInfo() {
        return this.modelManager.getModelInfo();
    }

    public Hashtable getAuxiliaryInfo() {
        return this.modelManager.getAuxiliaryInfo();
    }

    public Hashtable getShapeInfo() {
        return this.modelManager.getShapeInfo();
    }

    int getShapeIdFromObjectName(String objectName) {
        return this.modelManager.getShapeIdFromObjectName(objectName);
    }

    Vector getAllAtomInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllAtomInfo(bs);
    }

    Vector getAllBondInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllBondInfo(bs);
    }

    Vector getMoleculeInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getMoleculeInfo(bs);
    }

    public Hashtable getAllChainInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllChainInfo(bs);
    }

    public Hashtable getAllPolymerInfo(String atomExpression) {
        BitSet bs = this.getAtomBitSet(atomExpression);
        return this.modelManager.getAllPolymerInfo(bs);
    }

    void setLoadScript(String script) {
        this.loadScript = script;
    }

    public String getStateInfo() {
        StringBuffer s = new StringBuffer("# Jmol state version " + this.getJmolVersion() + "\n\n");
        s.append(this.global.getWindowState());
        s.append(this.fileManager.getState());
        s.append(this.global.getState());
        s.append(this.modelManager.getState());
        s.append(this.repaintManager.getState());
        s.append(this.transformManager.getState());
        s.append(this.selectionManager.getState());
        s.append("set refreshing true;\n");
        return s.toString();
    }

    public void setData(String type, String[] data) {
        if (type == null) {
            dataValues.clear();
            return;
        }
        dataValues.put(type, data);
    }

    public String[] getData(String type) {
        if (dataValues == null) {
            return null;
        }
        if (type.equalsIgnoreCase("types")) {
            String[] info = new String[]{"types", ""};
            Enumeration e = dataValues.keys();
            while (e.hasMoreElements()) {
                info[1] = info[1] + "," + e.nextElement();
            }
            if (info[1].length() > 0) {
                info[1] = info[1].substring(1);
            }
            return info;
        }
        return (String[])dataValues.get(type);
    }

    public String getAltLocListInModel(int modelIndex) {
        return this.modelManager.getAltLocListInModel(modelIndex);
    }

    public BitSet setConformation() {
        return this.modelManager.setConformation(-1, this.getSelectionSet());
    }

    public BitSet setConformation(int conformationIndex) {
        return this.modelManager.setConformation(this.getDisplayModelIndex(), conformationIndex);
    }

    public void autoHbond() {
        BitSet bs = this.getSelectionSet();
        this.autoHbond(bs, bs);
        this.addStateScript("calculate hbonds");
    }

    public void autoHbond(BitSet bsFrom, BitSet bsTo) {
        this.modelManager.autoHbond(bsFrom, bsTo);
    }

    boolean hbondsAreVisible() {
        return this.modelManager.hbondsAreVisible(this.getDisplayModelIndex());
    }

    public boolean havePartialCharges() {
        return this.modelManager.havePartialCharges();
    }

    UnitCell getCurrentUnitCell() {
        return this.modelManager.getUnitCell(this.getDisplayModelIndex());
    }

    Point3f getCurrentUnitCellOffset() {
        return this.modelManager.getUnitCellOffset(this.getDisplayModelIndex());
    }

    void setCurrentUnitCellOffset(int offset) {
        int modelIndex = this.getDisplayModelIndex();
        if (this.modelManager.setUnitCellOffset(modelIndex, offset)) {
            this.global.setParameterValue("_frame " + this.getModelNumber(modelIndex) + "; set unitcell", offset);
        }
    }

    void setCurrentUnitCellOffset(Point3f pt) {
        int modelIndex = this.getDisplayModelIndex();
        if (this.modelManager.setUnitCellOffset(modelIndex, pt)) {
            this.global.setParameterValue("_frame " + this.getModelNumber(modelIndex) + "; set unitcell", StateManager.encloseCoord((Tuple3f)pt));
        }
    }

    public int getMeasurementCount() {
        int count = this.getShapePropertyAsInt(6, "count");
        return count <= 0 ? 0 : count;
    }

    public String getMeasurementStringValue(int i) {
        String str = "" + this.getShapeProperty(6, "stringValue", i);
        return str;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(6, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(6, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int i) {
        int[] List2 = (int[])this.getShapeProperty(6, "countPlusIndices", i);
        return List2;
    }

    void setPendingMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "pending", atomCountPlusIndices);
    }

    void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
        this.refresh(0, "Viewer:clearAllMeasurements()");
    }

    public void clearMeasurements() {
        this.script("measures delete");
    }

    void defineMeasurement(Vector monitorExpressions, float[] rangeMinMax, boolean isDelete, boolean isAllConnected, boolean isShowHide, boolean isHidden) {
        this.setShapeProperty(6, "setConnected", new Boolean(isAllConnected));
        this.setShapeProperty(6, "setRange", rangeMinMax);
        this.setShapeProperty(6, isDelete ? "deleteVector" : (isShowHide ? (isHidden ? "hideVector" : "showVector") : "defineVector"), monitorExpressions);
        this.setStatusNewDefaultModeMeasurement("scripted", 1, "?");
    }

    public void deleteMeasurement(int i) {
        this.setShapeProperty(6, "delete", new Integer(i));
    }

    void deleteMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "delete", atomCountPlusIndices);
    }

    public void showMeasurement(int[] atomCountPlusIndices, boolean isON) {
        this.setShapeProperty(6, isON ? "show" : "hide", atomCountPlusIndices);
        this.refresh(0, "Viewer:showMeasurements()");
    }

    void hideMeasurements(boolean isOFF) {
        this.setShapeProperty(6, "hideAll", new Boolean(isOFF));
        this.refresh(0, "hideMeasurements()");
    }

    void toggleMeasurement(int[] atomCountPlusIndices) {
        this.setShapeProperty(6, "toggle", atomCountPlusIndices);
    }

    void repaint() {
        this.display.repaint();
    }

    void setAnimationDirection(int direction) {
        this.repaintManager.setAnimationDirection(direction);
    }

    void reverseAnimation() {
        this.repaintManager.reverseAnimation();
    }

    int getAnimationDirection() {
        return this.repaintManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.repaintManager.getAnimationInfo();
    }

    private void setAnimationFps(int fps) {
        this.repaintManager.setAnimationFps(fps);
    }

    public int getAnimationFps() {
        return this.repaintManager.animationFps;
    }

    void setAnimationReplayMode(int replay, float firstFrameDelay, float lastFrameDelay) {
        this.repaintManager.setAnimationReplayMode(replay, firstFrameDelay, lastFrameDelay);
    }

    int getAnimationReplayMode() {
        return this.repaintManager.animationReplayMode;
    }

    void setAnimationOn(boolean animationOn) {
        boolean wasAnimating = this.repaintManager.animationOn;
        if (animationOn == wasAnimating) {
            return;
        }
        this.repaintManager.setAnimationOn(animationOn);
    }

    void resumeAnimation() {
        if (this.repaintManager.animationOn) {
            Logger.debug((String)"animation is ON in resumeAnimation");
            return;
        }
        this.repaintManager.resumeAnimation();
        this.refresh(0, "Viewer:resumeAnimation()");
    }

    void pauseAnimation() {
        if (!this.repaintManager.animationOn || this.repaintManager.animationPaused) {
            return;
        }
        this.repaintManager.pauseAnimation();
        this.refresh(0, "Viewer:pauseAnimation()");
    }

    void setAnimationRange(int modelIndex1, int modelIndex2) {
        this.repaintManager.setAnimationRange(modelIndex1, modelIndex2);
    }

    BitSet getVisibleFramesBitSet() {
        return this.repaintManager.getVisibleFramesBitSet();
    }

    boolean isAnimationOn() {
        return this.repaintManager.animationOn;
    }

    void setAnimationNext() {
        if (this.repaintManager.setAnimationNext()) {
            this.refresh(0, "Viewer:setAnimationNext()");
        }
    }

    void setAnimationPrevious() {
        if (this.repaintManager.setAnimationPrevious()) {
            this.refresh(0, "Viewer:setAnimationPrevious()");
        }
    }

    void rewindAnimation() {
        this.repaintManager.rewindAnimation();
        this.refresh(0, "Viewer:rewindAnimation()");
    }

    void setDisplayModelIndex(int modelIndex) {
        this.repaintManager.setDisplayModelIndex(modelIndex);
    }

    int getCurrentModelIndex() {
        return this.repaintManager.displayModelIndex;
    }

    public int getDisplayModelIndex() {
        int modelIndex = this.repaintManager.displayModelIndex;
        int backgroundIndex = this.getBackgroundModelIndex();
        return backgroundIndex >= 0 ? -2 - modelIndex : modelIndex;
    }

    private void setBackgroundModel(int modelNumber) {
        int modelIndex = this.getModelNumberIndex(modelNumber);
        this.setBackgroundModelIndex(modelIndex);
    }

    private void setBackgroundModelIndex(int modelIndex) {
        this.repaintManager.setBackgroundModelIndex(modelIndex);
    }

    public int getBackgroundModelIndex() {
        return this.repaintManager.backgroundModelIndex;
    }

    FrameRenderer getFrameRenderer() {
        return this.repaintManager.frameRenderer;
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean inMotion) {
        if (this.wasInMotion ^ inMotion) {
            if (inMotion) {
                ++this.motionEventNumber;
            }
            this.repaintManager.setInMotion(inMotion);
            this.wasInMotion = inMotion;
        }
    }

    boolean getInMotion() {
        return this.repaintManager.inMotion;
    }

    public void pushHoldRepaint() {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    private void setRefreshing(boolean TF) {
        this.refreshing = TF;
    }

    public void refresh() {
        this.repaintManager.refresh();
    }

    public void refresh(int isOrientationChange, String strWhy) {
        this.repaintManager.refresh();
        this.statusManager.setStatusViewerRefreshed(isOrientationChange, strWhy);
    }

    void requestRepaintAndWait() {
        if (this.haveDisplay) {
            this.repaintManager.requestRepaintAndWait();
        }
    }

    public void repaintView() {
        this.repaintManager.repaintDone();
    }

    boolean areAxesTainted() {
        boolean TF = this.axesAreTainted;
        this.axesAreTainted = false;
        return TF;
    }

    public void setScreenDimension(Dimension dim) {
        int height = dim.height;
        int width = dim.width;
        if (this.getStereoMode() == 1) {
            width = (width + 1) / 2;
        }
        if (this.dimScreen.width == width && this.dimScreen.height == height) {
            return;
        }
        this.dimScreen.width = width;
        this.dimScreen.height = height;
        this.transformManager.setScreenDimension(width, height);
        this.transformManager.scaleFitToScreen();
        this.g3d.setWindowSize(width, height, this.global.enableFullSceneAntialiasing);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    void setRectClip(Rectangle clip) {
        if (clip == null) {
            this.rectClip.y = 0;
            this.rectClip.x = 0;
            this.rectClip.setSize(this.dimScreen);
        } else {
            this.rectClip.setBounds(clip);
            if (this.rectClip.x < 0) {
                this.rectClip.x = 0;
            }
            if (this.rectClip.y < 0) {
                this.rectClip.y = 0;
            }
            if (this.rectClip.x + this.rectClip.width > this.dimScreen.width) {
                this.rectClip.width = this.dimScreen.width - this.rectClip.x;
            }
            if (this.rectClip.y + this.rectClip.height > this.dimScreen.height) {
                this.rectClip.height = this.dimScreen.height - this.rectClip.y;
            }
        }
    }

    public void renderScreenImage(Graphics g, Dimension size, Rectangle clip) {
        if (this.isTainted || this.getSlabEnabled()) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (size != null) {
            this.setScreenDimension(size);
        }
        this.setRectClip(null);
        int stereoMode = this.getStereoMode();
        switch (stereoMode) {
            case 1: {
                this.render1(g, this.getImage(true, false), this.dimScreen.width, 0);
            }
            case 0: {
                this.render1(g, this.getImage(false, false), 0, 0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.render1(g, this.getStereoImage(stereoMode, false), 0, 0);
            }
        }
        this.repaintView();
    }

    private Image getImage(boolean isDouble, boolean antialias) {
        Matrix3f matrixRotate = this.transformManager.getStereoRotationMatrix(isDouble);
        this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, matrixRotate, antialias);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        return this.g3d.getScreenImage();
    }

    private Image getStereoImage(int stereoMode, boolean antialias) {
        this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, this.transformManager.getStereoRotationMatrix(true), antialias);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        this.g3d.snapshotAnaglyphChannelBytes();
        this.g3d.beginRendering(this.rectClip.x, this.rectClip.y, this.rectClip.width, this.rectClip.height, this.transformManager.getStereoRotationMatrix(false), antialias);
        this.repaintManager.render(this.g3d, this.rectClip, this.modelManager.getFrame(), this.repaintManager.displayModelIndex);
        this.g3d.endRendering();
        switch (stereoMode) {
            case 2: {
                this.g3d.applyCyanAnaglyph();
                break;
            }
            case 5: {
                this.g3d.applyCustomAnaglyph(this.transformManager.stereoColors);
                break;
            }
            case 3: {
                this.g3d.applyBlueAnaglyph();
                break;
            }
            default: {
                this.g3d.applyGreenAnaglyph();
            }
        }
        return this.g3d.getScreenImage();
    }

    private void render1(Graphics g, Image img, int x, int y) {
        if (g == null) {
            return;
        }
        try {
            g.drawImage(img, x, y, null);
        }
        catch (NullPointerException npe) {
            Logger.error((String)"Sun!! ... fix graphics your bugs!");
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        boolean antialias = true;
        boolean isStereo = false;
        this.setRectClip(null);
        int stereoMode = this.getStereoMode();
        switch (stereoMode) {
            case 1: {
                isStereo = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.getStereoImage(stereoMode, false);
            }
        }
        return this.getImage(isStereo, antialias);
    }

    public String getJpegBase64(int quality) {
        Image eImage = this.getScreenImage();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JpegEncoder jc = new JpegEncoder(eImage, quality, (OutputStream)os);
        jc.Compress();
        byte[] jpeg = os.toByteArray();
        this.releaseScreenImage();
        return "" + Base64.getBase64((byte[])jpeg);
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    public String evalFile(String strFilename) {
        return this.scriptManager.addScript(strFilename, true, false);
    }

    public String script(String strScript) {
        return this.evalString(strScript);
    }

    public String evalString(String strScript) {
        if (this.checkResume(strScript)) {
            return "script processing resumed";
        }
        if (this.checkHalt(strScript)) {
            return "script execution halted";
        }
        return this.scriptManager.addScript(strScript, false, false);
    }

    boolean usingScriptQueue() {
        return this.scriptManager.useQueue;
    }

    public void clearScriptQueue() {
        this.scriptManager.clearQueue();
    }

    public boolean checkResume(String strScript) {
        if (strScript.equalsIgnoreCase("resume")) {
            this.resumeScriptExecution();
            return true;
        }
        return false;
    }

    public boolean checkHalt(String strScript) {
        String str = strScript.toLowerCase();
        if (str.equals("pause")) {
            this.pauseScriptExecution();
            return true;
        }
        if (str.startsWith("exit")) {
            this.haltScriptExecution();
            this.clearScriptQueue();
            return str.equals("exit");
        }
        if (str.startsWith("quit")) {
            this.haltScriptExecution();
            return str.equals("quit");
        }
        return false;
    }

    public String evalStringQuiet(String strScript) {
        if (this.checkResume(strScript)) {
            return "script processing resumed";
        }
        if (this.checkHalt(strScript)) {
            return "script execution halted";
        }
        return this.scriptManager.addScript(strScript, false, true);
    }

    public String scriptWait(String strScript) {
        this.scriptManager.waitForQueue();
        boolean doTranslateTemp = GT.getDoTranslate();
        GT.setDoTranslate((boolean)false);
        String str = (String)this.evalStringWaitStatus("JSON", strScript, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false, false, null);
        GT.setDoTranslate((boolean)doTranslateTemp);
        return str;
    }

    public Object scriptWaitStatus(String strScript, String statusList) {
        this.scriptManager.waitForQueue();
        boolean doTranslateTemp = GT.getDoTranslate();
        GT.setDoTranslate((boolean)false);
        Object ret = this.evalStringWaitStatus("object", strScript, statusList, false, false, null);
        GT.setDoTranslate((boolean)doTranslateTemp);
        return ret;
    }

    public Object evalStringWaitStatus(String returnType, String strScript, String statusList) {
        this.scriptManager.waitForQueue();
        return this.evalStringWaitStatus(returnType, strScript, statusList, false, false, null);
    }

    synchronized Object evalStringWaitStatus(String returnType, String strScript, String statusList, boolean isScriptFile, boolean isQuiet, Vector tokenInfo) {
        boolean isOK;
        if (this.checkResume(strScript)) {
            return "script processing resumed";
        }
        if (this.checkHalt(strScript)) {
            return "script execution halted";
        }
        if (strScript == null) {
            return null;
        }
        String oldStatusList = this.statusManager.statusList;
        this.getProperty("String", "jmolStatus", statusList);
        boolean bl = tokenInfo != null ? this.eval.loadTokenInfo(strScript, tokenInfo) : (isOK = isScriptFile ? this.eval.loadScriptFile(strScript, isQuiet) : this.eval.loadScriptString(strScript, isQuiet));
        if (isOK) {
            this.eval.runEval();
            String strErrorMessage = this.eval.getErrorMessage();
            int msWalltime = this.eval.getExecutionWalltime();
            this.statusManager.setStatusScriptTermination(strErrorMessage, msWalltime);
            if (isScriptFile && this.writeInfo != null) {
                this.createImage(this.writeInfo);
            }
        }
        if (isScriptFile && this.autoExit) {
            System.out.flush();
            System.exit(0);
        }
        if (returnType.equalsIgnoreCase("String")) {
            return this.eval.getErrorMessage();
        }
        Object info = this.getProperty(returnType, "jmolStatus", statusList);
        this.getProperty("object", "jmolStatus", oldStatusList);
        return info;
    }

    public synchronized String scriptCheck(String strScript) {
        if (strScript == null) {
            return null;
        }
        Object obj = this.eval.checkScript(strScript);
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public synchronized Object compileInfo(String strScript) {
        if (strScript == null) {
            return null;
        }
        Object obj = this.eval.checkScript(strScript);
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj;
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        this.eval.haltExecution();
    }

    public void resumeScriptExecution() {
        this.eval.resumePausedExecution();
    }

    public void pauseScriptExecution() {
        this.refresh();
        this.eval.pauseExecution();
    }

    void setDefaultLoadScript(String script) {
        this.global.defaultLoadScript = script;
    }

    String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    String getStandardLabelFormat() {
        return this.stateManager.getStandardLabelFormat();
    }

    int getRibbonAspectRatio() {
        return this.global.ribbonAspectRatio;
    }

    private void setRibbonAspectRatio(int ratio) {
        this.global.ribbonAspectRatio = ratio;
    }

    float getSheetSmoothing() {
        return this.global.sheetSmoothing;
    }

    private void setSheetSmoothing(float factor0To1) {
        this.global.sheetSmoothing = factor0To1;
    }

    boolean getSsbondsBackbone() {
        return this.global.ssbondsBackbone;
    }

    private void setHbondsBackbone(boolean TF) {
        this.global.hbondsBackbone = TF;
    }

    boolean getHbondsBackbone() {
        return this.global.hbondsBackbone;
    }

    private void setHbondsSolid(boolean TF) {
        this.global.hbondsSolid = TF;
    }

    boolean getHbondsSolid() {
        return this.global.hbondsSolid;
    }

    private void setMarBond(short marBond) {
        this.global.marBond = marBond;
        this.setShapeSize(1, marBond * 2);
    }

    void hoverOn(int atomIndex) {
        if (!(this.eval != null && this.isScriptExecuting() || atomIndex == this.hoverAtomIndex)) {
            this.loadShape(22);
            this.setShapeProperty(22, "target", new Integer(atomIndex));
            this.hoverAtomIndex = atomIndex;
        }
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(22, "target", null);
            this.hoverAtomIndex = -1;
        }
    }

    void setLabel(String strLabel) {
        if (strLabel != null) {
            this.setShapeSize(4, 0);
        }
        this.setShapeProperty(4, "label", strLabel);
    }

    void togglePickingLabel(BitSet bs) {
        this.setShapeSize(4, 0);
        this.modelManager.setShapeProperty(4, "toggleLabel", null, bs);
        this.refresh(0, "Viewer:");
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    private void setShapeShow(int shapeID, boolean show) {
        this.setShapeSize(shapeID, show ? -1 : 0);
    }

    boolean getShapeShow(int shapeID) {
        return this.getShapeSize(shapeID) != 0;
    }

    void loadShape(int shapeID) {
        this.modelManager.loadShape(shapeID);
    }

    void setShapeSize(int shapeID, int size) {
        this.setShapeSize(shapeID, size, this.selectionManager.bsSelection);
    }

    void setShapeSize(int shapeID, int size, BitSet bsAtoms) {
        this.modelManager.setShapeSize(shapeID, size, bsAtoms);
        this.refresh(0, "Viewer:setShapeSize(" + shapeID + "," + size + ")");
    }

    int getShapeSize(int shapeID) {
        return this.modelManager.getShapeSize(shapeID);
    }

    void setShapeProperty(int shapeID, String propertyName, Object value) {
        if (shapeID < 0) {
            return;
        }
        this.modelManager.setShapeProperty(shapeID, propertyName, value, this.selectionManager.bsSelection);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapeProperty(int shapeID, String propertyName, Object value, BitSet bs) {
        if (shapeID < 0) {
            return;
        }
        this.modelManager.setShapeProperty(shapeID, propertyName, value, bs);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapePropertyArgb(int shapeID, String propertyName, int argb) {
        this.setShapeProperty(shapeID, propertyName, argb == 0 ? null : new Integer(argb | 0xFF000000));
    }

    Object getShapeProperty(int shapeType, String propertyName) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, Integer.MIN_VALUE);
    }

    Object getShapeProperty(int shapeType, String propertyName, int index) {
        return this.modelManager.getShapeProperty(shapeType, propertyName, index);
    }

    int getShapePropertyAsInt(int shapeID, String propertyName) {
        Object value = this.getShapeProperty(shapeID, propertyName);
        return value == null || !(value instanceof Integer) ? Integer.MIN_VALUE : (Integer)value;
    }

    int getShapeID(String shapeName) {
        int i = 30;
        while (--i >= 0) {
            if (!JmolConstants.shapeClassBases[i].equals(shapeName)) continue;
            return i;
        }
        String msg = "Unrecognized shape name:" + shapeName;
        Logger.error((String)msg);
        throw new NullPointerException(msg);
    }

    short getColix(Object object) {
        return Graphics3D.getColix((Object)object);
    }

    private void setRasmolHydrogenSetting(boolean b) {
        this.global.rasmolHydrogenSetting = b;
    }

    boolean getRasmolHydrogenSetting() {
        return this.global.rasmolHydrogenSetting;
    }

    private void setRasmolHeteroSetting(boolean b) {
        this.global.rasmolHeteroSetting = b;
    }

    boolean getRasmolHeteroSetting() {
        return this.global.rasmolHeteroSetting;
    }

    boolean getDebugScript() {
        return this.global.debugScript;
    }

    private void setDebugScript(boolean debugScript) {
        this.global.debugScript = debugScript;
        Logger.setActiveLevel((int)0, (boolean)debugScript);
    }

    void atomPicked(int atomIndex, int modifiers) {
        if (!this.isInSelectionSubset(atomIndex)) {
            return;
        }
        this.pickingManager.atomPicked(atomIndex, modifiers);
    }

    void clearClickCount() {
        this.mouseManager.clearClickCount();
        this.setTainted(true);
    }

    private void setPickingMode(String mode) {
        int pickingMode = JmolConstants.GetPickingMode(mode);
        if (pickingMode < 0) {
            pickingMode = 1;
        }
        this.pickingManager.setPickingMode(pickingMode);
    }

    int getPickingMode() {
        return this.pickingManager.getPickingMode();
    }

    private void setPickingStyle(String style) {
        int pickingStyle = JmolConstants.GetPickingMode(style);
        if (pickingStyle < 0) {
            pickingStyle = 0;
        }
        this.pickingManager.setPickingStyle(pickingStyle);
    }

    public String getAtomInfo(int atomIndex) {
        return this.modelManager.getAtomInfo(atomIndex);
    }

    public String getAtomInfoXYZ(int atomIndex) {
        return this.modelManager.getAtomInfoXYZ(atomIndex);
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.messageQueue;
    }

    Viewer getViewer() {
        return this;
    }

    private void setCallbackFunction(String callbackType, String callbackFunction) {
        if (callbackFunction.equalsIgnoreCase("none")) {
            callbackFunction = null;
        }
        this.statusManager.setCallbackFunction(callbackType, callbackFunction);
    }

    void setStatusAtomPicked(int atomIndex, String info) {
        this.statusManager.setStatusAtomPicked(atomIndex, info);
    }

    void setStatusAtomHovered(int atomIndex, String info) {
        this.statusManager.setStatusAtomHovered(atomIndex, info);
    }

    void setStatusNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.statusManager.setStatusNewPickingModeMeasurement(iatom, strMeasure);
    }

    void setStatusNewDefaultModeMeasurement(String status, int count, String strMeasure) {
        this.statusManager.setStatusNewDefaultModeMeasurement(status, count, strMeasure);
    }

    void setStatusScriptStarted(int iscript, String script, String strError) {
        this.statusManager.setStatusScriptStarted(iscript, script, strError);
    }

    void setStatusUserAction(String info) {
        this.statusManager.setStatusUserAction(info);
    }

    Vector getStatusChanged(String statusNameList) {
        return this.statusManager.getStatusChanged(statusNameList);
    }

    void popupMenu(int x, int y) {
        if (this.global.disablePopupMenu) {
            return;
        }
        this.setFrankOn(true);
        this.statusManager.popupMenu(x, y);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener);
    }

    void setStatusFrameChanged(int frameNo) {
        this.statusManager.setStatusFrameChanged(frameNo);
    }

    void setStatusFileLoaded(int ptLoad, String fullPathName, String fileName, String modelName, Object clientFile, String strError) {
        this.statusManager.setStatusFileLoaded(fullPathName, fileName, modelName, clientFile, strError, ptLoad);
    }

    void setStatusFileNotLoaded(String fullPathName, String errorMsg) {
        this.setStatusFileLoaded(-1, fullPathName, null, null, null, errorMsg);
    }

    public void scriptEcho(String strEcho) {
        this.statusManager.setScriptEcho(strEcho);
    }

    void scriptStatus(String strStatus) {
        this.statusManager.setScriptStatus(strStatus);
    }

    public void showUrl(String urlString) {
        if (urlString.indexOf(":") < 0) {
            String base = this.fileManager.getAppletDocumentBase();
            if (base == "") {
                base = this.fileManager.getFullPathName();
            }
            if (base.indexOf("/") >= 0) {
                base = base.substring(0, base.lastIndexOf("/") + 1);
            } else if (base.indexOf("\\") >= 0) {
                base = base.substring(0, base.lastIndexOf("\\") + 1);
            }
            urlString = base + urlString;
        }
        Logger.info((String)("showUrl:" + urlString));
        this.statusManager.showUrl(urlString);
    }

    void showConsole(boolean showConsole) {
        this.statusManager.showConsole(showConsole);
    }

    void clearConsole() {
        this.statusManager.clearConsole();
    }

    public boolean getBooleanProperty(String key) {
        if (key.equalsIgnoreCase("hideNotSelected")) {
            return this.selectionManager.getHideNotSelected();
        }
        if (key.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (key.equalsIgnoreCase("perspectiveDepth")) {
            return this.getPerspectiveDepth();
        }
        if (key.equalsIgnoreCase("showAxes")) {
            return this.getShapeShow(17);
        }
        if (key.equalsIgnoreCase("showBoundBox")) {
            return this.getShapeShow(18);
        }
        if (key.equalsIgnoreCase("showUnitcell")) {
            return this.getShapeShow(19);
        }
        if (key.equalsIgnoreCase("debugScript")) {
            return this.getDebugScript();
        }
        if (key.equalsIgnoreCase("showHydrogens")) {
            return this.getShowHydrogens();
        }
        if (key.equalsIgnoreCase("frank")) {
            return this.getFrankOn();
        }
        if (key.equalsIgnoreCase("showMultipleBonds")) {
            return this.getShowMultipleBonds();
        }
        if (key.equalsIgnoreCase("showMeasurements")) {
            return this.getShowMeasurements();
        }
        if (key.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            return this.getAxesOrientationRasmol();
        }
        if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            return this.getZeroBasedXyzRasmol();
        }
        if (key.equalsIgnoreCase("testFlag1")) {
            return this.getTestFlag1();
        }
        if (key.equalsIgnoreCase("testFlag2")) {
            return this.getTestFlag2();
        }
        if (key.equalsIgnoreCase("testFlag3")) {
            return this.getTestFlag3();
        }
        if (key.equalsIgnoreCase("testFlag4")) {
            return this.getTestFlag4();
        }
        if (key.equalsIgnoreCase("chainCaseSensitive")) {
            return this.getChainCaseSensitive();
        }
        if (key.equalsIgnoreCase("hideNameInPopup")) {
            return this.getHideNameInPopup();
        }
        if (key.equalsIgnoreCase("autobond")) {
            return this.getAutoBond();
        }
        if (key.equalsIgnoreCase("greyscaleRendering")) {
            return this.getGreyscaleRendering();
        }
        if (key.equalsIgnoreCase("disablePopupMenu")) {
            return this.getDisablePopupMenu();
        }
        if (this.global.htPropertyFlags.containsKey(key)) {
            return (Boolean)this.global.htPropertyFlags.get(key);
        }
        Logger.error((String)("viewer.getBooleanProperty(" + key + ") - unrecognized"));
        return false;
    }

    public void setStringProperty(String key, String value) {
        if (key.toLowerCase().indexOf("callback") >= 0) {
            this.setCallbackFunction(key, value);
        } else if (key.equalsIgnoreCase("appletProxy")) {
            this.setAppletProxy(value);
        } else if (key.equalsIgnoreCase("defaultDirectory")) {
            this.setDefaultDirectory(value);
        } else if (key.equalsIgnoreCase("help")) {
            this.setHelpPath(value);
        } else if (key.equalsIgnoreCase("backgroundColor")) {
            this.setColorBackground(value);
        } else if (key.equalsIgnoreCase("defaults")) {
            this.setDefaults(value);
        } else if (key.equalsIgnoreCase("defaultColorScheme")) {
            this.setDefaultColors(value);
        } else if (key.equalsIgnoreCase("picking")) {
            this.setPickingMode(value);
        } else if (key.equalsIgnoreCase("pickingStyle")) {
            this.setPickingStyle(value);
        } else if (key.charAt(0) != '@' && !this.global.htParameterValues.containsKey(key)) {
            Logger.warn((String)("viewer.setStringProperty(" + key + "," + value + ") - new SET option"));
            return;
        }
        this.global.setParameterValue(key, value);
    }

    public void setFloatProperty(String key, float value) {
        if (key.equalsIgnoreCase("sheetSmoothing")) {
            this.setSheetSmoothing(value);
        } else if (key.equalsIgnoreCase("dipoleScale")) {
            this.setDipoleScale(value);
        } else if (key.equalsIgnoreCase("stereoDegrees")) {
            this.setStereoDegrees(value);
        } else if (key.equalsIgnoreCase("vectorScale")) {
            this.setVectorScale(value);
        } else if (key.equalsIgnoreCase("vibrationPeriod")) {
            this.setVibrationPeriod(value);
        } else if (key.equalsIgnoreCase("vibrationScale")) {
            this.setVibrationScale(value);
        } else if (key.equalsIgnoreCase("bondTolerance")) {
            this.setBondTolerance(value);
        } else if (key.equalsIgnoreCase("minBondDistance")) {
            this.setMinBondDistance(value);
        } else if (key.equalsIgnoreCase("scaleAngstromsPerInch")) {
            this.setScaleAngstromsPerInch(value);
        } else if (key.equalsIgnoreCase("solventProbeRadius")) {
            this.setSolventProbeRadius(value);
        } else {
            if (key.equalsIgnoreCase("radius")) {
                this.setFloatProperty("solventProbeRadius", value);
                return;
            }
            if (!this.global.htParameterValues.containsKey(key)) {
                Logger.warn((String)("viewer.setFloatProperty(" + key + "," + value + ") - new SET option"));
                return;
            }
        }
        this.global.setParameterValue(key, value);
    }

    public void setIntProperty(String key, int value) {
        this.setIntProperty(key, value, true);
    }

    void setIntProperty(String key, int value, boolean defineNew) {
        if (key.equalsIgnoreCase("backgroundModel")) {
            this.setBackgroundModel(value);
        } else if (key.equalsIgnoreCase("specPower")) {
            this.setSpecularPower(value);
        } else if (key.equalsIgnoreCase("specular")) {
            this.setSpecularPercent(value);
        } else if (key.equalsIgnoreCase("diffuse")) {
            this.setDiffusePercent(value);
        } else if (key.equalsIgnoreCase("ambient")) {
            this.setAmbientPercent(value);
        } else if (key.equalsIgnoreCase("ribbonAspectRatio")) {
            this.setRibbonAspectRatio(value);
        } else if (key.equalsIgnoreCase("pickingSpinRate")) {
            this.setPickingSpinRate(value);
        } else if (key.equalsIgnoreCase("animationFps")) {
            this.setAnimationFps(value);
        } else if (key.equalsIgnoreCase("percentVdwAtom")) {
            this.setPercentVdwAtom(value);
        } else if (key.equalsIgnoreCase("bondRadiusMilliAngstroms")) {
            this.setMarBond((short)value);
        } else if (key.equalsIgnoreCase("hermiteLevel")) {
            this.setHermiteLevel(value);
        } else {
            if (value != 0 || value != 1 || !this.setBooleanProperty(key, false, false)) {
                this.setFloatProperty(key, value);
            }
            return;
        }
        if (defineNew) {
            this.global.setParameterValue(key, value);
        }
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setBooleanProperty(key, value, true);
    }

    boolean setBooleanProperty(String key, boolean value, boolean defineNew) {
        boolean notFound = false;
        if (key.equalsIgnoreCase("refreshing")) {
            this.setRefreshing(value);
        } else if (key.equalsIgnoreCase("ssBondsBackbone")) {
            this.setSsbondsBackbone(value);
        } else if (key.equalsIgnoreCase("hbondsBackbone")) {
            this.setHbondsBackbone(value);
        } else if (key.equalsIgnoreCase("hbondsSolid")) {
            this.setHbondsSolid(value);
        } else if (key.equalsIgnoreCase("specular")) {
            this.setSpecular(value);
        } else if (key.equalsIgnoreCase("slab")) {
            this.setSlabEnabled(value);
        } else if (key.equalsIgnoreCase("zoom")) {
            this.setZoomEnabled(value);
        } else if (key.equalsIgnoreCase("solvent")) {
            this.setSolventOn(value);
        } else if (key.equalsIgnoreCase("highResolution")) {
            this.setHighResolution(value);
        } else if (key.equalsIgnoreCase("traceAlpha")) {
            this.setTraceAlpha(value);
        } else if (key.equalsIgnoreCase("zoomLarge")) {
            this.setZoomLarge(value);
        } else if (key.equalsIgnoreCase("languageTranslation")) {
            GT.setDoTranslate((boolean)value);
        } else if (key.equalsIgnoreCase("hideNotSelected")) {
            this.setHideNotSelected(value);
        } else if (key.equalsIgnoreCase("colorRasmol")) {
            this.setDefaultColors(value ? "rasmol" : "jmol");
        } else if (key.equalsIgnoreCase("perspectiveDepth")) {
            this.setPerspectiveDepth(value);
        } else if (key.equalsIgnoreCase("scriptQueue")) {
            this.scriptManager.setQueue(value);
        } else if (key.equalsIgnoreCase("dotSurface")) {
            this.setDotSurfaceFlag(value);
        } else if (key.equalsIgnoreCase("dotsSelectedOnly")) {
            this.setDotsSelectedOnlyFlag(value);
        } else if (key.equalsIgnoreCase("showAxes")) {
            this.setShapeShow(17, value);
        } else if (key.equalsIgnoreCase("showBoundBox")) {
            this.setShapeShow(18, value);
        } else if (key.equalsIgnoreCase("showUnitcell")) {
            this.setShapeShow(19, value);
        } else if (key.equalsIgnoreCase("selectionHalos")) {
            this.setSelectionHaloEnabled(value);
        } else if (key.equalsIgnoreCase("debugScript")) {
            this.setDebugScript(value);
        } else if (key.equalsIgnoreCase("frank")) {
            this.setFrankOn(value);
        } else if (key.equalsIgnoreCase("showHydrogens")) {
            this.setShowHydrogens(value);
        } else if (key.equalsIgnoreCase("defaultSelectHydrogen")) {
            this.setRasmolHydrogenSetting(value);
        } else if (key.equalsIgnoreCase("defaultSelectHetero")) {
            this.setRasmolHeteroSetting(value);
        } else if (key.equalsIgnoreCase("showMultipleBonds")) {
            this.setShowMultipleBonds(value);
        } else if (key.equalsIgnoreCase("showHiddenSelectionHalos")) {
            this.setShowHiddenSelectionHalos(value);
        } else if (key.equalsIgnoreCase("showMeasurements")) {
            this.setShowMeasurements(value);
        } else if (key.equalsIgnoreCase("axesOrientationRasmol")) {
            this.setAxesOrientationRasmol(value);
        } else if (key.equalsIgnoreCase("windowCentered")) {
            this.setWindowCentered(value);
        } else if (key.equalsIgnoreCase("adjustCamera")) {
            this.setAdjustCamera(value);
        } else if (key.equalsIgnoreCase("axesWindow")) {
            this.setAxesModeMolecular(!value);
        } else if (key.equalsIgnoreCase("axesMolecular")) {
            this.setAxesModeMolecular(value);
        } else if (key.equalsIgnoreCase("axesUnitCell")) {
            this.setAxesModeUnitCell(value);
        } else if (key.equalsIgnoreCase("displayCellParameters")) {
            this.setDisplayCellParameters(value);
        } else if (key.equalsIgnoreCase("testFlag1")) {
            this.setTestFlag1(value);
        } else if (key.equalsIgnoreCase("testFlag2")) {
            this.setTestFlag2(value);
        } else if (key.equalsIgnoreCase("testFlag3")) {
            this.setTestFlag3(value);
        } else if (key.equalsIgnoreCase("testFlag4")) {
            this.setTestFlag4(value);
        } else if (key.equalsIgnoreCase("ribbonBorder")) {
            this.setRibbonBorder(value);
        } else if (key.equalsIgnoreCase("cartoonRockets")) {
            this.setCartoonRocketFlag(value);
        } else if (key.equalsIgnoreCase("greyscaleRendering")) {
            this.setGreyscaleRendering(value);
        } else {
            if (key.equalsIgnoreCase("bonds")) {
                return this.setBooleanProperty("showMultipleBonds", value, true);
            }
            if (key.equalsIgnoreCase("hydrogen")) {
                return this.setBooleanProperty("defaultSelectHydrogen", value, true);
            }
            if (key.equalsIgnoreCase("hetero")) {
                return this.setBooleanProperty("defaultSelectHetero", value, true);
            }
            if (key.equalsIgnoreCase("showSelections")) {
                return this.setBooleanProperty("selectionHalos", value, true);
            }
            if (key.equalsIgnoreCase("bondModeOr")) {
                this.setBondSelectionModeOr(value);
            } else if (key.equalsIgnoreCase("zeroBasedXyzRasmol")) {
                this.setZeroBasedXyzRasmol(value);
            } else if (key.equalsIgnoreCase("rangeSelected")) {
                this.setRangeSelected(value);
            } else if (key.equalsIgnoreCase("cameraMove")) {
                this.setAllowCameraMove(value);
            } else if (key.equalsIgnoreCase("measureAllModels")) {
                this.setMeasureAllModels(value);
            } else if (key.equalsIgnoreCase("statusReporting")) {
                this.setAllowStatusReporting(value);
            } else if (key.equalsIgnoreCase("chainCaseSensitive")) {
                this.setChainCaseSensitive(value);
            } else if (key.equalsIgnoreCase("hideNameInPopup")) {
                this.setHideNameInPopup(value);
            } else if (key.equalsIgnoreCase("autobond")) {
                this.setAutoBond(value);
            } else if (key.equalsIgnoreCase("disablePopupMenu")) {
                this.setDisablePopupMenu(value);
            } else if (key.equalsIgnoreCase("forceAutoBond")) {
                this.setForceAutoBond(value);
            } else {
                notFound = true;
            }
            if (!defineNew) {
                return !notFound;
            }
            if (!notFound) {
                this.global.setPropertyFlag(key, value);
                return true;
            }
            notFound = true;
        }
        if (!defineNew) {
            return !notFound;
        }
        if (notFound && !value && !this.global.htPropertyFlags.containsKey(key)) {
            Logger.error((String)("viewer.setBooleanProperty(" + key + "," + value + ") - unrecognized SET option"));
            this.scriptStatus("Script ERROR: unrecognized SET option: set " + key);
            return false;
        }
        this.global.setPropertyFlag(key, value);
        if (notFound) {
            return false;
        }
        this.setTainted(true);
        this.refresh(0, "viewer.setBooleanProperty");
        return true;
    }

    boolean getDotSurfaceFlag() {
        return this.global.dotSurfaceFlag;
    }

    private void setDotSurfaceFlag(boolean TF) {
        this.global.dotSurfaceFlag = TF;
    }

    boolean getDotsSelectedOnlyFlag() {
        return this.global.dotsSelectedOnlyFlag;
    }

    private void setDotsSelectedOnlyFlag(boolean TF) {
        this.global.dotsSelectedOnlyFlag = TF;
    }

    boolean isRangeSelected() {
        return this.global.rangeSelected;
    }

    private void setRangeSelected(boolean TF) {
        this.global.rangeSelected = TF;
    }

    boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    private void setWindowCentered(boolean TF) {
        this.transformManager.setWindowCentered(TF);
    }

    boolean isCameraAdjustable() {
        return this.global.adjustCameraFlag;
    }

    private void setAdjustCamera(boolean TF) {
        this.global.adjustCameraFlag = TF;
    }

    boolean allowCameraMove() {
        return this.global.allowCameraMoveFlag;
    }

    private void setAllowCameraMove(boolean TF) {
        this.global.allowCameraMoveFlag = TF;
    }

    private void setSolventProbeRadius(float radius) {
        this.global.solventProbeRadius = radius;
    }

    float getSolventProbeRadius() {
        return this.global.solventProbeRadius;
    }

    float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    private void setSolventOn(boolean isOn) {
        this.global.solventOn = isOn;
    }

    boolean getSolventOn() {
        return this.global.solventOn;
    }

    private void setAllowStatusReporting(boolean TF) {
        this.statusManager.setAllowStatusReporting(TF);
    }

    private void setTestFlag1(boolean value) {
        this.global.testFlag1 = value;
    }

    boolean getTestFlag1() {
        return this.global.testFlag1;
    }

    boolean getTestFlag2() {
        return this.global.testFlag2;
    }

    private void setTestFlag2(boolean value) {
        this.global.testFlag2 = value;
    }

    boolean getTestFlag3() {
        return this.global.testFlag3;
    }

    private void setTestFlag3(boolean value) {
        this.global.testFlag3 = value;
    }

    boolean getTestFlag4() {
        return this.global.testFlag4;
    }

    private void setTestFlag4(boolean value) {
        this.global.testFlag4 = value;
    }

    private void setPerspectiveDepth(boolean perspectiveDepth) {
        this.transformManager.setPerspectiveDepth(perspectiveDepth);
        this.refresh(0, "Viewer:setPerspectiveDepth()");
    }

    private void setAxesOrientationRasmol(boolean axesOrientationRasmol) {
        this.transformManager.setAxesOrientationRasmol(axesOrientationRasmol);
        this.refresh(0, "Viewer:setAxesOrientationRasmol()");
    }

    public boolean getAxesOrientationRasmol() {
        return this.transformManager.axesOrientationRasmol;
    }

    private void setAxesModeMolecular(boolean TF) {
        this.global.axesMode = TF ? 1 : 0;
        this.axesAreTainted = true;
    }

    void setAxesModeUnitCell(boolean TF) {
        this.global.axesMode = TF ? 2 : 0;
        this.axesAreTainted = true;
    }

    int getAxesMode() {
        return this.global.axesMode;
    }

    private void setDisplayCellParameters(boolean displayCellParameters) {
        this.global.displayCellParameters = displayCellParameters;
    }

    boolean getDisplayCellParameters() {
        return this.global.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    public void setSelectionHalos(boolean TF) {
        if (this.getSelectionHaloEnabled() != TF) {
            this.script("selectionHalos " + TF);
        }
    }

    private void setSelectionHaloEnabled(boolean selectionHaloEnabled) {
        this.loadShape(16);
        this.modelManager.setSelectionHaloEnabled(selectionHaloEnabled);
    }

    boolean getSelectionHaloEnabled() {
        return this.modelManager.getSelectionHaloEnabled();
    }

    private void setBondSelectionModeOr(boolean bondSelectionModeOr) {
        this.global.bondSelectionModeOr = bondSelectionModeOr;
        this.refresh(0, "Viewer:setBondSelectionModeOr()");
    }

    boolean getBondSelectionModeOr() {
        return this.global.bondSelectionModeOr;
    }

    boolean getChainCaseSensitive() {
        return this.global.chainCaseSensitive;
    }

    private void setChainCaseSensitive(boolean chainCaseSensitive) {
        this.global.chainCaseSensitive = chainCaseSensitive;
    }

    boolean getRibbonBorder() {
        return this.global.ribbonBorder;
    }

    private void setRibbonBorder(boolean borderOn) {
        this.global.ribbonBorder = borderOn;
    }

    boolean getCartoonRocketFlag() {
        return this.global.cartoonRocketFlag;
    }

    private void setCartoonRocketFlag(boolean TF) {
        this.global.cartoonRocketFlag = TF;
    }

    boolean getHideNameInPopup() {
        return this.global.hideNameInPopup;
    }

    private void setHideNameInPopup(boolean hideNameInPopup) {
        this.global.hideNameInPopup = hideNameInPopup;
    }

    private void setZoomLarge(boolean TF) {
        this.global.zoomLarge = TF;
        this.scaleFitToScreen();
    }

    boolean getZoomLarge() {
        return this.global.zoomLarge;
    }

    private void setTraceAlpha(boolean TF) {
        this.global.traceAlpha = TF;
    }

    boolean getTraceAlpha() {
        return this.global.traceAlpha;
    }

    int getHermiteLevel() {
        return this.global.hermiteLevel;
    }

    private void setHermiteLevel(int level) {
        this.global.hermiteLevel = level;
    }

    boolean getHighResolution() {
        return this.global.highResolutionFlag;
    }

    private void setHighResolution(boolean TF) {
        this.global.highResolutionFlag = TF;
    }

    private void setSsbondsBackbone(boolean TF) {
        this.global.ssbondsBackbone = TF;
    }

    String getLoadState() {
        return this.global.getLoadState();
    }

    private void setAutoBond(boolean TF) {
        this.global.autoBond = TF;
    }

    public boolean getAutoBond() {
        return this.global.autoBond;
    }

    int makeConnections(float minDistance, float maxDistance, short order, int connectOperation, BitSet bsA, BitSet bsB) {
        this.clearAllMeasurements();
        return this.modelManager.makeConnections(minDistance, maxDistance, order, connectOperation, bsA, bsB);
    }

    void setGreyscaleRendering(boolean greyscaleRendering) {
        this.global.greyscaleRendering = greyscaleRendering;
        this.g3d.setGreyscaleMode(greyscaleRendering);
        this.refresh(0, "Viewer:setGreyscaleRendering()");
    }

    boolean getGreyscaleRendering() {
        return this.global.greyscaleRendering;
    }

    private void setDisablePopupMenu(boolean disablePopupMenu) {
        this.global.disablePopupMenu = disablePopupMenu;
    }

    boolean getDisablePopupMenu() {
        return this.global.disablePopupMenu;
    }

    private void setForceAutoBond(boolean forceAutoBond) {
        this.global.forceAutoBond = forceAutoBond;
    }

    boolean getForceAutoBond() {
        return this.global.forceAutoBond;
    }

    private void setPercentVdwAtom(int percentVdwAtom) {
        this.global.percentVdwAtom = percentVdwAtom;
        this.setShapeSize(0, -percentVdwAtom);
    }

    private void setFrankOn(boolean TF) {
        this.global.frankOn = TF;
        this.setShapeSize(20, TF ? 1 : 0);
    }

    boolean getFrankOn() {
        return this.global.frankOn;
    }

    public int getPercentVdwAtom() {
        return this.global.percentVdwAtom;
    }

    short getMadAtom() {
        return (short)(-this.global.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.global.marBond * 2);
    }

    public short getMarBond() {
        return this.global.marBond;
    }

    void setModeMultipleBond(byte modeMultipleBond) {
        this.global.modeMultipleBond = modeMultipleBond;
        this.refresh(0, "Viewer:setModeMultipleBond()");
    }

    byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    void setShowMultipleBonds(boolean TF) {
        this.global.showMultipleBonds = TF;
        this.refresh(0, "Viewer:setShowMultipleBonds()");
    }

    boolean getShowMultipleBonds() {
        return this.global.showMultipleBonds;
    }

    private void setShowHydrogens(boolean TF) {
        this.global.showHydrogens = TF;
        this.refresh(0, "Viewer:setShowHydrogens()");
    }

    public boolean getShowHydrogens() {
        return this.global.showHydrogens;
    }

    private void setShowHiddenSelectionHalos(boolean TF) {
        this.global.showHiddenSelectionHalos = TF;
        this.refresh(0, "Viewer:setShowHiddenSelectionHalos()");
    }

    public boolean getShowHiddenSelectionHalos() {
        return this.global.showHiddenSelectionHalos;
    }

    public boolean getShowBbcage() {
        return this.getShapeShow(18);
    }

    public boolean getShowAxes() {
        return this.getShapeShow(17);
    }

    private void setShowMeasurements(boolean TF) {
        this.global.showMeasurements = TF;
        this.refresh(0, "setShowMeasurements()");
    }

    public boolean getShowMeasurements() {
        return this.global.showMeasurements;
    }

    private void setMeasureAllModels(boolean TF) {
        this.global.measureAllModels = TF;
    }

    boolean getMeasureAllModelsFlag() {
        return this.global.measureAllModels;
    }

    boolean setMeasureDistanceUnits(String units) {
        if (!this.global.setMeasureDistanceUnits(units)) {
            return false;
        }
        this.setShapeProperty(6, "reformatDistances", null);
        return true;
    }

    String getMeasureDistanceUnits() {
        return this.global.getMeasureDistanceUnits();
    }

    private void setDefaults(String type) {
        if (type.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        this.stateManager.setJmolDefaults();
    }

    private void setZeroBasedXyzRasmol(boolean zeroBasedXyzRasmol) {
        this.global.zeroBasedXyzRasmol = zeroBasedXyzRasmol;
        this.modelManager.setZeroBased();
    }

    boolean getZeroBasedXyzRasmol() {
        return this.global.zeroBasedXyzRasmol;
    }

    Point3f[] allocTempPoints(int size) {
        return this.tempManager.allocTempPoints(size);
    }

    void freeTempPoints(Point3f[] tempPoints) {
        this.tempManager.freeTempPoints(tempPoints);
    }

    Point3i[] allocTempScreens(int size) {
        return this.tempManager.allocTempScreens(size);
    }

    void freeTempScreens(Point3i[] tempScreens) {
        this.tempManager.freeTempScreens(tempScreens);
    }

    boolean[] allocTempBooleans(int size) {
        return this.tempManager.allocTempBooleans(size);
    }

    void freeTempBooleans(boolean[] tempBooleans) {
        this.tempManager.freeTempBooleans(tempBooleans);
    }

    byte[] allocTempBytes(int size) {
        return this.tempManager.allocTempBytes(size);
    }

    void freeTempBytes(byte[] tempBytes) {
        this.tempManager.freeTempBytes(tempBytes);
    }

    Font3D getFont3D(int fontSize) {
        return this.g3d.getFont3D("SansSerif", "Plain", fontSize);
    }

    Font3D getFont3D(String fontFace, String fontStyle, int fontSize) {
        return this.g3d.getFont3D(fontFace, fontStyle, fontSize);
    }

    String formatDecimal(float value, int decimalDigits) {
        DecimalFormat formatter;
        if (decimalDigits < 0) {
            return "" + value;
        }
        if (this.formatters == null) {
            this.formatters = new DecimalFormat[formattingStrings.length];
        }
        if (decimalDigits >= formattingStrings.length) {
            decimalDigits = formattingStrings.length - 1;
        }
        if ((formatter = this.formatters[decimalDigits]) == null) {
            formatter = this.formatters[decimalDigits] = new DecimalFormat(formattingStrings[decimalDigits]);
        }
        return formatter.format(value);
    }

    String getElementSymbol(int i) {
        return this.modelManager.getElementSymbol(i);
    }

    int getElementNumber(int i) {
        return this.modelManager.getElementNumber(i);
    }

    public String getAtomName(int i) {
        return this.modelManager.getAtomName(i);
    }

    public int getAtomNumber(int i) {
        return this.modelManager.getAtomNumber(i);
    }

    float getAtomX(int i) {
        return this.modelManager.getAtomX(i);
    }

    float getAtomY(int i) {
        return this.modelManager.getAtomY(i);
    }

    float getAtomZ(int i) {
        return this.modelManager.getAtomZ(i);
    }

    public Point3f getAtomPoint3f(int i) {
        return this.modelManager.getAtomPoint3f(i);
    }

    public float getAtomRadius(int i) {
        return this.modelManager.getAtomRadius(i);
    }

    public int getAtomArgb(int i) {
        return this.g3d.getColixArgb(this.modelManager.getAtomColix(i));
    }

    String getAtomChain(int i) {
        return this.modelManager.getAtomChain(i);
    }

    public int getAtomModelIndex(int i) {
        return this.modelManager.getAtomModelIndex(i);
    }

    String getAtomSequenceCode(int i) {
        return this.modelManager.getAtomSequenceCode(i);
    }

    public Point3f getBondPoint3f1(int i) {
        return this.modelManager.getBondPoint3f1(i);
    }

    public Point3f getBondPoint3f2(int i) {
        return this.modelManager.getBondPoint3f2(i);
    }

    public float getBondRadius(int i) {
        return this.modelManager.getBondRadius(i);
    }

    public short getBondOrder(int i) {
        return this.modelManager.getBondOrder(i);
    }

    public int getBondArgb1(int i) {
        return this.g3d.getColixArgb(this.modelManager.getBondColix1(i));
    }

    public int getBondModelIndex(int i) {
        return this.modelManager.getBondModelIndex(i);
    }

    public int getBondArgb2(int i) {
        return this.g3d.getColixArgb(this.modelManager.getBondColix2(i));
    }

    public Point3f[] getPolymerLeadMidPoints(int modelIndex, int polymerIndex) {
        return this.modelManager.getPolymerLeadMidPoints(modelIndex, polymerIndex);
    }

    void setStereoMode(int stereoMode, String state) {
        this.global.stereoState = state;
        this.transformManager.setStereoMode(stereoMode);
        this.setBooleanProperty("greyscaleRendering", stereoMode > 1);
    }

    void setStereoMode(int[] twoColors, String state) {
        this.global.stereoState = state;
        this.transformManager.setStereoMode(twoColors);
        this.setBooleanProperty("greyscaleRendering", true);
    }

    int getStereoMode() {
        return this.transformManager.stereoMode;
    }

    float getStereoDegrees() {
        return this.transformManager.stereoDegrees;
    }

    private void setStereoDegrees(float degrees) {
        this.transformManager.setStereoDegrees(degrees);
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    public Object getProperty(String returnType, String infoType, String paramInfo) {
        return this.propertyManager.getProperty(returnType, infoType, paramInfo);
    }

    String getModelExtract(String atomExpression) {
        BitSet bs = this.selectionManager.getAtomBitSet(atomExpression);
        return this.fileManager.getFullPathName() + "\nJmol version " + this.getJmolVersion() + "\nEXTRACT: " + atomExpression + "\n" + this.modelManager.getModelExtract(bs);
    }

    String simpleReplace(String str, String strFrom, String strTo) {
        if (str == null) {
            return str;
        }
        int fromLength = strFrom.length();
        if (fromLength == 0) {
            return str;
        }
        boolean isOnce = strTo.indexOf(strFrom) >= 0;
        String stemp = "";
        while (str.indexOf(strFrom) >= 0) {
            int ipt;
            int ipt0 = 0;
            while ((ipt = str.indexOf(strFrom, ipt0)) >= 0) {
                stemp = stemp + str.substring(ipt0, ipt) + strTo;
                ipt0 = ipt + fromLength;
            }
            str = stemp + str.substring(ipt0, str.length());
            if (!isOnce) continue;
            break;
        }
        return str;
    }

    String getHexColorFromIndex(short colix) {
        return this.g3d.getHexColorFromIndex(colix);
    }

    void setModelVisibility() {
        this.modelManager.setModelVisibility();
    }

    void setTainted(boolean TF) {
        this.isTainted = TF && this.refreshing;
        this.axesAreTainted = TF && this.refreshing;
    }

    void checkObjectClicked(int x, int y, int modifiers) {
        this.modelManager.checkObjectClicked(x, y, modifiers);
    }

    void checkObjectDragged(int prevX, int prevY, int deltaX, int deltaY, int modifiers) {
        this.modelManager.checkObjectDragged(prevX, prevY, deltaX, deltaY, modifiers);
    }

    int cardinalityOf(BitSet bs) {
        int nbitset = 0;
        int i = bs.size();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            ++nbitset;
        }
        return nbitset;
    }

    void rotateAxisAngleAtCenter(Point3f rotCenter, Vector3f rotAxis, float degrees, float endDegrees, boolean isSpin) {
        this.transformManager.rotateAxisAngleAtCenter(rotCenter, rotAxis, degrees, endDegrees, isSpin);
    }

    void rotateAboutPointsInternal(Point3f point1, Point3f point2, float nDegrees, float endDegrees, boolean isSpin) {
        this.transformManager.rotateAboutPointsInternal(point1, point2, nDegrees, endDegrees, false, isSpin);
    }

    private void setPickingSpinRate(int rate) {
        if (rate < 1) {
            rate = 1;
        }
        this.global.pickingSpinRate = rate;
    }

    void startSpinningAxis(int atomIndex1, int atomIndex2, boolean isClockwise) {
        Point3f pt1 = this.modelManager.getAtomPoint3f(atomIndex1);
        Point3f pt2 = this.modelManager.getAtomPoint3f(atomIndex2);
        this.startSpinningAxis(pt1, pt2, isClockwise);
    }

    void startSpinningAxis(Point3f pt1, Point3f pt2, boolean isClockwise) {
        if (this.getSpinOn()) {
            this.setSpinOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(pt1, pt2, this.global.pickingSpinRate, Float.MAX_VALUE, isClockwise, true);
    }

    Point3f getDrawObjectCenter(String axisID) {
        return this.modelManager.getSpinCenter(axisID, this.repaintManager.displayModelIndex);
    }

    Vector3f getDrawObjectAxis(String axisID) {
        return this.modelManager.getSpinAxis(axisID, this.repaintManager.displayModelIndex);
    }

    Vector3f getModelDipole() {
        return this.modelManager.getModelDipole();
    }

    void getBondDipoles() {
        this.modelManager.getBondDipoles();
    }

    private void setDipoleScale(float scale) {
        this.loadShape(24);
        this.setShapeProperty(24, "dipoleVectorScale", new Float(scale));
    }

    void getAtomIdentityInfo(int atomIndex, Hashtable info) {
        this.modelManager.getAtomIdentityInfo(atomIndex, info);
    }

    void setDefaultLattice(Point3f ptLattice) {
        this.global.setDefaultLattice(ptLattice);
    }

    Point3f getDefaultLattice() {
        return this.global.getDefaultLatticePoint();
    }

    public void setAtomCoord(int atomIndex, float x, float y, float z) {
        this.modelManager.setAtomCoord(atomIndex, x, y, z);
    }

    public void setAtomCoordRelative(int atomIndex, float x, float y, float z) {
        this.modelManager.setAtomCoordRelative(atomIndex, x, y, z);
    }

    public void setAtomCoordRelative(Point3f offset) {
        this.modelManager.setAtomCoordRelative(offset, this.selectionManager.bsSelection);
    }

    float functionXY(String functionName, int x, int y) {
        return this.statusManager.functionXY(functionName, x, y);
    }

    Point3f[] getAdditionalHydrogens(BitSet atomSet) {
        return this.modelManager.getAdditionalHydrogens(atomSet);
    }

    private void setHelpPath(String url) {
        this.global.helpPath = url;
    }

    void getHelp(String what) {
        if (this.global.helpPath == null) {
            this.global.helpPath = this.global.defaultHelpPath;
        }
        this.showUrl(this.global.helpPath + what);
    }

    void addCommand(String command) {
        this.commandHistory.addCommand(command);
    }

    String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    public String getSetHistory(int howFarBack) {
        return this.commandHistory.getSetHistory(howFarBack);
    }

    void createImage(String type_name) {
        int i;
        if (type_name == null) {
            return;
        }
        if (type_name.length() == 0) {
            type_name = "JPG:jmol.jpg";
        }
        if ((i = type_name.indexOf(":")) < 0) {
            i = type_name.length();
            type_name = type_name + ":jmol.jpg";
        }
        String type = type_name.substring(0, i);
        String file = type_name.substring(i + 1);
        this.createImage(file, type, 100);
    }

    public void createImage(String file, String type, int quality) {
        this.setModelVisibility();
        this.statusManager.createImage(file, type, quality);
    }

    public void setSyncDriver(int syncMode) {
        Logger.debug((String)(this.htmlName + " viewer setting sync driver " + syncMode));
        this.statusManager.setSyncDriver(syncMode);
    }

    public int getSyncMode() {
        return this.statusManager.getSyncMode();
    }
}

