/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

class CubeReader
extends AtomSetCollectionReader {
    boolean negativeAtomCount;
    int atomCount;
    final int[] voxelCounts = new int[3];
    final float[] origin = new float[3];
    final float[][] voxelVectors = new float[3][];
    float[][][] voxelData;

    CubeReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader br) throws Exception {
        this.reader = br;
        this.atomSetCollection = new AtomSetCollection("cube");
        try {
            this.atomSetCollection.newAtomSet();
            this.readTitleLines();
            this.readAtomCountAndOrigin();
            this.readVoxelVectors();
            this.readAtoms();
            this.readExtraLine();
        }
        catch (Exception ex) {
            this.atomSetCollection.errorMessage = "Could not read Cube file:" + ex + "\n line:\n" + this.line;
            Logger.error((String)("Could not read Cube file line " + this.line), (Throwable)ex);
        }
        return this.atomSetCollection;
    }

    void readTitleLines() throws Exception {
        String title = this.readLineTrimmed() + " - ";
        this.atomSetCollection.setAtomSetName(title + this.readLineTrimmed());
    }

    void readAtomCountAndOrigin() throws Exception {
        this.readLine();
        this.atomCount = this.parseInt(this.line);
        this.origin[0] = this.parseFloat(this.line, this.ichNextParse);
        this.origin[1] = this.parseFloat(this.line, this.ichNextParse);
        this.origin[2] = this.parseFloat(this.line, this.ichNextParse);
        if (this.atomCount < 0) {
            this.atomCount = -this.atomCount;
            this.negativeAtomCount = true;
        }
    }

    void readVoxelVectors() throws Exception {
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
    }

    void readVoxelVector(int voxelVectorIndex) throws Exception {
        this.readLine();
        float[] voxelVector = new float[3];
        this.voxelVectors[voxelVectorIndex] = voxelVector;
        this.voxelCounts[voxelVectorIndex] = this.parseInt(this.line);
        voxelVector[0] = this.parseFloat(this.line, this.ichNextParse);
        voxelVector[1] = this.parseFloat(this.line, this.ichNextParse);
        voxelVector[2] = this.parseFloat(this.line, this.ichNextParse);
    }

    void readAtoms() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)this.parseInt(this.line);
            atom.partialCharge = this.parseFloat(this.line, this.ichNextParse);
            ((Tuple3f)atom).x = this.parseFloat(this.line, this.ichNextParse) * 0.5291772f;
            ((Tuple3f)atom).y = this.parseFloat(this.line, this.ichNextParse) * 0.5291772f;
            ((Tuple3f)atom).z = this.parseFloat(this.line, this.ichNextParse) * 0.5291772f;
        }
    }

    void readExtraLine() throws Exception {
        int nSurfaces;
        if (this.negativeAtomCount) {
            this.readLine();
        }
        if ((nSurfaces = this.parseInt(this.line)) != Integer.MIN_VALUE && nSurfaces < 0) {
            this.atomSetCollection.setFileTypeName("jvxl");
        }
    }
}

