/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.vecmath.Tuple3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public SmarterJmolAdapter(JmolAdapter.Logger logger) {
        super("SmarterJmolAdapter", logger);
    }

    public void finish(Object clientFile) {
        ((AtomSetCollection)((Object)clientFile)).finish();
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader, int[] params) {
        try {
            Object atomSetCollectionOrErrorMessage = Resolver.resolve(name, bufferedReader, this.logger, params);
            if (atomSetCollectionOrErrorMessage instanceof String) {
                return atomSetCollectionOrErrorMessage;
            }
            if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)((Object)atomSetCollectionOrErrorMessage);
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown reader error";
        }
        catch (Exception e) {
            Logger.error(null, (Throwable)e);
            return "" + e;
        }
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        try {
            Object atomSetCollectionOrErrorMessage = Resolver.resolve(name, bufferedReader, this.logger);
            if (atomSetCollectionOrErrorMessage instanceof String) {
                return atomSetCollectionOrErrorMessage;
            }
            if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)((Object)atomSetCollectionOrErrorMessage);
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown reader error";
        }
        catch (Exception e) {
            Logger.error(null, (Throwable)e);
            return "" + e;
        }
    }

    public Object openBufferedReaders(String[] name, BufferedReader[] bufferedReader) {
        int size = Math.min(name.length, bufferedReader.length);
        AtomSetCollection[] atomSetCollections = new AtomSetCollection[size];
        for (int i = 0; i < size; ++i) {
            try {
                Object atomSetCollectionOrErrorMessage = Resolver.resolve(name[i], bufferedReader[i], this.logger);
                if (atomSetCollectionOrErrorMessage instanceof String) {
                    return atomSetCollectionOrErrorMessage;
                }
                if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                    atomSetCollections[i] = (AtomSetCollection)((Object)atomSetCollectionOrErrorMessage);
                    if (atomSetCollections[i].errorMessage == null) continue;
                    return atomSetCollections[i].errorMessage;
                }
                return "unknown reader error";
            }
            catch (Exception e) {
                Logger.error(null, (Throwable)e);
                return "" + e;
            }
        }
        AtomSetCollection result = new AtomSetCollection(atomSetCollections);
        if (result.errorMessage != null) {
            return result.errorMessage;
        }
        return result;
    }

    public Object openDOMReader(Object DOMNode) {
        try {
            Object atomSetCollectionOrErrorMessage = Resolver.DOMResolve(DOMNode, this.logger);
            if (atomSetCollectionOrErrorMessage instanceof String) {
                return atomSetCollectionOrErrorMessage;
            }
            if (atomSetCollectionOrErrorMessage instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)((Object)atomSetCollectionOrErrorMessage);
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown DOM reader error";
        }
        catch (Exception e) {
            Logger.error(null, (Throwable)e);
            return "" + e;
        }
    }

    public String getFileTypeName(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).fileTypeName;
    }

    public String getAtomSetCollectionName(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).collectionName;
    }

    public Properties getAtomSetCollectionProperties(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).atomSetCollectionProperties;
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).atomSetCollectionAuxiliaryInfo;
    }

    public int getAtomSetCount(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).atomSetCount;
    }

    public int getAtomSetNumber(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)((Object)clientFile)).getAtomSetNumber(atomSetIndex);
    }

    public String getAtomSetName(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)((Object)clientFile)).getAtomSetName(atomSetIndex);
    }

    public Properties getAtomSetProperties(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)((Object)clientFile)).getAtomSetProperties(atomSetIndex);
    }

    public Hashtable getAtomSetAuxiliaryInfo(Object clientFile, int atomSetIndex) {
        return ((AtomSetCollection)((Object)clientFile)).getAtomSetAuxiliaryInfo(atomSetIndex);
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).atomCount;
    }

    public boolean coordinatesAreFractional(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        return ((AtomSetCollection)((Object)clientFile)).notionalUnitCell;
    }

    public float[] getPdbScaleMatrix(Object clientFile) {
        float[] a = ((AtomSetCollection)((Object)clientFile)).notionalUnitCell;
        if (a.length < 22) {
            return null;
        }
        float[] b = new float[16];
        for (int i = 0; i < 16; ++i) {
            b[i] = a[6 + i];
        }
        return b;
    }

    public float[] getPdbScaleTranslate(Object clientFile) {
        float[] a = ((AtomSetCollection)((Object)clientFile)).notionalUnitCell;
        if (a.length < 22) {
            return null;
        }
        float[] b = new float[]{a[9], a[13], a[17]};
        return b;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator((AtomSetCollection)((Object)clientFile));
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator((AtomSetCollection)((Object)clientFile));
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object clientFile) {
        AtomSetCollection atomSetCollection = (AtomSetCollection)((Object)clientFile);
        return atomSetCollection.structureCount == 0 ? null : new StructureIterator(atomSetCollection);
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        int structureCount;
        Structure[] structures;
        Structure structure;
        int istructure;

        StructureIterator(AtomSetCollection atomSetCollection) {
            super((JmolAdapter)SmarterJmolAdapter.this);
            this.structureCount = atomSetCollection.structureCount;
            this.structures = atomSetCollection.structures;
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public int getModelIndex() {
            return this.structure.modelIndex;
        }

        public String getStructureType() {
            return this.structure.structureType;
        }

        public char getStartChainID() {
            return JmolAdapter.canonizeChainID((char)this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return JmolAdapter.canonizeInsertionCode((char)this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return JmolAdapter.canonizeChainID((char)this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        AtomSetCollection atomSetCollection;
        Atom[] atoms;
        Bond[] bonds;
        int ibond;
        Bond bond;

        BondIterator(AtomSetCollection atomSetCollection) {
            super((JmolAdapter)SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.atoms = atomSetCollection.atoms;
            this.bonds = atomSetCollection.bonds;
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.atomSetCollection.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atomIndex1);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atomIndex2);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        AtomSetCollection atomSetCollection;
        int iatom;
        Atom atom;

        AtomIterator(AtomSetCollection atomSetCollection) {
            super((JmolAdapter)SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomSetCollection.atomCount) {
                return false;
            }
            this.atom = this.atomSetCollection.atoms[this.iatom++];
            return true;
        }

        public int getAtomSetIndex() {
            return this.atom.atomSetIndex;
        }

        public BitSet getAtomSymmetry() {
            return this.atom.bsSymmetry;
        }

        public int getAtomSite() {
            return this.atom.atomSite;
        }

        public Object getUniqueID() {
            return new Integer(this.atom.atomIndex);
        }

        public String getElementSymbol() {
            if (this.atom.elementSymbol != null) {
                return this.atom.elementSymbol;
            }
            return this.atom.getElementSymbol();
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public float getX() {
            return ((Tuple3f)this.atom).x;
        }

        public float getY() {
            return ((Tuple3f)this.atom).y;
        }

        public float getZ() {
            return ((Tuple3f)this.atom).z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return JmolAdapter.canonizeChainID((char)this.atom.chainID);
        }

        public char getAlternateLocationID() {
            return JmolAdapter.canonizeAlternateLocationID((char)this.atom.alternateLocationID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return JmolAdapter.canonizeInsertionCode((char)this.atom.insertionCode);
        }
    }
}

