/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.vecmath.Tuple3f;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.XmlReader;
import org.xml.sax.XMLReader;

class XmlOdysseyReader
extends XmlReader {
    String[] odysseyImplementedAttributes = new String[]{"id", "label", "xyz", "element", "hybrid", "a", "b", "order"};
    String modelName = null;
    String formula = null;
    String phase = null;

    XmlOdysseyReader(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        new OdysseyHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    XmlOdysseyReader(XmlReader parent, AtomSetCollection atomSetCollection, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.odysseyImplementedAttributes;
        new OdysseyHandler().walkDOMTree(DOMNode);
    }

    void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        if ("structure".equals(localName)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.atom = new Atom();
            this.atom.atomName = atts.containsKey("label") ? (String)atts.get("label") : (String)atts.get("id");
            if (atts.containsKey("xyz")) {
                String xyz = (String)atts.get("xyz");
                String[] tokens = this.getTokens(xyz);
                ((Tuple3f)this.atom).x = this.parseFloat(tokens[0]);
                ((Tuple3f)this.atom).y = this.parseFloat(tokens[1]);
                ((Tuple3f)this.atom).z = this.parseFloat(tokens[2]);
            }
            if (atts.containsKey("element")) {
                this.atom.elementSymbol = (String)atts.get("element");
            }
            return;
        }
        if ("bond".equals(localName)) {
            String atom1 = (String)atts.get("a");
            String atom2 = (String)atts.get("b");
            int order = 1;
            if (atts.containsKey("order")) {
                order = this.parseBondToken((String)atts.get("order"));
            }
            this.atomSetCollection.addNewBond(atom1, atom2, order);
            return;
        }
        if ("odyssey_simulation".equals(localName)) {
            if (this.modelName != null && this.phase != null) {
                this.modelName = this.modelName + " - " + this.phase;
            }
            if (this.modelName != null) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
            if (this.formula != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.formula);
            }
        }
        if ("title".equals(localName) || "formula".equals(localName) || "phase".equals(localName)) {
            this.keepChars = true;
        }
    }

    int parseBondToken(String str) {
        if (str.length() >= 1) {
            switch (str.charAt(0)) {
                case 's': {
                    return 1;
                }
                case 'd': {
                    return 2;
                }
                case 't': {
                    return 3;
                }
                case 'a': {
                    return 4;
                }
            }
            return this.parseInt(str);
        }
        return 1;
    }

    void processEndElement(String uri, String localName, String qName) {
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(((Tuple3f)this.atom).z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        if ("title".equals(localName)) {
            this.modelName = this.chars;
        }
        if ("formula".equals(localName)) {
            this.formula = this.chars;
        }
        if ("phase".equals(localName)) {
            this.phase = this.chars;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class OdysseyHandler
    extends XmlReader.JmolXmlHandler {
        OdysseyHandler() {
            super(XmlOdysseyReader.this);
        }

        OdysseyHandler(XMLReader xmlReader) {
            super(XmlOdysseyReader.this);
            this.setHandler(xmlReader, this);
        }
    }
}

