/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.XmlArgusReader;
import org.jmol.adapter.smarter.XmlChem3dReader;
import org.jmol.adapter.smarter.XmlCmlReader;
import org.jmol.adapter.smarter.XmlMolproReader;
import org.jmol.adapter.smarter.XmlOdysseyReader;
import org.jmol.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class XmlReader
extends AtomSetCollectionReader {
    XmlReader subReader;
    XmlReader parent;
    Atom atom;
    String[] implementedAttributes = new String[]{"id"};
    static final String CML_NAMESPACE_URI = "http://www.xml-cml.org/schema";
    boolean keepChars;
    String chars;

    XmlReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        XMLReader xmlReader = this.getXmlReader();
        if (xmlReader == null) {
            this.atomSetCollection = new AtomSetCollection("xml");
            this.atomSetCollection.errorMessage = "No XML reader found";
            return this.atomSetCollection;
        }
        this.processXml(xmlReader);
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    XMLReader getXmlReader() {
        XMLReader xmlr = null;
        if (xmlr == null && System.getProperty("java.version").compareTo("1.4") >= 0) {
            xmlr = this.allocateXmlReader14();
        }
        if (xmlr == null) {
            xmlr = this.allocateXmlReaderAelfred2();
        }
        return xmlr;
    }

    XMLReader allocateXmlReader14() {
        XMLReader xmlr = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            xmlr = saxParser.getXMLReader();
            Logger.debug((String)"Using JAXP/SAX XML parser.");
        }
        catch (Exception e) {
            Logger.error((String)("Could not instantiate JAXP/SAX XML reader: " + e.getMessage()));
        }
        return xmlr;
    }

    XMLReader allocateXmlReaderAelfred2() {
        XMLReader xmlr = null;
        try {
            xmlr = (XMLReader)((Object)((Object)this)).getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
            Logger.debug((String)"Using Aelfred2 XML parser.");
        }
        catch (Exception e) {
            Logger.error((String)"Could not instantiate Aelfred2 XML reader!");
        }
        return xmlr;
    }

    void processXml(XMLReader xmlReader) throws Exception {
        String xmlType = this.getXmlType(this.reader);
        this.atomSetCollection = new AtomSetCollection(xmlType);
        this.logger.log("XmlReader thinks", (Object)xmlType);
        if (xmlType.indexOf("cml(xml)") >= 0) {
            this.subReader = new XmlCmlReader(this, this.atomSetCollection, this.reader, xmlReader);
            return;
        }
        if (xmlType == "molpro(xml)") {
            this.subReader = new XmlMolproReader(this, this.atomSetCollection, this.reader, xmlReader);
            return;
        }
        if (xmlType == "chem3d(xml)") {
            this.subReader = new XmlChem3dReader(this, this.atomSetCollection, this.reader, xmlReader);
            return;
        }
        if (xmlType == "odyssey(xml)") {
            this.subReader = new XmlOdysseyReader(this, this.atomSetCollection, this.reader, xmlReader);
            return;
        }
        if (xmlType == "arguslab(xml)") {
            this.subReader = new XmlArgusReader(this, this.atomSetCollection, this.reader, xmlReader);
            return;
        }
        new JmolXmlHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    String getReaderHeader(int nBytes) throws Exception {
        this.reader.mark(nBytes);
        char[] buf = new char[nBytes];
        int cchBuf = this.reader.read(buf);
        this.reader.reset();
        StringBuffer str = new StringBuffer();
        return "" + str.append(buf, 0, cchBuf);
    }

    String getXmlType(BufferedReader reader) throws Exception {
        String header = this.getReaderHeader(5000);
        if (header.indexOf("http://www.molpro.net/") >= 0) {
            return "molpro(xml)";
        }
        if (header.indexOf("odyssey") >= 0) {
            return "odyssey(xml)";
        }
        if (header.indexOf("C3XML") >= 0) {
            return "chem3d(xml)";
        }
        if (header.indexOf("arguslab") >= 0) {
            return "arguslab(xml)";
        }
        if (header.indexOf(CML_NAMESPACE_URI) >= 0 || header.indexOf("cml:") >= 0) {
            return "cml(xml)";
        }
        return "unidentified cml(xml)";
    }

    void parseReaderXML(XMLReader xmlReader) {
        InputSource is = new InputSource(this.reader);
        is.setSystemId("foo");
        try {
            xmlReader.parse(is);
        }
        catch (Exception e) {
            Logger.error((String)"ERROR IN XmlReader.parseReaderXML", (Throwable)e);
        }
    }

    AtomSetCollection readAtomSetCollectionFromDOM(Object Node2) throws Exception {
        JSObject DOMNode = (JSObject)Node2;
        this.processXml(DOMNode);
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void processXml(JSObject DOMNode) {
        if (DOMNode == null) {
            throw new RuntimeException("Not a node");
        }
        String xmlType = this.getXmlType(DOMNode);
        this.logger.log("XmlReader thinks", (Object)xmlType);
        this.atomSetCollection = new AtomSetCollection(xmlType);
        if (xmlType.indexOf("cml(DOM)") >= 0) {
            this.subReader = new XmlCmlReader(this, this.atomSetCollection, DOMNode);
            return;
        }
        if (xmlType == "molpro(DOM)") {
            this.subReader = new XmlMolproReader(this, this.atomSetCollection, DOMNode);
            return;
        }
        if (xmlType == "chem3d(DOM)") {
            this.subReader = new XmlChem3dReader(this, this.atomSetCollection, DOMNode);
            return;
        }
        if (xmlType == "odyssey(DOM)") {
            this.subReader = new XmlOdysseyReader(this, this.atomSetCollection, DOMNode);
            return;
        }
        if (xmlType == "arguslab(DOM)") {
            this.subReader = new XmlArgusReader(this, this.atomSetCollection, DOMNode);
            return;
        }
        Logger.error((String)"XmlReader.java could not resolve DOM XML type");
        new JmolXmlHandler().walkDOMTree(DOMNode);
    }

    String getXmlType(JSObject DOMNode) {
        String namespaceURI = (String)DOMNode.getMember("namespaceURI");
        String localName = (String)DOMNode.getMember("localName");
        if (namespaceURI.startsWith("http://www.molpro.net/")) {
            return "molpro(DOM)";
        }
        if (((String)DOMNode.getMember("localName")).equals("odyssey_simulation")) {
            return "odyssey(DOM)";
        }
        if (((String)DOMNode.getMember("localName")).equals("arguslab")) {
            return "arguslab(DOM)";
        }
        if (namespaceURI.startsWith(CML_NAMESPACE_URI) || "cml" == localName) {
            return "cml(DOM)";
        }
        return "unidentified cml(DOM)";
    }

    void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
    }

    void setKeepChars(boolean TF) {
        this.keepChars = TF;
        this.chars = null;
    }

    void processEndElement(String uri, String localName, String qName) {
    }

    class JmolXmlHandler
    extends DefaultHandler
    implements ErrorHandler {
        HashMap atts;

        JmolXmlHandler() {
        }

        JmolXmlHandler(XMLReader xmlReader) {
            this.setHandler(xmlReader, this);
        }

        void setHandler(XMLReader xmlReader, JmolXmlHandler handler) {
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setEntityResolver(handler);
                xmlReader.setContentHandler(handler);
                xmlReader.setErrorHandler(handler);
            }
            catch (Exception e) {
                Logger.error((String)"ERROR IN XmlReader.JmolXmlHandler.setHandler", (Throwable)e);
            }
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            this.getAttributes(attributes);
            Logger.debug((String)("start " + localName));
            this.startElement(namespaceURI, localName, qName);
        }

        void startElement(String namespaceURI, String localName, String qName) {
            XmlReader.this.processStartElement(namespaceURI, localName, qName, this.atts);
        }

        public void endElement(String uri, String localName, String qName) {
            Logger.debug((String)("end " + localName));
            XmlReader.this.processEndElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) {
            if (XmlReader.this.keepChars) {
                XmlReader.this.chars = XmlReader.this.chars == null ? new String(ch, start, length) : XmlReader.this.chars + new String(ch, start, length);
            }
        }

        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) {
            Logger.debug((String)("Not resolving this:\n      name: " + name + "\n  systemID: " + systemId + "\n  publicID: " + publicId + "\n   baseURI: " + baseURI));
            return null;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            Logger.debug((String)("Not resolving this:\n  publicID: " + publicId + "\n  systemID: " + systemId));
            return null;
        }

        public void error(SAXParseException exception) {
            Logger.error((String)("SAX ERROR:" + exception.getMessage()));
        }

        public void fatalError(SAXParseException exception) {
            Logger.error((String)("SAX FATAL:" + exception.getMessage()));
        }

        public void warning(SAXParseException exception) {
            Logger.warn((String)("SAX WARNING:" + exception.getMessage()));
        }

        void walkDOMTree(JSObject DOMNode) {
            String namespaceURI = (String)DOMNode.getMember("namespaceURI");
            String localName = (String)DOMNode.getMember("localName");
            String qName = (String)DOMNode.getMember("nodeName");
            JSObject attributes = (JSObject)DOMNode.getMember("attributes");
            this.getAttributes(attributes);
            this.startElement(namespaceURI, localName, qName);
            if (((Boolean)DOMNode.call("hasChildNodes", null)).booleanValue()) {
                for (JSObject nextNode = (JSObject)DOMNode.getMember("firstChild"); nextNode != (JSObject)null; nextNode = (JSObject)nextNode.getMember("nextSibling")) {
                    this.walkDOMTree(nextNode);
                }
            }
            this.endElement(namespaceURI, localName, qName);
        }

        void getAttributes(Attributes attributes) {
            int nAtts = attributes.getLength();
            this.atts = new HashMap(nAtts);
            int i = nAtts;
            while (--i >= 0) {
                this.atts.put(attributes.getLocalName(i), attributes.getValue(i));
            }
        }

        void getAttributes(JSObject attributes) {
            if (attributes == null) {
                this.atts = new HashMap(0);
                return;
            }
            int nAtts = ((Number)attributes.getMember("length")).intValue();
            this.atts = new HashMap(nAtts);
            int i = XmlReader.this.implementedAttributes.length;
            while (--i >= 0) {
                Object[] attArgs = new Object[]{XmlReader.this.implementedAttributes[i]};
                JSObject attNode = (JSObject)attributes.call("getNamedItem", attArgs);
                if (attNode == null) continue;
                String attLocalName = (String)attNode.getMember("name");
                String attValue = (String)attNode.getMember("value");
                this.atts.put(attLocalName, attValue);
            }
        }
    }
}

