/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.AlphaPolymer;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Monomer;

class AminoPolymer
extends AlphaPolymer {
    short[] mainchainHbondOffsets;
    short[] min1Indexes;
    short[] min1Energies;
    short[] min2Indexes;
    short[] min2Energies;
    boolean hbondsAlreadyCalculated;
    boolean debugHbonds;
    final Vector3f vectorPreviousOC = new Vector3f();
    final Point3f aminoHydrogenPoint = new Point3f();
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private static final double QConst = -27888.0;
    int hPtr = 0;

    AminoPolymer(Monomer[] monomers) {
        super(monomers);
    }

    boolean hasWingPoints() {
        return true;
    }

    void calcHydrogenBonds(BitSet bsA, BitSet bsB) {
        this.debugHbonds = Logger.isActiveLevel((int)0);
        this.initializeHbondDataStructures();
        this.calcProteinMainchainHydrogenBonds(bsA, bsB);
    }

    void initializeHbondDataStructures() {
        int i;
        if (this.mainchainHbondOffsets == null) {
            this.mainchainHbondOffsets = new short[this.monomerCount];
            this.min1Indexes = new short[this.monomerCount];
            this.min1Energies = new short[this.monomerCount];
            this.min2Indexes = new short[this.monomerCount];
            this.min2Energies = new short[this.monomerCount];
        } else {
            i = this.monomerCount;
            while (--i >= 0) {
                this.min2Energies[i] = 0;
                this.min1Energies[i] = 0;
                this.mainchainHbondOffsets[i] = 0;
            }
        }
        i = this.monomerCount;
        while (--i >= 0) {
            this.min2Indexes[i] = -1;
            this.min1Indexes[i] = -1;
        }
    }

    void freeHbondDataStructures() {
        this.min2Energies = null;
        this.min2Indexes = null;
        this.min1Energies = null;
        this.min1Indexes = null;
        this.mainchainHbondOffsets = null;
    }

    void calcProteinMainchainHydrogenBonds(BitSet bsA, BitSet bsB) {
        for (int i = 0; i < this.monomerCount; ++i) {
            AminoMonomer residue = (AminoMonomer)this.monomers[i];
            this.mainchainHbondOffsets[i] = 0;
            if (i > 0 && residue.getGroupID() != 15) {
                Point3f nitrogenPoint = residue.getNitrogenAtomPoint();
                this.aminoHydrogenPoint.add((Tuple3f)nitrogenPoint, (Tuple3f)this.vectorPreviousOC);
                this.bondAminoHydrogen(i, this.aminoHydrogenPoint, bsA, bsB);
            }
            Point3f carbonPoint = residue.getCarbonylCarbonAtomPoint();
            Point3f oxygenPoint = residue.getCarbonylOxygenAtomPoint();
            this.vectorPreviousOC.sub((Tuple3f)carbonPoint, (Tuple3f)oxygenPoint);
            this.vectorPreviousOC.scale(1.0f / this.vectorPreviousOC.length());
        }
    }

    void bondAminoHydrogen(int indexDonor, Point3f hydrogenPoint, BitSet bsA, BitSet bsB) {
        AminoMonomer source = (AminoMonomer)this.monomers[indexDonor];
        Point3f sourceAlphaPoint = source.getLeadAtomPoint();
        Point3f sourceNitrogenPoint = source.getNitrogenAtomPoint();
        int energyMin1 = 0;
        int energyMin2 = 0;
        int indexMin1 = -1;
        int indexMin2 = -1;
        int i = this.monomerCount;
        while (--i >= 0) {
            AminoMonomer target;
            Point3f targetAlphaPoint;
            float dist2;
            if (i == indexDonor || i + 1 == indexDonor || i - 1 == indexDonor || (dist2 = sourceAlphaPoint.distanceSquared(targetAlphaPoint = (target = (AminoMonomer)this.monomers[i]).getLeadAtomPoint())) > 81.0f) continue;
            int energy = this.calcHbondEnergy(source.getNitrogenAtom(), sourceNitrogenPoint, hydrogenPoint, target);
            if (energy < energyMin1) {
                energyMin2 = energyMin1;
                indexMin2 = indexMin1;
                energyMin1 = energy;
                indexMin1 = i;
                continue;
            }
            if (energy >= energyMin2) continue;
            energyMin2 = energy;
            indexMin2 = i;
        }
        if (indexMin1 >= 0) {
            this.mainchainHbondOffsets[indexDonor] = (short)(indexDonor - indexMin1);
            this.min1Indexes[indexDonor] = (short)indexMin1;
            this.min1Energies[indexDonor] = (short)energyMin1;
            this.createResidueHydrogenBond(indexDonor, indexMin1, bsA, bsB);
            if (indexMin2 >= 0) {
                this.createResidueHydrogenBond(indexDonor, indexMin2, bsA, bsB);
                this.min2Indexes[indexDonor] = (short)indexMin2;
                this.min2Energies[indexDonor] = (short)energyMin2;
            }
        }
    }

    int calcHbondEnergy(Atom nitrogen, Point3f nitrogenPoint, Point3f hydrogenPoint, AminoMonomer target) {
        boolean isHbond;
        Point3f targetOxygenPoint = target.getCarbonylOxygenAtomPoint();
        float distON2 = targetOxygenPoint.distanceSquared(nitrogenPoint);
        if (distON2 < 0.5f) {
            return 0;
        }
        float distOH2 = targetOxygenPoint.distanceSquared(hydrogenPoint);
        if (distOH2 < 0.5f) {
            return 0;
        }
        Point3f targetCarbonPoint = target.getCarbonylCarbonAtomPoint();
        float distCH2 = targetCarbonPoint.distanceSquared(hydrogenPoint);
        if (distCH2 < 0.5f) {
            return 0;
        }
        float distCN2 = targetCarbonPoint.distanceSquared(nitrogenPoint);
        if (distCN2 < 0.5f) {
            return 0;
        }
        double distOH = Math.sqrt(distOH2);
        double distCH = Math.sqrt(distCH2);
        double distCN = Math.sqrt(distCN2);
        double distON = Math.sqrt(distON2);
        int energy = (int)(-27888.0 / distOH - -27888.0 / distCH + -27888.0 / distCN - -27888.0 / distON);
        boolean bl = isHbond = distCN2 > distCH2 && distOH <= 3.0 && energy <= -500;
        if (this.debugHbonds) {
            Logger.debug((String)("draw calcHydrogen" + ++this.hPtr + " (" + nitrogen.getInfo() + ") {" + hydrogenPoint.x + " " + hydrogenPoint.y + " " + hydrogenPoint.z + "} #" + isHbond + " " + nitrogen.getInfo() + " " + target.getLeadAtom().getInfo() + " distOH=" + distOH + " distCH=" + distCH + " distCN=" + distCN + " distON=" + distON + " energy=" + energy));
        }
        return !isHbond ? 0 : (energy < -9900 ? -9900 : energy);
    }

    void createResidueHydrogenBond(int indexAminoGroup, int indexCarbonylGroup, BitSet bsA, BitSet bsB) {
        short order;
        int aminoBackboneHbondOffset = indexAminoGroup - indexCarbonylGroup;
        switch (aminoBackboneHbondOffset) {
            case 2: {
                order = 128;
                break;
            }
            case 3: {
                order = 192;
                break;
            }
            case 4: {
                order = 256;
                break;
            }
            case 5: {
                order = 320;
                break;
            }
            case -3: {
                order = 384;
                break;
            }
            case -4: {
                order = 448;
                break;
            }
            default: {
                order = 64;
            }
        }
        AminoMonomer donor = (AminoMonomer)this.monomers[indexAminoGroup];
        Atom nitrogen = donor.getNitrogenAtom();
        AminoMonomer recipient = (AminoMonomer)this.monomers[indexCarbonylGroup];
        Atom oxygen = recipient.getCarbonylOxygenAtom();
        this.model.mmset.frame.addHydrogenBond(nitrogen, oxygen, order, bsA, bsB);
    }

    void calculateStructures() {
        int start;
        char[] structureTags = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            AminoMonomer leadingResidue = (AminoMonomer)this.monomers[i];
            AminoMonomer trailingResidue = (AminoMonomer)this.monomers[i + 1];
            this.calcPhiPsiAngles(leadingResidue, trailingResidue);
            structureTags[i] = AminoPolymer.isHelix(leadingResidue.psi, trailingResidue.phi) ? (trailingResidue.phi < 0.0f && leadingResidue.psi < 25.0f ? 52 : 51) : (AminoPolymer.isSheet(leadingResidue.psi, trailingResidue.phi) ? 115 : (AminoPolymer.isTurn(leadingResidue.psi, trailingResidue.phi) ? 116 : 110));
            if (!Logger.isActiveLevel((int)0)) continue;
            Logger.debug((String)(this.monomers[0].chain.chainID + " aminopolymer:" + i + " " + trailingResidue.phi + "," + leadingResidue.psi + " " + structureTags[i]));
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '4') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '4'; ++end) {
            }
            if (--end >= start + 3) {
                this.addSecondaryStructure((byte)3, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '3') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '3'; ++end) {
            }
            if (--end >= start + 3) {
                this.addSecondaryStructure((byte)3, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 's') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 's'; ++end) {
            }
            if (--end >= start + 2) {
                this.addSecondaryStructure((byte)2, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 't') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 't'; ++end) {
            }
            if (--end >= start + 2) {
                this.addSecondaryStructure((byte)1, start, end);
            }
            start = end;
        }
    }

    void calcPhiPsiAngles(AminoMonomer leadingResidue, AminoMonomer trailingResidue) {
        Point3f nitrogen1 = leadingResidue.getNitrogenAtomPoint();
        Point3f alphacarbon1 = leadingResidue.getLeadAtomPoint();
        Point3f carbon1 = leadingResidue.getCarbonylCarbonAtomPoint();
        Point3f nitrogen2 = trailingResidue.getNitrogenAtomPoint();
        Point3f alphacarbon2 = trailingResidue.getLeadAtomPoint();
        Point3f carbon2 = trailingResidue.getCarbonylCarbonAtomPoint();
        trailingResidue.phi = Measurement.computeTorsion(carbon1, nitrogen2, alphacarbon2, carbon2);
        leadingResidue.psi = Measurement.computeTorsion(nitrogen1, alphacarbon1, carbon1, nitrogen2);
    }

    static boolean isHelix(float psi, float phi) {
        return phi >= -160.0f && phi <= 0.0f && psi >= -100.0f && psi <= 45.0f;
    }

    static boolean isSheet(float psi, float phi) {
        return phi >= -180.0f && phi <= -10.0f && psi >= 70.0f && psi <= 180.0f || phi >= -180.0f && phi <= -45.0f && psi >= -180.0f && psi <= -130.0f || phi >= 140.0f && phi <= 180.0f && psi >= 90.0f && psi <= 180.0f;
    }

    static boolean isTurn(float psi, float phi) {
        return phi >= 30.0f && phi <= 90.0f && psi >= -15.0f && psi <= 95.0f;
    }

    boolean isHbonded(int indexDonor, int indexAcceptor) {
        if (indexDonor < 0 || indexDonor >= this.monomerCount || indexAcceptor < 0 || indexAcceptor >= this.monomerCount) {
            return false;
        }
        return this.min1Indexes[indexDonor] == indexAcceptor && this.min1Energies[indexDonor] <= -500 || this.min2Indexes[indexDonor] == indexAcceptor && this.min2Energies[indexDonor] <= -500;
    }
}

