/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Halos;
import org.jmol.viewer.ShapeRenderer;

class HalosRenderer
extends ShapeRenderer {
    HalosRenderer() {
    }

    void render() {
        boolean showHiddenSelections;
        Halos halos = (Halos)this.shape;
        boolean selectDisplayTrue = this.viewer.getSelectionHaloEnabled();
        boolean bl = showHiddenSelections = selectDisplayTrue && this.viewer.getShowHiddenSelectionHalos();
        if (halos.mads == null && !selectDisplayTrue) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        BitSet bsSelected = selectDisplayTrue ? this.viewer.getSelectionSet() : null;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if ((atom.shapeVisibilityFlags & 1) == 0) continue;
            int mad = halos.mads == null ? 0 : halos.mads[i];
            int colix = halos.colixes == null ? 0 : halos.colixes[i];
            boolean isHidden = this.frame.bsHidden.get(i);
            if (selectDisplayTrue && bsSelected.get(i)) {
                if (isHidden && !showHiddenSelections) continue;
                if (mad == 0) {
                    mad = -1;
                }
                if (colix == 0) {
                    colix = halos.colixSelection;
                }
                if (colix == 3) {
                    colix = 23;
                }
            } else if (isHidden) continue;
            if (mad == 0) continue;
            this.render1(atom, (short)mad, (short)colix);
        }
    }

    void render1(Atom atom, short mad, short colix) {
        int haloDiameter;
        int halowidth;
        int z = atom.screenZ;
        short diameter = mad;
        if (diameter < 0) {
            diameter = atom.screenDiameter;
            if (diameter == 0) {
                diameter = this.viewer.scaleToScreen(z, 500);
            }
        } else {
            diameter = this.viewer.scaleToScreen(z, mad);
        }
        if ((halowidth = diameter / 4) < 4) {
            halowidth = 4;
        }
        if (halowidth > 10) {
            halowidth = 10;
        }
        if ((haloDiameter = diameter + 2 * halowidth) <= 0) {
            return;
        }
        colix = Graphics3D.inheritColix((short)colix, (short)atom.colixAtom);
        this.g3d.fillScreenedCircleCentered(colix, haloDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }
}

