/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.viewer.AlphaPolymer;
import org.jmol.viewer.ProteinStructure;

class Helix
extends ProteinStructure {
    Helix(AlphaPolymer apolymer, int monomerIndex, int monomerCount) {
        super(apolymer, (byte)3, monomerIndex, monomerCount);
    }

    void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        this.axisA = new Point3f();
        this.axisB = new Point3f();
        this.apolymer.getLeadMidPoint(this.monomerIndex, this.axisA);
        this.apolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount, this.axisB);
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub((Tuple3f)this.axisB, (Tuple3f)this.axisA);
        this.axisUnitVector.normalize();
        this.calcCenter();
        this.axisA.set((Tuple3f)this.center);
        int nTries = 0;
        while (nTries++ < 4 && (double)this.findAxis(nTries) > 0.001) {
        }
        Point3f tempA = new Point3f();
        this.apolymer.getLeadMidPoint(this.monomerIndex, tempA);
        this.projectOntoAxis(tempA);
        this.axisA = tempA;
        Point3f tempB = new Point3f();
        this.apolymer.getLeadMidPoint(this.monomerIndex + this.monomerCount, tempB);
        this.projectOntoAxis(tempB);
        this.axisB.set((Tuple3f)tempB);
    }

    float findAxis(int nTries) {
        Vector3f sumXiYi = new Vector3f();
        Vector3f vTemp = new Vector3f();
        Point3f pt = new Point3f();
        Point3f ptProj = new Point3f();
        Vector3f a = new Vector3f(this.axisUnitVector);
        float sum_Xi2 = 0.0f;
        float sum_Yi2 = 0.0f;
        int i = this.monomerIndex + this.monomerCount;
        while (--i >= this.monomerIndex) {
            pt.set((Tuple3f)this.apolymer.getLeadPoint(i));
            ptProj.set((Tuple3f)pt);
            this.projectOntoAxis(ptProj);
            vTemp.sub((Tuple3f)pt, (Tuple3f)ptProj);
            sum_Yi2 += vTemp.lengthSquared();
            vTemp.cross(this.vectorProjection, vTemp);
            sumXiYi.add((Tuple3f)vTemp);
            sum_Xi2 += this.vectorProjection.lengthSquared();
        }
        Vector3f m = new Vector3f(sumXiYi);
        m.scale(1.0f / sum_Xi2);
        vTemp.cross(m, this.axisUnitVector);
        this.axisUnitVector.add((Tuple3f)vTemp);
        this.axisUnitVector.normalize();
        vTemp.set((Tuple3f)this.axisUnitVector);
        vTemp.sub((Tuple3f)a);
        return vTemp.length();
    }

    void calcCenter() {
        if (this.center != null) {
            return;
        }
        this.center = new Point3f();
        int i = this.monomerIndex + this.monomerCount;
        while (--i >= this.monomerIndex) {
            this.center.add((Tuple3f)this.apolymer.getLeadPoint(i));
        }
        this.center.scale(1.0f / (float)this.monomerCount);
    }
}

