/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.ShapeRenderer;

abstract class MeshRenderer
extends ShapeRenderer {
    boolean iShowTriangles;
    boolean iShowNormals;
    boolean iHideBackground;
    short backgroundColix;
    Point3f[] vertices;
    Point3i[] screens;
    float[] vertexValues;
    Point3i pt0 = new Point3i();
    Point3i pt3 = new Point3i();
    boolean frontOnly;
    Vector3f[] transformedVectors;
    final Point3f ptTemp = new Point3f();
    final Point3i ptTempi = new Point3i();

    MeshRenderer() {
    }

    boolean render1(Mesh mesh) {
        if (mesh.visibilityFlags == 0 || !mesh.isValid) {
            return false;
        }
        int vertexCount = mesh.vertexCount;
        if (vertexCount == 0) {
            return false;
        }
        this.vertices = mesh.vertices;
        this.screens = this.viewer.allocTempScreens(vertexCount);
        this.vertexValues = mesh.vertexValues;
        this.transformedVectors = this.g3d.getTransformedVertexVectors();
        int i = vertexCount;
        while (--i >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[i]) && !mesh.hasGridPoints) continue;
            this.viewer.transformPoint(this.vertices[i], this.screens[i]);
        }
        this.iShowTriangles = this.viewer.getTestFlag3();
        this.iShowNormals = this.viewer.getTestFlag4();
        boolean bl = this.iHideBackground = mesh.jvxlPlane != null && mesh.hideBackground;
        if (this.iHideBackground) {
            this.backgroundColix = Graphics3D.getColix((int)this.viewer.getBackgroundArgb());
        }
        boolean isDrawPickMode = mesh.meshType == "draw" && this.viewer.getPickingMode() == 4;
        int drawType = mesh.drawType;
        short colix = mesh.colix;
        if ((drawType == 3 || drawType == 1) && mesh.vertexCount >= 2) {
            int i2 = 0;
            int i0 = 0;
            while (i2 < mesh.vertexCount - 1) {
                this.g3d.fillHermite(colix, 5, 3, 3, 3, this.screens[i0], this.screens[i2], this.screens[i2 + 1], this.screens[i2 + (i2 + 2 == mesh.vertexCount ? 1 : 2)]);
                i0 = i2++;
            }
        }
        switch (drawType) {
            case 1: {
                Point3i pt1 = this.screens[mesh.vertexCount - 2];
                Point3i pt2 = this.screens[mesh.vertexCount - 1];
                Vector3f tip = new Vector3f((float)(pt2.x - pt1.x), (float)(pt2.y - pt1.y), (float)(pt2.z - pt1.z));
                float d = tip.length();
                if (!(d > 0.0f)) break;
                tip.scale(5.0f / d);
                this.pt0.x = pt2.x - (int)Math.floor(4.0f * tip.x);
                this.pt0.y = pt2.y - (int)Math.floor(4.0f * tip.y);
                this.pt0.z = pt2.z - (int)Math.floor(4.0f * tip.z);
                this.pt3.x = pt2.x + (int)Math.floor(tip.x);
                this.pt3.y = pt2.y + (int)Math.floor(tip.y);
                this.pt3.z = pt2.z + (int)Math.floor(tip.z);
                this.g3d.fillCone(colix, (byte)2, 15, this.pt0, this.pt3);
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (mesh.showPoints) {
                    this.renderPoints(mesh, this.screens, vertexCount);
                }
                if (this.iShowNormals) {
                    this.renderNormals(mesh, this.screens, vertexCount);
                }
                if (mesh.drawTriangles) {
                    this.renderTriangles(mesh, this.screens, false);
                }
                if (!mesh.fillTriangles) break;
                this.renderTriangles(mesh, this.screens, true);
            }
        }
        if (isDrawPickMode) {
            this.renderHandles(mesh, this.screens, vertexCount);
        }
        this.viewer.freeTempScreens(this.screens);
        return true;
    }

    void renderHandles(Mesh mesh, Point3i[] screens, int vertexCount) {
        block0 : switch (mesh.drawType) {
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int i = mesh.polygonCount;
                while (--i >= 0) {
                    int[] vertexIndexes;
                    if (!mesh.isPolygonDisplayable(i) || (vertexIndexes = mesh.polygonIndexes[i]) == null) continue;
                    int j = vertexIndexes.length;
                    while (--j >= 0) {
                        int k = vertexIndexes[j];
                        this.g3d.fillScreenedCircleCentered((short)23, 10, screens[k].x, screens[k].y, screens[k].z);
                    }
                    break block0;
                }
                break;
            }
        }
    }

    void renderPoints(Mesh mesh, Point3i[] screens, int vertexCount) {
        short colix = mesh.colix;
        short[] vertexColixes = mesh.vertexColixes;
        int iCount = mesh.lastViewableVertex > 0 ? mesh.lastViewableVertex + 1 : vertexCount;
        int iFirst = mesh.firstViewableVertex;
        int i = iCount;
        while (--i >= iFirst) {
            if (this.vertexValues == null || Float.isNaN(this.vertexValues[i])) continue;
            this.g3d.fillSphereCentered(vertexColixes != null ? vertexColixes[i] : colix, 4, screens[i]);
        }
        if (mesh.hasGridPoints) {
            for (i = 0; i < iFirst; ++i) {
                this.g3d.fillSphereCentered((short)12, 2, screens[i]);
            }
        }
        if (mesh.hasGridPoints && !mesh.isContoured) {
            for (i = 1; i < vertexCount; i += 3) {
                this.g3d.fillCylinder((short)12, (byte)3, 1, screens[i], screens[i + 1]);
            }
        }
    }

    void renderNormals(Mesh mesh, Point3i[] screens, int vertexCount) {
        int i = vertexCount;
        while (--i >= 0) {
            if (i % 3 != 0) continue;
            this.ptTemp.set((Tuple3f)mesh.vertices[i]);
            short n = mesh.normixes[i];
            if (n <= 0) continue;
            this.ptTemp.add((Tuple3f)this.g3d.getNormixVector(n));
            this.viewer.transformPoint(this.ptTemp, this.ptTempi);
            this.g3d.fillCylinder((short)8, (byte)3, 1, screens[i], this.ptTempi);
        }
    }

    void renderTriangles(Mesh mesh, Point3i[] screens, boolean fill) {
        int[][] polygonIndexes = mesh.polygonIndexes;
        short[] normixes = mesh.normixes;
        short colix = mesh.colix;
        short[] vertexColixes = mesh.vertexColixes;
        short hideColix = 0;
        try {
            hideColix = vertexColixes[mesh.polygonIndexes[0][0]];
        }
        catch (Exception e) {
            // empty catch block
        }
        int i = mesh.polygonCount;
        while (--i >= 0) {
            short colixD;
            short colixC;
            short colixB;
            short colixA;
            int[] vertexIndexes;
            if (!mesh.isPolygonDisplayable(i) || (vertexIndexes = polygonIndexes[i]) == null) continue;
            int iA = vertexIndexes[0];
            int iB = vertexIndexes[1];
            int iC = vertexIndexes[2];
            if (vertexColixes != null) {
                colixA = vertexColixes[iA];
                colixB = vertexColixes[iB];
                colixC = vertexColixes[iC];
            } else {
                colixB = colixC = colix;
                colixA = colixC;
            }
            if (this.iHideBackground) {
                if (colixA == hideColix && colixB == hideColix && colixC == hideColix) continue;
                if (colixA == hideColix) {
                    colixA = this.backgroundColix;
                }
                if (colixB == hideColix) {
                    colixB = this.backgroundColix;
                }
                if (colixC == hideColix) {
                    colixC = this.backgroundColix;
                }
            }
            if (iB == iC) {
                this.g3d.fillCylinder(colixA, (byte)3, iA == iB ? 6 : 3, screens[iA], screens[iB]);
                continue;
            }
            if (vertexIndexes.length == 3) {
                if (fill) {
                    if (this.iShowTriangles) {
                        this.g3d.fillTriangle(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC], 0.1f);
                        continue;
                    }
                    if (this.frontOnly && this.transformedVectors[normixes[iA]].z < 0.0f && this.transformedVectors[normixes[iB]].z < 0.0f && this.transformedVectors[normixes[iC]].z < 0.0f) continue;
                    this.g3d.fillTriangle(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC]);
                    continue;
                }
                this.g3d.drawTriangle(colixA, screens[iA], screens[iB], screens[iC]);
                continue;
            }
            if (vertexIndexes.length != 4) continue;
            int iD = vertexIndexes[3];
            short s = colixD = vertexColixes != null ? vertexColixes[iD] : colix;
            if (fill) {
                if (this.frontOnly && this.transformedVectors[normixes[iA]].z < 0.0f && this.transformedVectors[normixes[iB]].z < 0.0f && this.transformedVectors[normixes[iC]].z < 0.0f && this.transformedVectors[normixes[iD]].z < 0.0f) continue;
                this.g3d.fillQuadrilateral(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC], screens[iD], colixD, normixes[iD]);
                continue;
            }
            this.g3d.drawQuadrilateral(colixA, screens[iA], screens[iB], screens[iC], screens[iD]);
        }
    }
}

