/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point4f;
import org.jmol.util.Logger;
import org.jmol.viewer.Isosurface;

class MolecularOrbital
extends Isosurface {
    String moTranslucency = null;
    Point4f moPlane = null;
    Float moCutoff = new Float(0.05f);
    Float moResolution = null;
    Float moScale = null;
    Integer moColorPos = null;
    Integer moColorNeg = null;
    Float moRed = null;
    Float moBlue = null;
    String moTitleFormat = null;
    boolean moDebug;
    boolean moIsPositiveOnly = false;
    int myColorPt;
    String strID;

    MolecularOrbital() {
    }

    void initShape() {
        this.myType = "molecularOrbital";
        super.setProperty("thisID", "mo", null);
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug((String)("MolecularOrbital.setProperty " + propertyName + " " + value));
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.moDebug = false;
            this.strID = (String)value;
            super.setProperty("init", null, null);
            return;
        }
        if ("cutoff" == propertyName) {
            this.moCutoff = (Float)value;
            this.moIsPositiveOnly = false;
            return;
        }
        if ("scale" == propertyName) {
            this.moScale = (Float)value;
            return;
        }
        if ("cutoffPositive" == propertyName) {
            this.moCutoff = (Float)value;
            this.moIsPositiveOnly = true;
            return;
        }
        if ("resolution" == propertyName) {
            this.moResolution = (Float)value;
            return;
        }
        if ("titleFormat" == propertyName) {
            this.moTitleFormat = (String)value;
            return;
        }
        if ("colorRGB" == propertyName) {
            this.moColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            return;
        }
        if ("plane" == propertyName) {
            this.moPlane = (Point4f)value;
            return;
        }
        if ("molecularOrbital" == propertyName) {
            this.setOrbital((Integer)value);
            return;
        }
        if ("translucency" == propertyName) {
            this.moTranslucency = (String)value;
        }
        super.setProperty(propertyName, value, bs);
    }

    Object getProperty(String propertyName, int param) {
        if (propertyName == "showMO") {
            int nOrb;
            StringBuffer str = new StringBuffer();
            String infoType = "jvxlFileData";
            Vector mos = (Vector)this.moData.get("mos");
            int n = nOrb = mos == null ? 0 : mos.size();
            if (nOrb == 0) {
                return "";
            }
            int thisMO = param;
            int currentMO = this.qm_moNumber;
            if (currentMO == 0) {
                thisMO = 0;
            }
            int nTotal = thisMO > 0 ? 1 : nOrb;
            for (int i = 1; i <= nOrb; ++i) {
                if (thisMO != 0 && thisMO != i && (thisMO != Integer.MAX_VALUE || i != currentMO)) continue;
                super.setProperty("init", "mo_show", null);
                this.setOrbital(i);
                str.append(super.getProperty(infoType, nTotal));
                infoType = "jvxlSurfaceData";
                super.setProperty("delete", "mo_show", null);
            }
            return "" + str;
        }
        if (propertyName == "moNumber") {
            return this.qm_moNumber == 0 ? null : new Integer(this.qm_moNumber);
        }
        return null;
    }

    void setOrbital(int moNumber) {
        super.setProperty("reset", this.strID, null);
        if (this.moDebug) {
            super.setProperty("debug", Boolean.TRUE, null);
        }
        if (this.moScale != null) {
            super.setProperty("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            super.setProperty("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            super.setProperty("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                super.setProperty("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                super.setProperty(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                super.setProperty("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                super.setProperty("colorRGB", this.moColorPos, null);
            }
        }
        super.setProperty("title", this.moTitleFormat, null);
        super.setProperty("molecularOrbital", new Integer(moNumber), null);
        if (this.moTranslucency != null) {
            super.setProperty("translucency", this.moTranslucency, null);
        }
    }
}

