/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.util.Logger;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Group;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.ProteinStructure;

abstract class Monomer
extends Group {
    Polymer polymer;
    final byte[] offsets;

    Monomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] interestingAtomOffsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        this.offsets = interestingAtomOffsets;
    }

    void setPolymer(Polymer polymer) {
        this.polymer = polymer;
    }

    int getPolymerLength() {
        return this.polymer == null ? 0 : this.polymer.monomerCount;
    }

    int getPolymerIndex() {
        return this.polymer == null ? -1 : this.polymer.getIndex(this);
    }

    static byte[] scanForOffsets(int firstAtomIndex, int[] specialAtomIndexes, byte[] interestingAtomIDs) {
        int interestingCount = interestingAtomIDs.length;
        byte[] offsets = new byte[interestingCount];
        int i = interestingCount;
        while (--i >= 0) {
            int offset;
            int atomIndex;
            byte atomID = interestingAtomIDs[i];
            if (atomID < 0) {
                atomIndex = specialAtomIndexes[~atomID];
            } else {
                atomIndex = specialAtomIndexes[atomID];
                if (atomIndex < 0) {
                    return null;
                }
            }
            if (atomIndex < 0) {
                offset = 255;
            } else {
                offset = atomIndex - firstAtomIndex;
                if (offset < 0 || offset > 254) {
                    Logger.warn((String)("Monomer.scanForOffsets i=" + i + " atomID=" + atomID + " atomIndex:" + atomIndex + " firstAtomIndex:" + firstAtomIndex + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + offset));
                    if (atomID < 0) {
                        offset = 255;
                    }
                }
            }
            offsets[i] = (byte)offset;
        }
        return offsets;
    }

    boolean isDna() {
        return false;
    }

    boolean isRna() {
        return false;
    }

    final boolean isProtein() {
        return this instanceof AlphaMonomer;
    }

    final boolean isNucleic() {
        return this instanceof PhosphorusMonomer;
    }

    void setStructure(ProteinStructure proteinstructure) {
    }

    ProteinStructure getProteinStructure() {
        return null;
    }

    byte getProteinStructureType() {
        return 0;
    }

    boolean isHelix() {
        return false;
    }

    boolean isSheet() {
        return false;
    }

    final Atom getAtomFromOffset(byte offset) {
        if (offset == -1) {
            return null;
        }
        return this.chain.frame.atoms[this.firstAtomIndex + (offset & 0xFF)];
    }

    final Point3f getAtomPointFromOffset(byte offset) {
        if (offset == -1) {
            return null;
        }
        return this.chain.frame.atoms[this.firstAtomIndex + (offset & 0xFF)];
    }

    final Atom getAtomFromOffsetIndex(int offsetIndex) {
        if (offsetIndex > this.offsets.length) {
            return null;
        }
        int offset = this.offsets[offsetIndex] & 0xFF;
        if (offset == 255) {
            return null;
        }
        return this.chain.frame.atoms[this.firstAtomIndex + offset];
    }

    final Point3f getAtomPointFromOffsetIndex(int offsetIndex) {
        return this.getAtomFromOffsetIndex(offsetIndex);
    }

    final Atom getSpecialAtom(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            if (offset == 255) {
                return null;
            }
            return this.chain.frame.atoms[this.firstAtomIndex + offset];
        }
        return null;
    }

    final Point3f getSpecialAtomPoint(byte[] interestingIDs, byte specialAtomID) {
        int i = interestingIDs.length;
        while (--i >= 0) {
            byte interestingID = interestingIDs[i];
            if (interestingID < 0) {
                interestingID = -interestingID;
            }
            if (specialAtomID != interestingID) continue;
            int offset = this.offsets[i] & 0xFF;
            if (offset == 255) {
                return null;
            }
            return this.chain.frame.atoms[this.firstAtomIndex + offset];
        }
        return null;
    }

    Atom getAtom(byte specialAtomID) {
        return null;
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return null;
    }

    final int getLeadAtomIndex() {
        return this.firstAtomIndex + (this.offsets[0] & 0xFF);
    }

    final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    final Point3f getLeadAtomPoint() {
        return this.getAtomPointFromOffsetIndex(0);
    }

    final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    final Point3f getWingAtomPoint() {
        return this.getAtomPointFromOffsetIndex(1);
    }

    final Point3f getPointAtomPoint() {
        return this.getAtomPointFromOffsetIndex(3);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int x, int y, Closest closest, short madBegin, short madEnd) {
    }

    Hashtable getMyInfo() {
        ProteinStructure structure;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("chain", "" + this.chain.chainID);
        int seqNum = this.getSeqNumber();
        char insCode = this.getInsertionCode();
        if (seqNum > 0) {
            info.put("sequenceNumber", new Integer(seqNum));
        }
        if (insCode != '\u0000') {
            info.put("insertionCode", "" + insCode);
        }
        info.put("atomInfo1", this.chain.frame.atoms[this.firstAtomIndex].getInfo());
        info.put("atomInfo2", this.chain.frame.atoms[this.lastAtomIndex].getInfo());
        info.put("_apt1", new Integer(this.firstAtomIndex));
        info.put("_apt2", new Integer(this.lastAtomIndex));
        if (!Float.isNaN(this.phi)) {
            info.put("phi", new Float(this.phi));
        }
        if (!Float.isNaN(this.psi)) {
            info.put("psi", new Float(this.psi));
        }
        if ((structure = this.getProteinStructure()) != null) {
            info.put("structureIndex", new Integer(structure.index));
            info.put("structureType", Monomer.getStructureTypeName(structure.type));
        }
        info.put("shapeVisibilityFlags", new Integer(this.shapeVisibilityFlags));
        return info;
    }

    static String getStructureTypeName(byte type) {
        switch (type) {
            case 3: {
                return "helix";
            }
            case 2: {
                return "sheet";
            }
            case 1: {
                return "turn";
            }
            case 4: {
                return "DNA";
            }
            case 5: {
                return "RNA";
            }
        }
        return type + "?";
    }

    final void updateOffsetsForAlternativeLocations(BitSet bsSelected, int nAltLocInModel) {
        int offsetIndex = this.offsets.length;
        block0: while (--offsetIndex >= 0) {
            int offset = this.offsets[offsetIndex] & 0xFF;
            if (offset == 255) continue;
            int iThis = this.firstAtomIndex + offset;
            Atom atom = this.chain.frame.atoms[iThis];
            if (atom.alternateLocationID == 0) continue;
            int nScan = this.lastAtomIndex - this.firstAtomIndex;
            for (int i = 1; i <= nScan; ++i) {
                int offsetNew;
                int iNew = iThis + i;
                if (iNew > this.lastAtomIndex) {
                    iNew -= nScan + 1;
                }
                if ((offsetNew = iNew - this.firstAtomIndex) < 0 || offsetNew > 255 || iNew == iThis || this.chain.frame.atomNames[iNew] != this.chain.frame.atomNames[iThis] || !bsSelected.get(iNew)) continue;
                this.offsets[offsetIndex] = (byte)offsetNew;
                continue block0;
            }
        }
    }
}

