/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Frame;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Viewer;

class PickingManager {
    Viewer viewer;
    int pickingMode = 1;
    int pickingStyleSelect = 0;
    int pickingStyleMeasure = 4;
    int queuedAtomCount = 0;
    int[] queuedAtomIndexes = new int[4];
    int[] countPlusIndices = new int[5];

    PickingManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.pickingMode = 1;
    }

    void atomPicked(int atomIndex, int modifiers) {
        boolean alternateKey;
        boolean shiftKey = (modifiers & 1) != 0;
        boolean bl = alternateKey = (modifiers & 8) != 0;
        if (atomIndex == -1) {
            if (this.pickingStyleSelect == 2 && !shiftKey && !alternateKey) {
                this.viewer.script("select none");
            }
            if (this.pickingMode == 14 || this.pickingStyleMeasure == 3) {
                this.queuedAtomCount = 0;
            }
            if (this.pickingMode == 3) {
                this.viewer.script("zoomTo out");
            }
            return;
        }
        Frame frame = this.viewer.getFrame();
        switch (this.pickingMode) {
            case 0: {
                break;
            }
            case 1: {
                this.viewer.setStatusAtomPicked(atomIndex, this.viewer.getAtomInfoXYZ(atomIndex));
                break;
            }
            case 14: 
            case 15: {
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) break;
                float distance = frame.getDistance(this.queuedAtomIndexes[0], atomIndex);
                String value = "Distance " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " : " + distance;
                this.viewer.setStatusNewPickingModeMeasurement(2, value);
                if (this.pickingMode != 14 && this.pickingStyleMeasure != 3) break;
                this.toggleMeasurement(2);
                break;
            }
            case 16: {
                if (this.queuedAtomCount >= 3) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 3) break;
                float angle = frame.getAngle(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], atomIndex);
                String value = "Angle " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " : " + angle;
                this.viewer.setStatusNewPickingModeMeasurement(3, value);
                if (this.pickingStyleMeasure != 3) break;
                this.toggleMeasurement(3);
                break;
            }
            case 17: {
                if (this.queuedAtomCount >= 4) {
                    this.queuedAtomCount = 0;
                }
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 4) break;
                float torsion = frame.getTorsion(this.queuedAtomIndexes[0], this.queuedAtomIndexes[1], this.queuedAtomIndexes[2], atomIndex);
                String value = "Torsion " + this.viewer.getAtomInfo(this.queuedAtomIndexes[0]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[1]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[2]) + " - " + this.viewer.getAtomInfo(this.queuedAtomIndexes[3]) + " : " + torsion;
                this.viewer.setStatusNewPickingModeMeasurement(4, value);
                if (this.pickingStyleMeasure != 3) break;
                this.toggleMeasurement(4);
                break;
            }
            case 2: {
                this.viewer.script("set toggleLabel (atomindex=" + atomIndex + ")");
                break;
            }
            case 3: {
                this.viewer.script("zoomTo (atomindex=" + atomIndex + ")");
                break;
            }
            case 8: {
                this.applyMouseStyle("atomIndex=" + atomIndex, shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 9: {
                this.applyMouseStyle("within(group, atomIndex=" + atomIndex + ")", shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 10: {
                this.applyMouseStyle("within(chain, atomIndex=" + atomIndex + ")", shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 11: {
                this.applyMouseStyle("visible and within(molecule, atomIndex=" + atomIndex + ")", shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 12: {
                this.applyMouseStyle("visible and within(site, atomIndex=" + atomIndex + ")", shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 13: {
                this.applyMouseStyle("visible and within(element, atomIndex=" + atomIndex + ")", shiftKey, alternateKey);
                this.viewer.clearClickCount();
                break;
            }
            case 5: {
                if (this.viewer.getSpinOn()) {
                    this.viewer.script("spin off");
                    break;
                }
                if (this.queuedAtomCount >= 2) {
                    this.queuedAtomCount = 0;
                }
                if (this.queuedAtomCount == 1 && this.queuedAtomIndexes[0] == atomIndex) break;
                this.queueAtom(atomIndex);
                if (this.queuedAtomCount < 2) {
                    if (this.viewer.getSpinOn()) {
                        this.viewer.script("spin off");
                    }
                    this.viewer.scriptStatus(this.queuedAtomCount == 1 ? GT._((String)"pick one more atom in order to spin the model around an axis") : GT._((String)"pick two atoms in order to spin the model around an axis"));
                    break;
                }
                this.viewer.script("spin (atomindex=" + this.queuedAtomIndexes[0] + ") (atomIndex=" + atomIndex + ")");
            }
        }
    }

    void toggleMeasurement(int nAtoms) {
        this.countPlusIndices[0] = nAtoms;
        int iLast = -1;
        for (int i = 0; i < nAtoms; ++i) {
            int iThis = this.queuedAtomIndexes[i];
            if (iLast == iThis) {
                this.queuedAtomCount = i;
                return;
            }
            int n = iThis;
            this.countPlusIndices[i + 1] = n;
            iLast = n;
        }
        this.viewer.script(Measurement.getMeasurementScript(this.countPlusIndices));
    }

    void applyMouseStyle(String item, boolean shiftKey, boolean alternateKey) {
        item = "(" + item + ")";
        if (this.pickingStyleSelect == 2) {
            if (shiftKey && alternateKey) {
                this.viewer.script("select selected and not " + item);
            } else if (shiftKey) {
                this.viewer.script("select selected tog " + item);
            } else if (alternateKey) {
                this.viewer.script("select selected or " + item);
            } else {
                this.viewer.script("select " + item);
            }
        } else if (shiftKey | this.pickingStyleSelect == 0) {
            this.viewer.script("select selected tog " + item);
        } else {
            this.viewer.script("select " + item);
        }
    }

    int getPickingMode() {
        return this.pickingMode;
    }

    void setPickingMode(int pickingMode) {
        this.pickingMode = pickingMode;
        this.queuedAtomCount = 0;
    }

    void setPickingStyle(int pickingStyle) {
        Logger.debug((String)(" setPickingStyle " + pickingStyle + ": " + JmolConstants.getPickingStyleName(pickingStyle)));
        if (pickingStyle >= 3) {
            this.pickingStyleMeasure = pickingStyle;
            this.queuedAtomCount = 0;
        } else {
            this.pickingStyleSelect = pickingStyle;
        }
    }

    void queueAtom(int atomIndex) {
        this.queuedAtomIndexes[this.queuedAtomCount++] = atomIndex;
        this.viewer.setStatusAtomPicked(atomIndex, "Atom #" + this.queuedAtomCount + ":" + this.viewer.getAtomInfo(atomIndex));
    }
}

