/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.AlphaPolymer;
import org.jmol.viewer.Monomer;

abstract class ProteinStructure {
    AlphaPolymer apolymer;
    byte type;
    int monomerIndex;
    int monomerCount;
    Point3f axisA;
    Point3f axisB;
    Vector3f axisUnitVector;
    Point3f[] segments;
    int index;
    Point3f center;
    final Vector3f vectorProjection = new Vector3f();

    ProteinStructure(AlphaPolymer apolymer, byte type, int monomerIndex, int monomerCount) {
        this.apolymer = apolymer;
        this.type = type;
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)("Creating ProteinStructure" + type + " from " + monomerIndex + " through " + (monomerIndex + monomerCount - 1)));
        }
        this.monomerIndex = monomerIndex;
        this.monomerCount = monomerCount;
    }

    void calcAxis() {
    }

    void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new Point3f[this.monomerCount + 1];
        this.segments[this.monomerCount] = this.axisB;
        this.segments[0] = this.axisA;
        Vector3f axis = new Vector3f(this.axisUnitVector);
        axis.scale(this.axisB.distance(this.axisA) / (float)this.monomerCount);
        for (int i = 1; i < this.monomerCount; ++i) {
            Point3f point = this.segments[i] = new Point3f();
            point.set((Tuple3f)this.segments[i - 1]);
            point.add((Tuple3f)axis);
        }
    }

    boolean lowerNeighborIsHelixOrSheet() {
        if (this.monomerIndex == 0) {
            return false;
        }
        return this.apolymer.monomers[this.monomerIndex - 1].isHelix() || this.apolymer.monomers[this.monomerIndex - 1].isSheet();
    }

    boolean upperNeighborIsHelixOrSheet() {
        int upperNeighborIndex = this.monomerIndex + this.monomerCount;
        if (upperNeighborIndex == this.apolymer.monomerCount) {
            return false;
        }
        return this.apolymer.monomers[upperNeighborIndex].isHelix() || this.apolymer.monomers[upperNeighborIndex].isSheet();
    }

    void projectOntoAxis(Point3f point) {
        this.vectorProjection.sub((Tuple3f)point, (Tuple3f)this.axisA);
        float projectedLength = this.vectorProjection.dot(this.axisUnitVector);
        point.set((Tuple3f)this.axisUnitVector);
        point.scaleAdd(projectedLength, (Tuple3f)this.axisA);
        this.vectorProjection.sub((Tuple3f)point, (Tuple3f)this.axisA);
    }

    int getMonomerCount() {
        return this.monomerCount;
    }

    int getMonomerIndex() {
        return this.monomerIndex;
    }

    int getIndex(Monomer monomer) {
        Monomer[] monomers = this.apolymer.monomers;
        int i = this.monomerCount;
        while (--i >= 0 && monomers[this.monomerIndex + i] != monomer) {
        }
        return i;
    }

    Point3f[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    Point3f getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    Point3f getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    Point3f getStructureMidPoint(int index) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[index];
    }
}

