/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.JmolStatusListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class StatusManager {
    boolean allowStatusReporting = true;
    Viewer viewer;
    JmolStatusListener jmolStatusListener;
    String statusList = "";
    Hashtable messageQueue = new Hashtable();
    int statusPtr = 0;
    static int MAXIMUM_QUEUE_LENGTH = 16;
    String compileError;
    int minSyncRepeatMs = 100;
    int lastSyncTimeMs = 0;
    boolean drivingSync = false;
    boolean isSynced = false;

    void setAllowStatusReporting(boolean TF) {
        this.allowStatusReporting = TF;
    }

    StatusManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.setStatusFileLoaded(null, null, null, null, null, 0);
    }

    synchronized boolean resetMessageQueue(String statusList) {
        boolean isRemove = statusList.length() > 0 && statusList.charAt(0) == '-';
        boolean isAdd = statusList.length() > 0 && statusList.charAt(0) == '+';
        String oldList = this.statusList;
        if (isRemove) {
            this.statusList = this.viewer.simpleReplace(oldList, statusList.substring(1, statusList.length()), "");
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            return true;
        }
        if (oldList.equals(statusList = this.viewer.simpleReplace(statusList, "+", "")) || isAdd && oldList.indexOf(statusList) >= 0) {
            return false;
        }
        if (!isAdd) {
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            this.statusList = "";
        }
        this.statusList = this.statusList + statusList;
        Logger.debug((String)(oldList + "\nmessageQueue = " + this.statusList));
        return true;
    }

    synchronized void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.jmolStatusListener = jmolStatusListener;
    }

    synchronized boolean setStatusList(String statusList) {
        return this.resetMessageQueue(statusList);
    }

    synchronized void setCallbackFunction(String callbackType, String callbackFunction) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.setCallbackFunction(callbackType, callbackFunction);
        }
    }

    synchronized void setStatusAtomPicked(int atomIndex, String strInfo) {
        if (atomIndex < 0) {
            return;
        }
        Logger.info((String)("setStatusAtomPicked(" + atomIndex + "," + strInfo + ")"));
        this.setStatusChanged("atomPicked", atomIndex, strInfo, false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyAtomPicked(atomIndex, strInfo);
        }
    }

    synchronized void setStatusAtomHovered(int iatom, String strInfo) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyAtomHovered(iatom, strInfo);
        }
    }

    synchronized void setStatusFileLoaded(String fullPathName, String fileName, String modelName, Object clientFile, String errorMsg, int ptLoad) {
        this.setStatusChanged("fileLoaded", ptLoad, fullPathName, false);
        if (errorMsg != null) {
            this.setStatusChanged("fileLoadError", ptLoad, errorMsg, false);
        }
        if (this.jmolStatusListener != null && (ptLoad == -1 || ptLoad == 3)) {
            this.jmolStatusListener.notifyFileLoaded(fullPathName, fileName, modelName, clientFile, errorMsg);
        }
    }

    synchronized void setStatusFrameChanged(int frameNo) {
        boolean isAnimationRunning = frameNo <= -2;
        int f = frameNo;
        if (isAnimationRunning) {
            f = -2 - f;
        }
        this.setStatusChanged("frameChanged", frameNo, f >= 0 ? this.viewer.getModelName(f) : "", false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyFrameChanged(frameNo);
        }
    }

    synchronized void setStatusNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.setStatusChanged("measurePicked", iatom, strMeasure, false);
        Logger.info((String)("measurePicked " + iatom + " " + strMeasure));
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyNewPickingModeMeasurement(iatom, strMeasure);
        }
    }

    synchronized void setStatusNewDefaultModeMeasurement(String status, int count, String strMeasure) {
        this.setStatusChanged(status, count, strMeasure, false);
        if (status == "measureCompleted") {
            Logger.info((String)("measurement[" + count + "] = " + strMeasure));
        }
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyNewDefaultModeMeasurement(count, status + ": " + strMeasure);
        }
    }

    synchronized void setStatusScriptStarted(int iscript, String script, String compileError) {
        this.compileError = compileError;
        compileError = compileError == null ? GT._((String)"Jmol executing script ...") : "Script ERROR: " + compileError;
        this.setStatusChanged("scriptStarted", iscript, script, false);
        this.setStatusChanged("scriptMessage", 0, compileError, false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyScriptStart(compileError, script);
        }
    }

    synchronized void setStatusScriptTermination(String statusMessage, int msWalltime) {
        statusMessage = "Jmol script terminated" + (this.compileError == null ? "" : " ERROR: " + this.compileError);
        if (this.jmolStatusListener == null) {
            return;
        }
        this.jmolStatusListener.notifyScriptTermination(statusMessage, msWalltime);
    }

    synchronized void setStatusUserAction(String strInfo) {
        Logger.info((String)("userAction(" + strInfo + ")"));
        if (this.isSynced) {
            this.syncSend("SLAVE", null);
        }
        this.drivingSync = true;
        this.setStatusChanged("userAction", 0, strInfo, false);
    }

    synchronized void setScriptEcho(String strEcho) {
        if (strEcho == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, strEcho, false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.sendConsoleEcho(strEcho);
        }
    }

    synchronized void setScriptStatus(String strStatus) {
        if (strStatus == null) {
            return;
        }
        boolean isError = strStatus.indexOf("ERROR:") >= 0;
        this.setStatusChanged(isError ? "scriptError" : "scriptStatus", 0, strStatus, false);
        if (isError || strStatus.equals("Script completed")) {
            this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (isError ? " unsuccesscully: " + strStatus : " successfully"), false);
        }
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.sendConsoleMessage(strStatus);
        }
    }

    synchronized void setStatusViewerRefreshed(int isOrientationChange, String strWhy) {
        if (isOrientationChange == 1) {
            this.setStatusChanged("newOrientation", 0, strWhy, true);
            if (this.isSynced && this.drivingSync) {
                int time = (int)System.currentTimeMillis();
                Logger.debug((String)(" syncing" + time + " " + this.lastSyncTimeMs + " " + this.minSyncRepeatMs));
                if (this.lastSyncTimeMs == 0 || time - this.lastSyncTimeMs >= this.minSyncRepeatMs) {
                    this.lastSyncTimeMs = time;
                    Logger.debug((String)"sending sync");
                    this.syncSend(this.viewer.getMoveToText((float)this.minSyncRepeatMs / 1000.0f), null);
                }
            }
        } else {
            this.setStatusChanged("viewerRefreshed", 0, strWhy, false);
        }
    }

    synchronized void popupMenu(int x, int y) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.handlePopupMenu(x, y);
        }
    }

    public void setSyncDriver(int syncMode) {
        this.drivingSync = syncMode == 1;
        this.isSynced = syncMode > 0 || this.isSynced && syncMode < 0;
        Logger.debug((String)(this.viewer.getHtmlName() + " " + syncMode + " synced? " + this.isSynced + " driving?" + this.drivingSync));
    }

    public void syncSend(String script, String appletName) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.sendSyncScript(script, appletName);
        }
    }

    public int getSyncMode() {
        if (!this.isSynced) {
            return 0;
        }
        return this.drivingSync ? 1 : -1;
    }

    synchronized void showUrl(String urlString) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(urlString);
        }
    }

    synchronized void clearConsole() {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.sendConsoleMessage(null);
        }
    }

    synchronized void showConsole(boolean showConsole) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showConsole(showConsole);
        }
    }

    synchronized void setStatusChanged(String statusName, int intInfo, Object statusInfo, boolean isReplace) {
        Vector statusRecordSet;
        if (!this.allowStatusReporting || this.statusList != "all" && this.statusList.indexOf(statusName) < 0) {
            return;
        }
        ++this.statusPtr;
        Vector<Object> msgRecord = new Vector<Object>();
        msgRecord.add(new Integer(this.statusPtr));
        msgRecord.add(statusName);
        msgRecord.add(new Integer(intInfo));
        msgRecord.add(statusInfo);
        if (isReplace && this.messageQueue.containsKey(statusName)) {
            this.messageQueue.remove(statusName);
        }
        if ((statusRecordSet = this.messageQueue.containsKey(statusName) ? (Vector)this.messageQueue.remove(statusName) : new Vector()).size() == MAXIMUM_QUEUE_LENGTH) {
            statusRecordSet.remove(0);
        }
        statusRecordSet.add(msgRecord);
        this.messageQueue.put(statusName, statusRecordSet);
    }

    synchronized Vector getStatusChanged(String statusNameList) {
        Vector msgList = new Vector();
        if (this.setStatusList(statusNameList)) {
            return msgList;
        }
        Enumeration e = this.messageQueue.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            String statusName = (String)e.nextElement();
            msgList.add(this.messageQueue.remove(statusName));
            ++n;
        }
        return msgList;
    }

    float functionXY(String functionName, int x, int y) {
        return this.jmolStatusListener == null ? 0.0f : this.jmolStatusListener.functionXY(functionName, x, y);
    }

    public void createImage(String file, String type, int quality) {
        if (this.jmolStatusListener == null) {
            return;
        }
        this.jmolStatusListener.createImage(file, type, quality);
    }
}

