/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3i;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.Strands;

class StrandsRenderer
extends MpsRenderer {
    int strandCount;
    float strandSeparation;
    float baseOffset;

    StrandsRenderer() {
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        if (this.wingVectors == null) {
            return;
        }
        this.setStrandCount(((Strands)this.shape).strandCount);
        this.render1();
    }

    void setStrandCount(int strandCount) {
        this.strandCount = strandCount;
        this.strandSeparation = strandCount <= 1 ? 0.0f : 1.0f / (float)(strandCount - 1);
        this.baseOffset = strandCount % 2 == 0 ? this.strandSeparation / 2.0f : this.strandSeparation;
    }

    void render1() {
        Point3i[] screens;
        int i = this.strandCount >> 1;
        while (--i >= 0) {
            float f = (float)i * this.strandSeparation + this.baseOffset;
            screens = this.calcScreens(f);
            this.render1Strand(screens);
            this.viewer.freeTempScreens(screens);
            screens = this.calcScreens(-f);
            this.render1Strand(screens);
            this.viewer.freeTempScreens(screens);
        }
        if (this.strandCount % 2 == 1) {
            screens = this.calcScreens(0.0f);
            this.render1Strand(screens);
            this.viewer.freeTempScreens(screens);
        }
    }

    void render1Strand(Point3i[] screens) {
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!this.bsVisible.get(i)) continue;
            this.renderHermiteCylinder(screens, i);
        }
    }
}

