/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.NumberFormat;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import org.jmol.symmetry.UnitCell;
import org.jmol.viewer.BbcageRenderer;
import org.jmol.viewer.Frame;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Uccage;

class UccageRenderer
extends ShapeRenderer {
    NumberFormat nf;
    byte fid;
    final Point3i[] screens = new Point3i[8];
    final Point3f[] verticesT = new Point3f[8];
    Uccage uccage;

    UccageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screens[i] = new Point3i();
            this.verticesT[i] = new Point3f();
        }
    }

    void initRenderer() {
    }

    void render() {
        this.uccage = (Uccage)this.shape;
        short colix = this.uccage.colix;
        short mad = this.uccage.mad;
        if (mad == 0) {
            return;
        }
        this.render1(mad, colix);
    }

    void render1(short mad, short colix) {
        if (this.frame.cellInfos == null) {
            return;
        }
        UnitCell unitCell = this.viewer.getCurrentUnitCell();
        if (unitCell == null) {
            return;
        }
        Frame.CellInfo cellInfo = this.frame.cellInfos[this.viewer.getDisplayModelIndex()];
        Point3f[] vertices = unitCell.getVertices();
        Point3f offset = unitCell.getCartesianOffset();
        if (colix == 0) {
            colix = (short)17;
        }
        int i = 8;
        while (--i >= 0) {
            this.verticesT[i].add((Tuple3f)vertices[i], (Tuple3f)offset);
        }
        BbcageRenderer.render(this.viewer, this.g3d, mad, colix, this.verticesT, this.screens);
        if (!this.viewer.getDisplayCellParameters()) {
            return;
        }
        if (this.nf == null) {
            this.nf = NumberFormat.getInstance();
            this.fid = this.g3d.getFontFid("Monospaced", 14);
        }
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(3);
            this.nf.setMinimumFractionDigits(3);
        }
        this.g3d.setFont(this.fid);
        int line = 15;
        int lineheight = 15;
        if (cellInfo.spaceGroup != null) {
            this.g3d.drawStringNoSlab(cellInfo.spaceGroup, null, colix, (short)0, 5, line += lineheight, 0);
        }
        this.g3d.drawStringNoSlab("a=" + this.nfformat(unitCell.getInfo(0)) + "\u00c5", null, colix, (short)0, 5, line += lineheight, 0);
        this.g3d.drawStringNoSlab("b=" + this.nfformat(unitCell.getInfo(1)) + "\u00c5", null, colix, (short)0, 5, line += lineheight, 0);
        this.g3d.drawStringNoSlab("c=" + this.nfformat(unitCell.getInfo(2)) + "\u00c5", null, colix, (short)0, 5, line += lineheight, 0);
        if (this.nf != null) {
            this.nf.setMaximumFractionDigits(1);
        }
        this.g3d.drawStringNoSlab("\u03b1=" + this.nfformat(unitCell.getInfo(3)) + "\u00b0", null, colix, (short)0, 5, line += lineheight, 0);
        this.g3d.drawStringNoSlab("\u03b2=" + this.nfformat(unitCell.getInfo(4)) + "\u00b0", null, colix, (short)0, 5, line += lineheight, 0);
        this.g3d.drawStringNoSlab("\u03b3=" + this.nfformat(unitCell.getInfo(5)) + "\u00b0", null, colix, (short)0, 5, line += lineheight, 0);
    }

    String nfformat(float x) {
        if (this.nf == null) {
            return "" + x;
        }
        return this.nf.format(x);
    }
}

