/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.javascript.JSObject;
import org.jmol.api.JmolAppletInterface;
import org.jmol.util.Logger;

public class JmolAppletRegistry {
    String name;
    boolean mayScript;
    Applet applet;
    AppletContext appletContext;
    String strJavaVendor;
    String strJavaVersion;
    String strOSName;
    public static Hashtable htRegistry = new Hashtable();

    public JmolAppletRegistry(String name, boolean mayScript, Applet applet) {
        if (name == null || name.length() == 0) {
            name = null;
        }
        this.name = name;
        this.mayScript = mayScript;
        this.applet = applet;
        this.appletContext = applet.getAppletContext();
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strJavaVersion = System.getProperty("java.version");
        this.strOSName = System.getProperty("os.name");
        this.checkIn(name, applet);
    }

    public Enumeration applets() {
        return htRegistry.elements();
    }

    void checkIn(String name, Applet applet) {
        Logger.info((String)("AppletRegistry.checkIn(" + name + ")"));
        if (name != null) {
            htRegistry.put(name, applet);
        }
    }

    JSObject getJsoWindow() {
        JSObject jsoWindow = null;
        if (this.mayScript) {
            try {
                jsoWindow = JSObject.getWindow((Applet)this.applet);
            }
            catch (Exception e) {
                Logger.error((String)"exception trying to get jsoWindow");
            }
        } else {
            Logger.warn((String)("mayScript not specified for:" + this.name));
        }
        return jsoWindow;
    }

    JSObject getJsoTop() {
        JSObject jsoTop = null;
        JSObject jsoWindow = this.getJsoWindow();
        if (jsoWindow != null) {
            try {
                jsoTop = (JSObject)jsoWindow.getMember("top");
            }
            catch (Exception e) {
                Logger.error((String)"exception trying to get window.top");
            }
        }
        return jsoTop;
    }

    public void script(String targetName, String script) {
        this.scriptCallback(targetName, script, null);
    }

    public void scriptCallback(String targetName, String script, String callbackJavaScript) {
        if (targetName == null || targetName.length() == 0) {
            Logger.error((String)"no targetName specified");
            return;
        }
        if (this.tryDirect(targetName, script, callbackJavaScript)) {
            return;
        }
        Logger.error((String)("unable to find target:" + targetName));
    }

    private boolean tryDirect(String targetName, String script, String callbackJavaScript) {
        Logger.debug((String)"tryDirect trying appletContext");
        Applet target = this.appletContext.getApplet(targetName);
        if (target == null) {
            Logger.debug((String)"... trying registry");
            target = htRegistry.get(targetName);
        }
        if (target == null) {
            Logger.error((String)("tryDirect failed to find applet:" + targetName));
            return false;
        }
        if (!(target instanceof JmolAppletInterface)) {
            Logger.error((String)("target " + targetName + " is not a JmolApplet"));
            return true;
        }
        JmolAppletInterface targetJmolApplet = (JmolAppletInterface)target;
        targetJmolApplet.scriptButton(callbackJavaScript == null ? null : this.getJsoWindow(), this.name, script, callbackJavaScript);
        return true;
    }
}

