/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.viewer.Cartoon;
import org.jmol.viewer.Mps;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.ProteinStructure;
import org.jmol.viewer.RocketsRenderer;

class CartoonRenderer
extends RocketsRenderer {
    boolean newRockets = true;
    boolean renderAsRockets;
    final Point3f[] ring6Points = new Point3f[6];
    final Point3i[] ring6Screens = new Point3i[6];
    final Point3f[] ring5Points = new Point3f[5];
    final Point3i[] ring5Screens = new Point3i[5];

    CartoonRenderer() {
        this.ring6Screens[5] = new Point3i();
        int i = 5;
        while (--i >= 0) {
            this.ring5Screens[i] = new Point3i();
            this.ring6Screens[i] = new Point3i();
        }
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        Cartoon.Cchain schain = (Cartoon.Cchain)mpspolymer;
        if (schain.wingVectors == null || this.isCarbohydrate) {
            return;
        }
        this.calcScreenControlPoints();
        if (this.isNucleic) {
            this.renderNucleic();
            return;
        }
        boolean val = this.viewer.getCartoonRocketFlag();
        if (this.renderAsRockets != val) {
            for (int i = 0; i < this.monomerCount; ++i) {
                schain.falsifyMesh(i, false);
            }
            this.renderAsRockets = val;
        }
        this.ribbonTopScreens = this.calcScreens(0.5f);
        this.ribbonBottomScreens = this.calcScreens(-0.5f);
        this.calcRopeMidPoints(this.newRockets);
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
        this.viewer.freeTempScreens(this.ribbonTopScreens);
        this.viewer.freeTempScreens(this.ribbonBottomScreens);
    }

    void renderNucleic() {
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!this.bsVisible.get(i)) continue;
            this.renderHermiteConic(i, false);
            this.renderNucleicBaseStep((NucleicMonomer)this.monomers[i], this.getLeadColix(i), this.mads[i], this.controlPointScreens[i + 1]);
        }
    }

    void render1() {
        boolean lastWasSheet = false;
        boolean lastWasHelix = false;
        ProteinStructure previousStructure = null;
        int i = this.monomerCount;
        while (--i >= 0) {
            boolean isHelixRocket;
            ProteinStructure thisStructure = this.monomers[i].getProteinStructure();
            if (thisStructure != previousStructure) {
                lastWasHelix = false;
                lastWasSheet = false;
            }
            previousStructure = thisStructure;
            boolean isHelix = this.isHelix(i);
            boolean isSheet = this.isSheet(i);
            boolean bl = isHelixRocket = this.renderAsRockets ? isHelix : false;
            if (this.bsVisible.get(i) && !isHelixRocket) {
                if (isSheet || isHelix) {
                    if (lastWasSheet && isSheet || lastWasHelix && isHelix) {
                        this.renderHermiteRibbon(true, i, true);
                    } else {
                        this.renderHermiteArrowHead(i);
                    }
                } else {
                    this.renderHermiteConic(i, true);
                }
            }
            lastWasSheet = isSheet;
            lastWasHelix = isHelix;
        }
        if (this.renderAsRockets) {
            this.renderRockets();
        }
    }

    void renderRockets() {
        this.tPending = false;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.bsVisible.get(i) || !this.isHelix(i)) continue;
            this.renderSpecialSegment(this.monomers[i], this.getLeadColix(i), this.mads[i]);
        }
        this.renderPending();
    }

    void renderNucleicBaseStep(NucleicMonomer nucleotide, short colix, short mad, Point3i backboneScreen) {
        Point3i stepScreen;
        nucleotide.getBaseRing6Points(this.ring6Points);
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderRing6(colix);
        boolean hasRing5 = nucleotide.maybeGetBaseRing5Points(this.ring5Points);
        if (hasRing5) {
            this.viewer.transformPoints(this.ring5Points, this.ring5Screens);
            this.renderRing5();
            stepScreen = this.ring5Screens[2];
        } else {
            stepScreen = this.ring6Screens[1];
        }
        this.g3d.fillCylinder(colix, (byte)3, this.viewer.scaleToScreen(backboneScreen.z, mad > 1 ? mad / 2 : mad), backboneScreen, stepScreen);
        --this.ring6Screens[5].z;
        int i = 5;
        while (--i > 0) {
            --this.ring6Screens[i].z;
            if (!hasRing5) continue;
            --this.ring5Screens[i].z;
        }
        i = 6;
        while (--i > 0) {
            this.g3d.fillCylinder(colix, (byte)3, 3, this.ring6Screens[i], this.ring6Screens[i - 1]);
        }
        if (hasRing5) {
            i = 5;
            while (--i > 0) {
                this.g3d.fillCylinder(colix, (byte)3, 3, this.ring5Screens[i], this.ring5Screens[i - 1]);
            }
        } else {
            this.g3d.fillCylinder(colix, (byte)3, 3, this.ring6Screens[5], this.ring6Screens[0]);
        }
    }

    void renderRing6(short colix) {
        this.g3d.calcSurfaceShade(colix, this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[1], this.ring6Screens[2]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[4], this.ring6Screens[5]);
        this.g3d.fillTriangle(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
    }

    void renderRing5() {
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[2], this.ring5Screens[3]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[1], this.ring5Screens[2]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[3], this.ring5Screens[4]);
    }
}

