/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Monomer;

class PhosphorusMonomer
extends Monomer {
    static final byte[] phosphorusOffsets = new byte[]{0};
    static float MAX_ADJACENT_PHOSPHORUS_DISTANCE = 7.5f;
    boolean isPurine;
    boolean isPyrimidine;

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes, Atom[] atoms) {
        if (firstIndex != lastIndex || specialAtomIndexes[12] != firstIndex) {
            return null;
        }
        return new PhosphorusMonomer(chain, group3, seqcode, firstIndex, lastIndex, phosphorusOffsets);
    }

    PhosphorusMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        if (group3.indexOf(84) >= 0) {
            chain.isDna = true;
        }
        if (group3.indexOf(85) + group3.indexOf(73) > -2) {
            chain.isRna = true;
        }
        this.isPurine = group3.indexOf(65) + group3.indexOf(71) + group3.indexOf(73) > -3;
        this.isPyrimidine = group3.indexOf(84) + group3.indexOf(67) + group3.indexOf(85) > -3;
    }

    boolean isPhosphorusMonomer() {
        return true;
    }

    boolean isDna() {
        return this.chain.isDna();
    }

    boolean isRna() {
        return this.chain.isRna();
    }

    boolean isPurine() {
        return this.isPurine;
    }

    boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    byte getProteinStructureType() {
        return 0;
    }

    Atom getAtom(byte specialAtomID) {
        return specialAtomID == 12 ? this.getLeadAtom() : null;
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return specialAtomID == 12 ? this.getLeadAtomPoint() : null;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof PhosphorusMonomer)) {
            return false;
        }
        float distance = this.getLeadAtomPoint().distance(possiblyPreviousMonomer.getLeadAtomPoint());
        return distance <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }
}

