/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javax.vecmath.Point3f;
import org.jmol.viewer.Atom;

public class MepCalculation {
    static final float bohr_per_angstrom = 1.8897161f;
    public static int MAX_GRID = 40;
    float[] X = new float[MAX_GRID];
    float[] Y = new float[MAX_GRID];
    float[] Z = new float[MAX_GRID];
    float[] X2 = new float[MAX_GRID];
    float[] Y2 = new float[MAX_GRID];
    float[] Z2 = new float[MAX_GRID];
    Atom[] atoms;
    float[] mepCharges;
    Point3f[] atomCoordBohr;
    float[][] xyzBohr = new float[MAX_GRID][3];
    float[][][] voxelData;
    int[] countsXYZ;
    float[] originBohr = new float[3];
    float[] stepBohr = new float[3];
    int xMin;
    int xMax;
    int yMin;
    int yMax;
    int zMin;
    int zMax;

    public MepCalculation() {
    }

    public MepCalculation(Atom[] atoms, float[] mepCharges) {
        this.atoms = atoms;
        this.mepCharges = mepCharges;
    }

    public void createMepCube(float[][][] voxelData, int[] countsXYZ, float[] originXYZ, float[] stepsXYZ) {
        this.voxelData = voxelData;
        this.countsXYZ = countsXYZ;
        this.setupCoordinates(originXYZ, stepsXYZ);
        this.processMep();
    }

    private void setupCoordinates(float[] originXYZ, float[] stepsXYZ) {
        int i = 3;
        while (--i >= 0) {
            this.originBohr[i] = originXYZ[i] * 1.8897161f;
            this.stepBohr[i] = stepsXYZ[i] * 1.8897161f;
        }
        i = 3;
        while (--i >= 0) {
            this.xyzBohr[0][i] = this.originBohr[i];
            int n = this.countsXYZ[i];
            float inc = this.stepBohr[i];
            int j = 0;
            while (++j < n) {
                this.xyzBohr[j][i] = this.xyzBohr[j - 1][i] + inc;
            }
        }
        this.atomCoordBohr = new Point3f[this.atoms.length];
        for (i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i] == null) continue;
            this.atomCoordBohr[i] = new Point3f((Point3f)this.atoms[i]);
            this.atomCoordBohr[i].scale(1.8897161f);
        }
    }

    private void processMep() {
        int i;
        this.setMinMax();
        int firstAtom = 0;
        int lastAtom = this.atomCoordBohr.length;
        for (i = 0; i < lastAtom; ++i) {
            if (this.atomCoordBohr[i] == null) continue;
            firstAtom = i;
            break;
        }
        i = lastAtom;
        while (--i >= firstAtom) {
            if (this.atomCoordBohr[i] == null) continue;
            lastAtom = i + 1;
            break;
        }
        for (int atomIndex = firstAtom; atomIndex < lastAtom; ++atomIndex) {
            if (this.atomCoordBohr[atomIndex] == null) continue;
            float x = this.atomCoordBohr[atomIndex].x;
            float y = this.atomCoordBohr[atomIndex].y;
            float z = this.atomCoordBohr[atomIndex].z;
            float charge = this.mepCharges[atomIndex];
            int i2 = this.countsXYZ[0];
            while (--i2 >= 0) {
                this.X2[i2] = this.X[i2] = this.xyzBohr[i2][0] - x;
                int n = i2;
                this.X2[n] = this.X2[n] * this.X[i2];
            }
            i2 = this.countsXYZ[1];
            while (--i2 >= 0) {
                this.Y2[i2] = this.Y[i2] = this.xyzBohr[i2][1] - y;
                int n = i2;
                this.Y2[n] = this.Y2[n] * this.Y[i2];
            }
            i2 = this.countsXYZ[2];
            while (--i2 >= 0) {
                this.Z2[i2] = this.Z[i2] = this.xyzBohr[i2][2] - z;
                int n = i2;
                this.Z2[n] = this.Z2[n] * this.Z[i2];
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        float d2 = this.X2[ix] + this.Y2[iy] + this.Z2[iz];
                        float[] fArray = this.voxelData[ix][iy];
                        int n = iz;
                        fArray[n] = fArray[n] + (d2 == 0.0f ? charge * Float.POSITIVE_INFINITY : charge / (float)Math.sqrt(d2));
                    }
                }
            }
        }
    }

    private void setMinMax() {
        this.xMin = 0;
        this.yMin = 0;
        this.zMin = 0;
        this.xMax = this.countsXYZ[0];
        this.yMax = this.countsXYZ[1];
        this.zMax = this.countsXYZ[2];
    }
}

