/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Shade3D;

class Cylinder3D {
    final Graphics3D g3d;
    final Line3D line3d;
    private short colixA;
    private short colixB;
    private int[] shadesA;
    private boolean isScreenedA;
    private int[] shadesB;
    private boolean isScreenedB;
    private int xA;
    private int yA;
    private int zA;
    private int dxB;
    private int dyB;
    private int dzB;
    private float xAf;
    private float yAf;
    private float zAf;
    private float dxBf;
    private float dyBf;
    private float dzBf;
    private boolean tEvenDiameter;
    private int diameter;
    private byte endcaps;
    private boolean tEndcapOpen;
    private int xEndcap;
    private int yEndcap;
    private int zEndcap;
    private int argbEndcap;
    private short colixEndcap;
    private int intensityEndcap;
    private float radius;
    private float radius2;
    private float cosTheta;
    private float cosPhi;
    private float sinPhi;
    int sampleCount;
    boolean notClipped;
    float xTip;
    float yTip;
    float zTip;
    int rasterCount;
    float[] tRaster = new float[32];
    float[] txRaster = new float[32];
    float[] tyRaster = new float[32];
    float[] tzRaster = new float[32];
    int[] xRaster = new int[32];
    int[] yRaster = new int[32];
    int[] zRaster = new int[32];
    int[] fp8IntensityUp = new int[32];
    int yMin;
    int yMax;
    int xMin;
    int xMax;
    int zXMin;
    int zXMax;

    Cylinder3D(Graphics3D g3d) {
        this.g3d = g3d;
        this.line3d = g3d.line3d;
    }

    void render(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        int codeMaxB;
        int codeMinB;
        int codeMaxA;
        int r = diameter / 2 + 1;
        int codeMinA = this.line3d.clipCode(xA - r, yA - r, zA - r);
        boolean bl = this.notClipped = (codeMinA | (codeMaxA = this.line3d.clipCode(xA + r, yA + r, zA + r)) | (codeMinB = this.line3d.clipCode(xB - r, yB - r, zB - r)) | (codeMaxB = this.line3d.clipCode(xB + r, yB + r, zB + r))) == 0;
        if ((codeMinA & codeMaxB & codeMaxA & codeMinB) != 0) {
            return;
        }
        this.dxB = xB - xA;
        this.dyB = yB - yA;
        this.dzB = zB - zA;
        if (diameter <= 1) {
            this.line3d.plotLineDelta(this.g3d.getColixArgb(colixA), Graphics3D.isColixTranslucent(colixA), this.g3d.getColixArgb(colixB), Graphics3D.isColixTranslucent(colixB), xA, yA, zA, this.dxB, this.dyB, this.dzB, this.notClipped);
            return;
        }
        this.diameter = diameter;
        this.xA = xA;
        this.yA = yA;
        this.zA = zA;
        this.colixA = colixA;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = colixB;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.isScreenedA = (colixA & 0x4000) != 0;
        this.isScreenedB = (colixB & 0x4000) != 0;
        this.endcaps = endcaps;
        this.calcArgbEndcap(true);
        this.generateBaseEllipse();
        if (endcaps == 2) {
            this.renderFlatEndcap(true);
        }
        int i = this.rasterCount;
        while (--i >= 0) {
            this.plotRaster(i);
        }
        if (endcaps == 3) {
            this.renderSphericalEndcaps();
        }
    }

    void renderBits(short colixA, short colixB, byte endcaps, int diameter, float xA, float yA, float zA, float xB, float yB, float zB) {
        int codeMaxB;
        int codeMinB;
        int codeMaxA;
        int r = diameter / 2 + 1;
        int codeMinA = this.line3d.clipCode((int)xA - r, (int)yA - r, (int)zA - r);
        boolean bl = this.notClipped = (codeMinA | (codeMaxA = this.line3d.clipCode((int)xA + r, (int)yA + r, (int)zA + r)) | (codeMinB = this.line3d.clipCode((int)xB - r, (int)yB - r, (int)zB - r)) | (codeMaxB = this.line3d.clipCode((int)xB + r, (int)yB + r, (int)zB + r))) == 0;
        if ((codeMinA & codeMaxB & codeMaxA & codeMinB) != 0) {
            return;
        }
        this.dxBf = xB - xA;
        this.dyBf = yB - yA;
        this.dzBf = zB - zA;
        if (diameter == 0 || diameter == 1) {
            this.line3d.plotLineDelta(this.g3d.getColixArgb(colixA), Graphics3D.isColixTranslucent(colixA), this.g3d.getColixArgb(colixB), Graphics3D.isColixTranslucent(colixB), (int)xA, (int)yA, (int)zA, this.dxB, this.dyB, this.dzB, this.notClipped);
            return;
        }
        if (diameter > 0) {
            this.diameter = diameter;
            this.xAf = xA;
            this.yAf = yA;
            this.zAf = zA;
        }
        this.xA = (int)this.xAf;
        this.yA = (int)this.yAf;
        this.zA = (int)this.zAf;
        this.dxB = (int)this.dxBf;
        this.dyB = (int)this.dyBf;
        this.dzB = (int)this.dzBf;
        this.colixA = colixA;
        this.shadesA = this.g3d.getShades(this.colixA);
        this.colixB = colixB;
        this.shadesB = this.g3d.getShades(this.colixB);
        this.isScreenedA = (colixA & 0x4000) != 0;
        this.isScreenedB = (colixB & 0x4000) != 0;
        this.endcaps = endcaps;
        this.calcArgbEndcap(true);
        if (diameter > 0) {
            this.generateBaseEllipsePrecisely();
        }
        if (endcaps == 2) {
            this.renderFlatEndcap(true);
        }
        this.line3d.setLineBits(this.dxBf, this.dyBf);
        int i = this.rasterCount;
        while (--i >= 0) {
            this.plotRasterBits(i);
        }
        if (endcaps == 3) {
            this.renderSphericalEndcaps();
        }
        this.xAf += this.dxBf;
        this.yAf += this.dyBf;
        this.zAf += this.dzBf;
    }

    private void plotRasterBits(int i) {
        int fp8Up = this.fp8IntensityUp[i];
        int x = this.xRaster[i];
        int y = this.yRaster[i];
        int z = this.zRaster[i];
        if (this.tEndcapOpen) {
            if (this.notClipped) {
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1);
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1);
            } else {
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1);
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1);
            }
        }
        this.line3d.plotLineDeltaBits(this.shadesA, this.isScreenedA, this.shadesB, this.isScreenedB, fp8Up >> 8, this.xA + x, this.yA + y, this.zA - z, this.dxB, this.dyB, this.dzB, this.notClipped);
        if (this.endcaps == 1) {
            this.line3d.plotLineDelta(this.shadesA[0], this.isScreenedA, this.shadesB[0], this.isScreenedB, this.xA - x, this.yA - y, this.zA + z, this.dxB, this.dyB, this.dzB, this.notClipped);
        }
    }

    void renderCone(short colix, byte endcap, int diameter, float xA, float yA, float zA, float xTip, float yTip, float zTip) {
        this.xAf = xA;
        this.dxBf = xTip - this.xAf;
        this.yAf = yA;
        this.dyBf = yTip - this.yAf;
        this.zAf = zA;
        this.dzBf = zTip - this.zAf;
        this.xA = (int)Math.floor(this.xAf);
        this.yA = (int)Math.floor(this.yAf);
        this.zA = (int)Math.floor(this.zAf);
        this.dxB = (int)Math.floor(this.dxBf);
        this.dyB = (int)Math.floor(this.dyBf);
        this.dzB = (int)Math.floor(this.dzBf);
        this.xTip = xTip;
        this.yTip = yTip;
        this.zTip = zTip;
        this.colixA = colix;
        this.shadesA = this.g3d.getShades(colix);
        this.isScreenedA = (this.colixA & 0x4000) != 0;
        byte intensityTip = Shade3D.calcIntensity(this.dxB, this.dyB, -this.dzB);
        this.g3d.plotPixelClipped(this.shadesA[intensityTip], this.isScreenedA, (int)xTip, (int)yTip, (int)zTip);
        this.diameter = diameter;
        if (diameter <= 1) {
            if (diameter == 1) {
                this.line3d.plotLineDelta(this.colixA, this.isScreenedA, this.colixA, this.isScreenedA, this.xA, this.yA, this.zA, this.dxB, this.dyB, this.dzB, this.notClipped);
            }
            return;
        }
        this.endcaps = endcap;
        this.calcArgbEndcap(false);
        this.generateBaseEllipsePrecisely();
        if (this.endcaps == 2) {
            this.renderFlatEndcap(false);
        }
        int i = this.rasterCount;
        while (--i >= 0) {
            this.plotRasterCone(i);
        }
    }

    private void generateBaseEllipse() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        int mag2d2 = this.dxB * this.dxB + this.dyB * this.dyB;
        if (mag2d2 == 0) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float mag2d = (float)Math.sqrt(mag2d2);
            float mag3d = (float)Math.sqrt(mag2d2 + this.dzB * this.dzB);
            this.cosTheta = (float)this.dzB / mag3d;
            this.cosPhi = (float)this.dxB / mag2d;
            this.sinPhi = (float)this.dyB / mag2d;
        }
        this.calcRotatedPoint(0.0f, 0, false);
        this.calcRotatedPoint(0.5f, 1, false);
        this.calcRotatedPoint(1.0f, 2, false);
        this.rasterCount = 3;
        this.interpolate(0, 1);
        this.interpolate(1, 2);
    }

    private void generateBaseEllipsePrecisely() {
        this.tEvenDiameter = (this.diameter & 1) == 0;
        this.radius = (float)this.diameter / 2.0f;
        this.radius2 = this.radius * this.radius;
        float mag2d2 = this.dxBf * this.dxBf + this.dyBf * this.dyBf;
        if (mag2d2 == 0.0f) {
            this.cosTheta = 1.0f;
            this.cosPhi = 1.0f;
            this.sinPhi = 0.0f;
        } else {
            float mag2d = (float)Math.sqrt(mag2d2);
            float mag3d = (float)Math.sqrt(mag2d2 + this.dzBf * this.dzBf);
            this.cosTheta = this.dzBf / mag3d;
            this.cosPhi = this.dxBf / mag2d;
            this.sinPhi = this.dyBf / mag2d;
        }
        this.calcRotatedPoint(0.0f, 0, true);
        this.calcRotatedPoint(0.5f, 1, true);
        this.calcRotatedPoint(1.0f, 2, true);
        this.rasterCount = 3;
        this.interpolatePrecisely(0, 1);
        this.interpolatePrecisely(1, 2);
        for (int i = 0; i < this.rasterCount; ++i) {
            this.xRaster[i] = (int)Math.floor(this.txRaster[i]);
            this.yRaster[i] = (int)Math.floor(this.tyRaster[i]);
            this.zRaster[i] = (int)Math.floor(this.tzRaster[i]);
        }
    }

    private void calcRotatedPoint(float t, int i, boolean isPrecision) {
        double zR;
        double yR;
        double yT;
        this.tRaster[i] = t;
        double tPI = (double)t * Math.PI;
        double xT = Math.sin(tPI) * (double)this.cosTheta;
        double xR = (double)this.radius * (xT * (double)this.cosPhi - (yT = Math.cos(tPI)) * (double)this.sinPhi);
        double z2 = (double)this.radius2 - (xR * xR + (yR = (double)this.radius * (xT * (double)this.sinPhi + yT * (double)this.cosPhi)) * yR);
        double d = zR = z2 > 0.0 ? Math.sqrt(z2) : 0.0;
        if (isPrecision) {
            this.txRaster[i] = (float)xR;
            this.tyRaster[i] = (float)yR;
            this.tzRaster[i] = (float)zR;
        } else if (this.tEvenDiameter) {
            this.xRaster[i] = (int)(xR - 0.5);
            this.yRaster[i] = (int)(yR - 0.5);
            this.zRaster[i] = (int)(zR + 0.5);
        } else {
            this.xRaster[i] = (int)xR;
            this.yRaster[i] = (int)yR;
            this.zRaster[i] = (int)(zR + 0.5);
        }
        this.fp8IntensityUp[i] = Shade3D.calcFp8Intensity((float)xR, (float)yR, (float)zR);
    }

    private void interpolate(int iLower, int iUpper) {
        int dy;
        int dx = this.xRaster[iUpper] - this.xRaster[iLower];
        if (dx < 0) {
            dx = -dx;
        }
        if ((dy = this.yRaster[iUpper] - this.yRaster[iLower]) < 0) {
            dy = -dy;
        }
        if (dx + dy <= 1) {
            return;
        }
        float tLower = this.tRaster[iLower];
        float tUpper = this.tRaster[iUpper];
        int iMid = this.allocRaster(false);
        int j = 4;
        while (--j >= 0) {
            float tMid = (tLower + tUpper) / 2.0f;
            this.calcRotatedPoint(tMid, iMid, false);
            if (this.xRaster[iMid] == this.xRaster[iLower] && this.yRaster[iMid] == this.yRaster[iLower]) {
                this.fp8IntensityUp[iLower] = (this.fp8IntensityUp[iLower] + this.fp8IntensityUp[iMid]) / 2;
                tLower = tMid;
                continue;
            }
            if (this.xRaster[iMid] == this.xRaster[iUpper] && this.yRaster[iMid] == this.yRaster[iUpper]) {
                this.fp8IntensityUp[iUpper] = (this.fp8IntensityUp[iUpper] + this.fp8IntensityUp[iMid]) / 2;
                tUpper = tMid;
                continue;
            }
            this.interpolate(iLower, iMid);
            this.interpolate(iMid, iUpper);
            return;
        }
        this.xRaster[iMid] = this.xRaster[iLower];
        this.yRaster[iMid] = this.yRaster[iUpper];
    }

    private void interpolatePrecisely(int iLower, int iUpper) {
        float dy;
        int dx = (int)Math.floor(this.txRaster[iUpper]) - (int)Math.floor(this.txRaster[iLower]);
        if (dx < 0) {
            dx = -dx;
        }
        if ((dy = (float)((int)Math.floor(this.tyRaster[iUpper]) - (int)Math.floor(this.tyRaster[iLower]))) < 0.0f) {
            dy = -dy;
        }
        if ((float)dx + dy <= 1.0f) {
            return;
        }
        float tLower = this.tRaster[iLower];
        float tUpper = this.tRaster[iUpper];
        int iMid = this.allocRaster(true);
        int j = 4;
        while (--j >= 0) {
            float tMid = (tLower + tUpper) / 2.0f;
            this.calcRotatedPoint(tMid, iMid, true);
            if ((int)Math.floor(this.txRaster[iMid]) == (int)Math.floor(this.txRaster[iLower]) && (int)Math.floor(this.tyRaster[iMid]) == (int)Math.floor(this.tyRaster[iLower])) {
                this.fp8IntensityUp[iLower] = (this.fp8IntensityUp[iLower] + this.fp8IntensityUp[iMid]) / 2;
                tLower = tMid;
                continue;
            }
            if ((int)Math.floor(this.txRaster[iMid]) == (int)Math.floor(this.txRaster[iUpper]) && (int)Math.floor(this.tyRaster[iMid]) == (int)Math.floor(this.tyRaster[iUpper])) {
                this.fp8IntensityUp[iUpper] = (this.fp8IntensityUp[iUpper] + this.fp8IntensityUp[iMid]) / 2;
                tUpper = tMid;
                continue;
            }
            this.interpolatePrecisely(iLower, iMid);
            this.interpolatePrecisely(iMid, iUpper);
            return;
        }
        this.txRaster[iMid] = this.txRaster[iLower];
        this.tyRaster[iMid] = this.tyRaster[iUpper];
    }

    private void plotRaster(int i) {
        int fp8Up = this.fp8IntensityUp[i];
        int x = this.xRaster[i];
        int y = this.yRaster[i];
        int z = this.zRaster[i];
        if (this.tEndcapOpen) {
            if (this.notClipped) {
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1);
                this.g3d.plotPixelUnclipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1);
            } else {
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap + x, this.yEndcap + y, this.zEndcap - z - 1);
                this.g3d.plotPixelClipped(this.argbEndcap, this.xEndcap - x, this.yEndcap - y, this.zEndcap + z - 1);
            }
        }
        this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesB, this.isScreenedB, fp8Up >> 8, this.xA + x, this.yA + y, this.zA - z, this.dxB, this.dyB, this.dzB, this.notClipped);
        if (this.endcaps == 1) {
            this.line3d.plotLineDelta(this.shadesA[0], this.isScreenedA, this.shadesB[0], this.isScreenedB, this.xA - x, this.yA - y, this.zA + z, this.dxB, this.dyB, this.dzB, this.notClipped);
        }
    }

    private int[] realloc(int[] a) {
        int[] t = new int[a.length * 2];
        System.arraycopy(a, 0, t, 0, a.length);
        return t;
    }

    private float[] realloc(float[] a) {
        float[] t = new float[a.length * 2];
        System.arraycopy(a, 0, t, 0, a.length);
        return t;
    }

    private int allocRaster(boolean isPrecision) {
        while (this.rasterCount >= this.xRaster.length) {
            this.xRaster = this.realloc(this.xRaster);
            this.yRaster = this.realloc(this.yRaster);
            this.zRaster = this.realloc(this.zRaster);
            this.tRaster = this.realloc(this.tRaster);
        }
        while (this.rasterCount >= this.fp8IntensityUp.length) {
            this.fp8IntensityUp = this.realloc(this.fp8IntensityUp);
        }
        if (isPrecision) {
            while (this.rasterCount >= this.txRaster.length) {
                this.txRaster = this.realloc(this.txRaster);
                this.tyRaster = this.realloc(this.tyRaster);
                this.tzRaster = this.realloc(this.tzRaster);
            }
        }
        return this.rasterCount++;
    }

    private void findMinMaxY() {
        this.yMin = this.yMax = this.yRaster[0];
        int i = this.rasterCount;
        while (--i > 0) {
            int y = this.yRaster[i];
            if (y < this.yMin) {
                this.yMin = y;
                continue;
            }
            if (y > this.yMax) {
                this.yMax = y;
                continue;
            }
            if ((y = -y) < this.yMin) {
                this.yMin = y;
                continue;
            }
            if (y <= this.yMax) continue;
            this.yMax = y;
        }
    }

    private void findMinMaxX(int y) {
        this.xMin = Integer.MAX_VALUE;
        this.xMax = Integer.MIN_VALUE;
        int i = this.rasterCount;
        while (--i >= 0) {
            int x;
            if (this.yRaster[i] == y) {
                x = this.xRaster[i];
                if (x < this.xMin) {
                    this.xMin = x;
                    this.zXMin = this.zRaster[i];
                }
                if (x > this.xMax) {
                    this.xMax = x;
                    this.zXMax = this.zRaster[i];
                }
            }
            if (this.yRaster[i] != -y) continue;
            x = -this.xRaster[i];
            if (x < this.xMin) {
                this.xMin = x;
                this.zXMin = -this.zRaster[i];
            }
            if (x <= this.xMax) continue;
            this.xMax = x;
            this.zXMax = -this.zRaster[i];
        }
    }

    private void renderFlatEndcap(boolean tCylinder) {
        if (this.dzB == 0) {
            return;
        }
        int xT = this.xA;
        int yT = this.yA;
        int zT = this.zA;
        if (tCylinder && this.dzB < 0) {
            xT += this.dxB;
            yT += this.dyB;
            zT += this.dzB;
        }
        this.findMinMaxY();
        for (int y = this.yMin; y <= this.yMax; ++y) {
            this.findMinMaxX(y);
            int count = this.xMax - this.xMin + 1;
            this.g3d.setColorNoisy(this.colixEndcap, this.intensityEndcap);
            this.g3d.plotPixelsClipped(count, xT + this.xMin, yT + y, zT - this.zXMin - 1, zT - this.zXMax - 1, null, null);
        }
    }

    private void renderSphericalEndcaps() {
        this.g3d.fillSphereCentered(this.colixA, this.diameter, this.xA, this.yA, this.zA + 1);
        this.g3d.fillSphereCentered(this.colixB, this.diameter, this.xA + this.dxB, this.yA + this.dyB, this.zA + this.dzB + 1);
    }

    private void plotRasterCone(int i) {
        float x = this.txRaster[i];
        float y = this.tyRaster[i];
        float z = this.tzRaster[i];
        float xUp = this.xAf + x;
        float yUp = this.yAf + y;
        float zUp = this.zAf - z;
        float xDn = this.xAf - x;
        float yDn = this.yAf - y;
        float zDn = this.zAf + z;
        if (this.tEndcapOpen) {
            this.g3d.plotPixelClipped(this.argbEndcap, this.isScreenedA, (int)xUp, (int)yUp, (int)zUp);
            this.g3d.plotPixelClipped(this.argbEndcap, this.isScreenedA, (int)xDn, (int)yDn, (int)zDn);
        }
        int fp8Up = this.fp8IntensityUp[i];
        this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, fp8Up >> 8, (int)xUp, (int)yUp, (int)zUp, (int)Math.ceil(this.xTip - xUp), (int)Math.ceil(this.yTip - yUp), (int)Math.ceil(this.zTip - zUp), false);
        this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, fp8Up >> 8, (int)xUp, (int)yUp + 1, (int)zUp, (int)Math.ceil(this.xTip - xUp), (int)Math.ceil(this.yTip - yUp) + 1, (int)Math.ceil(this.zTip - zUp), false);
        this.line3d.plotLineDelta(this.shadesA, this.isScreenedA, this.shadesA, this.isScreenedA, fp8Up >> 8, (int)xUp + 1, (int)yUp, (int)zUp, (int)Math.ceil(this.xTip - xUp) + 1, (int)Math.ceil(this.yTip - yUp), (int)Math.ceil(this.zTip - zUp), false);
        if (this.endcaps != 2 || this.dzB <= 0) {
            int argb = this.shadesA[0];
            this.line3d.plotLineDelta(argb, this.isScreenedA, argb, this.isScreenedA, (int)xDn, (int)yDn, (int)zDn, (int)Math.ceil(this.xTip - xDn), (int)Math.ceil(this.yTip - yDn), (int)Math.ceil(this.zTip - zDn), false);
        }
    }

    private void calcArgbEndcap(boolean tCylinder) {
        int[] shadesEndcap;
        this.tEndcapOpen = false;
        if (this.endcaps == 3 || this.dzB == 0) {
            return;
        }
        this.xEndcap = this.xA;
        this.yEndcap = this.yA;
        this.zEndcap = this.zA;
        if (this.dzB >= 0 || !tCylinder) {
            this.intensityEndcap = Shade3D.calcIntensity(-this.dxB, -this.dyB, this.dzB);
            this.colixEndcap = this.colixA;
            shadesEndcap = this.shadesA;
        } else {
            this.intensityEndcap = Shade3D.calcIntensity(this.dxB, this.dyB, -this.dzB);
            this.colixEndcap = this.colixB;
            shadesEndcap = this.shadesB;
            this.xEndcap += this.dxB;
            this.yEndcap += this.dyB;
            this.zEndcap += this.dzB;
        }
        if (this.intensityEndcap > Graphics3D.intensitySpecularSurfaceLimit) {
            this.intensityEndcap = Graphics3D.intensitySpecularSurfaceLimit;
        }
        this.argbEndcap = shadesEndcap[this.intensityEndcap];
        this.tEndcapOpen = this.endcaps == 1;
    }
}

