/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.jmol.g3d.Platform3D;
import org.jmol.util.Logger;

public final class Font3D {
    public final byte fid;
    public final String fontFace;
    public final String fontStyle;
    public final short fontSize;
    public final Font font;
    public final FontMetrics fontMetrics;
    static Graphics graphicsOffscreen;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount;
    private static short[] fontkeys;
    private static Font3D[] font3ds;
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    public static final String[] fontFaces;
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    public static final String[] fontStyles;

    private Font3D(byte fid, int idFontFace, int idFontStyle, int fontSize, Font font, FontMetrics fontMetrics) {
        this.fid = fid;
        this.fontFace = fontFaces[idFontFace];
        this.fontStyle = fontStyles[idFontStyle];
        this.fontSize = (short)fontSize;
        this.font = font;
        this.fontMetrics = fontMetrics;
    }

    static synchronized void initialize(Platform3D platform) {
        if (graphicsOffscreen == null) {
            graphicsOffscreen = platform.allocateOffscreenImage(1, 1).getGraphics();
        }
    }

    static Font3D getFont3D(int fontface, int fontstyle, int fontsize, Platform3D platform) {
        if (graphicsOffscreen == null) {
            Font3D.initialize(platform);
        }
        if (fontsize > 63) {
            fontsize = 63;
        }
        short fontkey = (short)((fontface & 3) << 8 | (fontstyle & 3) << 6 | fontsize);
        int i = fontkeyCount;
        while (--i > 0) {
            if (fontkey != fontkeys[i]) continue;
            return font3ds[i];
        }
        return Font3D.allocFont3D(fontkey, fontface, fontstyle, fontsize);
    }

    public static synchronized Font3D allocFont3D(short fontkey, int fontface, int fontstyle, int fontsize) {
        Font3D font3d;
        int fontIndexNext;
        int i = fontkeyCount;
        while (--i > 0) {
            if (fontkey != fontkeys[i]) continue;
            return font3ds[i];
        }
        if ((fontIndexNext = fontkeyCount++) == fontkeys.length) {
            short[] t0 = new short[fontIndexNext + 8];
            System.arraycopy(fontkeys, 0, t0, 0, fontIndexNext);
            fontkeys = t0;
            Font3D[] t1 = new Font3D[fontIndexNext + 8];
            System.arraycopy(font3ds, 0, t1, 0, fontIndexNext);
            font3ds = t1;
        }
        Font font = new Font(fontFaces[fontface], fontstyle, fontsize);
        if (graphicsOffscreen == null) {
            Logger.error((String)"Font3D.graphicsOffscreen not initialized");
        }
        FontMetrics fontMetrics = graphicsOffscreen.getFontMetrics(font);
        Font3D.font3ds[fontIndexNext] = font3d = new Font3D((byte)fontIndexNext, fontface, fontstyle, fontsize, font, fontMetrics);
        Font3D.fontkeys[fontIndexNext] = fontkey;
        return font3d;
    }

    public static int getFontFaceID(String fontface) {
        if ("Monospaced".equalsIgnoreCase(fontface)) {
            return 2;
        }
        if ("Serif".equalsIgnoreCase(fontface)) {
            return 1;
        }
        return 0;
    }

    public static int getFontStyleID(String fontstyle) {
        int i = 4;
        while (--i > 0 && !fontStyles[i].equalsIgnoreCase(fontstyle)) {
        }
        return i;
    }

    public static Font3D getFont3D(byte fontID) {
        return font3ds[fontID & 0xFF];
    }

    static {
        fontkeyCount = 1;
        fontkeys = new short[8];
        font3ds = new Font3D[8];
        fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
        fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    }
}

